/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.transition.Transition;
import android.transition.TransitionValues;
import android.transition.Visibility;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;

public class Fade
extends Visibility {
    private static boolean DBG = false;
    private static final String LOG_TAG = "Fade";
    private static final String PROPNAME_SCREEN_X = "android:fade:screenX";
    private static final String PROPNAME_SCREEN_Y = "android:fade:screenY";
    public static final int IN = 1;
    public static final int OUT = 2;
    private int mFadingMode;

    public Fade() {
        this(3);
    }

    public Fade(int fadingMode) {
        this.mFadingMode = fadingMode;
    }

    private Animator createAnimation(View view, float startAlpha, float endAlpha, AnimatorListenerAdapter listener) {
        if (startAlpha == endAlpha) {
            if (listener != null) {
                listener.onAnimationEnd(null);
            }
            return null;
        }
        ObjectAnimator anim2 = ObjectAnimator.ofFloat(view, "transitionAlpha", startAlpha, endAlpha);
        if (DBG) {
            Log.d(LOG_TAG, "Created animator " + anim2);
        }
        if (listener != null) {
            anim2.addListener(listener);
            anim2.addPauseListener(listener);
        }
        return anim2;
    }

    private void captureValues(TransitionValues transitionValues) {
        int[] loc = new int[2];
        transitionValues.view.getLocationOnScreen(loc);
        transitionValues.values.put(PROPNAME_SCREEN_X, loc[0]);
        transitionValues.values.put(PROPNAME_SCREEN_Y, loc[1]);
    }

    public void captureStartValues(TransitionValues transitionValues) {
        super.captureStartValues(transitionValues);
        this.captureValues(transitionValues);
    }

    public Animator onAppear(ViewGroup sceneRoot, TransitionValues startValues, int startVisibility, TransitionValues endValues, int endVisibility) {
        if ((this.mFadingMode & 1) != 1 || endValues == null) {
            return null;
        }
        final View endView = endValues.view;
        if (DBG) {
            View startView = startValues != null ? startValues.view : null;
            Log.d(LOG_TAG, "Fade.onAppear: startView, startVis, endView, endVis = " + startView + ", " + startVisibility + ", " + endView + ", " + endVisibility);
        }
        endView.setTransitionAlpha(0.0f);
        Transition.TransitionListenerAdapter transitionListener = new Transition.TransitionListenerAdapter(){
            boolean mCanceled = false;
            float mPausedAlpha;

            public void onTransitionCancel(Transition transition2) {
                endView.setTransitionAlpha(1.0f);
                this.mCanceled = true;
            }

            public void onTransitionEnd(Transition transition2) {
                if (!this.mCanceled) {
                    endView.setTransitionAlpha(1.0f);
                }
            }

            public void onTransitionPause(Transition transition2) {
                this.mPausedAlpha = endView.getTransitionAlpha();
                endView.setTransitionAlpha(1.0f);
            }

            public void onTransitionResume(Transition transition2) {
                endView.setTransitionAlpha(this.mPausedAlpha);
            }
        };
        this.addListener(transitionListener);
        return this.createAnimation(endView, 0.0f, 1.0f, null);
    }

    public Animator onDisappear(ViewGroup sceneRoot, TransitionValues startValues, int startVisibility, TransitionValues endValues, int endVisibility) {
        View endView;
        if ((this.mFadingMode & 2) != 2) {
            return null;
        }
        View view = null;
        View startView = startValues != null ? startValues.view : null;
        View view2 = endView = endValues != null ? endValues.view : null;
        if (DBG) {
            Log.d(LOG_TAG, "Fade.onDisappear: startView, startVis, endView, endVis = " + startView + ", " + startVisibility + ", " + endView + ", " + endVisibility);
        }
        View overlayView = null;
        View viewToKeep = null;
        if (endView == null || endView.getParent() == null) {
            if (endView != null) {
                view = overlayView = endView;
            } else if (startView != null) {
                View startParent;
                int id2;
                if (startView.getParent() == null) {
                    view = overlayView = startView;
                } else if (startView.getParent() instanceof View && startView.getParent().getParent() == null && (id2 = (startParent = (View)((Object)startView.getParent())).getId()) != -1 && sceneRoot.findViewById(id2) != null && this.mCanRemoveViews) {
                    view = overlayView = startView;
                }
            }
        } else if (endVisibility == 4) {
            viewToKeep = view = endView;
        } else if (startView == endView) {
            viewToKeep = view = endView;
        } else {
            overlayView = view = startView;
        }
        final int finalVisibility = endVisibility;
        if (overlayView != null) {
            int screenX = (Integer)startValues.values.get(PROPNAME_SCREEN_X);
            int screenY = (Integer)startValues.values.get(PROPNAME_SCREEN_Y);
            int[] loc = new int[2];
            sceneRoot.getLocationOnScreen(loc);
            overlayView.offsetLeftAndRight(screenX - loc[0] - overlayView.getLeft());
            overlayView.offsetTopAndBottom(screenY - loc[1] - overlayView.getTop());
            sceneRoot.getOverlay().add(overlayView);
            float startAlpha = 1.0f;
            float endAlpha = 0.0f;
            final View finalView = view;
            final View finalOverlayView = overlayView;
            final View finalViewToKeep = viewToKeep;
            final ViewGroup finalSceneRoot = sceneRoot;
            AnimatorListenerAdapter endListener = new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    finalView.setTransitionAlpha(1.0f);
                    if (finalViewToKeep != null) {
                        finalViewToKeep.setVisibility(finalVisibility);
                    }
                    if (finalOverlayView != null) {
                        finalSceneRoot.getOverlay().remove(finalOverlayView);
                    }
                }

                public void onAnimationPause(Animator animation) {
                    if (finalOverlayView != null) {
                        finalSceneRoot.getOverlay().remove(finalOverlayView);
                    }
                }

                public void onAnimationResume(Animator animation) {
                    if (finalOverlayView != null) {
                        finalSceneRoot.getOverlay().add(finalOverlayView);
                    }
                }
            };
            return this.createAnimation(view, 1.0f, endAlpha, endListener);
        }
        if (viewToKeep != null) {
            viewToKeep.setVisibility(0);
            float startAlpha = 1.0f;
            float endAlpha = 0.0f;
            final View finalView = view;
            final View finalOverlayView = overlayView;
            final View finalViewToKeep = viewToKeep;
            final ViewGroup finalSceneRoot = sceneRoot;
            AnimatorListenerAdapter endListener = new AnimatorListenerAdapter(){
                boolean mCanceled = false;
                float mPausedAlpha = -1.0f;

                public void onAnimationPause(Animator animation) {
                    if (finalViewToKeep != null && !this.mCanceled) {
                        finalViewToKeep.setVisibility(finalVisibility);
                    }
                    this.mPausedAlpha = finalView.getTransitionAlpha();
                    finalView.setTransitionAlpha(1.0f);
                }

                public void onAnimationResume(Animator animation) {
                    if (finalViewToKeep != null && !this.mCanceled) {
                        finalViewToKeep.setVisibility(0);
                    }
                    finalView.setTransitionAlpha(this.mPausedAlpha);
                }

                public void onAnimationCancel(Animator animation) {
                    this.mCanceled = true;
                    if (this.mPausedAlpha >= 0.0f) {
                        finalView.setTransitionAlpha(this.mPausedAlpha);
                    }
                }

                public void onAnimationEnd(Animator animation) {
                    if (!this.mCanceled) {
                        finalView.setTransitionAlpha(1.0f);
                    }
                    if (finalViewToKeep != null && !this.mCanceled) {
                        finalViewToKeep.setVisibility(finalVisibility);
                    }
                    if (finalOverlayView != null) {
                        finalSceneRoot.getOverlay().remove(finalOverlayView);
                    }
                }
            };
            return this.createAnimation(view, 1.0f, endAlpha, endListener);
        }
        return null;
    }
}

