/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import com.android.internal.util.Preconditions;

public final class SizeF {
    private final float mWidth;
    private final float mHeight;

    public SizeF(float width, float height) {
        this.mWidth = Preconditions.checkArgumentFinite((float)width, (String)"width");
        this.mHeight = Preconditions.checkArgumentFinite((float)height, (String)"height");
    }

    public float getWidth() {
        return this.mWidth;
    }

    public float getHeight() {
        return this.mHeight;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof SizeF) {
            SizeF other = (SizeF)obj;
            return this.mWidth == other.mWidth && this.mHeight == other.mHeight;
        }
        return false;
    }

    public String toString() {
        return this.mWidth + "x" + this.mHeight;
    }

    private static NumberFormatException invalidSizeF(String s) {
        throw new NumberFormatException("Invalid SizeF: \"" + s + "\"");
    }

    public static SizeF parseSizeF(String string2) throws NumberFormatException {
        Preconditions.checkNotNull(string2, "string must not be null");
        int sep_ix = string2.indexOf(42);
        if (sep_ix < 0) {
            sep_ix = string2.indexOf(120);
        }
        if (sep_ix < 0) {
            throw SizeF.invalidSizeF(string2);
        }
        try {
            return new SizeF(Float.parseFloat(string2.substring(0, sep_ix)), Float.parseFloat(string2.substring(sep_ix + 1)));
        }
        catch (NumberFormatException e) {
            throw SizeF.invalidSizeF(string2);
        }
        catch (IllegalArgumentException e) {
            throw SizeF.invalidSizeF(string2);
        }
    }

    public int hashCode() {
        return Float.floatToIntBits(this.mWidth) ^ Float.floatToIntBits(this.mHeight);
    }
}

