/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.content.res.Resources;
import android.os.Handler;
import android.os.SystemClock;
import android.util.FloatMath;
import android.view.GestureDetector;
import android.view.InputEventConsistencyVerifier;
import android.view.MotionEvent;
import android.view.ViewConfiguration;

public class ScaleGestureDetector {
    private static final String TAG = "ScaleGestureDetector";
    private final Context mContext;
    private final OnScaleGestureListener mListener;
    private float mFocusX;
    private float mFocusY;
    private boolean mQuickScaleEnabled;
    private float mCurrSpan;
    private float mPrevSpan;
    private float mInitialSpan;
    private float mCurrSpanX;
    private float mCurrSpanY;
    private float mPrevSpanX;
    private float mPrevSpanY;
    private long mCurrTime;
    private long mPrevTime;
    private boolean mInProgress;
    private int mSpanSlop;
    private int mMinSpan;
    private float mTouchUpper;
    private float mTouchLower;
    private float mTouchHistoryLastAccepted;
    private int mTouchHistoryDirection;
    private long mTouchHistoryLastAcceptedTime;
    private int mTouchMinMajor;
    private MotionEvent mDoubleTapEvent;
    private int mDoubleTapMode = 0;
    private final Handler mHandler;
    private static final long TOUCH_STABILIZE_TIME = 128L;
    private static final int DOUBLE_TAP_MODE_NONE = 0;
    private static final int DOUBLE_TAP_MODE_IN_PROGRESS = 1;
    private static final float SCALE_FACTOR = 0.5f;
    private final InputEventConsistencyVerifier mInputEventConsistencyVerifier = InputEventConsistencyVerifier.isInstrumentationEnabled() ? new InputEventConsistencyVerifier(this, 0) : null;
    private GestureDetector mGestureDetector;
    private boolean mEventBeforeOrAboveStartingGestureEvent;

    public ScaleGestureDetector(Context context, OnScaleGestureListener listener) {
        this(context, listener, null);
    }

    public ScaleGestureDetector(Context context, OnScaleGestureListener listener, Handler handler) {
        this.mContext = context;
        this.mListener = listener;
        this.mSpanSlop = ViewConfiguration.get(context).getScaledTouchSlop() * 2;
        Resources res = context.getResources();
        this.mTouchMinMajor = res.getDimensionPixelSize(17104906);
        this.mMinSpan = res.getDimensionPixelSize(17104905);
        this.mHandler = handler;
        if (context.getApplicationInfo().targetSdkVersion > 18) {
            this.setQuickScaleEnabled(true);
        }
    }

    private void addTouchHistory(MotionEvent ev) {
        long currentTime = SystemClock.uptimeMillis();
        int count = ev.getPointerCount();
        boolean accept = currentTime - this.mTouchHistoryLastAcceptedTime >= 128L;
        float total = 0.0f;
        int sampleCount = 0;
        for (int i = 0; i < count; ++i) {
            boolean hasLastAccepted = !Float.isNaN(this.mTouchHistoryLastAccepted);
            int historySize = ev.getHistorySize();
            int pointerSampleCount = historySize + 1;
            for (int h = 0; h < pointerSampleCount; ++h) {
                long time;
                int directionSig;
                float major = h < historySize ? ev.getHistoricalTouchMajor(i, h) : ev.getTouchMajor(i);
                if (major < (float)this.mTouchMinMajor) {
                    major = this.mTouchMinMajor;
                }
                total += major;
                if (Float.isNaN(this.mTouchUpper) || major > this.mTouchUpper) {
                    this.mTouchUpper = major;
                }
                if (Float.isNaN(this.mTouchLower) || major < this.mTouchLower) {
                    this.mTouchLower = major;
                }
                if (!hasLastAccepted || (directionSig = (int)Math.signum(major - this.mTouchHistoryLastAccepted)) == this.mTouchHistoryDirection && (directionSig != 0 || this.mTouchHistoryDirection != 0)) continue;
                this.mTouchHistoryDirection = directionSig;
                this.mTouchHistoryLastAcceptedTime = time = h < historySize ? ev.getHistoricalEventTime(h) : ev.getEventTime();
                accept = false;
            }
            sampleCount += pointerSampleCount;
        }
        float avg = total / (float)sampleCount;
        if (accept) {
            float newAccepted = (this.mTouchUpper + this.mTouchLower + avg) / 3.0f;
            this.mTouchUpper = (this.mTouchUpper + newAccepted) / 2.0f;
            this.mTouchLower = (this.mTouchLower + newAccepted) / 2.0f;
            this.mTouchHistoryLastAccepted = newAccepted;
            this.mTouchHistoryDirection = 0;
            this.mTouchHistoryLastAcceptedTime = ev.getEventTime();
        }
    }

    private void clearTouchHistory() {
        this.mTouchUpper = Float.NaN;
        this.mTouchLower = Float.NaN;
        this.mTouchHistoryLastAccepted = Float.NaN;
        this.mTouchHistoryDirection = 0;
        this.mTouchHistoryLastAcceptedTime = 0L;
    }

    public boolean onTouchEvent(MotionEvent event) {
        int minSpan;
        float focusY;
        float focusX;
        int div;
        boolean streamComplete;
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onTouchEvent(event, 0);
        }
        this.mCurrTime = event.getEventTime();
        int action = event.getActionMasked();
        if (this.mQuickScaleEnabled) {
            this.mGestureDetector.onTouchEvent(event);
        }
        boolean bl = streamComplete = action == 1 || action == 3;
        if (action == 0 || streamComplete) {
            if (this.mInProgress) {
                this.mListener.onScaleEnd(this);
                this.mInProgress = false;
                this.mInitialSpan = 0.0f;
                this.mDoubleTapMode = 0;
            }
            if (streamComplete) {
                this.clearTouchHistory();
                return true;
            }
        }
        boolean configChanged = action == 0 || action == 6 || action == 5;
        boolean pointerUp = action == 6;
        int skipIndex = pointerUp ? event.getActionIndex() : -1;
        float sumX = 0.0f;
        float sumY = 0.0f;
        int count = event.getPointerCount();
        int n = div = pointerUp ? count - 1 : count;
        if (this.mDoubleTapMode == 1) {
            focusX = this.mDoubleTapEvent.getX();
            focusY = this.mDoubleTapEvent.getY();
            this.mEventBeforeOrAboveStartingGestureEvent = event.getY() < focusY;
        } else {
            for (int i = 0; i < count; ++i) {
                if (skipIndex == i) continue;
                sumX += event.getX(i);
                sumY += event.getY(i);
            }
            focusX = sumX / (float)div;
            focusY = sumY / (float)div;
        }
        this.addTouchHistory(event);
        float devSumX = 0.0f;
        float devSumY = 0.0f;
        for (int i = 0; i < count; ++i) {
            if (skipIndex == i) continue;
            float touchSize = this.mTouchHistoryLastAccepted / 2.0f;
            devSumX += Math.abs(event.getX(i) - focusX) + touchSize;
            devSumY += Math.abs(event.getY(i) - focusY) + touchSize;
        }
        float devX = devSumX / (float)div;
        float devY = devSumY / (float)div;
        float spanX = devX * 2.0f;
        float spanY = devY * 2.0f;
        float span = this.inDoubleTapMode() ? spanY : FloatMath.sqrt(spanX * spanX + spanY * spanY);
        boolean wasInProgress = this.mInProgress;
        this.mFocusX = focusX;
        this.mFocusY = focusY;
        if (!this.inDoubleTapMode() && this.mInProgress && (span < (float)this.mMinSpan || configChanged)) {
            this.mListener.onScaleEnd(this);
            this.mInProgress = false;
            this.mInitialSpan = span;
            this.mDoubleTapMode = 0;
        }
        if (configChanged) {
            this.mPrevSpanX = this.mCurrSpanX = spanX;
            this.mPrevSpanY = this.mCurrSpanY = spanY;
            this.mPrevSpan = this.mCurrSpan = span;
            this.mInitialSpan = this.mCurrSpan;
        }
        int n2 = minSpan = this.inDoubleTapMode() ? this.mSpanSlop : this.mMinSpan;
        if (!this.mInProgress && span >= (float)minSpan && (wasInProgress || Math.abs(span - this.mInitialSpan) > (float)this.mSpanSlop)) {
            this.mPrevSpanX = this.mCurrSpanX = spanX;
            this.mPrevSpanY = this.mCurrSpanY = spanY;
            this.mPrevSpan = this.mCurrSpan = span;
            this.mPrevTime = this.mCurrTime;
            this.mInProgress = this.mListener.onScaleBegin(this);
        }
        if (action == 2) {
            this.mCurrSpanX = spanX;
            this.mCurrSpanY = spanY;
            this.mCurrSpan = span;
            boolean updatePrev = true;
            if (this.mInProgress) {
                updatePrev = this.mListener.onScale(this);
            }
            if (updatePrev) {
                this.mPrevSpanX = this.mCurrSpanX;
                this.mPrevSpanY = this.mCurrSpanY;
                this.mPrevSpan = this.mCurrSpan;
                this.mPrevTime = this.mCurrTime;
            }
        }
        return true;
    }

    private boolean inDoubleTapMode() {
        return this.mDoubleTapMode == 1;
    }

    public void setQuickScaleEnabled(boolean scales) {
        this.mQuickScaleEnabled = scales;
        if (this.mQuickScaleEnabled && this.mGestureDetector == null) {
            GestureDetector.SimpleOnGestureListener gestureListener = new GestureDetector.SimpleOnGestureListener(){

                public boolean onDoubleTap(MotionEvent e) {
                    ScaleGestureDetector.this.mDoubleTapEvent = e;
                    ScaleGestureDetector.this.mDoubleTapMode = 1;
                    return true;
                }
            };
            this.mGestureDetector = new GestureDetector(this.mContext, gestureListener, this.mHandler);
        }
    }

    public boolean isQuickScaleEnabled() {
        return this.mQuickScaleEnabled;
    }

    public boolean isInProgress() {
        return this.mInProgress;
    }

    public float getFocusX() {
        return this.mFocusX;
    }

    public float getFocusY() {
        return this.mFocusY;
    }

    public float getCurrentSpan() {
        return this.mCurrSpan;
    }

    public float getCurrentSpanX() {
        return this.mCurrSpanX;
    }

    public float getCurrentSpanY() {
        return this.mCurrSpanY;
    }

    public float getPreviousSpan() {
        return this.mPrevSpan;
    }

    public float getPreviousSpanX() {
        return this.mPrevSpanX;
    }

    public float getPreviousSpanY() {
        return this.mPrevSpanY;
    }

    public float getScaleFactor() {
        if (this.inDoubleTapMode()) {
            boolean scaleUp = this.mEventBeforeOrAboveStartingGestureEvent && this.mCurrSpan < this.mPrevSpan || !this.mEventBeforeOrAboveStartingGestureEvent && this.mCurrSpan > this.mPrevSpan;
            float spanDiff = Math.abs(1.0f - this.mCurrSpan / this.mPrevSpan) * 0.5f;
            return this.mPrevSpan <= 0.0f ? 1.0f : (scaleUp ? 1.0f + spanDiff : 1.0f - spanDiff);
        }
        return this.mPrevSpan > 0.0f ? this.mCurrSpan / this.mPrevSpan : 1.0f;
    }

    public long getTimeDelta() {
        return this.mCurrTime - this.mPrevTime;
    }

    public long getEventTime() {
        return this.mCurrTime;
    }

    public static class SimpleOnScaleGestureListener
    implements OnScaleGestureListener {
        public boolean onScale(ScaleGestureDetector detector) {
            return false;
        }

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            return true;
        }

        public void onScaleEnd(ScaleGestureDetector detector) {
        }
    }

    public static interface OnScaleGestureListener {
        public boolean onScale(ScaleGestureDetector var1);

        public boolean onScaleBegin(ScaleGestureDetector var1);

        public void onScaleEnd(ScaleGestureDetector var1);
    }
}

