/*
 * Decompiled with CFR 0.152.
 */
package com.android.i18n.phonenumbers;

import com.android.i18n.phonenumbers.MetadataManager;
import com.android.i18n.phonenumbers.PhoneNumberUtil;
import com.android.i18n.phonenumbers.Phonemetadata;
import com.android.i18n.phonenumbers.Phonenumber;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class ShortNumberInfo {
    private static final Logger logger = Logger.getLogger(ShortNumberInfo.class.getName());
    private static final ShortNumberInfo INSTANCE = new ShortNumberInfo(PhoneNumberUtil.getInstance());
    private static final Set<String> REGIONS_WHERE_EMERGENCY_NUMBERS_MUST_BE_EXACT = new HashSet<String>();
    private final PhoneNumberUtil phoneUtil;

    public static ShortNumberInfo getInstance() {
        return INSTANCE;
    }

    ShortNumberInfo(PhoneNumberUtil util) {
        this.phoneUtil = util;
    }

    public boolean isPossibleShortNumberForRegion(String shortNumber, String regionDialingFrom) {
        Phonemetadata.PhoneMetadata phoneMetadata = MetadataManager.getShortNumberMetadataForRegion((String)regionDialingFrom);
        if (phoneMetadata == null) {
            return false;
        }
        Phonemetadata.PhoneNumberDesc generalDesc = phoneMetadata.getGeneralDesc();
        return this.phoneUtil.isNumberPossibleForDesc(shortNumber, generalDesc);
    }

    public boolean isPossibleShortNumber(Phonenumber.PhoneNumber number) {
        List<String> regionCodes = this.phoneUtil.getRegionCodesForCountryCode(number.getCountryCode());
        String shortNumber = this.phoneUtil.getNationalSignificantNumber(number);
        for (String region : regionCodes) {
            Phonemetadata.PhoneMetadata phoneMetadata = MetadataManager.getShortNumberMetadataForRegion((String)region);
            if (!this.phoneUtil.isNumberPossibleForDesc(shortNumber, phoneMetadata.getGeneralDesc())) continue;
            return true;
        }
        return false;
    }

    public boolean isValidShortNumberForRegion(String shortNumber, String regionDialingFrom) {
        Phonemetadata.PhoneMetadata phoneMetadata = MetadataManager.getShortNumberMetadataForRegion((String)regionDialingFrom);
        if (phoneMetadata == null) {
            return false;
        }
        Phonemetadata.PhoneNumberDesc generalDesc = phoneMetadata.getGeneralDesc();
        if (!generalDesc.hasNationalNumberPattern() || !this.phoneUtil.isNumberMatchingDesc(shortNumber, generalDesc)) {
            return false;
        }
        Phonemetadata.PhoneNumberDesc shortNumberDesc = phoneMetadata.getShortCode();
        if (!shortNumberDesc.hasNationalNumberPattern()) {
            logger.log(Level.WARNING, "No short code national number pattern found for region: " + regionDialingFrom);
            return false;
        }
        return this.phoneUtil.isNumberMatchingDesc(shortNumber, shortNumberDesc);
    }

    public boolean isValidShortNumber(Phonenumber.PhoneNumber number) {
        List<String> regionCodes = this.phoneUtil.getRegionCodesForCountryCode(number.getCountryCode());
        String shortNumber = this.phoneUtil.getNationalSignificantNumber(number);
        String regionCode = this.getRegionCodeForShortNumberFromRegionList(number, regionCodes);
        if (regionCodes.size() > 1 && regionCode != null) {
            return true;
        }
        return this.isValidShortNumberForRegion(shortNumber, regionCode);
    }

    public ShortNumberCost getExpectedCostForRegion(String shortNumber, String regionDialingFrom) {
        Phonemetadata.PhoneMetadata phoneMetadata = MetadataManager.getShortNumberMetadataForRegion((String)regionDialingFrom);
        if (phoneMetadata == null) {
            return ShortNumberCost.UNKNOWN_COST;
        }
        if (this.phoneUtil.isNumberMatchingDesc(shortNumber, phoneMetadata.getPremiumRate())) {
            return ShortNumberCost.PREMIUM_RATE;
        }
        if (this.phoneUtil.isNumberMatchingDesc(shortNumber, phoneMetadata.getStandardRate())) {
            return ShortNumberCost.STANDARD_RATE;
        }
        if (this.phoneUtil.isNumberMatchingDesc(shortNumber, phoneMetadata.getTollFree())) {
            return ShortNumberCost.TOLL_FREE;
        }
        if (this.isEmergencyNumber(shortNumber, regionDialingFrom)) {
            return ShortNumberCost.TOLL_FREE;
        }
        return ShortNumberCost.UNKNOWN_COST;
    }

    public ShortNumberCost getExpectedCost(Phonenumber.PhoneNumber number) {
        List<String> regionCodes = this.phoneUtil.getRegionCodesForCountryCode(number.getCountryCode());
        if (regionCodes.size() == 0) {
            return ShortNumberCost.UNKNOWN_COST;
        }
        String shortNumber = this.phoneUtil.getNationalSignificantNumber(number);
        if (regionCodes.size() == 1) {
            return this.getExpectedCostForRegion(shortNumber, regionCodes.get(0));
        }
        ShortNumberCost cost = ShortNumberCost.TOLL_FREE;
        block6: for (String regionCode : regionCodes) {
            ShortNumberCost costForRegion = this.getExpectedCostForRegion(shortNumber, regionCode);
            switch (costForRegion) {
                case PREMIUM_RATE: {
                    return ShortNumberCost.PREMIUM_RATE;
                }
                case UNKNOWN_COST: {
                    cost = ShortNumberCost.UNKNOWN_COST;
                    continue block6;
                }
                case STANDARD_RATE: {
                    if (cost == ShortNumberCost.UNKNOWN_COST) continue block6;
                    cost = ShortNumberCost.STANDARD_RATE;
                    continue block6;
                }
                case TOLL_FREE: {
                    continue block6;
                }
            }
            logger.log(Level.SEVERE, "Unrecognised cost for region: " + (Object)((Object)costForRegion));
        }
        return cost;
    }

    private String getRegionCodeForShortNumberFromRegionList(Phonenumber.PhoneNumber number, List<String> regionCodes) {
        if (regionCodes.size() == 0) {
            return null;
        }
        if (regionCodes.size() == 1) {
            return regionCodes.get(0);
        }
        String nationalNumber = this.phoneUtil.getNationalSignificantNumber(number);
        for (String regionCode : regionCodes) {
            Phonemetadata.PhoneMetadata phoneMetadata = MetadataManager.getShortNumberMetadataForRegion((String)regionCode);
            if (phoneMetadata == null || !this.phoneUtil.isNumberMatchingDesc(nationalNumber, phoneMetadata.getShortCode())) continue;
            return regionCode;
        }
        return null;
    }

    Set<String> getSupportedRegions() {
        return Collections.unmodifiableSet(MetadataManager.getShortNumberMetadataSupportedRegions());
    }

    String getExampleShortNumber(String regionCode) {
        Phonemetadata.PhoneMetadata phoneMetadata = MetadataManager.getShortNumberMetadataForRegion((String)regionCode);
        if (phoneMetadata == null) {
            return "";
        }
        Phonemetadata.PhoneNumberDesc desc = phoneMetadata.getShortCode();
        if (desc.hasExampleNumber()) {
            return desc.getExampleNumber();
        }
        return "";
    }

    String getExampleShortNumberForCost(String regionCode, ShortNumberCost cost) {
        Phonemetadata.PhoneMetadata phoneMetadata = MetadataManager.getShortNumberMetadataForRegion((String)regionCode);
        if (phoneMetadata == null) {
            return "";
        }
        Phonemetadata.PhoneNumberDesc desc = null;
        switch (cost) {
            case TOLL_FREE: {
                desc = phoneMetadata.getTollFree();
                break;
            }
            case STANDARD_RATE: {
                desc = phoneMetadata.getStandardRate();
                break;
            }
            case PREMIUM_RATE: {
                desc = phoneMetadata.getPremiumRate();
                break;
            }
        }
        if (desc != null && desc.hasExampleNumber()) {
            return desc.getExampleNumber();
        }
        return "";
    }

    public boolean connectsToEmergencyNumber(String number, String regionCode) {
        return this.matchesEmergencyNumberHelper(number, regionCode, true);
    }

    public boolean isEmergencyNumber(String number, String regionCode) {
        return this.matchesEmergencyNumberHelper(number, regionCode, false);
    }

    private boolean matchesEmergencyNumberHelper(String number, String regionCode, boolean allowPrefixMatch) {
        if (PhoneNumberUtil.PLUS_CHARS_PATTERN.matcher(number = PhoneNumberUtil.extractPossibleNumber(number)).lookingAt()) {
            return false;
        }
        Phonemetadata.PhoneMetadata metadata = MetadataManager.getShortNumberMetadataForRegion((String)regionCode);
        if (metadata == null || !metadata.hasEmergency()) {
            return false;
        }
        Pattern emergencyNumberPattern = Pattern.compile(metadata.getEmergency().getNationalNumberPattern());
        String normalizedNumber = PhoneNumberUtil.normalizeDigitsOnly(number);
        return !allowPrefixMatch || REGIONS_WHERE_EMERGENCY_NUMBERS_MUST_BE_EXACT.contains(regionCode) ? emergencyNumberPattern.matcher(normalizedNumber).matches() : emergencyNumberPattern.matcher(normalizedNumber).lookingAt();
    }

    public boolean isCarrierSpecific(Phonenumber.PhoneNumber number) {
        List<String> regionCodes = this.phoneUtil.getRegionCodesForCountryCode(number.getCountryCode());
        String regionCode = this.getRegionCodeForShortNumberFromRegionList(number, regionCodes);
        String nationalNumber = this.phoneUtil.getNationalSignificantNumber(number);
        Phonemetadata.PhoneMetadata phoneMetadata = MetadataManager.getShortNumberMetadataForRegion((String)regionCode);
        return phoneMetadata != null && this.phoneUtil.isNumberMatchingDesc(nationalNumber, phoneMetadata.getCarrierSpecific());
    }

    static {
        REGIONS_WHERE_EMERGENCY_NUMBERS_MUST_BE_EXACT.add("BR");
        REGIONS_WHERE_EMERGENCY_NUMBERS_MUST_BE_EXACT.add("CL");
        REGIONS_WHERE_EMERGENCY_NUMBERS_MUST_BE_EXACT.add("NI");
    }

    public static enum ShortNumberCost {
        TOLL_FREE,
        STANDARD_RATE,
        PREMIUM_RATE,
        UNKNOWN_COST;

    }
}

