/*
 * Decompiled with CFR 0.152.
 */
package com.android.i18n.phonenumbers.prefixmapper;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeSet;

public class MappingFileProvider
implements Externalizable {
    private int numOfEntries = 0;
    private int[] countryCallingCodes;
    private List<Set<String>> availableLanguages;
    private static final Map<String, String> LOCALE_NORMALIZATION_MAP;

    public void readFileConfigs(SortedMap<Integer, Set<String>> availableDataFiles) {
        this.numOfEntries = availableDataFiles.size();
        this.countryCallingCodes = new int[this.numOfEntries];
        this.availableLanguages = new ArrayList<Set<String>>(this.numOfEntries);
        int index = 0;
        Iterator i$ = availableDataFiles.keySet().iterator();
        while (i$.hasNext()) {
            int countryCallingCode = (Integer)i$.next();
            this.countryCallingCodes[index++] = countryCallingCode;
            this.availableLanguages.add(new HashSet((Collection)availableDataFiles.get(countryCallingCode)));
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        this.numOfEntries = objectInput.readInt();
        if (this.countryCallingCodes == null || this.countryCallingCodes.length < this.numOfEntries) {
            this.countryCallingCodes = new int[this.numOfEntries];
        }
        if (this.availableLanguages == null) {
            this.availableLanguages = new ArrayList<Set<String>>();
        }
        for (int i = 0; i < this.numOfEntries; ++i) {
            this.countryCallingCodes[i] = objectInput.readInt();
            int numOfLangs = objectInput.readInt();
            HashSet<String> setOfLangs = new HashSet<String>();
            for (int j = 0; j < numOfLangs; ++j) {
                setOfLangs.add(objectInput.readUTF());
            }
            this.availableLanguages.add(setOfLangs);
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.numOfEntries);
        for (int i = 0; i < this.numOfEntries; ++i) {
            objectOutput.writeInt(this.countryCallingCodes[i]);
            Set<String> setOfLangs = this.availableLanguages.get(i);
            int numOfLangs = setOfLangs.size();
            objectOutput.writeInt(numOfLangs);
            for (String lang : setOfLangs) {
                objectOutput.writeUTF(lang);
            }
        }
    }

    public String toString() {
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < this.numOfEntries; ++i) {
            output.append(this.countryCallingCodes[i]);
            output.append('|');
            TreeSet sortedSetOfLangs = new TreeSet(this.availableLanguages.get(i));
            for (String lang : sortedSetOfLangs) {
                output.append(lang);
                output.append(',');
            }
            output.append('\n');
        }
        return output.toString();
    }

    String getFileName(int countryCallingCode, String language, String script, String region) {
        String languageCode;
        if (language.length() == 0) {
            return "";
        }
        int index = Arrays.binarySearch(this.countryCallingCodes, countryCallingCode);
        if (index < 0) {
            return "";
        }
        Set<String> setOfLangs = this.availableLanguages.get(index);
        if (setOfLangs.size() > 0 && (languageCode = this.findBestMatchingLanguageCode(setOfLangs, language, script, region)).length() > 0) {
            StringBuilder fileName = new StringBuilder();
            fileName.append(countryCallingCode).append('_').append(languageCode);
            return fileName.toString();
        }
        return "";
    }

    private String findBestMatchingLanguageCode(Set<String> setOfLangs, String language, String script, String region) {
        StringBuilder fullLocale = this.constructFullLocale(language, script, region);
        String fullLocaleStr = fullLocale.toString();
        String normalizedLocale = LOCALE_NORMALIZATION_MAP.get(fullLocaleStr);
        if (normalizedLocale != null && setOfLangs.contains(normalizedLocale)) {
            return normalizedLocale;
        }
        if (setOfLangs.contains(fullLocaleStr)) {
            return fullLocaleStr;
        }
        if (this.onlyOneOfScriptOrRegionIsEmpty(script, region)) {
            if (setOfLangs.contains(language)) {
                return language;
            }
        } else if (script.length() > 0 && region.length() > 0) {
            StringBuilder langWithScript = new StringBuilder(language).append('_').append(script);
            String langWithScriptStr = langWithScript.toString();
            if (setOfLangs.contains(langWithScriptStr)) {
                return langWithScriptStr;
            }
            StringBuilder langWithRegion = new StringBuilder(language).append('_').append(region);
            String langWithRegionStr = langWithRegion.toString();
            if (setOfLangs.contains(langWithRegionStr)) {
                return langWithRegionStr;
            }
            if (setOfLangs.contains(language)) {
                return language;
            }
        }
        return "";
    }

    private boolean onlyOneOfScriptOrRegionIsEmpty(String script, String region) {
        return script.length() == 0 && region.length() > 0 || region.length() == 0 && script.length() > 0;
    }

    private StringBuilder constructFullLocale(String language, String script, String region) {
        StringBuilder fullLocale = new StringBuilder(language);
        this.appendSubsequentLocalePart(script, fullLocale);
        this.appendSubsequentLocalePart(region, fullLocale);
        return fullLocale;
    }

    private void appendSubsequentLocalePart(String subsequentLocalePart, StringBuilder fullLocale) {
        if (subsequentLocalePart.length() > 0) {
            fullLocale.append('_').append(subsequentLocalePart);
        }
    }

    static {
        HashMap<String, String> normalizationMap = new HashMap<String, String>();
        normalizationMap.put("zh_TW", "zh_Hant");
        normalizationMap.put("zh_HK", "zh_Hant");
        normalizationMap.put("zh_MO", "zh_Hant");
        LOCALE_NORMALIZATION_MAP = Collections.unmodifiableMap(normalizationMap);
    }
}

