/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.os.Build;
import android.telephony.Rlog;
import android.telephony.SmsManager;
import android.telephony.TelephonyManager;
import android.util.SparseIntArray;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.cdma.sms.UserData;
import com.android.internal.util.XmlUtils;

public class Sms7BitEncodingTranslator {
    private static final String TAG = "Sms7BitEncodingTranslator";
    private static final boolean DBG = Build.IS_DEBUGGABLE;
    private static boolean mIs7BitTranslationTableLoaded = false;
    private static SparseIntArray mTranslationTable = null;
    private static SparseIntArray mTranslationTableCommon = null;
    private static SparseIntArray mTranslationTableGSM = null;
    private static SparseIntArray mTranslationTableCDMA = null;
    private static final String XML_START_TAG = "SmsEnforce7BitTranslationTable";
    private static final String XML_TRANSLATION_TYPE_TAG = "TranslationType";
    private static final String XML_CHARACTOR_TAG = "Character";
    private static final String XML_FROM_TAG = "from";
    private static final String XML_TO_TAG = "to";

    public static String translate(CharSequence message) {
        if (message == null) {
            Rlog.w(TAG, "Null message can not be translated");
            return null;
        }
        int size = message.length();
        if (size <= 0) {
            return "";
        }
        if (!mIs7BitTranslationTableLoaded) {
            mTranslationTableCommon = new SparseIntArray();
            mTranslationTableGSM = new SparseIntArray();
            mTranslationTableCDMA = new SparseIntArray();
            Sms7BitEncodingTranslator.load7BitTranslationTableFromXml();
            mIs7BitTranslationTableLoaded = true;
        }
        if (mTranslationTableCommon != null && mTranslationTableCommon.size() > 0 || mTranslationTableGSM != null && mTranslationTableGSM.size() > 0 || mTranslationTableCDMA != null && mTranslationTableCDMA.size() > 0) {
            char[] output = new char[size];
            for (int i = 0; i < size; ++i) {
                output[i] = Sms7BitEncodingTranslator.translateIfNeeded(message.charAt(i));
            }
            return String.valueOf(output);
        }
        return null;
    }

    private static char translateIfNeeded(char c) {
        if (Sms7BitEncodingTranslator.noTranslationNeeded(c)) {
            if (DBG) {
                Rlog.v(TAG, "No translation needed for " + Integer.toHexString(c));
            }
            return c;
        }
        int translation = -1;
        if (mTranslationTableCommon != null) {
            translation = mTranslationTableCommon.get(c, -1);
        }
        if (translation == -1) {
            if (Sms7BitEncodingTranslator.useCdmaFormatForMoSms()) {
                if (mTranslationTableCDMA != null) {
                    translation = mTranslationTableCDMA.get(c, -1);
                }
            } else if (mTranslationTableGSM != null) {
                translation = mTranslationTableGSM.get(c, -1);
            }
        }
        if (translation != -1) {
            if (DBG) {
                Rlog.v(TAG, Integer.toHexString(c) + " (" + c + ")" + " translated to " + Integer.toHexString(translation) + " (" + (char)translation + ")");
            }
            return (char)translation;
        }
        if (DBG) {
            Rlog.w(TAG, "No translation found for " + Integer.toHexString(c) + "! Replacing for empty space");
        }
        return ' ';
    }

    private static boolean noTranslationNeeded(char c) {
        if (Sms7BitEncodingTranslator.useCdmaFormatForMoSms()) {
            return GsmAlphabet.isGsmSeptets((char)c) && UserData.charToAscii.get(c, -1) != -1;
        }
        return GsmAlphabet.isGsmSeptets((char)c);
    }

    private static boolean useCdmaFormatForMoSms() {
        if (!SmsManager.getDefault().isImsSmsSupported()) {
            return TelephonyManager.getDefault().getCurrentPhoneType() == 2;
        }
        return "3gpp2".equals(SmsManager.getDefault().getImsSmsFormat());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load7BitTranslationTableFromXml() {
        XmlResourceParser parser = null;
        Resources r = Resources.getSystem();
        if (parser == null) {
            if (DBG) {
                Rlog.d(TAG, "load7BitTranslationTableFromXml: open normal file");
            }
            parser = r.getXml(0x1110010);
        }
        try {
            XmlUtils.beginDocument(parser, XML_START_TAG);
            while (true) {
                XmlUtils.nextElement(parser);
                String tag = parser.getName();
                if (DBG) {
                    Rlog.d(TAG, "tag: " + tag);
                }
                if (XML_TRANSLATION_TYPE_TAG.equals(tag)) {
                    String type = parser.getAttributeValue(null, "Type");
                    if (DBG) {
                        Rlog.d(TAG, "type: " + type);
                    }
                    if (type.equals("common")) {
                        mTranslationTable = mTranslationTableCommon;
                        continue;
                    }
                    if (type.equals("gsm")) {
                        mTranslationTable = mTranslationTableGSM;
                        continue;
                    }
                    if (type.equals("cdma")) {
                        mTranslationTable = mTranslationTableCDMA;
                        continue;
                    }
                    Rlog.e(TAG, "Error Parsing 7BitTranslationTable: found incorrect type" + type);
                    continue;
                }
                if (!XML_CHARACTOR_TAG.equals(tag) || mTranslationTable == null) break;
                int from = parser.getAttributeUnsignedIntValue(null, XML_FROM_TAG, -1);
                int to = parser.getAttributeUnsignedIntValue(null, XML_TO_TAG, -1);
                if (from != -1 && to != -1) {
                    if (DBG) {
                        Rlog.d(TAG, "Loading mapping " + Integer.toHexString(from).toUpperCase() + " -> " + Integer.toHexString(to).toUpperCase());
                    }
                    mTranslationTable.put(from, to);
                    continue;
                }
                Rlog.d(TAG, "Invalid translation table file format");
            }
            if (DBG) {
                Rlog.d(TAG, "load7BitTranslationTableFromXml: parsing successful, file loaded");
            }
        }
        catch (Exception e) {
            Rlog.e(TAG, "Got exception while loading 7BitTranslationTable file.", e);
        }
        finally {
            if (parser instanceof XmlResourceParser) {
                parser.close();
            }
        }
    }
}

