/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.ActivityManagerNative;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.telephony.Rlog;
import android.telephony.SubInfoRecord;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneProxy;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.uicc.IccFileHandler;
import com.android.internal.telephony.uicc.IccUtils;
import com.android.internal.telephony.uicc.SpnOverride;
import java.util.List;

public class SubInfoRecordUpdater
extends Handler {
    private static final String LOG_TAG = "SUB";
    private static final int PROJECT_SIM_NUM = TelephonyManager.getDefault().getPhoneCount();
    private static final int EVENT_OFFSET = 8;
    private static final int EVENT_QUERY_ICCID_DONE = 1;
    private static final String ICCID_STRING_FOR_NO_SIM = "";
    public static final int SIM_NOT_CHANGE = 0;
    public static final int SIM_CHANGED = -1;
    public static final int SIM_NEW = -2;
    public static final int SIM_REPOSITION = -3;
    public static final int SIM_NOT_INSERT = -99;
    public static final int STATUS_NO_SIM_INSERTED = 0;
    public static final int STATUS_SIM1_INSERTED = 1;
    public static final int STATUS_SIM2_INSERTED = 2;
    public static final int STATUS_SIM3_INSERTED = 4;
    public static final int STATUS_SIM4_INSERTED = 8;
    private static Phone[] sPhone;
    private static Context sContext;
    private static IccFileHandler[] sFh;
    private static String[] sIccId;
    private static int[] sInsertSimState;
    private static TelephonyManager sTelephonyMgr;
    private static boolean sNeedUpdate;
    private final BroadcastReceiver sReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            SubInfoRecordUpdater.logd("[Receiver]+");
            String action = intent.getAction();
            SubInfoRecordUpdater.logd("Action: " + action);
            if (action.equals("android.intent.action.SIM_STATE_CHANGED")) {
                String simStatus = intent.getStringExtra("ss");
                int slotId = intent.getIntExtra("slot", -1000);
                SubInfoRecordUpdater.logd("slotId: " + slotId + " simStatus: " + simStatus);
                if (slotId == -1000) {
                    return;
                }
                if ("READY".equals(simStatus) || "LOCKED".equals(simStatus)) {
                    if (sIccId[slotId] != null && sIccId[slotId].equals(SubInfoRecordUpdater.ICCID_STRING_FOR_NO_SIM)) {
                        SubInfoRecordUpdater.logd("SIM" + (slotId + 1) + " hot plug in");
                        sIccId[slotId] = null;
                        sNeedUpdate = true;
                    }
                    SubInfoRecordUpdater.this.queryIccId(slotId);
                } else if ("LOADED".equals(simStatus)) {
                    long subId;
                    SubInfoRecordUpdater.this.queryIccId(slotId);
                    if (sTelephonyMgr == null) {
                        sTelephonyMgr = TelephonyManager.from(sContext);
                    }
                    if (SubscriptionManager.isValidSubId(subId = intent.getLongExtra("subscription", -1000L))) {
                        SubInfoRecord subInfo;
                        String msisdn = TelephonyManager.getDefault().getLine1NumberForSubscriber(subId);
                        ContentResolver contentResolver = sContext.getContentResolver();
                        if (msisdn != null) {
                            ContentValues number = new ContentValues(1);
                            number.put("number", msisdn);
                            contentResolver.update(SubscriptionManager.CONTENT_URI, number, "_id=" + Long.toString(subId), null);
                        }
                        if ((subInfo = SubscriptionManager.getSubInfoForSubscriber(subId)) != null && subInfo.nameSource != 2) {
                            String nameToSet;
                            SpnOverride mSpnOverride = new SpnOverride();
                            String CarrierName = TelephonyManager.getDefault().getSimOperator(subId);
                            SubInfoRecordUpdater.logd("CarrierName = " + CarrierName);
                            if (mSpnOverride.containsCarrier(CarrierName)) {
                                nameToSet = mSpnOverride.getSpn(CarrierName) + " 0" + Integer.toString(slotId + 1);
                                SubInfoRecordUpdater.logd("Found, name = " + nameToSet);
                            } else {
                                nameToSet = "SUB 0" + Integer.toString(slotId + 1);
                                SubInfoRecordUpdater.logd("Not found, name = " + nameToSet);
                            }
                            ContentValues name = new ContentValues(1);
                            name.put("display_name", nameToSet);
                            contentResolver.update(SubscriptionManager.CONTENT_URI, name, "_id=" + Long.toString(subId), null);
                        }
                    } else {
                        SubInfoRecordUpdater.logd("[Receiver] Invalid subId, could not update ContentResolver");
                    }
                } else if ("ABSENT".equals(simStatus)) {
                    if (sIccId[slotId] != null && !sIccId[slotId].equals(SubInfoRecordUpdater.ICCID_STRING_FOR_NO_SIM)) {
                        SubInfoRecordUpdater.logd("SIM" + (slotId + 1) + " hot plug out");
                        sNeedUpdate = true;
                    }
                    sFh[slotId] = null;
                    sIccId[slotId] = SubInfoRecordUpdater.ICCID_STRING_FOR_NO_SIM;
                    if (SubInfoRecordUpdater.this.isAllIccIdQueryDone() && sNeedUpdate) {
                        SubInfoRecordUpdater.this.updateSimInfoByIccId();
                    }
                }
            }
            SubInfoRecordUpdater.logd("[Receiver]-");
        }
    };

    public SubInfoRecordUpdater(Context context, Phone[] phoneProxy, CommandsInterface[] ci) {
        SubInfoRecordUpdater.logd("Constructor invoked");
        sContext = context;
        sPhone = phoneProxy;
        IntentFilter intentFilter = new IntentFilter("android.intent.action.SIM_STATE_CHANGED");
        sContext.registerReceiver(this.sReceiver, intentFilter);
    }

    private static int encodeEventId(int event, int slotId) {
        return event << slotId * 8;
    }

    private boolean isAllIccIdQueryDone() {
        for (int i = 0; i < PROJECT_SIM_NUM; ++i) {
            if (sIccId[i] != null) continue;
            SubInfoRecordUpdater.logd("Wait for SIM" + (i + 1) + " IccId");
            return false;
        }
        SubInfoRecordUpdater.logd("All IccIds query complete");
        return true;
    }

    public static void setDisplayNameForNewSub(String newSubName, int subId, int newNameSource) {
        SubInfoRecord subInfo = SubscriptionManager.getSubInfoForSubscriber(subId);
        if (subInfo != null) {
            int oldNameSource = subInfo.nameSource;
            String oldSubName = subInfo.displayName;
            SubInfoRecordUpdater.logd("[setDisplayNameForNewSub] mSubInfoIdx = " + subInfo.subId + ", oldSimName = " + oldSubName + ", oldNameSource = " + oldNameSource + ", newSubName = " + newSubName + ", newNameSource = " + newNameSource);
            if (oldSubName == null || oldNameSource == 0 && newSubName != null || oldNameSource == 1 && newSubName != null && !newSubName.equals(oldSubName)) {
                SubscriptionManager.setDisplayName(newSubName, subInfo.subId, newNameSource);
            }
        } else {
            SubInfoRecordUpdater.logd(LOG_TAG + (subId + 1) + " SubInfo not created yet");
        }
    }

    @Override
    public void handleMessage(Message msg) {
        int pivot;
        int slotId;
        AsyncResult ar = (AsyncResult)msg.obj;
        int msgNum = msg.what;
        for (slotId = 0; slotId <= 2 && msgNum >= (pivot = 1 << slotId * 8); ++slotId) {
        }
        int event = msgNum >> --slotId * 8;
        switch (event) {
            case 1: {
                SubInfoRecordUpdater.logd("handleMessage : <EVENT_QUERY_ICCID_DONE> SIM" + (slotId + 1));
                if (ar.exception == null) {
                    if (ar.result != null) {
                        byte[] data = (byte[])ar.result;
                        SubInfoRecordUpdater.sIccId[slotId] = IccUtils.bcdToString(data, 0, data.length);
                    } else {
                        SubInfoRecordUpdater.logd("Null ar");
                        SubInfoRecordUpdater.sIccId[slotId] = ICCID_STRING_FOR_NO_SIM;
                    }
                } else {
                    SubInfoRecordUpdater.sIccId[slotId] = ICCID_STRING_FOR_NO_SIM;
                    SubInfoRecordUpdater.logd("Query IccId fail: " + ar.exception);
                }
                SubInfoRecordUpdater.logd("sIccId[" + slotId + "] = " + sIccId[slotId]);
                if (!this.isAllIccIdQueryDone() || !sNeedUpdate) break;
                this.updateSimInfoByIccId();
                break;
            }
            default: {
                SubInfoRecordUpdater.logd("Unknown msg:" + msg.what);
            }
        }
    }

    private void queryIccId(int slotId) {
        SubInfoRecordUpdater.logd("queryIccId: slotid=" + slotId);
        if (sFh[slotId] == null) {
            SubInfoRecordUpdater.logd("Getting IccFileHandler");
            SubInfoRecordUpdater.sFh[slotId] = ((PhoneProxy)sPhone[slotId]).getIccFileHandler();
        }
        if (sFh[slotId] != null) {
            String iccId = sIccId[slotId];
            if (iccId == null) {
                SubInfoRecordUpdater.logd("Querying IccId");
                sFh[slotId].loadEFTransparent(12258, this.obtainMessage(SubInfoRecordUpdater.encodeEventId(1, slotId)));
            } else {
                SubInfoRecordUpdater.logd("NOT Querying IccId its already set sIccid[" + slotId + "]=" + iccId);
            }
        } else {
            SubInfoRecordUpdater.logd("sFh[" + slotId + "] is null, ignore");
        }
    }

    public synchronized void updateSimInfoByIccId() {
        int i;
        int i2;
        int i3;
        SubInfoRecordUpdater.logd("[updateSimInfoByIccId]+ Start");
        sNeedUpdate = false;
        SubscriptionManager.clearSubInfo();
        for (int i4 = 0; i4 < PROJECT_SIM_NUM; ++i4) {
            SubInfoRecordUpdater.sInsertSimState[i4] = 0;
        }
        int insertedSimCount = PROJECT_SIM_NUM;
        for (int i5 = 0; i5 < PROJECT_SIM_NUM; ++i5) {
            if (!ICCID_STRING_FOR_NO_SIM.equals(sIccId[i5])) continue;
            --insertedSimCount;
            SubInfoRecordUpdater.sInsertSimState[i5] = -99;
        }
        SubInfoRecordUpdater.logd("insertedSimCount = " + insertedSimCount);
        int index = 0;
        for (int i6 = 0; i6 < PROJECT_SIM_NUM; ++i6) {
            if (sInsertSimState[i6] == -99) continue;
            index = 2;
            for (int j = i6 + 1; j < PROJECT_SIM_NUM; ++j) {
                if (sInsertSimState[j] != 0 || !sIccId[i6].equals(sIccId[j])) continue;
                SubInfoRecordUpdater.sInsertSimState[i6] = 1;
                SubInfoRecordUpdater.sInsertSimState[j] = index++;
            }
        }
        ContentResolver contentResolver = sContext.getContentResolver();
        String[] oldIccId = new String[PROJECT_SIM_NUM];
        for (i3 = 0; i3 < PROJECT_SIM_NUM; ++i3) {
            oldIccId[i3] = null;
            List<SubInfoRecord> oldSubInfo = SubscriptionController.getInstance().getSubInfoUsingSlotIdWithCheck(i3, false);
            if (oldSubInfo != null) {
                oldIccId[i3] = oldSubInfo.get((int)0).iccId;
                SubInfoRecordUpdater.logd("oldSubId = " + oldSubInfo.get((int)0).subId);
                if (sInsertSimState[i3] == 0 && !sIccId[i3].equals(oldIccId[i3])) {
                    SubInfoRecordUpdater.sInsertSimState[i3] = -1;
                }
                if (sInsertSimState[i3] == 0) continue;
                ContentValues value = new ContentValues(1);
                value.put("sim_id", -1000);
                contentResolver.update(SubscriptionManager.CONTENT_URI, value, "_id=" + Long.toString(oldSubInfo.get((int)0).subId), null);
                continue;
            }
            if (sInsertSimState[i3] == 0) {
                SubInfoRecordUpdater.sInsertSimState[i3] = -1;
            }
            oldIccId[i3] = ICCID_STRING_FOR_NO_SIM;
            SubInfoRecordUpdater.logd("No SIM in slot " + i3 + " last time");
        }
        for (i3 = 0; i3 < PROJECT_SIM_NUM; ++i3) {
            SubInfoRecordUpdater.logd("oldIccId[" + i3 + "] = " + oldIccId[i3] + ", sIccId[" + i3 + "] = " + sIccId[i3]);
        }
        int nNewCardCount = 0;
        int nNewSimStatus = 0;
        for (i2 = 0; i2 < PROJECT_SIM_NUM; ++i2) {
            if (sInsertSimState[i2] == -99) {
                SubInfoRecordUpdater.logd("No SIM inserted in slot " + i2 + " this time");
                continue;
            }
            if (sInsertSimState[i2] > 0) {
                SubscriptionManager.addSubInfoRecord(sIccId[i2] + Integer.toString(sInsertSimState[i2]), i2);
                SubInfoRecordUpdater.logd(LOG_TAG + (i2 + 1) + " has invalid IccId");
            } else {
                SubscriptionManager.addSubInfoRecord(sIccId[i2], i2);
            }
            if (!SubInfoRecordUpdater.isNewSim(sIccId[i2], oldIccId)) continue;
            ++nNewCardCount;
            switch (i2) {
                case 0: {
                    nNewSimStatus |= 1;
                    break;
                }
                case 1: {
                    nNewSimStatus |= 2;
                    break;
                }
                case 2: {
                    nNewSimStatus |= 4;
                }
            }
            SubInfoRecordUpdater.sInsertSimState[i2] = -2;
        }
        for (i2 = 0; i2 < PROJECT_SIM_NUM; ++i2) {
            if (sInsertSimState[i2] == -1) {
                SubInfoRecordUpdater.sInsertSimState[i2] = -3;
            }
            SubInfoRecordUpdater.logd("sInsertSimState[" + i2 + "] = " + sInsertSimState[i2]);
        }
        List<SubInfoRecord> subInfos = SubscriptionManager.getActiveSubInfoList();
        int nSubCount = subInfos == null ? 0 : subInfos.size();
        SubInfoRecordUpdater.logd("nSubCount = " + nSubCount);
        for (int i7 = 0; i7 < nSubCount; ++i7) {
            SubInfoRecord temp = subInfos.get(i7);
            String msisdn = TelephonyManager.getDefault().getLine1NumberForSubscriber(temp.subId);
            if (msisdn == null) continue;
            ContentValues value = new ContentValues(1);
            value.put("number", msisdn);
            contentResolver.update(SubscriptionManager.CONTENT_URI, value, "_id=" + Long.toString(temp.subId), null);
        }
        boolean hasSimRemoved = false;
        for (i = 0; i < PROJECT_SIM_NUM; ++i) {
            if (sIccId[i] == null || !sIccId[i].equals(ICCID_STRING_FOR_NO_SIM) || oldIccId[i].equals(ICCID_STRING_FOR_NO_SIM)) continue;
            hasSimRemoved = true;
            break;
        }
        if (nNewCardCount == 0) {
            if (hasSimRemoved) {
                for (i = 0; i < PROJECT_SIM_NUM; ++i) {
                    if (sInsertSimState[i] != -3) continue;
                    SubInfoRecordUpdater.logd("No new SIM detected and SIM repositioned");
                    SubInfoRecordUpdater.setUpdatedData(3, nSubCount, nNewSimStatus);
                    break;
                }
                if (i == PROJECT_SIM_NUM) {
                    SubInfoRecordUpdater.logd("No new SIM detected and SIM removed");
                    SubInfoRecordUpdater.setUpdatedData(2, nSubCount, nNewSimStatus);
                }
            } else {
                for (i = 0; i < PROJECT_SIM_NUM; ++i) {
                    if (sInsertSimState[i] != -3) continue;
                    SubInfoRecordUpdater.logd("No new SIM detected and SIM repositioned");
                    SubInfoRecordUpdater.setUpdatedData(3, nSubCount, nNewSimStatus);
                    break;
                }
                if (i == PROJECT_SIM_NUM) {
                    SubInfoRecordUpdater.logd("[updateSimInfoByIccId] All SIM inserted into the same slot");
                    SubInfoRecordUpdater.setUpdatedData(4, nSubCount, nNewSimStatus);
                }
            }
        } else {
            SubInfoRecordUpdater.logd("New SIM detected");
            SubInfoRecordUpdater.setUpdatedData(1, nSubCount, nNewSimStatus);
        }
        SubInfoRecordUpdater.logd("[updateSimInfoByIccId]- SimInfo update complete");
    }

    private static void setUpdatedData(int detectedType, int subCount, int newSimStatus) {
        Intent intent = new Intent("android.intent.action.ACTION_SUBINFO_RECORD_UPDATED");
        SubInfoRecordUpdater.logd("[setUpdatedData]+ ");
        if (detectedType == 1) {
            intent.putExtra("simDetectStatus", 1);
            intent.putExtra("simCount", subCount);
            intent.putExtra("newSIMSlot", newSimStatus);
        } else if (detectedType == 3) {
            intent.putExtra("simDetectStatus", 3);
            intent.putExtra("simCount", subCount);
        } else if (detectedType == 2) {
            intent.putExtra("simDetectStatus", 2);
            intent.putExtra("simCount", subCount);
        } else if (detectedType == 4) {
            intent.putExtra("simDetectStatus", 4);
        }
        SubInfoRecordUpdater.logd("broadcast intent ACTION_SUBINFO_RECORD_UPDATED : [" + detectedType + ", " + subCount + ", " + newSimStatus + "]");
        ActivityManagerNative.broadcastStickyIntent(intent, "android.permission.READ_PHONE_STATE", -1);
        SubInfoRecordUpdater.logd("[setUpdatedData]- ");
    }

    private static boolean isNewSim(String iccId, String[] oldIccId) {
        boolean newSim = true;
        for (int i = 0; i < PROJECT_SIM_NUM; ++i) {
            if (!iccId.equals(oldIccId[i])) continue;
            newSim = false;
            break;
        }
        SubInfoRecordUpdater.logd("newSim = " + newSim);
        return newSim;
    }

    public void dispose() {
        SubInfoRecordUpdater.logd("[dispose]");
        sContext.unregisterReceiver(this.sReceiver);
    }

    private static void logd(String message) {
        Rlog.d(LOG_TAG, "[SubInfoRecordUpdater]" + message);
    }

    static {
        sContext = null;
        sFh = new IccFileHandler[PROJECT_SIM_NUM];
        sIccId = new String[PROJECT_SIM_NUM];
        sInsertSimState = new int[PROJECT_SIM_NUM];
        sTelephonyMgr = null;
        sNeedUpdate = true;
    }
}

