/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.PendingIntent;
import android.net.Uri;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.Rlog;
import android.telephony.SubscriptionManager;
import com.android.internal.telephony.ISms;
import com.android.internal.telephony.IccSmsInterfaceManager;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneFactory;
import com.android.internal.telephony.PhoneProxy;
import com.android.internal.telephony.SmsRawData;
import com.android.internal.telephony.SubscriptionController;
import java.util.List;

public class UiccSmsController
extends ISms.Stub {
    static final String LOG_TAG = "RIL_UiccSmsController";
    protected Phone[] mPhone;

    protected UiccSmsController(Phone[] phone) {
        this.mPhone = phone;
        if (ServiceManager.getService("isms") == null) {
            ServiceManager.addService("isms", this);
        }
    }

    @Override
    public boolean updateMessageOnIccEf(String callingPackage, int index, int status, byte[] pdu) throws RemoteException {
        return this.updateMessageOnIccEfForSubscriber(this.getPreferredSmsSubscription(), callingPackage, index, status, pdu);
    }

    public boolean updateMessageOnIccEfForSubscriber(long subId, String callingPackage, int index, int status, byte[] pdu) throws RemoteException {
        IccSmsInterfaceManager iccSmsIntMgr = this.getIccSmsInterfaceManager(subId);
        if (iccSmsIntMgr != null) {
            return iccSmsIntMgr.updateMessageOnIccEf(callingPackage, index, status, pdu);
        }
        Rlog.e(LOG_TAG, "updateMessageOnIccEf iccSmsIntMgr is null for Subscription: " + subId);
        return false;
    }

    @Override
    public boolean copyMessageToIccEf(String callingPackage, int status, byte[] pdu, byte[] smsc) throws RemoteException {
        return this.copyMessageToIccEfForSubscriber(this.getPreferredSmsSubscription(), callingPackage, status, pdu, smsc);
    }

    public boolean copyMessageToIccEfForSubscriber(long subId, String callingPackage, int status, byte[] pdu, byte[] smsc) throws RemoteException {
        IccSmsInterfaceManager iccSmsIntMgr = this.getIccSmsInterfaceManager(subId);
        if (iccSmsIntMgr != null) {
            return iccSmsIntMgr.copyMessageToIccEf(callingPackage, status, pdu, smsc);
        }
        Rlog.e(LOG_TAG, "copyMessageToIccEf iccSmsIntMgr is null for Subscription: " + subId);
        return false;
    }

    @Override
    public List<SmsRawData> getAllMessagesFromIccEf(String callingPackage) throws RemoteException {
        return this.getAllMessagesFromIccEfForSubscriber(this.getPreferredSmsSubscription(), callingPackage);
    }

    public List<SmsRawData> getAllMessagesFromIccEfForSubscriber(long subId, String callingPackage) throws RemoteException {
        IccSmsInterfaceManager iccSmsIntMgr = this.getIccSmsInterfaceManager(subId);
        if (iccSmsIntMgr != null) {
            return iccSmsIntMgr.getAllMessagesFromIccEf(callingPackage);
        }
        Rlog.e(LOG_TAG, "getAllMessagesFromIccEf iccSmsIntMgr is null for Subscription: " + subId);
        return null;
    }

    @Override
    public void sendData(String callingPackage, String destAddr, String scAddr, int destPort, byte[] data, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        this.sendDataForSubscriber(this.getPreferredSmsSubscription(), callingPackage, destAddr, scAddr, destPort, data, sentIntent, deliveryIntent);
    }

    public void sendDataForSubscriber(long subId, String callingPackage, String destAddr, String scAddr, int destPort, byte[] data, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        IccSmsInterfaceManager iccSmsIntMgr = this.getIccSmsInterfaceManager(subId);
        if (iccSmsIntMgr != null) {
            iccSmsIntMgr.sendData(callingPackage, destAddr, scAddr, destPort, data, sentIntent, deliveryIntent);
        } else {
            Rlog.e(LOG_TAG, "sendText iccSmsIntMgr is null for Subscription: " + subId);
        }
    }

    @Override
    public void sendText(String callingPackage, String destAddr, String scAddr, String text, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        this.sendTextForSubscriber(this.getPreferredSmsSubscription(), callingPackage, destAddr, scAddr, text, sentIntent, deliveryIntent);
    }

    public void sendTextForSubscriber(long subId, String callingPackage, String destAddr, String scAddr, String text, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        IccSmsInterfaceManager iccSmsIntMgr = this.getIccSmsInterfaceManager(subId);
        if (iccSmsIntMgr != null) {
            iccSmsIntMgr.sendText(callingPackage, destAddr, scAddr, text, sentIntent, deliveryIntent);
        } else {
            Rlog.e(LOG_TAG, "sendText iccSmsIntMgr is null for Subscription: " + subId);
        }
    }

    @Override
    public void sendMultipartText(String callingPackage, String destAddr, String scAddr, List<String> parts, List<PendingIntent> sentIntents, List<PendingIntent> deliveryIntents) throws RemoteException {
        this.sendMultipartTextForSubscriber(this.getPreferredSmsSubscription(), callingPackage, destAddr, scAddr, parts, sentIntents, deliveryIntents);
    }

    public void sendMultipartTextForSubscriber(long subId, String callingPackage, String destAddr, String scAddr, List<String> parts, List<PendingIntent> sentIntents, List<PendingIntent> deliveryIntents) throws RemoteException {
        IccSmsInterfaceManager iccSmsIntMgr = this.getIccSmsInterfaceManager(subId);
        if (iccSmsIntMgr != null) {
            iccSmsIntMgr.sendMultipartText(callingPackage, destAddr, scAddr, parts, sentIntents, deliveryIntents);
        } else {
            Rlog.e(LOG_TAG, "sendMultipartText iccSmsIntMgr is null for Subscription: " + subId);
        }
    }

    @Override
    public boolean enableCellBroadcast(int messageIdentifier) throws RemoteException {
        return this.enableCellBroadcastForSubscriber(this.getPreferredSmsSubscription(), messageIdentifier);
    }

    public boolean enableCellBroadcastForSubscriber(long subId, int messageIdentifier) throws RemoteException {
        return this.enableCellBroadcastRangeForSubscriber(subId, messageIdentifier, messageIdentifier);
    }

    @Override
    public boolean enableCellBroadcastRange(int startMessageId, int endMessageId) throws RemoteException {
        return this.enableCellBroadcastRangeForSubscriber(this.getPreferredSmsSubscription(), startMessageId, endMessageId);
    }

    public boolean enableCellBroadcastRangeForSubscriber(long subId, int startMessageId, int endMessageId) throws RemoteException {
        IccSmsInterfaceManager iccSmsIntMgr = this.getIccSmsInterfaceManager(subId);
        if (iccSmsIntMgr != null) {
            return iccSmsIntMgr.enableCellBroadcastRange(startMessageId, endMessageId);
        }
        Rlog.e(LOG_TAG, "enableCellBroadcast iccSmsIntMgr is null for Subscription: " + subId);
        return false;
    }

    @Override
    public boolean disableCellBroadcast(int messageIdentifier) throws RemoteException {
        return this.disableCellBroadcastForSubscriber(this.getPreferredSmsSubscription(), messageIdentifier);
    }

    public boolean disableCellBroadcastForSubscriber(long subId, int messageIdentifier) throws RemoteException {
        return this.disableCellBroadcastRangeForSubscriber(subId, messageIdentifier, messageIdentifier);
    }

    @Override
    public boolean disableCellBroadcastRange(int startMessageId, int endMessageId) throws RemoteException {
        return this.disableCellBroadcastRangeForSubscriber(this.getPreferredSmsSubscription(), startMessageId, endMessageId);
    }

    public boolean disableCellBroadcastRangeForSubscriber(long subId, int startMessageId, int endMessageId) throws RemoteException {
        IccSmsInterfaceManager iccSmsIntMgr = this.getIccSmsInterfaceManager(subId);
        if (iccSmsIntMgr != null) {
            return iccSmsIntMgr.disableCellBroadcastRange(startMessageId, endMessageId);
        }
        Rlog.e(LOG_TAG, "disableCellBroadcast iccSmsIntMgr is null for Subscription:" + subId);
        return false;
    }

    @Override
    public int getPremiumSmsPermission(String packageName) {
        return this.getPremiumSmsPermissionForSubscriber(this.getPreferredSmsSubscription(), packageName);
    }

    public int getPremiumSmsPermissionForSubscriber(long subId, String packageName) {
        IccSmsInterfaceManager iccSmsIntMgr = this.getIccSmsInterfaceManager(subId);
        if (iccSmsIntMgr != null) {
            return iccSmsIntMgr.getPremiumSmsPermission(packageName);
        }
        Rlog.e(LOG_TAG, "getPremiumSmsPermission iccSmsIntMgr is null");
        return 0;
    }

    @Override
    public void setPremiumSmsPermission(String packageName, int permission2) {
        this.setPremiumSmsPermissionForSubscriber(this.getPreferredSmsSubscription(), packageName, permission2);
    }

    public void setPremiumSmsPermissionForSubscriber(long subId, String packageName, int permission2) {
        IccSmsInterfaceManager iccSmsIntMgr = this.getIccSmsInterfaceManager(subId);
        if (iccSmsIntMgr != null) {
            iccSmsIntMgr.setPremiumSmsPermission(packageName, permission2);
        } else {
            Rlog.e(LOG_TAG, "setPremiumSmsPermission iccSmsIntMgr is null");
        }
    }

    @Override
    public boolean isImsSmsSupported() {
        return this.isImsSmsSupportedForSubscriber(this.getPreferredSmsSubscription());
    }

    public boolean isImsSmsSupportedForSubscriber(long subId) {
        IccSmsInterfaceManager iccSmsIntMgr = this.getIccSmsInterfaceManager(subId);
        if (iccSmsIntMgr != null) {
            return iccSmsIntMgr.isImsSmsSupported();
        }
        Rlog.e(LOG_TAG, "isImsSmsSupported iccSmsIntMgr is null");
        return false;
    }

    @Override
    public String getImsSmsFormat() {
        return this.getImsSmsFormatForSubscriber(this.getPreferredSmsSubscription());
    }

    public String getImsSmsFormatForSubscriber(long subId) {
        IccSmsInterfaceManager iccSmsIntMgr = this.getIccSmsInterfaceManager(subId);
        if (iccSmsIntMgr != null) {
            return iccSmsIntMgr.getImsSmsFormat();
        }
        Rlog.e(LOG_TAG, "getImsSmsFormat iccSmsIntMgr is null");
        return null;
    }

    public void updateSmsSendStatus(int messageRef, boolean success) {
        this.getIccSmsInterfaceManager(SubscriptionManager.getDefaultSmsSubId()).updateSmsSendStatus(messageRef, success);
    }

    public void injectSmsPdu(byte[] pdu, String format, PendingIntent receivedIntent) {
        this.injectSmsPdu(SubscriptionManager.getDefaultSmsSubId(), pdu, format, receivedIntent);
    }

    public void injectSmsPdu(long subId, byte[] pdu, String format, PendingIntent receivedIntent) {
        this.getIccSmsInterfaceManager(subId).injectSmsPdu(pdu, format, receivedIntent);
    }

    private IccSmsInterfaceManager getIccSmsInterfaceManager(long subId) {
        int phoneId = SubscriptionController.getInstance().getPhoneId(subId);
        if (!SubscriptionManager.isValidPhoneId(phoneId) || phoneId == Integer.MAX_VALUE) {
            phoneId = 0;
        }
        try {
            return ((PhoneProxy)this.mPhone[phoneId]).getIccSmsInterfaceManager();
        }
        catch (NullPointerException e) {
            Rlog.e(LOG_TAG, "Exception is :" + e.toString() + " For subscription :" + subId);
            e.printStackTrace();
            return null;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Rlog.e(LOG_TAG, "Exception is :" + e.toString() + " For subscription :" + subId);
            e.printStackTrace();
            return null;
        }
    }

    public long getPreferredSmsSubscription() {
        return SubscriptionManager.getDefaultSmsSubId();
    }

    public boolean isSMSPromptEnabled() {
        return PhoneFactory.isSMSPromptEnabled();
    }

    public void sendStoredText(long subId, String callingPkg, Uri messageUri, String scAddress, PendingIntent sentIntent, PendingIntent deliveryIntent) throws RemoteException {
        IccSmsInterfaceManager iccSmsIntMgr = this.getIccSmsInterfaceManager(subId);
        if (iccSmsIntMgr != null) {
            iccSmsIntMgr.sendStoredText(callingPkg, messageUri, scAddress, sentIntent, deliveryIntent);
        } else {
            Rlog.e(LOG_TAG, "sendStoredText iccSmsIntMgr is null for subscription: " + subId);
        }
    }

    public void sendStoredMultipartText(long subId, String callingPkg, Uri messageUri, String scAddress, List<PendingIntent> sentIntents, List<PendingIntent> deliveryIntents) throws RemoteException {
        IccSmsInterfaceManager iccSmsIntMgr = this.getIccSmsInterfaceManager(subId);
        if (iccSmsIntMgr != null) {
            iccSmsIntMgr.sendStoredMultipartText(callingPkg, messageUri, scAddress, sentIntents, deliveryIntents);
        } else {
            Rlog.e(LOG_TAG, "sendStoredMultipartText iccSmsIntMgr is null for subscription: " + subId);
        }
    }
}

