/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cat;

import com.android.internal.telephony.cat.CatLog;

public class ImageDescriptor {
    int mWidth = 0;
    int mHeight = 0;
    int mCodingScheme = 0;
    int mImageId = 0;
    int mHighOffset = 0;
    int mLowOffset = 0;
    int mLength = 0;
    static final int CODING_SCHEME_BASIC = 17;
    static final int CODING_SCHEME_COLOUR = 33;

    ImageDescriptor() {
    }

    static ImageDescriptor parse(byte[] rawData, int valueIndex) {
        ImageDescriptor d = new ImageDescriptor();
        try {
            d.mWidth = rawData[valueIndex++] & 0xFF;
            d.mHeight = rawData[valueIndex++] & 0xFF;
            d.mCodingScheme = rawData[valueIndex++] & 0xFF;
            d.mImageId = (rawData[valueIndex++] & 0xFF) << 8;
            d.mImageId |= rawData[valueIndex++] & 0xFF;
            d.mHighOffset = rawData[valueIndex++] & 0xFF;
            d.mLowOffset = rawData[valueIndex++] & 0xFF;
            d.mLength = (rawData[valueIndex++] & 0xFF) << 8 | rawData[valueIndex++] & 0xFF;
        }
        catch (IndexOutOfBoundsException e) {
            CatLog.d("ImageDescripter", "parse; failed parsing image descriptor");
            d = null;
        }
        return d;
    }
}

