/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import com.android.internal.util.ArrayUtils;

public final class GrowingArrayUtils {
    public static <T> T[] append(T[] array2, int currentSize, T element) {
        assert (currentSize <= array2.length);
        if (currentSize + 1 > array2.length) {
            Object[] newArray = ArrayUtils.newUnpaddedArray(array2.getClass().getComponentType(), (int)GrowingArrayUtils.growSize(currentSize));
            System.arraycopy(array2, 0, newArray, 0, currentSize);
            array2 = newArray;
        }
        array2[currentSize] = element;
        return array2;
    }

    public static int[] append(int[] array2, int currentSize, int element) {
        assert (currentSize <= array2.length);
        if (currentSize + 1 > array2.length) {
            int[] newArray = ArrayUtils.newUnpaddedIntArray((int)GrowingArrayUtils.growSize(currentSize));
            System.arraycopy((int[])array2, (int)0, (int[])newArray, (int)0, (int)currentSize);
            array2 = newArray;
        }
        array2[currentSize] = element;
        return array2;
    }

    public static long[] append(long[] array2, int currentSize, long element) {
        assert (currentSize <= array2.length);
        if (currentSize + 1 > array2.length) {
            long[] newArray = ArrayUtils.newUnpaddedLongArray((int)GrowingArrayUtils.growSize(currentSize));
            System.arraycopy((long[])array2, (int)0, (long[])newArray, (int)0, (int)currentSize);
            array2 = newArray;
        }
        array2[currentSize] = element;
        return array2;
    }

    public static boolean[] append(boolean[] array2, int currentSize, boolean element) {
        assert (currentSize <= array2.length);
        if (currentSize + 1 > array2.length) {
            boolean[] newArray = ArrayUtils.newUnpaddedBooleanArray((int)GrowingArrayUtils.growSize(currentSize));
            System.arraycopy((boolean[])array2, (int)0, (boolean[])newArray, (int)0, (int)currentSize);
            array2 = newArray;
        }
        array2[currentSize] = element;
        return array2;
    }

    public static <T> T[] insert(T[] array2, int currentSize, int index, T element) {
        assert (currentSize <= array2.length);
        if (currentSize + 1 <= array2.length) {
            System.arraycopy(array2, index, array2, index + 1, currentSize - index);
            array2[index] = element;
            return array2;
        }
        Object[] newArray = ArrayUtils.newUnpaddedArray(array2.getClass().getComponentType(), (int)GrowingArrayUtils.growSize(currentSize));
        System.arraycopy(array2, 0, newArray, 0, index);
        newArray[index] = element;
        System.arraycopy(array2, index, newArray, index + 1, array2.length - index);
        return newArray;
    }

    public static int[] insert(int[] array2, int currentSize, int index, int element) {
        assert (currentSize <= array2.length);
        if (currentSize + 1 <= array2.length) {
            System.arraycopy((int[])array2, (int)index, (int[])array2, (int)(index + 1), (int)(currentSize - index));
            array2[index] = element;
            return array2;
        }
        int[] newArray = ArrayUtils.newUnpaddedIntArray((int)GrowingArrayUtils.growSize(currentSize));
        System.arraycopy((int[])array2, (int)0, (int[])newArray, (int)0, (int)index);
        newArray[index] = element;
        System.arraycopy((int[])array2, (int)index, (int[])newArray, (int)(index + 1), (int)(array2.length - index));
        return newArray;
    }

    public static long[] insert(long[] array2, int currentSize, int index, long element) {
        assert (currentSize <= array2.length);
        if (currentSize + 1 <= array2.length) {
            System.arraycopy((long[])array2, (int)index, (long[])array2, (int)(index + 1), (int)(currentSize - index));
            array2[index] = element;
            return array2;
        }
        long[] newArray = ArrayUtils.newUnpaddedLongArray((int)GrowingArrayUtils.growSize(currentSize));
        System.arraycopy((long[])array2, (int)0, (long[])newArray, (int)0, (int)index);
        newArray[index] = element;
        System.arraycopy((long[])array2, (int)index, (long[])newArray, (int)(index + 1), (int)(array2.length - index));
        return newArray;
    }

    public static boolean[] insert(boolean[] array2, int currentSize, int index, boolean element) {
        assert (currentSize <= array2.length);
        if (currentSize + 1 <= array2.length) {
            System.arraycopy((boolean[])array2, (int)index, (boolean[])array2, (int)(index + 1), (int)(currentSize - index));
            array2[index] = element;
            return array2;
        }
        boolean[] newArray = ArrayUtils.newUnpaddedBooleanArray((int)GrowingArrayUtils.growSize(currentSize));
        System.arraycopy((boolean[])array2, (int)0, (boolean[])newArray, (int)0, (int)index);
        newArray[index] = element;
        System.arraycopy((boolean[])array2, (int)index, (boolean[])newArray, (int)(index + 1), (int)(array2.length - index));
        return newArray;
    }

    public static int growSize(int currentSize) {
        return currentSize <= 4 ? 8 : currentSize * 2;
    }

    private GrowingArrayUtils() {
    }
}

