/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.content.res.Resources;
import android.inputmethodservice.Keyboard;
import android.inputmethodservice.KeyboardView;
import android.os.SystemClock;
import android.provider.Settings;
import android.util.Log;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewRootImpl;
import com.android.internal.widget.PasswordEntryKeyboard;

public class PasswordEntryKeyboardHelper
implements KeyboardView.OnKeyboardActionListener {
    public static final int KEYBOARD_MODE_ALPHA = 0;
    public static final int KEYBOARD_MODE_NUMERIC = 1;
    private static final int KEYBOARD_STATE_NORMAL = 0;
    private static final int KEYBOARD_STATE_SHIFTED = 1;
    private static final int KEYBOARD_STATE_CAPSLOCK = 2;
    private static final String TAG = "PasswordEntryKeyboardHelper";
    private int mKeyboardMode = 0;
    private int mKeyboardState = 0;
    private PasswordEntryKeyboard mQwertyKeyboard;
    private PasswordEntryKeyboard mQwertyKeyboardShifted;
    private PasswordEntryKeyboard mSymbolsKeyboard;
    private PasswordEntryKeyboard mSymbolsKeyboardShifted;
    private PasswordEntryKeyboard mNumericKeyboard;
    private final Context mContext;
    private final View mTargetView;
    private final KeyboardView mKeyboardView;
    private long[] mVibratePattern;
    private boolean mEnableHaptics = false;
    private static final int NUMERIC = 0;
    private static final int QWERTY = 1;
    private static final int QWERTY_SHIFTED = 2;
    private static final int SYMBOLS = 3;
    private static final int SYMBOLS_SHIFTED = 4;
    int[] mLayouts = new int[]{17760263, 17760265, 17760266, 17760267, 17760268};
    private boolean mUsingScreenWidth;

    public PasswordEntryKeyboardHelper(Context context, KeyboardView keyboardView, View targetView) {
        this(context, keyboardView, targetView, true, null);
    }

    public PasswordEntryKeyboardHelper(Context context, KeyboardView keyboardView, View targetView, boolean useFullScreenWidth) {
        this(context, keyboardView, targetView, useFullScreenWidth, null);
    }

    public PasswordEntryKeyboardHelper(Context context, KeyboardView keyboardView, View targetView, boolean useFullScreenWidth, int[] layouts) {
        this.mContext = context;
        this.mTargetView = targetView;
        this.mKeyboardView = keyboardView;
        this.mKeyboardView.setOnKeyboardActionListener(this);
        this.mUsingScreenWidth = useFullScreenWidth;
        if (layouts != null) {
            if (layouts.length != this.mLayouts.length) {
                throw new RuntimeException("Wrong number of layouts");
            }
            for (int i = 0; i < this.mLayouts.length; ++i) {
                this.mLayouts[i] = layouts[i];
            }
        }
        this.createKeyboards();
    }

    public void createKeyboards() {
        ViewGroup.LayoutParams lp = this.mKeyboardView.getLayoutParams();
        if (this.mUsingScreenWidth || lp.width == -1) {
            this.createKeyboardsWithDefaultWidth();
        } else {
            this.createKeyboardsWithSpecificSize(lp.width, lp.height);
        }
    }

    public void setEnableHaptics(boolean enabled) {
        this.mEnableHaptics = enabled;
    }

    public boolean isAlpha() {
        return this.mKeyboardMode == 0;
    }

    private void createKeyboardsWithSpecificSize(int width, int height) {
        this.mNumericKeyboard = new PasswordEntryKeyboard(this.mContext, this.mLayouts[0], width, height);
        this.mQwertyKeyboard = new PasswordEntryKeyboard(this.mContext, this.mLayouts[1], 16909183, width, height);
        this.mQwertyKeyboard.enableShiftLock();
        this.mQwertyKeyboardShifted = new PasswordEntryKeyboard(this.mContext, this.mLayouts[2], 16909183, width, height);
        this.mQwertyKeyboardShifted.enableShiftLock();
        this.mQwertyKeyboardShifted.setShifted(true);
        this.mSymbolsKeyboard = new PasswordEntryKeyboard(this.mContext, this.mLayouts[3], width, height);
        this.mSymbolsKeyboard.enableShiftLock();
        this.mSymbolsKeyboardShifted = new PasswordEntryKeyboard(this.mContext, this.mLayouts[4], width, height);
        this.mSymbolsKeyboardShifted.enableShiftLock();
        this.mSymbolsKeyboardShifted.setShifted(true);
    }

    private void createKeyboardsWithDefaultWidth() {
        this.mNumericKeyboard = new PasswordEntryKeyboard(this.mContext, this.mLayouts[0]);
        this.mQwertyKeyboard = new PasswordEntryKeyboard(this.mContext, this.mLayouts[1], 16909183);
        this.mQwertyKeyboard.enableShiftLock();
        this.mQwertyKeyboardShifted = new PasswordEntryKeyboard(this.mContext, this.mLayouts[2], 16909183);
        this.mQwertyKeyboardShifted.enableShiftLock();
        this.mQwertyKeyboardShifted.setShifted(true);
        this.mSymbolsKeyboard = new PasswordEntryKeyboard(this.mContext, this.mLayouts[3]);
        this.mSymbolsKeyboard.enableShiftLock();
        this.mSymbolsKeyboardShifted = new PasswordEntryKeyboard(this.mContext, this.mLayouts[4]);
        this.mSymbolsKeyboardShifted.enableShiftLock();
        this.mSymbolsKeyboardShifted.setShifted(true);
    }

    public void setKeyboardMode(int mode) {
        switch (mode) {
            case 0: {
                this.mKeyboardView.setKeyboard(this.mQwertyKeyboard);
                this.mKeyboardState = 0;
                boolean visiblePassword = Settings.System.getInt(this.mContext.getContentResolver(), "show_password", 1) != 0;
                boolean enablePreview = false;
                if (visiblePassword) {
                    // empty if block
                }
                this.mKeyboardView.setPreviewEnabled(false);
                break;
            }
            case 1: {
                this.mKeyboardView.setKeyboard(this.mNumericKeyboard);
                this.mKeyboardState = 0;
                this.mKeyboardView.setPreviewEnabled(false);
            }
        }
        this.mKeyboardMode = mode;
    }

    private void sendKeyEventsToTarget(int character) {
        ViewRootImpl viewRootImpl = this.mTargetView.getViewRootImpl();
        KeyEvent[] events = KeyCharacterMap.load(-1).getEvents(new char[]{(char)character});
        if (events != null) {
            for (KeyEvent event : events) {
                event = KeyEvent.changeFlags(event, event.getFlags() | 2 | 4);
                viewRootImpl.dispatchInputEvent(event);
            }
        }
    }

    public void sendDownUpKeyEvents(int keyEventCode) {
        long eventTime = SystemClock.uptimeMillis();
        ViewRootImpl viewRootImpl = this.mTargetView.getViewRootImpl();
        viewRootImpl.dispatchKeyFromIme(new KeyEvent(eventTime, eventTime, 0, keyEventCode, 0, 0, -1, 0, 6));
        viewRootImpl.dispatchKeyFromIme(new KeyEvent(eventTime, eventTime, 1, keyEventCode, 0, 0, -1, 0, 6));
    }

    public void onKey(int primaryCode, int[] keyCodes) {
        if (primaryCode == -5) {
            this.handleBackspace();
        } else if (primaryCode == -1) {
            this.handleShift();
        } else {
            if (primaryCode == -3) {
                this.handleClose();
                return;
            }
            if (primaryCode == -2 && this.mKeyboardView != null) {
                this.handleModeChange();
            } else {
                this.handleCharacter(primaryCode, keyCodes);
                if (this.mKeyboardState == 1) {
                    this.mKeyboardState = 2;
                    this.handleShift();
                }
            }
        }
    }

    public void setVibratePattern(int id2) {
        int[] tmpArray;
        block4: {
            tmpArray = null;
            try {
                tmpArray = this.mContext.getResources().getIntArray(id2);
            }
            catch (Resources.NotFoundException e) {
                if (id2 == 0) break block4;
                Log.e(TAG, "Vibrate pattern missing", e);
            }
        }
        if (tmpArray == null) {
            this.mVibratePattern = null;
            return;
        }
        this.mVibratePattern = new long[tmpArray.length];
        for (int i = 0; i < tmpArray.length; ++i) {
            this.mVibratePattern[i] = tmpArray[i];
        }
    }

    private void handleModeChange() {
        Keyboard current = this.mKeyboardView.getKeyboard();
        PasswordEntryKeyboard next = null;
        if (current == this.mQwertyKeyboard || current == this.mQwertyKeyboardShifted) {
            next = this.mSymbolsKeyboard;
        } else if (current == this.mSymbolsKeyboard || current == this.mSymbolsKeyboardShifted) {
            next = this.mQwertyKeyboard;
        }
        if (next != null) {
            this.mKeyboardView.setKeyboard(next);
            this.mKeyboardState = 0;
        }
    }

    public void handleBackspace() {
        this.sendDownUpKeyEvents(67);
        this.performHapticFeedback();
    }

    private void handleShift() {
        boolean isAlphaMode;
        if (this.mKeyboardView == null) {
            return;
        }
        Keyboard current = this.mKeyboardView.getKeyboard();
        PasswordEntryKeyboard next = null;
        boolean bl = isAlphaMode = current == this.mQwertyKeyboard || current == this.mQwertyKeyboardShifted;
        if (this.mKeyboardState == 0) {
            this.mKeyboardState = isAlphaMode ? 1 : 2;
            next = isAlphaMode ? this.mQwertyKeyboardShifted : this.mSymbolsKeyboardShifted;
        } else if (this.mKeyboardState == 1) {
            this.mKeyboardState = 2;
            next = isAlphaMode ? this.mQwertyKeyboardShifted : this.mSymbolsKeyboardShifted;
        } else if (this.mKeyboardState == 2) {
            this.mKeyboardState = 0;
            PasswordEntryKeyboard passwordEntryKeyboard = next = isAlphaMode ? this.mQwertyKeyboard : this.mSymbolsKeyboard;
        }
        if (next != null) {
            if (next != current) {
                this.mKeyboardView.setKeyboard(next);
            }
            next.setShiftLocked(this.mKeyboardState == 2);
            this.mKeyboardView.setShifted(this.mKeyboardState != 0);
        }
    }

    private void handleCharacter(int primaryCode, int[] keyCodes) {
        if (this.mKeyboardView.isShifted() && primaryCode != 32 && primaryCode != 10) {
            primaryCode = Character.toUpperCase(primaryCode);
        }
        this.sendKeyEventsToTarget(primaryCode);
    }

    private void handleClose() {
    }

    public void onPress(int primaryCode) {
        this.performHapticFeedback();
    }

    private void performHapticFeedback() {
        if (this.mEnableHaptics) {
            this.mKeyboardView.performHapticFeedback(1, 3);
        }
    }

    public void onRelease(int primaryCode) {
    }

    public void onText(CharSequence text) {
    }

    public void swipeDown() {
    }

    public void swipeLeft() {
    }

    public void swipeRight() {
    }

    public void swipeUp() {
    }
}

