/*
 * Decompiled with CFR 0.152.
 */
package com.android.okhttp.internal.spdy;

final class Settings {
    static final int DEFAULT_INITIAL_WINDOW_SIZE = 65536;
    static final int FLAG_CLEAR_PREVIOUSLY_PERSISTED_SETTINGS = 1;
    static final int PERSIST_VALUE = 1;
    static final int PERSISTED = 2;
    static final int UPLOAD_BANDWIDTH = 1;
    static final int DOWNLOAD_BANDWIDTH = 2;
    static final int ROUND_TRIP_TIME = 3;
    static final int MAX_CONCURRENT_STREAMS = 4;
    static final int CURRENT_CWND = 5;
    static final int DOWNLOAD_RETRANS_RATE = 6;
    static final int INITIAL_WINDOW_SIZE = 7;
    static final int CLIENT_CERTIFICATE_VECTOR_SIZE = 8;
    static final int COUNT = 9;
    private int set;
    private int persistValue;
    private int persisted;
    private final int[] values = new int[9];

    Settings() {
    }

    void set(int id2, int idFlags, int value) {
        if (id2 >= this.values.length) {
            return;
        }
        int bit = 1 << id2;
        this.set |= bit;
        this.persistValue = (idFlags & 1) != 0 ? (this.persistValue |= bit) : (this.persistValue &= ~bit);
        this.persisted = (idFlags & 2) != 0 ? (this.persisted |= bit) : (this.persisted &= ~bit);
        this.values[id2] = value;
    }

    boolean isSet(int id2) {
        int bit = 1 << id2;
        return (this.set & bit) != 0;
    }

    int get(int id2) {
        return this.values[id2];
    }

    int flags(int id2) {
        int result = 0;
        if (this.isPersisted(id2)) {
            result |= 2;
        }
        if (this.persistValue(id2)) {
            result |= 1;
        }
        return result;
    }

    int size() {
        return Integer.bitCount(this.set);
    }

    int getUploadBandwidth(int defaultValue) {
        int bit = 2;
        return (bit & this.set) != 0 ? this.values[1] : defaultValue;
    }

    int getDownloadBandwidth(int defaultValue) {
        int bit = 4;
        return (bit & this.set) != 0 ? this.values[2] : defaultValue;
    }

    int getRoundTripTime(int defaultValue) {
        int bit = 8;
        return (bit & this.set) != 0 ? this.values[3] : defaultValue;
    }

    int getMaxConcurrentStreams(int defaultValue) {
        int bit = 16;
        return (bit & this.set) != 0 ? this.values[4] : defaultValue;
    }

    int getCurrentCwnd(int defaultValue) {
        int bit = 32;
        return (bit & this.set) != 0 ? this.values[5] : defaultValue;
    }

    int getDownloadRetransRate(int defaultValue) {
        int bit = 64;
        return (bit & this.set) != 0 ? this.values[6] : defaultValue;
    }

    int getInitialWindowSize(int defaultValue) {
        int bit = 128;
        return (bit & this.set) != 0 ? this.values[7] : defaultValue;
    }

    int getClientCertificateVectorSize(int defaultValue) {
        int bit = 256;
        return (bit & this.set) != 0 ? this.values[8] : defaultValue;
    }

    boolean persistValue(int id2) {
        int bit = 1 << id2;
        return (this.persistValue & bit) != 0;
    }

    boolean isPersisted(int id2) {
        int bit = 1 << id2;
        return (this.persisted & bit) != 0;
    }

    void merge(Settings other) {
        for (int i = 0; i < 9; ++i) {
            if (!other.isSet(i)) continue;
            this.set(i, other.flags(i), other.get(i));
        }
    }
}

