/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.android_webview;

import android.content.Context;
import android.content.res.AssetManager;
import android.net.Uri;
import android.util.Log;
import android.util.TypedValue;
import com.android.org.chromium.base.CalledByNativeUnchecked;
import com.android.org.chromium.base.JNINamespace;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URLConnection;
import java.util.List;

@JNINamespace(value="android_webview")
public class AndroidProtocolHandler {
    private static final String TAG = "AndroidProtocolHandler";
    private static final String FILE_SCHEME = "file";
    private static final String CONTENT_SCHEME = "content";

    @CalledByNativeUnchecked
    public static InputStream open(Context context, String url) {
        Uri uri = AndroidProtocolHandler.verifyUrl(url);
        if (uri == null) {
            return null;
        }
        String path = uri.getPath();
        if (uri.getScheme().equals(FILE_SCHEME)) {
            if (path.startsWith(AndroidProtocolHandler.nativeGetAndroidAssetPath())) {
                return AndroidProtocolHandler.openAsset(context, uri);
            }
            if (path.startsWith(AndroidProtocolHandler.nativeGetAndroidResourcePath())) {
                return AndroidProtocolHandler.openResource(context, uri);
            }
        } else if (uri.getScheme().equals(CONTENT_SCHEME)) {
            return AndroidProtocolHandler.openContent(context, uri);
        }
        return null;
    }

    private static int getFieldId(Context context, String assetType, String assetName) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        Class<?> d = context.getClassLoader().loadClass(context.getPackageName() + ".R$" + assetType);
        Field field = d.getField(assetName);
        int id2 = field.getInt(null);
        return id2;
    }

    private static int getValueType(Context context, int field_id) {
        TypedValue value = new TypedValue();
        context.getResources().getValue(field_id, value, true);
        return value.type;
    }

    private static InputStream openResource(Context context, Uri uri) {
        assert (uri.getScheme().equals(FILE_SCHEME));
        assert (uri.getPath() != null);
        assert (uri.getPath().startsWith(AndroidProtocolHandler.nativeGetAndroidResourcePath()));
        List<String> pathSegments = uri.getPathSegments();
        if (pathSegments.size() != 3) {
            Log.e(TAG, "Incorrect resource path: " + uri);
            return null;
        }
        String assetPath = pathSegments.get(0);
        String assetType = pathSegments.get(1);
        String assetName = pathSegments.get(2);
        if (!("/" + assetPath + "/").equals(AndroidProtocolHandler.nativeGetAndroidResourcePath())) {
            Log.e(TAG, "Resource path does not start with " + AndroidProtocolHandler.nativeGetAndroidResourcePath() + ": " + uri);
            return null;
        }
        assetName = assetName.split("\\.")[0];
        try {
            int field_id;
            int value_type;
            if (context.getApplicationContext() != null) {
                context = context.getApplicationContext();
            }
            if ((value_type = AndroidProtocolHandler.getValueType(context, field_id = AndroidProtocolHandler.getFieldId(context, assetType, assetName))) == 3) {
                return context.getResources().openRawResource(field_id);
            }
            Log.e(TAG, "Asset not of type string: " + uri);
            return null;
        }
        catch (ClassNotFoundException e) {
            Log.e(TAG, "Unable to open resource URL: " + uri, e);
            return null;
        }
        catch (NoSuchFieldException e) {
            Log.e(TAG, "Unable to open resource URL: " + uri, e);
            return null;
        }
        catch (IllegalAccessException e) {
            Log.e(TAG, "Unable to open resource URL: " + uri, e);
            return null;
        }
    }

    private static InputStream openAsset(Context context, Uri uri) {
        assert (uri.getScheme().equals(FILE_SCHEME));
        assert (uri.getPath() != null);
        assert (uri.getPath().startsWith(AndroidProtocolHandler.nativeGetAndroidAssetPath()));
        String path = uri.getPath().replaceFirst(AndroidProtocolHandler.nativeGetAndroidAssetPath(), "");
        try {
            AssetManager assets = context.getAssets();
            return assets.open(path, 2);
        }
        catch (IOException e) {
            Log.e(TAG, "Unable to open asset URL: " + uri);
            return null;
        }
    }

    private static InputStream openContent(Context context, Uri uri) {
        assert (uri.getScheme().equals(CONTENT_SCHEME));
        try {
            Uri baseUri = AndroidProtocolHandler.stripQueryParameters(uri);
            return context.getContentResolver().openInputStream(baseUri);
        }
        catch (Exception e) {
            Log.e(TAG, "Unable to open content URL: " + uri);
            return null;
        }
    }

    @CalledByNativeUnchecked
    public static String getMimeType(Context context, InputStream stream, String url) {
        String mimeType;
        Uri uri = AndroidProtocolHandler.verifyUrl(url);
        if (uri == null) {
            return null;
        }
        String path = uri.getPath();
        if (uri.getScheme().equals(CONTENT_SCHEME)) {
            return context.getContentResolver().getType(uri);
        }
        if (uri.getScheme().equals(FILE_SCHEME) && path.startsWith(AndroidProtocolHandler.nativeGetAndroidAssetPath()) && (mimeType = URLConnection.guessContentTypeFromName(path)) != null) {
            return mimeType;
        }
        try {
            return URLConnection.guessContentTypeFromStream(stream);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static Uri verifyUrl(String url) {
        if (url == null) {
            return null;
        }
        Uri uri = Uri.parse(url);
        if (uri == null) {
            Log.e(TAG, "Malformed URL: " + url);
            return null;
        }
        String path = uri.getPath();
        if (path == null || path.length() == 0) {
            Log.e(TAG, "URL does not have a path: " + url);
            return null;
        }
        return uri;
    }

    private static Uri stripQueryParameters(Uri uri) {
        assert (uri.getAuthority() != null);
        assert (uri.getPath() != null);
        Uri.Builder builder = new Uri.Builder();
        builder.scheme(uri.getScheme());
        builder.encodedAuthority(uri.getAuthority());
        builder.encodedPath(uri.getPath());
        return builder.build();
    }

    public static void setResourceContextForTesting(Context context) {
        AndroidProtocolHandler.nativeSetResourceContextForTesting(context);
    }

    private static native void nativeSetResourceContextForTesting(Context var0);

    private static native String nativeGetAndroidAssetPath();

    private static native String nativeGetAndroidResourcePath();
}

