/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.android_webview;

import android.net.http.SslCertificate;
import android.net.http.SslError;
import android.util.Log;
import com.android.org.chromium.net.X509Util;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public class SslUtil {
    private static final String TAG = "SslUtil";

    public static SslError sslErrorFromNetErrorCode(int error, SslCertificate cert, String url) {
        assert (error >= -212 && error <= -200);
        switch (error) {
            case -200: {
                return new SslError(2, cert, url);
            }
            case -201: {
                return new SslError(4, cert, url);
            }
            case -202: {
                return new SslError(3, cert, url);
            }
        }
        return new SslError(5, cert, url);
    }

    public static SslCertificate getCertificateFromDerBytes(byte[] derBytes) {
        if (derBytes == null) {
            return null;
        }
        try {
            X509Certificate x509Certificate = X509Util.createCertificateFromBytes(derBytes);
            return new SslCertificate(x509Certificate);
        }
        catch (CertificateException e) {
            Log.w(TAG, "Could not read certificate: " + e);
        }
        catch (KeyStoreException e) {
            Log.w(TAG, "Could not read certificate: " + e);
        }
        catch (NoSuchAlgorithmException e) {
            Log.w(TAG, "Could not read certificate: " + e);
        }
        return null;
    }
}

