/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.com.googlecode.eyesfree.braille.translate;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.android.org.chromium.com.googlecode.eyesfree.braille.translate.BrailleTranslator;
import com.android.org.chromium.com.googlecode.eyesfree.braille.translate.ITranslatorService;
import com.android.org.chromium.com.googlecode.eyesfree.braille.translate.ITranslatorServiceCallback;

public class TranslatorManager {
    private static final String LOG_TAG = TranslatorManager.class.getSimpleName();
    private static final String ACTION_TRANSLATOR_SERVICE = "com.android.org.chromium.com.googlecode.eyesfree.braille.service.ACTION_TRANSLATOR_SERVICE";
    private static final Intent mServiceIntent = new Intent("com.android.org.chromium.com.googlecode.eyesfree.braille.service.ACTION_TRANSLATOR_SERVICE");
    private static final int REBIND_DELAY_MILLIS = 500;
    private static final int MAX_REBIND_ATTEMPTS = 5;
    public static final int ERROR = -1;
    public static final int SUCCESS = 0;
    private final Context mContext;
    private final TranslatorManagerHandler mHandler = new TranslatorManagerHandler();
    private final ServiceCallback mServiceCallback = new ServiceCallback();
    private OnInitListener mOnInitListener;
    private Connection mConnection;
    private int mNumFailedBinds = 0;

    public TranslatorManager(Context context, OnInitListener onInitListener) {
        this.mContext = context;
        this.mOnInitListener = onInitListener;
        this.doBindService();
    }

    public void destroy() {
        this.doUnbindService();
        this.mHandler.destroy();
    }

    public BrailleTranslator getTranslator(String tableName) {
        ITranslatorService localService = this.getTranslatorService();
        if (localService != null) {
            try {
                if (localService.checkTable(tableName)) {
                    return new BrailleTranslatorImpl(tableName);
                }
            }
            catch (RemoteException ex) {
                Log.e(LOG_TAG, "Error in getTranslator", ex);
            }
        }
        return null;
    }

    private void doBindService() {
        Connection localConnection = new Connection();
        if (!this.mContext.bindService(mServiceIntent, localConnection, 1)) {
            Log.e(LOG_TAG, "Failed to bind to service");
            this.mHandler.scheduleRebind();
            return;
        }
        this.mConnection = localConnection;
        Log.i(LOG_TAG, "Bound to translator service");
    }

    private void doUnbindService() {
        if (this.mConnection != null) {
            this.mContext.unbindService(this.mConnection);
            this.mConnection = null;
        }
    }

    private ITranslatorService getTranslatorService() {
        Connection localConnection = this.mConnection;
        if (localConnection != null) {
            return localConnection.mService;
        }
        return null;
    }

    private class TranslatorManagerHandler
    extends Handler {
        private static final int MSG_ON_INIT = 1;
        private static final int MSG_REBIND_SERVICE = 2;

        private TranslatorManagerHandler() {
        }

        public void onInit(int status) {
            this.obtainMessage(1, status, 0).sendToTarget();
        }

        public void destroy() {
            TranslatorManager.this.mOnInitListener = null;
            this.removeCallbacksAndMessages(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleRebind() {
            TranslatorManagerHandler translatorManagerHandler = this;
            synchronized (translatorManagerHandler) {
                if (TranslatorManager.this.mNumFailedBinds < 5) {
                    int delay = 500 << TranslatorManager.this.mNumFailedBinds;
                    this.sendEmptyMessageDelayed(2, delay);
                    ++TranslatorManager.this.mNumFailedBinds;
                } else {
                    this.onInit(-1);
                }
            }
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    this.handleOnInit(msg.arg1);
                    break;
                }
                case 2: {
                    this.handleRebindService();
                }
            }
        }

        private void handleOnInit(int status) {
            if (TranslatorManager.this.mOnInitListener != null) {
                TranslatorManager.this.mOnInitListener.onInit(status);
                TranslatorManager.this.mOnInitListener = null;
            }
        }

        private void handleRebindService() {
            if (TranslatorManager.this.mConnection != null) {
                TranslatorManager.this.doUnbindService();
            }
            TranslatorManager.this.doBindService();
        }
    }

    private class ServiceCallback
    extends ITranslatorServiceCallback.Stub {
        private ServiceCallback() {
        }

        public void onInit(int status) {
            TranslatorManager.this.mHandler.onInit(status);
        }
    }

    private class BrailleTranslatorImpl
    implements BrailleTranslator {
        private final String mTable;

        public BrailleTranslatorImpl(String table) {
            this.mTable = table;
        }

        public byte[] translate(String text) {
            ITranslatorService localService = TranslatorManager.this.getTranslatorService();
            if (localService != null) {
                try {
                    return localService.translate(text, this.mTable);
                }
                catch (RemoteException ex) {
                    Log.e(LOG_TAG, "Error in translate", ex);
                }
            }
            return null;
        }

        public String backTranslate(byte[] cells) {
            ITranslatorService localService = TranslatorManager.this.getTranslatorService();
            if (localService != null) {
                try {
                    return localService.backTranslate(cells, this.mTable);
                }
                catch (RemoteException ex) {
                    Log.e(LOG_TAG, "Error in backTranslate", ex);
                }
            }
            return null;
        }
    }

    private class Connection
    implements ServiceConnection {
        private volatile ITranslatorService mService;

        private Connection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName className, IBinder binder) {
            Log.i(LOG_TAG, "Connected to translation service");
            ITranslatorService localService = ITranslatorService.Stub.asInterface(binder);
            try {
                localService.setCallback(TranslatorManager.this.mServiceCallback);
                this.mService = localService;
                TranslatorManagerHandler translatorManagerHandler = TranslatorManager.this.mHandler;
                synchronized (translatorManagerHandler) {
                    TranslatorManager.this.mNumFailedBinds = 0;
                }
            }
            catch (RemoteException ex) {
                Log.e(LOG_TAG, "Error when setting callback", ex);
            }
        }

        public void onServiceDisconnected(ComponentName className) {
            Log.e(LOG_TAG, "Disconnected from translator service");
            this.mService = null;
            TranslatorManager.this.mHandler.scheduleRebind();
        }
    }

    public static interface OnInitListener {
        public void onInit(int var1);
    }
}

