/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.content.browser;

import android.content.Context;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.util.Log;
import com.android.org.chromium.base.ActivityStatus;
import com.android.org.chromium.base.CalledByNative;
import com.android.org.chromium.base.ThreadUtils;
import java.util.List;
import java.util.concurrent.FutureTask;

class LocationProvider {
    private static final String TAG = "LocationProvider";
    private LocationProviderImpl mImpl;

    private LocationProvider(Context context) {
        this.mImpl = new LocationProviderImpl(context);
    }

    @CalledByNative
    static LocationProvider create(Context context) {
        return new LocationProvider(context);
    }

    @CalledByNative
    public boolean start(final boolean gpsEnabled) {
        FutureTask<Object> task = new FutureTask<Object>(new Runnable(){

            public void run() {
                LocationProvider.this.mImpl.start(gpsEnabled);
            }
        }, null);
        ThreadUtils.runOnUiThread(task);
        return true;
    }

    @CalledByNative
    public void stop() {
        FutureTask<Object> task = new FutureTask<Object>(new Runnable(){

            public void run() {
                LocationProvider.this.mImpl.stop();
            }
        }, null);
        ThreadUtils.runOnUiThread(task);
    }

    public boolean isRunning() {
        assert (ThreadUtils.runningOnUiThread());
        return this.mImpl.isRunning();
    }

    public static native void nativeNewLocationAvailable(double var0, double var2, double var4, boolean var6, double var7, boolean var9, double var10, boolean var12, double var13, boolean var15, double var16);

    public static native void nativeNewErrorAvailable(String var0);

    private static class LocationProviderImpl
    implements LocationListener,
    ActivityStatus.StateListener {
        private Context mContext;
        private LocationManager mLocationManager;
        private boolean mIsRunning;
        private boolean mShouldRunAfterActivityResume;
        private boolean mIsGpsEnabled;

        LocationProviderImpl(Context context) {
            this.mContext = context;
        }

        public void onActivityStateChange(int state) {
            if (state == 4) {
                this.mShouldRunAfterActivityResume = this.mIsRunning;
                this.unregisterFromLocationUpdates();
            } else if (state == 3) {
                assert (!this.mIsRunning);
                if (this.mShouldRunAfterActivityResume) {
                    this.registerForLocationUpdates();
                }
            }
        }

        private void start(boolean gpsEnabled) {
            if (!this.mIsRunning && !this.mShouldRunAfterActivityResume) {
                ActivityStatus.registerStateListener(this);
            }
            this.mIsGpsEnabled = gpsEnabled;
            if (ActivityStatus.isPaused()) {
                this.mShouldRunAfterActivityResume = true;
            } else {
                this.unregisterFromLocationUpdates();
                this.registerForLocationUpdates();
            }
        }

        private void stop() {
            this.unregisterFromLocationUpdates();
            ActivityStatus.unregisterStateListener(this);
            this.mShouldRunAfterActivityResume = false;
        }

        private boolean isRunning() {
            return this.mIsRunning;
        }

        public void onLocationChanged(Location location) {
            if (this.mIsRunning) {
                this.updateNewLocation(location);
            }
        }

        private void updateNewLocation(Location location) {
            LocationProvider.nativeNewLocationAvailable(location.getLatitude(), location.getLongitude(), (double)location.getTime() / 1000.0, location.hasAltitude(), location.getAltitude(), location.hasAccuracy(), location.getAccuracy(), location.hasBearing(), location.getBearing(), location.hasSpeed(), location.getSpeed());
        }

        public void onStatusChanged(String provider, int status, Bundle extras) {
        }

        public void onProviderEnabled(String provider) {
        }

        public void onProviderDisabled(String provider) {
        }

        private void ensureLocationManagerCreated() {
            if (this.mLocationManager != null) {
                return;
            }
            this.mLocationManager = (LocationManager)this.mContext.getSystemService("location");
            if (this.mLocationManager == null) {
                Log.e(LocationProvider.TAG, "Could not get location manager.");
            }
        }

        private void registerForLocationUpdates() {
            this.ensureLocationManagerCreated();
            if (this.usePassiveOneShotLocation()) {
                return;
            }
            assert (!this.mIsRunning);
            this.mIsRunning = true;
            try {
                Criteria criteria = new Criteria();
                this.mLocationManager.requestLocationUpdates(0L, 0.0f, criteria, (LocationListener)this, ThreadUtils.getUiThreadLooper());
                if (this.mIsGpsEnabled) {
                    criteria.setAccuracy(1);
                    this.mLocationManager.requestLocationUpdates(0L, 0.0f, criteria, (LocationListener)this, ThreadUtils.getUiThreadLooper());
                }
            }
            catch (SecurityException e) {
                Log.e(LocationProvider.TAG, "Caught security exception registering for location updates from system. This should only happen in DumpRenderTree.");
            }
            catch (IllegalArgumentException e) {
                Log.e(LocationProvider.TAG, "Caught IllegalArgumentException registering for location updates.");
            }
        }

        private void unregisterFromLocationUpdates() {
            if (this.mIsRunning) {
                this.mIsRunning = false;
                this.mLocationManager.removeUpdates(this);
            }
        }

        private boolean usePassiveOneShotLocation() {
            if (!this.isOnlyPassiveLocationProviderEnabled()) {
                return false;
            }
            final Location location = this.mLocationManager.getLastKnownLocation("passive");
            if (location != null) {
                ThreadUtils.runOnUiThread(new Runnable(){

                    public void run() {
                        LocationProviderImpl.this.updateNewLocation(location);
                    }
                });
            }
            return true;
        }

        private boolean isOnlyPassiveLocationProviderEnabled() {
            List<String> providers = this.mLocationManager.getProviders(true);
            return providers != null && providers.size() == 1 && providers.get(0).equals("passive");
        }
    }
}

