/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.content.browser;

import android.content.Context;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.MotionEvent;
import com.android.org.chromium.content.browser.ZoomManager;

class SnapScrollController {
    private static final String TAG = "SnapScrollController";
    private static final int SNAP_NONE = 0;
    private static final int SNAP_HORIZ = 1;
    private static final int SNAP_VERT = 2;
    private static final int SNAP_BOUND = 16;
    private float mChannelDistance = 16.0f;
    private int mSnapScrollMode = 0;
    private int mFirstTouchX = -1;
    private int mFirstTouchY = -1;
    private float mDistanceX = 0.0f;
    private float mDistanceY = 0.0f;
    private ZoomManager mZoomManager;

    SnapScrollController(Context context, ZoomManager zoomManager) {
        this.calculateChannelDistance(context);
        this.mZoomManager = zoomManager;
    }

    void updateSnapScrollMode(float distanceX, float distanceY) {
        if (this.mSnapScrollMode == 1 || this.mSnapScrollMode == 2) {
            this.mDistanceX += Math.abs(distanceX);
            this.mDistanceY += Math.abs(distanceY);
            if (this.mSnapScrollMode == 1) {
                if (this.mDistanceY > this.mChannelDistance) {
                    this.mSnapScrollMode = 0;
                } else if (this.mDistanceX > this.mChannelDistance) {
                    this.mDistanceX = 0.0f;
                    this.mDistanceY = 0.0f;
                }
            } else if (this.mDistanceX > this.mChannelDistance) {
                this.mSnapScrollMode = 0;
            } else if (this.mDistanceY > this.mChannelDistance) {
                this.mDistanceX = 0.0f;
                this.mDistanceY = 0.0f;
            }
        }
    }

    void setSnapScrollingMode(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.mSnapScrollMode = 0;
                this.mFirstTouchX = (int)event.getX();
                this.mFirstTouchY = (int)event.getY();
                break;
            }
            case 2: {
                if (this.mZoomManager.isScaleGestureDetectionInProgress() || this.mSnapScrollMode != 0) break;
                int xDiff = (int)Math.abs(event.getX() - (float)this.mFirstTouchX);
                int yDiff = (int)Math.abs(event.getY() - (float)this.mFirstTouchY);
                if (xDiff > 16 && yDiff < 16) {
                    this.mSnapScrollMode = 1;
                    break;
                }
                if (xDiff >= 16 || yDiff <= 16) break;
                this.mSnapScrollMode = 2;
                break;
            }
            case 1: 
            case 3: {
                this.mFirstTouchX = -1;
                this.mFirstTouchY = -1;
                this.mDistanceX = 0.0f;
                this.mDistanceY = 0.0f;
                break;
            }
            default: {
                Log.i(TAG, "setSnapScrollingMode case-default no-op");
            }
        }
    }

    private void calculateChannelDistance(Context context) {
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        double screenSize = Math.hypot((double)metrics.widthPixels / (double)metrics.densityDpi, (double)metrics.heightPixels / (double)metrics.densityDpi);
        this.mChannelDistance = screenSize < 3.0 ? 16.0f : (screenSize < 5.0 ? 22.0f : (screenSize < 7.0 ? 28.0f : 34.0f));
        this.mChannelDistance *= metrics.density;
        if (this.mChannelDistance < 16.0f) {
            this.mChannelDistance = 16.0f;
        }
    }

    void resetSnapScrollMode() {
        this.mSnapScrollMode = 0;
    }

    boolean isSnapVertical() {
        return this.mSnapScrollMode == 2;
    }

    boolean isSnapHorizontal() {
        return this.mSnapScrollMode == 1;
    }

    boolean isSnappingScrolls() {
        return this.mSnapScrollMode != 0;
    }
}

