/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.content.browser;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.view.Choreographer;
import android.view.WindowManager;
import com.android.org.chromium.content.common.TraceEvent;

public class VSyncMonitor {
    private static final String TAG = "VSyncMonitor";
    private static final long NANOSECONDS_PER_SECOND = 1000000000L;
    private static final long NANOSECONDS_PER_MILLISECOND = 1000000L;
    private static final long NANOSECONDS_PER_MICROSECOND = 1000L;
    private Listener mListener;
    private final long mRefreshPeriodNano;
    private long mLastUpdateRequestNano;
    private boolean mHaveRequestInFlight;
    private int mTriggerNextVSyncCount;
    private static final int MAX_VSYNC_COUNT = 5;
    private final Choreographer mChoreographer;
    private final Choreographer.FrameCallback mVSyncFrameCallback;
    private final Handler mHandler;
    private final Runnable mVSyncRunnableCallback;
    private long mGoodStartingPointNano;
    private long mLastPostedNano;

    public VSyncMonitor(Context context, Listener listener) {
        this(context, listener, true);
    }

    VSyncMonitor(Context context, Listener listener, boolean enableJBVSync) {
        this.mListener = listener;
        float refreshRate = ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getRefreshRate();
        if (refreshRate <= 0.0f) {
            refreshRate = 60.0f;
        }
        this.mRefreshPeriodNano = (long)(1.0E9f / refreshRate);
        this.mTriggerNextVSyncCount = 0;
        if (enableJBVSync && Build.VERSION.SDK_INT >= 16) {
            this.mChoreographer = Choreographer.getInstance();
            this.mVSyncFrameCallback = new Choreographer.FrameCallback(){

                public void doFrame(long frameTimeNanos) {
                    TraceEvent.instant("VSync");
                    VSyncMonitor.this.onVSyncCallback(frameTimeNanos);
                }
            };
            this.mHandler = null;
            this.mVSyncRunnableCallback = null;
        } else {
            this.mChoreographer = null;
            this.mVSyncFrameCallback = null;
            this.mHandler = new Handler();
            this.mVSyncRunnableCallback = new Runnable(){

                public void run() {
                    TraceEvent.instant("VSyncTimer");
                    VSyncMonitor.this.onVSyncCallback(System.nanoTime());
                }
            };
            this.mGoodStartingPointNano = this.getCurrentNanoTime();
            this.mLastPostedNano = 0L;
        }
    }

    public long getVSyncPeriodInMicroseconds() {
        return this.mRefreshPeriodNano / 1000L;
    }

    public boolean isVSyncSignalAvailable() {
        return this.mChoreographer != null;
    }

    public void stop() {
        this.mTriggerNextVSyncCount = 0;
    }

    public void unregisterListener() {
        this.stop();
        this.mListener = null;
    }

    public void requestUpdate() {
        this.mTriggerNextVSyncCount = 5;
        this.mLastUpdateRequestNano = this.getCurrentNanoTime();
        this.postCallback();
    }

    public void setVSyncPointForICS(long goodStartingPointNano) {
        this.mGoodStartingPointNano = goodStartingPointNano;
    }

    private long getCurrentNanoTime() {
        return System.nanoTime();
    }

    private void onVSyncCallback(long frameTimeNanos) {
        assert (this.mHaveRequestInFlight);
        this.mHaveRequestInFlight = false;
        if (this.mTriggerNextVSyncCount > 0) {
            --this.mTriggerNextVSyncCount;
            this.postCallback();
        }
        if (this.mListener != null) {
            this.mListener.onVSync(this, frameTimeNanos / 1000L);
        }
    }

    private void postCallback() {
        if (this.mHaveRequestInFlight) {
            return;
        }
        this.mHaveRequestInFlight = true;
        if (this.isVSyncSignalAvailable()) {
            this.mChoreographer.postFrameCallback(this.mVSyncFrameCallback);
        } else {
            this.postRunnableCallback();
        }
    }

    private void postRunnableCallback() {
        assert (!this.isVSyncSignalAvailable());
        long currentTime = this.mLastUpdateRequestNano;
        long lastRefreshTime = this.mGoodStartingPointNano + (currentTime - this.mGoodStartingPointNano) / this.mRefreshPeriodNano * this.mRefreshPeriodNano;
        long delay = lastRefreshTime + this.mRefreshPeriodNano - currentTime;
        assert (delay >= 0L && delay < this.mRefreshPeriodNano);
        if (currentTime + delay <= this.mLastPostedNano + this.mRefreshPeriodNano / 2L) {
            delay += this.mRefreshPeriodNano;
        }
        this.mLastPostedNano = currentTime + delay;
        if (delay == 0L) {
            this.mHandler.post(this.mVSyncRunnableCallback);
        } else {
            this.mHandler.postDelayed(this.mVSyncRunnableCallback, delay / 1000000L);
        }
    }

    public static interface Listener {
        public void onVSync(VSyncMonitor var1, long var2);
    }
}

