/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.content.browser.accessibility;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Vibrator;
import android.speech.tts.TextToSpeech;
import android.util.Log;
import android.view.View;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import com.android.org.chromium.com.googlecode.eyesfree.braille.selfbraille.SelfBrailleClient;
import com.android.org.chromium.com.googlecode.eyesfree.braille.selfbraille.WriteData;
import com.android.org.chromium.content.browser.ContentViewCore;
import com.android.org.chromium.content.browser.JavascriptInterface;
import com.android.org.chromium.content.browser.WebContentsObserverAndroid;
import com.android.org.chromium.content.browser.accessibility.JellyBeanAccessibilityInjector;
import com.android.org.chromium.content.common.CommandLine;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class AccessibilityInjector
extends WebContentsObserverAndroid {
    private static final String TAG = "AccessibilityInjector";
    protected ContentViewCore mContentViewCore;
    private TextToSpeechWrapper mTextToSpeech;
    private VibratorWrapper mVibrator;
    private final boolean mHasVibratePermission;
    private AccessibilityManager mAccessibilityManager;
    protected boolean mInjectedScriptEnabled;
    protected boolean mScriptInjected;
    private final String mAccessibilityScreenReaderUrl;
    private static final int FEEDBACK_BRAILLE = 32;
    private static final int ACCESSIBILITY_SCRIPT_INJECTION_UNDEFINED = -1;
    private static final int ACCESSIBILITY_SCRIPT_INJECTION_OPTED_OUT = 0;
    private static final int ACCESSIBILITY_SCRIPT_INJECTION_PROVIDED = 1;
    private static final String ALIAS_ACCESSIBILITY_JS_INTERFACE = "accessibility";
    private static final String ALIAS_ACCESSIBILITY_JS_INTERFACE_2 = "accessibility2";
    private static final String DEFAULT_ACCESSIBILITY_SCREEN_READER_URL = "https://ssl.gstatic.com/accessibility/javascript/android/chromeandroidvox.js";
    private static final String ACCESSIBILITY_SCREEN_READER_JAVASCRIPT_TEMPLATE = "(function() {    var chooser = document.createElement('script');    chooser.type = 'text/javascript';    chooser.src = '%1s';    document.getElementsByTagName('head')[0].appendChild(chooser);  })();";
    private static final String TOGGLE_CHROME_VOX_JAVASCRIPT = "(function() {    if (typeof cvox !== 'undefined') {        cvox.ChromeVox.host.activateOrDeactivateChromeVox(%1s);    }  })();";

    public static AccessibilityInjector newInstance(ContentViewCore view) {
        if (Build.VERSION.SDK_INT < 16) {
            return new AccessibilityInjector(view);
        }
        return new JellyBeanAccessibilityInjector(view);
    }

    protected AccessibilityInjector(ContentViewCore view) {
        super(view);
        this.mContentViewCore = view;
        this.mAccessibilityScreenReaderUrl = CommandLine.getInstance().getSwitchValue("accessibility-js-url", DEFAULT_ACCESSIBILITY_SCREEN_READER_URL);
        this.mHasVibratePermission = this.mContentViewCore.getContext().checkCallingOrSelfPermission("android.permission.VIBRATE") == 0;
    }

    public void injectAccessibilityScriptIntoPage() {
        if (!this.accessibilityIsAvailable()) {
            return;
        }
        int axsParameterValue = this.getAxsUrlParameterValue();
        if (axsParameterValue != -1) {
            return;
        }
        String js = this.getScreenReaderInjectingJs();
        if (this.mContentViewCore.isDeviceAccessibilityScriptInjectionEnabled() && js != null && this.mContentViewCore.isAlive()) {
            this.addOrRemoveAccessibilityApisIfNecessary();
            this.mContentViewCore.evaluateJavaScript(js, null);
            this.mInjectedScriptEnabled = true;
            this.mScriptInjected = true;
        }
    }

    public void addOrRemoveAccessibilityApisIfNecessary() {
        if (this.accessibilityIsAvailable()) {
            this.addAccessibilityApis();
        } else {
            this.removeAccessibilityApis();
        }
    }

    public boolean accessibilityIsAvailable() {
        if (!this.getAccessibilityManager().isEnabled() || this.mContentViewCore.getContentSettings() == null || !this.mContentViewCore.getContentSettings().getJavaScriptEnabled()) {
            return false;
        }
        try {
            List<AccessibilityServiceInfo> services = this.getAccessibilityManager().getEnabledAccessibilityServiceList(33);
            return services.size() > 0;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public void setScriptEnabled(boolean enabled) {
        if (enabled && !this.mScriptInjected) {
            this.injectAccessibilityScriptIntoPage();
        }
        if (!this.accessibilityIsAvailable() || this.mInjectedScriptEnabled == enabled) {
            return;
        }
        this.mInjectedScriptEnabled = enabled;
        if (this.mContentViewCore.isAlive()) {
            String js = String.format(TOGGLE_CHROME_VOX_JAVASCRIPT, Boolean.toString(this.mInjectedScriptEnabled));
            this.mContentViewCore.evaluateJavaScript(js, null);
            if (!this.mInjectedScriptEnabled) {
                this.onPageLostFocus();
            }
        }
    }

    public void didStartLoading(String url) {
        this.mScriptInjected = false;
    }

    public void didStopLoading(String url) {
        this.injectAccessibilityScriptIntoPage();
    }

    public void onPageLostFocus() {
        if (this.mContentViewCore.isAlive()) {
            if (this.mTextToSpeech != null) {
                this.mTextToSpeech.stop();
            }
            if (this.mVibrator != null) {
                this.mVibrator.cancel();
            }
        }
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
    }

    public boolean supportsAccessibilityAction(int action) {
        return false;
    }

    public boolean performAccessibilityAction(int action, Bundle arguments) {
        return false;
    }

    protected void addAccessibilityApis() {
        Context context = this.mContentViewCore.getContext();
        if (context != null) {
            if (this.mTextToSpeech == null) {
                this.mTextToSpeech = new TextToSpeechWrapper(this.mContentViewCore.getContainerView(), context);
                this.mContentViewCore.addJavascriptInterface(this.mTextToSpeech, ALIAS_ACCESSIBILITY_JS_INTERFACE);
            }
            if (this.mVibrator == null && this.mHasVibratePermission) {
                this.mVibrator = new VibratorWrapper(context);
                this.mContentViewCore.addJavascriptInterface(this.mVibrator, ALIAS_ACCESSIBILITY_JS_INTERFACE_2);
            }
        }
    }

    protected void removeAccessibilityApis() {
        if (this.mTextToSpeech != null) {
            this.mContentViewCore.removeJavascriptInterface(ALIAS_ACCESSIBILITY_JS_INTERFACE);
            this.mTextToSpeech.stop();
            this.mTextToSpeech.shutdownInternal();
            this.mTextToSpeech = null;
        }
        if (this.mVibrator != null) {
            this.mContentViewCore.removeJavascriptInterface(ALIAS_ACCESSIBILITY_JS_INTERFACE_2);
            this.mVibrator.cancel();
            this.mVibrator = null;
        }
    }

    private int getAxsUrlParameterValue() {
        if (this.mContentViewCore.getUrl() == null) {
            return -1;
        }
        try {
            List<NameValuePair> params = URLEncodedUtils.parse(new URI(this.mContentViewCore.getUrl()), null);
            for (NameValuePair param : params) {
                if (!"axs".equals(param.getName())) continue;
                return Integer.parseInt(param.getValue());
            }
        }
        catch (URISyntaxException ex) {
        }
        catch (NumberFormatException ex) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return -1;
    }

    private String getScreenReaderInjectingJs() {
        return String.format(ACCESSIBILITY_SCREEN_READER_JAVASCRIPT_TEMPLATE, this.mAccessibilityScreenReaderUrl);
    }

    private AccessibilityManager getAccessibilityManager() {
        if (this.mAccessibilityManager == null) {
            this.mAccessibilityManager = (AccessibilityManager)this.mContentViewCore.getContext().getSystemService(ALIAS_ACCESSIBILITY_JS_INTERFACE);
        }
        return this.mAccessibilityManager;
    }

    private static class TextToSpeechWrapper {
        private TextToSpeech mTextToSpeech;
        private SelfBrailleClient mSelfBrailleClient;
        private View mView;

        public TextToSpeechWrapper(View view, Context context) {
            this.mView = view;
            this.mTextToSpeech = new TextToSpeech(context, null, null);
            this.mSelfBrailleClient = new SelfBrailleClient(context, CommandLine.getInstance().hasSwitch("debug-braille-service"));
        }

        @JavascriptInterface
        public boolean isSpeaking() {
            return this.mTextToSpeech.isSpeaking();
        }

        @JavascriptInterface
        public int speak(String text, int queueMode, String jsonParams) {
            HashMap<String, String> params = null;
            try {
                if (jsonParams != null) {
                    params = new HashMap<String, String>();
                    JSONObject json = new JSONObject(jsonParams);
                    Iterator keyIt = json.keys();
                    while (keyIt.hasNext()) {
                        String key = (String)keyIt.next();
                        if (json.optJSONObject(key) != null || json.optJSONArray(key) != null) continue;
                        params.put(key, json.getString(key));
                    }
                }
            }
            catch (JSONException e) {
                params = null;
            }
            return this.mTextToSpeech.speak(text, queueMode, params);
        }

        @JavascriptInterface
        public int stop() {
            return this.mTextToSpeech.stop();
        }

        @JavascriptInterface
        public void braille(String jsonString) {
            try {
                JSONObject jsonObj = new JSONObject(jsonString);
                WriteData data = WriteData.forView(this.mView);
                data.setText(jsonObj.getString("text"));
                data.setSelectionStart(jsonObj.getInt("startIndex"));
                data.setSelectionEnd(jsonObj.getInt("endIndex"));
                this.mSelfBrailleClient.write(data);
            }
            catch (JSONException ex) {
                Log.w(AccessibilityInjector.TAG, "Error parsing JS JSON object", ex);
            }
        }

        protected void shutdownInternal() {
            this.mTextToSpeech.shutdown();
            this.mSelfBrailleClient.shutdown();
        }
    }

    private static class VibratorWrapper {
        private static final long MAX_VIBRATE_DURATION_MS = 5000L;
        private Vibrator mVibrator;

        public VibratorWrapper(Context context) {
            this.mVibrator = (Vibrator)context.getSystemService("vibrator");
        }

        @JavascriptInterface
        public boolean hasVibrator() {
            return this.mVibrator.hasVibrator();
        }

        @JavascriptInterface
        public void vibrate(long milliseconds) {
            milliseconds = Math.min(milliseconds, 5000L);
            this.mVibrator.vibrate(milliseconds);
        }

        @JavascriptInterface
        public void vibrate(long[] pattern, int repeat) {
            for (int i = 0; i < pattern.length; ++i) {
                pattern[i] = Math.min(pattern[i], 5000L);
            }
            repeat = -1;
            this.mVibrator.vibrate(pattern, repeat);
        }

        @JavascriptInterface
        public void cancel() {
            this.mVibrator.cancel();
        }
    }
}

