/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.ui;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.SparseArray;
import android.widget.Toast;
import com.android.org.chromium.base.JNINamespace;
import java.io.Serializable;
import java.util.HashMap;

@JNINamespace(value="ui")
public class WindowAndroid {
    private int mNativeWindowAndroid = 0;
    private static final int REQUEST_CODE_PREFIX = 1000;
    private static final int REQUEST_CODE_RANGE_SIZE = 100;
    static final String WINDOW_CALLBACK_ERRORS = "window_callback_errors";
    private int mNextRequestCode = 0;
    protected Activity mActivity;
    protected SparseArray<IntentCallback> mOutstandingIntents;
    protected HashMap<Integer, String> mIntentErrors;

    public WindowAndroid(Activity activity) {
        this.mActivity = activity;
        this.mOutstandingIntents = new SparseArray();
        this.mIntentErrors = new HashMap();
    }

    public boolean showIntent(Intent intent, IntentCallback callback, int errorId) {
        int requestCode = 1000 + this.mNextRequestCode;
        this.mNextRequestCode = (this.mNextRequestCode + 1) % 100;
        try {
            this.mActivity.startActivityForResult(intent, requestCode);
        }
        catch (ActivityNotFoundException e) {
            return false;
        }
        this.mOutstandingIntents.put(requestCode, callback);
        this.mIntentErrors.put(requestCode, this.mActivity.getString(errorId));
        return true;
    }

    public void showError(String error) {
        if (error != null) {
            Toast.makeText((Context)this.mActivity, error, 0).show();
        }
    }

    public void showError(int resId) {
        this.showError(this.mActivity.getString(resId));
    }

    protected void showCallbackNonExistentError(String error) {
        this.showError(error);
    }

    public void sendBroadcast(Intent intent) {
        this.mActivity.sendBroadcast(intent);
    }

    @Deprecated
    public Context getContext() {
        return this.mActivity;
    }

    public void saveInstanceState(Bundle bundle) {
        bundle.putSerializable(WINDOW_CALLBACK_ERRORS, this.mIntentErrors);
    }

    public void restoreInstanceState(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        Serializable errors = bundle.getSerializable(WINDOW_CALLBACK_ERRORS);
        if (errors instanceof HashMap) {
            HashMap intentErrors;
            this.mIntentErrors = intentErrors = (HashMap)errors;
        }
    }

    public boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        IntentCallback callback = this.mOutstandingIntents.get(requestCode);
        this.mOutstandingIntents.delete(requestCode);
        String errorMessage = this.mIntentErrors.remove(requestCode);
        if (callback != null) {
            callback.onIntentCompleted(this, resultCode, this.mActivity.getContentResolver(), data);
            return true;
        }
        if (errorMessage != null) {
            this.showCallbackNonExistentError(errorMessage);
            return true;
        }
        return false;
    }

    public void destroy() {
        if (this.mNativeWindowAndroid != 0) {
            this.nativeDestroy(this.mNativeWindowAndroid);
            this.mNativeWindowAndroid = 0;
        }
    }

    public int getNativePointer() {
        if (this.mNativeWindowAndroid == 0) {
            this.mNativeWindowAndroid = this.nativeInit();
        }
        return this.mNativeWindowAndroid;
    }

    private native int nativeInit();

    private native void nativeDestroy(int var1);

    public static interface IntentCallback {
        public void onIntentCompleted(WindowAndroid var1, int var2, ContentResolver var3, Intent var4);
    }
}

