/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt;

import com.android.org.conscrypt.NativeCrypto;
import com.android.org.conscrypt.OpenSSLDSAPrivateKey;
import com.android.org.conscrypt.OpenSSLDSAPublicKey;
import com.android.org.conscrypt.OpenSSLECPrivateKey;
import com.android.org.conscrypt.OpenSSLECPublicKey;
import com.android.org.conscrypt.OpenSSLKey;
import com.android.org.conscrypt.OpenSSLKeyHolder;
import com.android.org.conscrypt.OpenSSLRSAPrivateCrtKey;
import com.android.org.conscrypt.OpenSSLRSAPrivateKey;
import com.android.org.conscrypt.OpenSSLRSAPublicKey;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public class OpenSSLSignature
extends Signature {
    private long ctx;
    private OpenSSLKey key;
    private final EngineType engineType;
    private final String evpAlgorithm;
    private final byte[] singleByte = new byte[1];

    private OpenSSLSignature(String algorithm, EngineType engineType) throws NoSuchAlgorithmException {
        super(algorithm);
        if ("RSA-MD2".equals(algorithm)) {
            throw new NoSuchAlgorithmException(algorithm);
        }
        this.engineType = engineType;
        this.evpAlgorithm = algorithm;
    }

    protected void engineUpdate(byte input) {
        this.singleByte[0] = input;
        this.engineUpdate(this.singleByte, 0, 1);
    }

    protected void engineUpdate(byte[] input, int offset, int len) {
        if (this.state == 2) {
            if (this.ctx == 0L) {
                try {
                    this.ctx = NativeCrypto.EVP_SignInit(this.evpAlgorithm);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            NativeCrypto.EVP_SignUpdate(this.ctx, input, offset, len);
        } else {
            if (this.ctx == 0L) {
                try {
                    this.ctx = NativeCrypto.EVP_VerifyInit(this.evpAlgorithm);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            NativeCrypto.EVP_VerifyUpdate(this.ctx, input, offset, len);
        }
    }

    protected Object engineGetParameter(String param) throws InvalidParameterException {
        return null;
    }

    private void checkEngineType(OpenSSLKey pkey) throws InvalidKeyException {
        int pkeyType = NativeCrypto.EVP_PKEY_type(pkey.getPkeyContext());
        switch (this.engineType) {
            case RSA: {
                if (pkeyType == 6) break;
                throw new InvalidKeyException("Signature not initialized as RSA");
            }
            case DSA: {
                if (pkeyType == 116) break;
                throw new InvalidKeyException("Signature not initialized as DSA");
            }
            case EC: {
                if (pkeyType == 408) break;
                throw new InvalidKeyException("Signature not initialized as EC");
            }
            default: {
                throw new InvalidKeyException("Need DSA or RSA or EC private key");
            }
        }
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.destroyContextIfExists();
        if (privateKey instanceof OpenSSLKeyHolder) {
            OpenSSLKey pkey = ((OpenSSLKeyHolder)((Object)privateKey)).getOpenSSLKey();
            this.checkEngineType(pkey);
            this.key = pkey;
        } else if (privateKey instanceof RSAPrivateCrtKey) {
            if (this.engineType != EngineType.RSA) {
                throw new InvalidKeyException("Signature not initialized as RSA");
            }
            RSAPrivateCrtKey rsaPrivateKey = (RSAPrivateCrtKey)privateKey;
            this.key = OpenSSLRSAPrivateCrtKey.getInstance(rsaPrivateKey);
        } else if (privateKey instanceof RSAPrivateKey) {
            if (this.engineType != EngineType.RSA) {
                throw new InvalidKeyException("Signature not initialized as RSA");
            }
            RSAPrivateKey rsaPrivateKey = (RSAPrivateKey)privateKey;
            this.key = OpenSSLRSAPrivateKey.getInstance(rsaPrivateKey);
        } else if (privateKey instanceof DSAPrivateKey) {
            if (this.engineType != EngineType.DSA) {
                throw new InvalidKeyException("Signature not initialized as DSA");
            }
            DSAPrivateKey dsaPrivateKey = (DSAPrivateKey)privateKey;
            this.key = OpenSSLDSAPrivateKey.getInstance(dsaPrivateKey);
        } else if (privateKey instanceof ECPrivateKey) {
            if (this.engineType != EngineType.EC) {
                throw new InvalidKeyException("Signature not initialized as EC");
            }
            ECPrivateKey ecPrivateKey = (ECPrivateKey)privateKey;
            this.key = OpenSSLECPrivateKey.getInstance(ecPrivateKey);
        } else {
            throw new InvalidKeyException("Need DSA or RSA or EC private key");
        }
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.destroyContextIfExists();
        if (publicKey instanceof OpenSSLKeyHolder) {
            OpenSSLKey pkey = ((OpenSSLKeyHolder)((Object)publicKey)).getOpenSSLKey();
            this.checkEngineType(pkey);
            this.key = pkey;
        } else if (publicKey instanceof RSAPublicKey) {
            if (this.engineType != EngineType.RSA) {
                throw new InvalidKeyException("Signature not initialized as RSA");
            }
            RSAPublicKey rsaPublicKey = (RSAPublicKey)publicKey;
            this.key = OpenSSLRSAPublicKey.getInstance(rsaPublicKey);
        } else if (publicKey instanceof DSAPublicKey) {
            if (this.engineType != EngineType.DSA) {
                throw new InvalidKeyException("Signature not initialized as DSA");
            }
            DSAPublicKey dsaPublicKey = (DSAPublicKey)publicKey;
            this.key = OpenSSLDSAPublicKey.getInstance(dsaPublicKey);
        } else if (publicKey instanceof ECPublicKey) {
            if (this.engineType != EngineType.EC) {
                throw new InvalidKeyException("Signature not initialized as EC");
            }
            ECPublicKey ecPublicKey = (ECPublicKey)publicKey;
            this.key = OpenSSLECPublicKey.getInstance(ecPublicKey);
        } else {
            throw new InvalidKeyException("Need DSA or RSA or EC public key");
        }
    }

    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
    }

    protected byte[] engineSign() throws SignatureException {
        if (this.key == null) {
            throw new SignatureException("Need DSA or RSA or EC private key");
        }
        try {
            byte[] buffer = new byte[NativeCrypto.EVP_PKEY_size(this.key.getPkeyContext())];
            int bytesWritten = NativeCrypto.EVP_SignFinal(this.ctx, buffer, 0, this.key.getPkeyContext());
            byte[] signature = new byte[bytesWritten];
            System.arraycopy(buffer, 0, signature, 0, bytesWritten);
            byte[] byArray = signature;
            return byArray;
        }
        catch (Exception ex) {
            throw new SignatureException(ex);
        }
        finally {
            this.destroyContextIfExists();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        if (this.key == null) {
            throw new SignatureException("Need DSA or RSA public key");
        }
        try {
            int result = NativeCrypto.EVP_VerifyFinal(this.ctx, sigBytes, 0, sigBytes.length, this.key.getPkeyContext());
            boolean bl = result == 1;
            return bl;
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.destroyContextIfExists();
        }
    }

    private void destroyContextIfExists() {
        if (this.ctx != 0L) {
            NativeCrypto.EVP_MD_CTX_destroy(this.ctx);
            this.ctx = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.ctx != 0L) {
                NativeCrypto.EVP_MD_CTX_destroy(this.ctx);
            }
        }
        finally {
            super.finalize();
        }
    }

    public static final class SHA512ECDSA
    extends OpenSSLSignature {
        public SHA512ECDSA() throws NoSuchAlgorithmException {
            super("SHA512", EngineType.EC);
        }
    }

    public static final class SHA384ECDSA
    extends OpenSSLSignature {
        public SHA384ECDSA() throws NoSuchAlgorithmException {
            super("SHA384", EngineType.EC);
        }
    }

    public static final class SHA256ECDSA
    extends OpenSSLSignature {
        public SHA256ECDSA() throws NoSuchAlgorithmException {
            super("SHA256", EngineType.EC);
        }
    }

    public static final class SHA1ECDSA
    extends OpenSSLSignature {
        public SHA1ECDSA() throws NoSuchAlgorithmException {
            super("SHA1", EngineType.EC);
        }
    }

    public static final class SHA1DSA
    extends OpenSSLSignature {
        public SHA1DSA() throws NoSuchAlgorithmException {
            super("DSA-SHA1", EngineType.DSA);
        }
    }

    public static final class SHA512RSA
    extends OpenSSLSignature {
        public SHA512RSA() throws NoSuchAlgorithmException {
            super("RSA-SHA512", EngineType.RSA);
        }
    }

    public static final class SHA384RSA
    extends OpenSSLSignature {
        public SHA384RSA() throws NoSuchAlgorithmException {
            super("RSA-SHA384", EngineType.RSA);
        }
    }

    public static final class SHA256RSA
    extends OpenSSLSignature {
        public SHA256RSA() throws NoSuchAlgorithmException {
            super("RSA-SHA256", EngineType.RSA);
        }
    }

    public static final class SHA1RSA
    extends OpenSSLSignature {
        public SHA1RSA() throws NoSuchAlgorithmException {
            super("RSA-SHA1", EngineType.RSA);
        }
    }

    public static final class MD5RSA
    extends OpenSSLSignature {
        public MD5RSA() throws NoSuchAlgorithmException {
            super("RSA-MD5", EngineType.RSA);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EngineType {
        RSA,
        DSA,
        EC;

    }
}

