/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManagerNative;
import android.app.AlarmManager;
import android.app.AppGlobals;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.admin.DeviceAdminInfo;
import android.app.admin.DevicePolicyManager;
import android.app.admin.IDevicePolicyManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.UserInfo;
import android.os.Binder;
import android.os.Environment;
import android.os.Handler;
import android.os.IBinder;
import android.os.IPowerManager;
import android.os.PowerManager;
import android.os.RecoverySystem;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.Settings;
import android.security.Credentials;
import android.security.IKeyChainService;
import android.security.KeyChain;
import android.util.AtomicFile;
import android.util.Log;
import android.util.PrintWriterPrinter;
import android.util.Slog;
import android.util.SparseArray;
import android.util.Xml;
import android.view.IWindowManager;
import com.android.internal.os.storage.ExternalStorageFormatter;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.JournaledFile;
import com.android.internal.util.XmlUtils;
import com.android.internal.widget.LockPatternUtils;
import com.android.org.conscrypt.TrustedCertificateStore;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DevicePolicyManagerService
extends IDevicePolicyManager.Stub {
    private static final String TAG = "DevicePolicyManagerService";
    private static final String DEVICE_POLICIES_XML = "device_policies.xml";
    private static final int REQUEST_EXPIRE_PASSWORD = 5571;
    private static final long MS_PER_DAY = 86400000L;
    private static final long EXPIRATION_GRACE_PERIOD_MS = 432000000L;
    protected static final String ACTION_EXPIRED_PASSWORD_NOTIFICATION = "com.android.server.ACTION_EXPIRED_PASSWORD_NOTIFICATION";
    private static final int MONITORING_CERT_NOTIFICATION_ID = 17039535;
    private static final boolean DBG = false;
    final Context mContext;
    final PowerManager.WakeLock mWakeLock;
    IPowerManager mIPowerManager;
    IWindowManager mIWindowManager;
    NotificationManager mNotificationManager;
    private DeviceOwner mDeviceOwner;
    private boolean mHasFeature;
    final SparseArray<DevicePolicyData> mUserData = new SparseArray();
    Handler mHandler = new Handler();
    BroadcastReceiver mReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            final int userHandle = intent.getIntExtra("android.intent.extra.user_handle", this.getSendingUserId());
            if ("android.intent.action.BOOT_COMPLETED".equals(action) || DevicePolicyManagerService.ACTION_EXPIRED_PASSWORD_NOTIFICATION.equals(action)) {
                DevicePolicyManagerService.this.mHandler.post(new Runnable(){

                    public void run() {
                        DevicePolicyManagerService.this.handlePasswordExpirationNotification(DevicePolicyManagerService.this.getUserData(userHandle));
                    }
                });
            }
            if ("android.intent.action.BOOT_COMPLETED".equals(action) || "android.security.STORAGE_CHANGED".equals(action)) {
                DevicePolicyManagerService.this.manageMonitoringCertificateNotification(intent);
            }
            if ("android.intent.action.USER_REMOVED".equals(action)) {
                DevicePolicyManagerService.this.removeUserData(userHandle);
            } else if ("android.intent.action.USER_STARTED".equals(action) || "android.intent.action.PACKAGE_CHANGED".equals(action) || "android.intent.action.PACKAGE_REMOVED".equals(action) || "android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE".equals(action)) {
                if ("android.intent.action.USER_STARTED".equals(action)) {
                    DevicePolicyManagerService devicePolicyManagerService = DevicePolicyManagerService.this;
                    synchronized (devicePolicyManagerService) {
                        DevicePolicyManagerService.this.mUserData.remove(userHandle);
                    }
                }
                DevicePolicyManagerService.this.handlePackagesChanged(userHandle);
            }
        }
    };
    public static final String SYSTEM_PROP_DISABLE_CAMERA = "sys.secpolicy.camera.disabled";

    private void handlePackagesChanged(int userHandle) {
        boolean removed = false;
        DevicePolicyData policy = this.getUserData(userHandle);
        IPackageManager pm = AppGlobals.getPackageManager();
        for (int i = policy.mAdminList.size() - 1; i >= 0; --i) {
            ActiveAdmin aa = policy.mAdminList.get(i);
            try {
                if (pm.getPackageInfo(aa.info.getPackageName(), 0, userHandle) != null && pm.getReceiverInfo(aa.info.getComponent(), 0, userHandle) != null) continue;
                removed = true;
                policy.mAdminList.remove(i);
                continue;
            }
            catch (RemoteException re) {
                // empty catch block
            }
        }
        if (removed) {
            this.validatePasswordOwnerLocked(policy);
            this.syncDeviceCapabilitiesLocked(policy);
            this.saveSettingsLocked(policy.mUserHandle);
        }
    }

    public DevicePolicyManagerService(Context context) {
        this.mContext = context;
        this.mHasFeature = context.getPackageManager().hasSystemFeature("android.software.device_admin");
        this.mWakeLock = ((PowerManager)context.getSystemService("power")).newWakeLock(1, "DPM");
        if (!this.mHasFeature) {
            return;
        }
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.BOOT_COMPLETED");
        filter.addAction(ACTION_EXPIRED_PASSWORD_NOTIFICATION);
        filter.addAction("android.intent.action.USER_REMOVED");
        filter.addAction("android.intent.action.USER_STARTED");
        filter.addAction("android.security.STORAGE_CHANGED");
        context.registerReceiverAsUser(this.mReceiver, UserHandle.ALL, filter, null, this.mHandler);
        filter = new IntentFilter();
        filter.addAction("android.intent.action.PACKAGE_CHANGED");
        filter.addAction("android.intent.action.PACKAGE_REMOVED");
        filter.addAction("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE");
        filter.addAction("android.intent.action.PACKAGE_ADDED");
        filter.addDataScheme("package");
        context.registerReceiverAsUser(this.mReceiver, UserHandle.ALL, filter, null, this.mHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DevicePolicyData getUserData(int userHandle) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            DevicePolicyData policy = this.mUserData.get(userHandle);
            if (policy == null) {
                policy = new DevicePolicyData(userHandle);
                this.mUserData.append(userHandle, policy);
                this.loadSettingsLocked(policy, userHandle);
            }
            return policy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeUserData(int userHandle) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (userHandle == 0) {
                Slog.w(TAG, "Tried to remove device policy file for user 0! Ignoring.");
                return;
            }
            DevicePolicyData policy = this.mUserData.get(userHandle);
            if (policy != null) {
                this.mUserData.remove(userHandle);
            }
            File policyFile = new File(Environment.getUserSystemDirectory(userHandle), DEVICE_POLICIES_XML);
            policyFile.delete();
            Slog.i(TAG, "Removed device policy file " + policyFile.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadDeviceOwner() {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (DeviceOwner.isRegistered()) {
                this.mDeviceOwner = new DeviceOwner();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setExpirationAlarmCheckLocked(Context context, DevicePolicyData policy) {
        long alarmTime;
        long expiration = this.getPasswordExpirationLocked(null, policy.mUserHandle);
        long now = System.currentTimeMillis();
        long timeToExpire = expiration - now;
        if (expiration == 0L) {
            alarmTime = 0L;
        } else if (timeToExpire <= 0L) {
            alarmTime = now + 86400000L;
        } else {
            long alarmInterval = timeToExpire % 86400000L;
            if (alarmInterval == 0L) {
                alarmInterval = 86400000L;
            }
            alarmTime = now + alarmInterval;
        }
        long token = Binder.clearCallingIdentity();
        try {
            AlarmManager am = (AlarmManager)context.getSystemService("alarm");
            PendingIntent pi = PendingIntent.getBroadcastAsUser(context, 5571, new Intent(ACTION_EXPIRED_PASSWORD_NOTIFICATION), 0x48000000, new UserHandle(policy.mUserHandle));
            am.cancel(pi);
            if (alarmTime != 0L) {
                am.set(1, alarmTime, pi);
            }
            Object var16_10 = null;
        }
        catch (Throwable throwable) {
            Object var16_11 = null;
            Binder.restoreCallingIdentity(token);
            throw throwable;
        }
        Binder.restoreCallingIdentity(token);
    }

    private IPowerManager getIPowerManager() {
        if (this.mIPowerManager == null) {
            IBinder b = ServiceManager.getService("power");
            this.mIPowerManager = IPowerManager.Stub.asInterface(b);
        }
        return this.mIPowerManager;
    }

    private IWindowManager getWindowManager() {
        if (this.mIWindowManager == null) {
            IBinder b = ServiceManager.getService("window");
            this.mIWindowManager = IWindowManager.Stub.asInterface(b);
        }
        return this.mIWindowManager;
    }

    private NotificationManager getNotificationManager() {
        if (this.mNotificationManager == null) {
            this.mNotificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        }
        return this.mNotificationManager;
    }

    ActiveAdmin getActiveAdminUncheckedLocked(ComponentName who, int userHandle) {
        ActiveAdmin admin = this.getUserData((int)userHandle).mAdminMap.get(who);
        if (admin != null && who.getPackageName().equals(admin.info.getActivityInfo().packageName) && who.getClassName().equals(admin.info.getActivityInfo().name)) {
            return admin;
        }
        return null;
    }

    ActiveAdmin getActiveAdminForCallerLocked(ComponentName who, int reqPolicy) throws SecurityException {
        int callingUid = Binder.getCallingUid();
        int userHandle = UserHandle.getUserId(callingUid);
        DevicePolicyData policy = this.getUserData(userHandle);
        if (who != null) {
            ActiveAdmin admin = policy.mAdminMap.get(who);
            if (admin == null) {
                throw new SecurityException("No active admin " + who);
            }
            if (admin.getUid() != callingUid) {
                throw new SecurityException("Admin " + who + " is not owned by uid " + Binder.getCallingUid());
            }
            if (!admin.info.usesPolicy(reqPolicy)) {
                throw new SecurityException("Admin " + admin.info.getComponent() + " did not specify uses-policy for: " + admin.info.getTagForPolicy(reqPolicy));
            }
            return admin;
        }
        int N = policy.mAdminList.size();
        for (int i = 0; i < N; ++i) {
            ActiveAdmin admin = policy.mAdminList.get(i);
            if (admin.getUid() != callingUid || !admin.info.usesPolicy(reqPolicy)) continue;
            return admin;
        }
        throw new SecurityException("No active admin owned by uid " + Binder.getCallingUid() + " for policy #" + reqPolicy);
    }

    void sendAdminCommandLocked(ActiveAdmin admin, String action) {
        this.sendAdminCommandLocked(admin, action, null);
    }

    void sendAdminCommandLocked(ActiveAdmin admin, String action, BroadcastReceiver result) {
        Intent intent = new Intent(action);
        intent.setComponent(admin.info.getComponent());
        if (action.equals("android.app.action.ACTION_PASSWORD_EXPIRING")) {
            intent.putExtra("expiration", admin.passwordExpirationDate);
        }
        if (result != null) {
            this.mContext.sendOrderedBroadcastAsUser(intent, admin.getUserHandle(), null, result, this.mHandler, -1, null, null);
        } else {
            this.mContext.sendBroadcastAsUser(intent, UserHandle.OWNER);
        }
    }

    void sendAdminCommandLocked(String action, int reqPolicy, int userHandle) {
        DevicePolicyData policy = this.getUserData(userHandle);
        int count = policy.mAdminList.size();
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                ActiveAdmin admin = policy.mAdminList.get(i);
                if (!admin.info.usesPolicy(reqPolicy)) continue;
                this.sendAdminCommandLocked(admin, action);
            }
        }
    }

    void removeActiveAdminLocked(final ComponentName adminReceiver, int userHandle) {
        final ActiveAdmin admin = this.getActiveAdminUncheckedLocked(adminReceiver, userHandle);
        if (admin != null) {
            this.sendAdminCommandLocked(admin, "android.app.action.DEVICE_ADMIN_DISABLED", new BroadcastReceiver(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onReceive(Context context, Intent intent) {
                    DevicePolicyManagerService devicePolicyManagerService = DevicePolicyManagerService.this;
                    synchronized (devicePolicyManagerService) {
                        int userHandle = admin.getUserHandle().getIdentifier();
                        DevicePolicyData policy = DevicePolicyManagerService.this.getUserData(userHandle);
                        boolean doProxyCleanup = admin.info.usesPolicy(5);
                        policy.mAdminList.remove(admin);
                        policy.mAdminMap.remove(adminReceiver);
                        DevicePolicyManagerService.this.validatePasswordOwnerLocked(policy);
                        DevicePolicyManagerService.this.syncDeviceCapabilitiesLocked(policy);
                        if (doProxyCleanup) {
                            DevicePolicyManagerService.this.resetGlobalProxyLocked(DevicePolicyManagerService.this.getUserData(userHandle));
                        }
                        DevicePolicyManagerService.this.saveSettingsLocked(userHandle);
                        DevicePolicyManagerService.this.updateMaximumTimeToLockLocked(policy);
                    }
                }
            });
        }
    }

    public DeviceAdminInfo findAdmin(ComponentName adminName, int userHandle) {
        if (!this.mHasFeature) {
            return null;
        }
        this.enforceCrossUserPermission(userHandle);
        Intent resolveIntent = new Intent();
        resolveIntent.setComponent(adminName);
        List<ResolveInfo> infos = this.mContext.getPackageManager().queryBroadcastReceivers(resolveIntent, 32896, userHandle);
        if (infos == null || infos.size() <= 0) {
            throw new IllegalArgumentException("Unknown admin: " + adminName);
        }
        try {
            return new DeviceAdminInfo(this.mContext, infos.get(0));
        }
        catch (XmlPullParserException e) {
            Slog.w(TAG, "Bad device admin requested for user=" + userHandle + ": " + adminName, e);
            return null;
        }
        catch (IOException e) {
            Slog.w(TAG, "Bad device admin requested for user=" + userHandle + ": " + adminName, e);
            return null;
        }
    }

    private static JournaledFile makeJournaledFile(int userHandle) {
        String base = userHandle == 0 ? "/data/system/device_policies.xml" : new File(Environment.getUserSystemDirectory(userHandle), DEVICE_POLICIES_XML).getAbsolutePath();
        return new JournaledFile(new File(base), new File(base + ".tmp"));
    }

    private void saveSettingsLocked(int userHandle) {
        DevicePolicyData policy = this.getUserData(userHandle);
        JournaledFile journal = DevicePolicyManagerService.makeJournaledFile(userHandle);
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(journal.chooseForWrite(), false);
            FastXmlSerializer out = new FastXmlSerializer();
            out.setOutput(stream, "utf-8");
            out.startDocument(null, true);
            out.startTag(null, "policies");
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin ap = policy.mAdminList.get(i);
                if (ap == null) continue;
                out.startTag(null, "admin");
                out.attribute(null, "name", ap.info.getComponent().flattenToString());
                ap.writeToXml(out);
                out.endTag(null, "admin");
            }
            if (policy.mPasswordOwner >= 0) {
                out.startTag(null, "password-owner");
                out.attribute(null, "value", Integer.toString(policy.mPasswordOwner));
                out.endTag(null, "password-owner");
            }
            if (policy.mFailedPasswordAttempts != 0) {
                out.startTag(null, "failed-password-attempts");
                out.attribute(null, "value", Integer.toString(policy.mFailedPasswordAttempts));
                out.endTag(null, "failed-password-attempts");
            }
            if (policy.mActivePasswordQuality != 0 || policy.mActivePasswordLength != 0 || policy.mActivePasswordUpperCase != 0 || policy.mActivePasswordLowerCase != 0 || policy.mActivePasswordLetters != 0 || policy.mActivePasswordNumeric != 0 || policy.mActivePasswordSymbols != 0 || policy.mActivePasswordNonLetter != 0) {
                out.startTag(null, "active-password");
                out.attribute(null, "quality", Integer.toString(policy.mActivePasswordQuality));
                out.attribute(null, "length", Integer.toString(policy.mActivePasswordLength));
                out.attribute(null, "uppercase", Integer.toString(policy.mActivePasswordUpperCase));
                out.attribute(null, "lowercase", Integer.toString(policy.mActivePasswordLowerCase));
                out.attribute(null, "letters", Integer.toString(policy.mActivePasswordLetters));
                out.attribute(null, "numeric", Integer.toString(policy.mActivePasswordNumeric));
                out.attribute(null, "symbols", Integer.toString(policy.mActivePasswordSymbols));
                out.attribute(null, "nonletter", Integer.toString(policy.mActivePasswordNonLetter));
                out.endTag(null, "active-password");
            }
            out.endTag(null, "policies");
            out.endDocument();
            stream.close();
            journal.commit();
            this.sendChangedNotification(userHandle);
        }
        catch (IOException e) {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            journal.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendChangedNotification(int userHandle) {
        Intent intent = new Intent("android.app.action.DEVICE_POLICY_MANAGER_STATE_CHANGED");
        intent.setFlags(0x40000000);
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.sendBroadcastAsUser(intent, new UserHandle(userHandle));
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            Binder.restoreCallingIdentity(ident);
            throw throwable;
        }
        Binder.restoreCallingIdentity(ident);
    }

    private void loadSettingsLocked(DevicePolicyData policy, int userHandle) {
        JournaledFile journal = DevicePolicyManagerService.makeJournaledFile(userHandle);
        FileInputStream stream = null;
        File file = journal.chooseForRead();
        try {
            int type;
            stream = new FileInputStream(file);
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(stream, null);
            while ((type = parser.next()) != 1 && type != 2) {
            }
            String tag = parser.getName();
            if (!"policies".equals(tag)) {
                throw new XmlPullParserException("Settings do not start with policies tag: found " + tag);
            }
            type = parser.next();
            int outerDepth = parser.getDepth();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                if (type == 3 || type == 4) continue;
                tag = parser.getName();
                if ("admin".equals(tag)) {
                    String name = parser.getAttributeValue(null, "name");
                    try {
                        DeviceAdminInfo dai = this.findAdmin(ComponentName.unflattenFromString(name), userHandle);
                        if (dai == null) continue;
                        ActiveAdmin ap = new ActiveAdmin(dai);
                        ap.readFromXml(parser);
                        policy.mAdminMap.put(ap.info.getComponent(), ap);
                        policy.mAdminList.add(ap);
                    }
                    catch (RuntimeException e) {
                        Slog.w(TAG, "Failed loading admin " + name, e);
                    }
                    continue;
                }
                if ("failed-password-attempts".equals(tag)) {
                    policy.mFailedPasswordAttempts = Integer.parseInt(parser.getAttributeValue(null, "value"));
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                if ("password-owner".equals(tag)) {
                    policy.mPasswordOwner = Integer.parseInt(parser.getAttributeValue(null, "value"));
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                if ("active-password".equals(tag)) {
                    policy.mActivePasswordQuality = Integer.parseInt(parser.getAttributeValue(null, "quality"));
                    policy.mActivePasswordLength = Integer.parseInt(parser.getAttributeValue(null, "length"));
                    policy.mActivePasswordUpperCase = Integer.parseInt(parser.getAttributeValue(null, "uppercase"));
                    policy.mActivePasswordLowerCase = Integer.parseInt(parser.getAttributeValue(null, "lowercase"));
                    policy.mActivePasswordLetters = Integer.parseInt(parser.getAttributeValue(null, "letters"));
                    policy.mActivePasswordNumeric = Integer.parseInt(parser.getAttributeValue(null, "numeric"));
                    policy.mActivePasswordSymbols = Integer.parseInt(parser.getAttributeValue(null, "symbols"));
                    policy.mActivePasswordNonLetter = Integer.parseInt(parser.getAttributeValue(null, "nonletter"));
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                Slog.w(TAG, "Unknown tag: " + tag);
                XmlUtils.skipCurrentTag(parser);
            }
        }
        catch (NullPointerException e) {
            Slog.w(TAG, "failed parsing " + file + " " + e);
        }
        catch (NumberFormatException e) {
            Slog.w(TAG, "failed parsing " + file + " " + e);
        }
        catch (XmlPullParserException e) {
            Slog.w(TAG, "failed parsing " + file + " " + e);
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            Slog.w(TAG, "failed parsing " + file + " " + e);
        }
        catch (IndexOutOfBoundsException e) {
            Slog.w(TAG, "failed parsing " + file + " " + e);
        }
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        LockPatternUtils utils = new LockPatternUtils(this.mContext);
        if (utils.getActivePasswordQuality() < policy.mActivePasswordQuality) {
            Slog.w(TAG, "Active password quality 0x" + Integer.toHexString(policy.mActivePasswordQuality) + " does not match actual quality 0x" + Integer.toHexString(utils.getActivePasswordQuality()));
            policy.mActivePasswordQuality = 0;
            policy.mActivePasswordLength = 0;
            policy.mActivePasswordUpperCase = 0;
            policy.mActivePasswordLowerCase = 0;
            policy.mActivePasswordLetters = 0;
            policy.mActivePasswordNumeric = 0;
            policy.mActivePasswordSymbols = 0;
            policy.mActivePasswordNonLetter = 0;
        }
        this.validatePasswordOwnerLocked(policy);
        this.syncDeviceCapabilitiesLocked(policy);
        this.updateMaximumTimeToLockLocked(policy);
    }

    static void validateQualityConstant(int quality) {
        switch (quality) {
            case 0: 
            case 32768: 
            case 65536: 
            case 131072: 
            case 262144: 
            case 327680: 
            case 393216: {
                return;
            }
        }
        throw new IllegalArgumentException("Invalid quality constant: 0x" + Integer.toHexString(quality));
    }

    void validatePasswordOwnerLocked(DevicePolicyData policy) {
        if (policy.mPasswordOwner >= 0) {
            boolean haveOwner = false;
            for (int i = policy.mAdminList.size() - 1; i >= 0; --i) {
                if (policy.mAdminList.get(i).getUid() != policy.mPasswordOwner) continue;
                haveOwner = true;
                break;
            }
            if (!haveOwner) {
                Slog.w(TAG, "Previous password owner " + policy.mPasswordOwner + " no longer active; disabling");
                policy.mPasswordOwner = -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void syncDeviceCapabilitiesLocked(DevicePolicyData policy) {
        boolean systemState = SystemProperties.getBoolean(SYSTEM_PROP_DISABLE_CAMERA, false);
        boolean cameraDisabled = this.getCameraDisabled(null, policy.mUserHandle);
        if (cameraDisabled != systemState) {
            long token = Binder.clearCallingIdentity();
            try {
                String value = cameraDisabled ? "1" : "0";
                SystemProperties.set(SYSTEM_PROP_DISABLE_CAMERA, value);
                Object var8_6 = null;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                Binder.restoreCallingIdentity(token);
                throw throwable;
            }
            Binder.restoreCallingIdentity(token);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void systemReady() {
        if (!this.mHasFeature) {
            return;
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.loadSettingsLocked(this.getUserData(0), 0);
            this.loadDeviceOwner();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePasswordExpirationNotification(DevicePolicyData policy) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            long now = System.currentTimeMillis();
            int N = policy.mAdminList.size();
            if (N <= 0) {
                return;
            }
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = policy.mAdminList.get(i);
                if (!admin.info.usesPolicy(6) || admin.passwordExpirationTimeout <= 0L || admin.passwordExpirationDate <= 0L || now < admin.passwordExpirationDate - 432000000L) continue;
                this.sendAdminCommandLocked(admin, "android.app.action.ACTION_PASSWORD_EXPIRING");
            }
            this.setExpirationAlarmCheckLocked(this.mContext, policy);
        }
    }

    private void manageMonitoringCertificateNotification(Intent intent) {
        int smallIconId;
        String contentText;
        boolean isManaged;
        NotificationManager notificationManager = this.getNotificationManager();
        boolean hasCert = DevicePolicyManager.hasAnyCaCertsInstalled();
        if (!hasCert) {
            if (intent.getAction().equals("android.security.STORAGE_CHANGED")) {
                UserManager um = (UserManager)this.mContext.getSystemService("user");
                for (UserInfo user : um.getUsers()) {
                    notificationManager.cancelAsUser(null, 17039535, user.getUserHandle());
                }
            }
            return;
        }
        boolean bl = isManaged = this.getDeviceOwner() != null;
        if (isManaged) {
            contentText = this.mContext.getString(17039537, this.getDeviceOwnerName());
            smallIconId = 17302954;
        } else {
            contentText = this.mContext.getString(17039536);
            smallIconId = 17301642;
        }
        Intent dialogIntent = new Intent("com.android.settings.MONITORING_CERT_INFO");
        dialogIntent.setFlags(0x10008000);
        dialogIntent.setPackage("com.android.settings");
        PendingIntent notifyIntent = PendingIntent.getActivityAsUser(this.mContext, 0, dialogIntent, 0x8000000, null, UserHandle.CURRENT);
        Notification noti = new Notification.Builder(this.mContext).setSmallIcon(smallIconId).setContentTitle(this.mContext.getString(17039535)).setContentText(contentText).setContentIntent(notifyIntent).setPriority(1).setShowWhen(false).build();
        if (intent.getAction().equals("android.security.STORAGE_CHANGED")) {
            UserManager um = (UserManager)this.mContext.getSystemService("user");
            for (UserInfo user : um.getUsers()) {
                notificationManager.notifyAsUser(null, 17039535, noti, user.getUserHandle());
            }
        } else {
            notificationManager.notifyAsUser(null, 17039535, noti, UserHandle.CURRENT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setActiveAdmin(ComponentName adminReceiver, boolean refreshing, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_DEVICE_ADMINS", null);
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyData policy = this.getUserData(userHandle);
        DeviceAdminInfo info = this.findAdmin(adminReceiver, userHandle);
        if (info == null) {
            throw new IllegalArgumentException("Bad admin: " + adminReceiver);
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            long ident = Binder.clearCallingIdentity();
            try {
                if (!refreshing && this.getActiveAdminUncheckedLocked(adminReceiver, userHandle) != null) {
                    throw new IllegalArgumentException("Admin is already added");
                }
                ActiveAdmin newAdmin = new ActiveAdmin(info);
                policy.mAdminMap.put(adminReceiver, newAdmin);
                int replaceIndex = -1;
                if (refreshing) {
                    int N = policy.mAdminList.size();
                    for (int i = 0; i < N; ++i) {
                        ActiveAdmin oldAdmin = policy.mAdminList.get(i);
                        if (!oldAdmin.info.getComponent().equals(adminReceiver)) continue;
                        replaceIndex = i;
                        break;
                    }
                }
                if (replaceIndex == -1) {
                    policy.mAdminList.add(newAdmin);
                    this.enableIfNecessary(info.getPackageName(), userHandle);
                } else {
                    policy.mAdminList.set(replaceIndex, newAdmin);
                }
                this.saveSettingsLocked(userHandle);
                this.sendAdminCommandLocked(newAdmin, "android.app.action.DEVICE_ADMIN_ENABLED");
                Object var15_13 = null;
            }
            catch (Throwable throwable) {
                Object var15_14 = null;
                Binder.restoreCallingIdentity(ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAdminActive(ComponentName adminReceiver, int userHandle) {
        if (!this.mHasFeature) {
            return false;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            return this.getActiveAdminUncheckedLocked(adminReceiver, userHandle) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasGrantedPolicy(ComponentName adminReceiver, int policyId, int userHandle) {
        if (!this.mHasFeature) {
            return false;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin administrator = this.getActiveAdminUncheckedLocked(adminReceiver, userHandle);
            if (administrator == null) {
                throw new SecurityException("No active admin " + adminReceiver);
            }
            return administrator.info.usesPolicy(policyId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ComponentName> getActiveAdmins(int userHandle) {
        if (!this.mHasFeature) {
            return Collections.EMPTY_LIST;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            DevicePolicyData policy = this.getUserData(userHandle);
            int N = policy.mAdminList.size();
            if (N <= 0) {
                return null;
            }
            ArrayList<ComponentName> res = new ArrayList<ComponentName>(N);
            for (int i = 0; i < N; ++i) {
                res.add(policy.mAdminList.get((int)i).info.getComponent());
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean packageHasActiveAdmins(String packageName, int userHandle) {
        if (!this.mHasFeature) {
            return false;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            DevicePolicyData policy = this.getUserData(userHandle);
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                if (!policy.mAdminList.get((int)i).info.getPackageName().equals(packageName)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeActiveAdmin(ComponentName adminReceiver, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminUncheckedLocked(adminReceiver, userHandle);
            if (admin == null) {
                return;
            }
            if (admin.getUid() != Binder.getCallingUid()) {
                if (this.mDeviceOwner != null && adminReceiver.getPackageName().equals(this.mDeviceOwner.getPackageName())) {
                    return;
                }
                this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_DEVICE_ADMINS", null);
            }
            long ident = Binder.clearCallingIdentity();
            try {
                this.removeActiveAdminLocked(adminReceiver, userHandle);
                Object var8_6 = null;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                Binder.restoreCallingIdentity(ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordQuality(ComponentName who, int quality, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        DevicePolicyManagerService.validateQualityConstant(quality);
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0);
            if (ap.passwordQuality != quality) {
                ap.passwordQuality = quality;
                this.saveSettingsLocked(userHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPasswordQuality(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int mode = 0;
            DevicePolicyData policy = this.getUserData(userHandle);
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                int n = admin != null ? admin.passwordQuality : mode;
                return n;
            }
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = policy.mAdminList.get(i);
                if (mode >= admin.passwordQuality) continue;
                mode = admin.passwordQuality;
            }
            return mode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordMinimumLength(ComponentName who, int length, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0);
            if (ap.minimumPasswordLength != length) {
                ap.minimumPasswordLength = length;
                this.saveSettingsLocked(userHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPasswordMinimumLength(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            DevicePolicyData policy = this.getUserData(userHandle);
            int length = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                int n = admin != null ? admin.minimumPasswordLength : length;
                return n;
            }
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = policy.mAdminList.get(i);
                if (length >= admin.minimumPasswordLength) continue;
                length = admin.minimumPasswordLength;
            }
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordHistoryLength(ComponentName who, int length, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0);
            if (ap.passwordHistoryLength != length) {
                ap.passwordHistoryLength = length;
                this.saveSettingsLocked(userHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPasswordHistoryLength(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            DevicePolicyData policy = this.getUserData(userHandle);
            int length = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                int n = admin != null ? admin.passwordHistoryLength : length;
                return n;
            }
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = policy.mAdminList.get(i);
                if (length >= admin.passwordHistoryLength) continue;
                length = admin.passwordHistoryLength;
            }
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordExpirationTimeout(ComponentName who, long timeout, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            long expiration;
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            if (timeout < 0L) {
                throw new IllegalArgumentException("Timeout must be >= 0 ms");
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 6);
            ap.passwordExpirationDate = expiration = timeout > 0L ? timeout + System.currentTimeMillis() : 0L;
            ap.passwordExpirationTimeout = timeout;
            if (timeout > 0L) {
                Slog.w(TAG, "setPasswordExpiration(): password will expire on " + DateFormat.getDateTimeInstance(2, 2).format(new Date(expiration)));
            }
            this.saveSettingsLocked(userHandle);
            this.setExpirationAlarmCheckLocked(this.mContext, this.getUserData(userHandle));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getPasswordExpirationTimeout(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return 0L;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                long l = admin != null ? admin.passwordExpirationTimeout : 0L;
                return l;
            }
            long timeout = 0L;
            DevicePolicyData policy = this.getUserData(userHandle);
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = policy.mAdminList.get(i);
                if (timeout != 0L && (admin.passwordExpirationTimeout == 0L || timeout <= admin.passwordExpirationTimeout)) continue;
                timeout = admin.passwordExpirationTimeout;
            }
            return timeout;
        }
    }

    private long getPasswordExpirationLocked(ComponentName who, int userHandle) {
        if (who != null) {
            ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
            return admin != null ? admin.passwordExpirationDate : 0L;
        }
        long timeout = 0L;
        DevicePolicyData policy = this.getUserData(userHandle);
        int N = policy.mAdminList.size();
        for (int i = 0; i < N; ++i) {
            ActiveAdmin admin = policy.mAdminList.get(i);
            if (timeout != 0L && (admin.passwordExpirationDate == 0L || timeout <= admin.passwordExpirationDate)) continue;
            timeout = admin.passwordExpirationDate;
        }
        return timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getPasswordExpiration(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return 0L;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            return this.getPasswordExpirationLocked(who, userHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordMinimumUpperCase(ComponentName who, int length, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0);
            if (ap.minimumPasswordUpperCase != length) {
                ap.minimumPasswordUpperCase = length;
                this.saveSettingsLocked(userHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPasswordMinimumUpperCase(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int length = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                int n = admin != null ? admin.minimumPasswordUpperCase : length;
                return n;
            }
            DevicePolicyData policy = this.getUserData(userHandle);
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = policy.mAdminList.get(i);
                if (length >= admin.minimumPasswordUpperCase) continue;
                length = admin.minimumPasswordUpperCase;
            }
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordMinimumLowerCase(ComponentName who, int length, int userHandle) {
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0);
            if (ap.minimumPasswordLowerCase != length) {
                ap.minimumPasswordLowerCase = length;
                this.saveSettingsLocked(userHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPasswordMinimumLowerCase(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int length = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                int n = admin != null ? admin.minimumPasswordLowerCase : length;
                return n;
            }
            DevicePolicyData policy = this.getUserData(userHandle);
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = policy.mAdminList.get(i);
                if (length >= admin.minimumPasswordLowerCase) continue;
                length = admin.minimumPasswordLowerCase;
            }
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordMinimumLetters(ComponentName who, int length, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0);
            if (ap.minimumPasswordLetters != length) {
                ap.minimumPasswordLetters = length;
                this.saveSettingsLocked(userHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPasswordMinimumLetters(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int length = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                int n = admin != null ? admin.minimumPasswordLetters : length;
                return n;
            }
            DevicePolicyData policy = this.getUserData(userHandle);
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = policy.mAdminList.get(i);
                if (length >= admin.minimumPasswordLetters) continue;
                length = admin.minimumPasswordLetters;
            }
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordMinimumNumeric(ComponentName who, int length, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0);
            if (ap.minimumPasswordNumeric != length) {
                ap.minimumPasswordNumeric = length;
                this.saveSettingsLocked(userHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPasswordMinimumNumeric(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int length = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                int n = admin != null ? admin.minimumPasswordNumeric : length;
                return n;
            }
            DevicePolicyData policy = this.getUserData(userHandle);
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = policy.mAdminList.get(i);
                if (length >= admin.minimumPasswordNumeric) continue;
                length = admin.minimumPasswordNumeric;
            }
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordMinimumSymbols(ComponentName who, int length, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0);
            if (ap.minimumPasswordSymbols != length) {
                ap.minimumPasswordSymbols = length;
                this.saveSettingsLocked(userHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPasswordMinimumSymbols(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int length = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                int n = admin != null ? admin.minimumPasswordSymbols : length;
                return n;
            }
            DevicePolicyData policy = this.getUserData(userHandle);
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = policy.mAdminList.get(i);
                if (length >= admin.minimumPasswordSymbols) continue;
                length = admin.minimumPasswordSymbols;
            }
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordMinimumNonLetter(ComponentName who, int length, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0);
            if (ap.minimumPasswordNonLetter != length) {
                ap.minimumPasswordNonLetter = length;
                this.saveSettingsLocked(userHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPasswordMinimumNonLetter(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int length = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                int n = admin != null ? admin.minimumPasswordNonLetter : length;
                return n;
            }
            DevicePolicyData policy = this.getUserData(userHandle);
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = policy.mAdminList.get(i);
                if (length >= admin.minimumPasswordNonLetter) continue;
                length = admin.minimumPasswordNonLetter;
            }
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActivePasswordSufficient(int userHandle) {
        if (!this.mHasFeature) {
            return true;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            DevicePolicyData policy = this.getUserData(userHandle);
            this.getActiveAdminForCallerLocked(null, 0);
            if (policy.mActivePasswordQuality < this.getPasswordQuality(null, userHandle) || policy.mActivePasswordLength < this.getPasswordMinimumLength(null, userHandle)) {
                return false;
            }
            if (policy.mActivePasswordQuality != 393216) {
                return true;
            }
            return policy.mActivePasswordUpperCase >= this.getPasswordMinimumUpperCase(null, userHandle) && policy.mActivePasswordLowerCase >= this.getPasswordMinimumLowerCase(null, userHandle) && policy.mActivePasswordLetters >= this.getPasswordMinimumLetters(null, userHandle) && policy.mActivePasswordNumeric >= this.getPasswordMinimumNumeric(null, userHandle) && policy.mActivePasswordSymbols >= this.getPasswordMinimumSymbols(null, userHandle) && policy.mActivePasswordNonLetter >= this.getPasswordMinimumNonLetter(null, userHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCurrentFailedPasswordAttempts(int userHandle) {
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(null, 1);
            return this.getUserData((int)userHandle).mFailedPasswordAttempts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaximumFailedPasswordsForWipe(ComponentName who, int num, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, 4);
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 1);
            if (ap.maximumFailedPasswordsForWipe != num) {
                ap.maximumFailedPasswordsForWipe = num;
                this.saveSettingsLocked(userHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaximumFailedPasswordsForWipe(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            DevicePolicyData policy = this.getUserData(userHandle);
            int count = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                int n = admin != null ? admin.maximumFailedPasswordsForWipe : count;
                return n;
            }
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = policy.mAdminList.get(i);
                if (count == 0) {
                    count = admin.maximumFailedPasswordsForWipe;
                    continue;
                }
                if (admin.maximumFailedPasswordsForWipe == 0 || count <= admin.maximumFailedPasswordsForWipe) continue;
                count = admin.maximumFailedPasswordsForWipe;
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean resetPassword(String password, int flags, int userHandle) {
        int quality;
        if (!this.mHasFeature) {
            return false;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(null, 2);
            quality = this.getPasswordQuality(null, userHandle);
            if (quality != 0) {
                int realQuality = LockPatternUtils.computePasswordQuality(password);
                if (realQuality < quality && quality != 393216) {
                    Slog.w(TAG, "resetPassword: password quality 0x" + Integer.toHexString(realQuality) + " does not meet required quality 0x" + Integer.toHexString(quality));
                    return false;
                }
                quality = Math.max(realQuality, quality);
            }
            int length = this.getPasswordMinimumLength(null, userHandle);
            if (password.length() < length) {
                Slog.w(TAG, "resetPassword: password length " + password.length() + " does not meet required length " + length);
                return false;
            }
            if (quality == 393216) {
                int letters = 0;
                int uppercase = 0;
                int lowercase = 0;
                int numbers = 0;
                int symbols = 0;
                int nonletter = 0;
                for (int i = 0; i < password.length(); ++i) {
                    char c = password.charAt(i);
                    if (c >= 'A' && c <= 'Z') {
                        ++letters;
                        ++uppercase;
                        continue;
                    }
                    if (c >= 'a' && c <= 'z') {
                        ++letters;
                        ++lowercase;
                        continue;
                    }
                    if (c >= '0' && c <= '9') {
                        ++numbers;
                        ++nonletter;
                        continue;
                    }
                    ++symbols;
                    ++nonletter;
                }
                int neededLetters = this.getPasswordMinimumLetters(null, userHandle);
                if (letters < neededLetters) {
                    Slog.w(TAG, "resetPassword: number of letters " + letters + " does not meet required number of letters " + neededLetters);
                    return false;
                }
                int neededNumbers = this.getPasswordMinimumNumeric(null, userHandle);
                if (numbers < neededNumbers) {
                    Slog.w(TAG, "resetPassword: number of numerical digits " + numbers + " does not meet required number of numerical digits " + neededNumbers);
                    return false;
                }
                int neededLowerCase = this.getPasswordMinimumLowerCase(null, userHandle);
                if (lowercase < neededLowerCase) {
                    Slog.w(TAG, "resetPassword: number of lowercase letters " + lowercase + " does not meet required number of lowercase letters " + neededLowerCase);
                    return false;
                }
                int neededUpperCase = this.getPasswordMinimumUpperCase(null, userHandle);
                if (uppercase < neededUpperCase) {
                    Slog.w(TAG, "resetPassword: number of uppercase letters " + uppercase + " does not meet required number of uppercase letters " + neededUpperCase);
                    return false;
                }
                int neededSymbols = this.getPasswordMinimumSymbols(null, userHandle);
                if (symbols < neededSymbols) {
                    Slog.w(TAG, "resetPassword: number of special symbols " + symbols + " does not meet required number of special symbols " + neededSymbols);
                    return false;
                }
                int neededNonLetter = this.getPasswordMinimumNonLetter(null, userHandle);
                if (nonletter < neededNonLetter) {
                    Slog.w(TAG, "resetPassword: number of non-letter characters " + nonletter + " does not meet required number of non-letter characters " + neededNonLetter);
                    return false;
                }
            }
        }
        int callingUid = Binder.getCallingUid();
        DevicePolicyData policy = this.getUserData(userHandle);
        if (policy.mPasswordOwner >= 0 && policy.mPasswordOwner != callingUid) {
            Slog.w(TAG, "resetPassword: already set by another uid and not entered by user");
            return false;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            LockPatternUtils utils = new LockPatternUtils(this.mContext);
            utils.saveLockPassword(password, quality, false, userHandle);
            DevicePolicyManagerService devicePolicyManagerService2 = this;
            synchronized (devicePolicyManagerService2) {
                int newOwner;
                int n = newOwner = (flags & 1) != 0 ? callingUid : -1;
                if (policy.mPasswordOwner != newOwner) {
                    policy.mPasswordOwner = newOwner;
                    this.saveSettingsLocked(userHandle);
                }
            }
            Object var22_26 = null;
        }
        catch (Throwable throwable) {
            Object var22_27 = null;
            Binder.restoreCallingIdentity(ident);
            throw throwable;
        }
        Binder.restoreCallingIdentity(ident);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaximumTimeToLock(ComponentName who, long timeMs, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 3);
            if (ap.maximumTimeToUnlock != timeMs) {
                ap.maximumTimeToUnlock = timeMs;
                this.saveSettingsLocked(userHandle);
                this.updateMaximumTimeToLockLocked(this.getUserData(userHandle));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateMaximumTimeToLockLocked(DevicePolicyData policy) {
        long timeMs = this.getMaximumTimeToLock(null, policy.mUserHandle);
        if (policy.mLastMaximumTimeToLock == timeMs) {
            return;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            if (timeMs <= 0L) {
                timeMs = Integer.MAX_VALUE;
            } else {
                Settings.Global.putInt(this.mContext.getContentResolver(), "stay_on_while_plugged_in", 0);
            }
            policy.mLastMaximumTimeToLock = timeMs;
            try {
                this.getIPowerManager().setMaximumScreenOffTimeoutFromDeviceAdmin((int)timeMs);
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Failure talking with power manager", e);
            }
            Object var8_5 = null;
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            Binder.restoreCallingIdentity(ident);
            throw throwable;
        }
        Binder.restoreCallingIdentity(ident);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMaximumTimeToLock(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return 0L;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            long time = 0L;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                long l = admin != null ? admin.maximumTimeToUnlock : time;
                return l;
            }
            DevicePolicyData policy = this.getUserData(userHandle);
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = policy.mAdminList.get(i);
                if (time == 0L) {
                    time = admin.maximumTimeToUnlock;
                    continue;
                }
                if (admin.maximumTimeToUnlock == 0L || time <= admin.maximumTimeToUnlock) continue;
                time = admin.maximumTimeToUnlock;
            }
            return time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lockNow() {
        if (!this.mHasFeature) {
            return;
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(null, 3);
            this.lockNowUnchecked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void lockNowUnchecked() {
        long ident = Binder.clearCallingIdentity();
        try {
            try {
                this.getIPowerManager().goToSleep(SystemClock.uptimeMillis(), 1);
                this.getWindowManager().lockNow(null);
            }
            catch (RemoteException remoteException) {
                Object var5_3 = null;
                Binder.restoreCallingIdentity(ident);
                return;
            }
            Object var5_2 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            Binder.restoreCallingIdentity(ident);
            throw throwable;
        }
        Binder.restoreCallingIdentity(ident);
    }

    private boolean isExtStorageEncrypted() {
        String state = SystemProperties.get("vold.decrypt");
        return !"".equals(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean installCaCert(byte[] certBuffer) throws RemoteException {
        byte[] pemCert;
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_CA_CERTIFICATES", null);
        KeyChain.KeyChainConnection keyChainConnection = null;
        try {
            X509Certificate cert = DevicePolicyManagerService.parseCert(certBuffer);
            pemCert = Credentials.convertToPem(cert);
        }
        catch (CertificateException ce) {
            Log.e(TAG, "Problem converting cert", ce);
            return false;
        }
        catch (IOException ioe) {
            Log.e(TAG, "Problem reading cert", ioe);
            return false;
        }
        keyChainConnection = KeyChain.bind(this.mContext);
        try {
            boolean ioe;
            block9: {
                keyChainConnection.getService().installCaCertificate(pemCert);
                ioe = true;
                {
                    Object var6_9 = null;
                    if (keyChainConnection == null) break block9;
                    keyChainConnection.close();
                    keyChainConnection = null;
                }
            }
            return ioe;
        }
        catch (Throwable throwable) {
            try {
                Object var6_10 = null;
                if (keyChainConnection != null) {
                    keyChainConnection.close();
                    keyChainConnection = null;
                }
                throw throwable;
            }
            catch (InterruptedException e1) {
                Log.w(TAG, "installCaCertsToKeyChain(): ", e1);
                Thread.currentThread().interrupt();
                return false;
            }
        }
    }

    private static X509Certificate parseCert(byte[] certBuffer) throws CertificateException, IOException {
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        return (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(certBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uninstallCaCert(byte[] certBuffer) {
        block9: {
            this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_CA_CERTIFICATES", null);
            TrustedCertificateStore certStore = new TrustedCertificateStore();
            String alias = null;
            try {
                X509Certificate cert = DevicePolicyManagerService.parseCert(certBuffer);
                alias = certStore.getCertificateAlias(cert);
            }
            catch (CertificateException ce) {
                Log.e(TAG, "Problem creating X509Certificate", ce);
                return;
            }
            catch (IOException ioe) {
                Log.e(TAG, "Problem reading certificate", ioe);
                return;
            }
            try {
                KeyChain.KeyChainConnection keyChainConnection = KeyChain.bind(this.mContext);
                IKeyChainService service = keyChainConnection.getService();
                try {
                    try {
                        service.deleteCaCertificate(alias);
                    }
                    catch (RemoteException e) {
                        Log.e(TAG, "from CaCertUninstaller: ", e);
                        Object var8_10 = null;
                        keyChainConnection.close();
                        keyChainConnection = null;
                        break block9;
                    }
                    Object var8_9 = null;
                    keyChainConnection.close();
                    keyChainConnection = null;
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    keyChainConnection.close();
                    keyChainConnection = null;
                    throw throwable;
                }
            }
            catch (InterruptedException ie) {
                Log.w(TAG, "CaCertUninstaller: ", ie);
                Thread.currentThread().interrupt();
            }
        }
    }

    void wipeDataLocked(int flags) {
        boolean wipeExtRequested;
        boolean forceExtWipe = !Environment.isExternalStorageRemovable() && this.isExtStorageEncrypted();
        boolean bl = wipeExtRequested = (flags & 1) != 0;
        if ((forceExtWipe || wipeExtRequested) && !Environment.isExternalStorageEmulated()) {
            Intent intent = new Intent("com.android.internal.os.storage.FORMAT_AND_FACTORY_RESET");
            intent.putExtra("always_reset", true);
            intent.setComponent(ExternalStorageFormatter.COMPONENT_NAME);
            this.mWakeLock.acquire(10000L);
            this.mContext.startService(intent);
        } else {
            try {
                RecoverySystem.rebootWipeUserData(this.mContext);
            }
            catch (IOException e) {
                Slog.w(TAG, "Failed requesting data wipe", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wipeData(int flags, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(null, 4);
            long ident = Binder.clearCallingIdentity();
            try {
                this.wipeDeviceOrUserLocked(flags, userHandle);
                Object var7_5 = null;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                Binder.restoreCallingIdentity(ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity(ident);
        }
    }

    private void wipeDeviceOrUserLocked(int flags, final int userHandle) {
        if (userHandle == 0) {
            this.wipeDataLocked(flags);
        } else {
            this.lockNowUnchecked();
            this.mHandler.post(new Runnable(){

                public void run() {
                    try {
                        ActivityManagerNative.getDefault().switchUser(0);
                        ((UserManager)DevicePolicyManagerService.this.mContext.getSystemService("user")).removeUser(userHandle);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getRemoveWarning(ComponentName comp, final RemoteCallback result, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceCrossUserPermission(userHandle);
        this.mContext.enforceCallingOrSelfPermission("android.permission.BIND_DEVICE_ADMIN", null);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminUncheckedLocked(comp, userHandle);
            if (admin == null) {
                try {
                    result.sendResult(null);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                return;
            }
            Intent intent = new Intent("android.app.action.DEVICE_ADMIN_DISABLE_REQUESTED");
            intent.setComponent(admin.info.getComponent());
            this.mContext.sendOrderedBroadcastAsUser(intent, new UserHandle(userHandle), null, new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    try {
                        result.sendResult(this.getResultExtras(false));
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }, null, -1, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setActivePasswordState(int quality, int length, int letters, int uppercase, int lowercase, int numbers, int symbols, int nonletter, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceCrossUserPermission(userHandle);
        this.mContext.enforceCallingOrSelfPermission("android.permission.BIND_DEVICE_ADMIN", null);
        DevicePolicyData p = this.getUserData(userHandle);
        DevicePolicyManagerService.validateQualityConstant(quality);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (p.mActivePasswordQuality != quality || p.mActivePasswordLength != length || p.mFailedPasswordAttempts != 0 || p.mActivePasswordLetters != letters || p.mActivePasswordUpperCase != uppercase || p.mActivePasswordLowerCase != lowercase || p.mActivePasswordNumeric != numbers || p.mActivePasswordSymbols != symbols || p.mActivePasswordNonLetter != nonletter) {
                long ident = Binder.clearCallingIdentity();
                try {
                    p.mActivePasswordQuality = quality;
                    p.mActivePasswordLength = length;
                    p.mActivePasswordLetters = letters;
                    p.mActivePasswordLowerCase = lowercase;
                    p.mActivePasswordUpperCase = uppercase;
                    p.mActivePasswordNumeric = numbers;
                    p.mActivePasswordSymbols = symbols;
                    p.mActivePasswordNonLetter = nonletter;
                    p.mFailedPasswordAttempts = 0;
                    this.saveSettingsLocked(userHandle);
                    this.updatePasswordExpirationsLocked(userHandle);
                    this.setExpirationAlarmCheckLocked(this.mContext, p);
                    this.sendAdminCommandLocked("android.app.action.ACTION_PASSWORD_CHANGED", 0, userHandle);
                    Object var15_13 = null;
                }
                catch (Throwable throwable) {
                    Object var15_14 = null;
                    Binder.restoreCallingIdentity(ident);
                    throw throwable;
                }
                Binder.restoreCallingIdentity(ident);
                {
                }
            }
        }
    }

    private void updatePasswordExpirationsLocked(int userHandle) {
        DevicePolicyData policy = this.getUserData(userHandle);
        int N = policy.mAdminList.size();
        if (N > 0) {
            for (int i = 0; i < N; ++i) {
                long expiration;
                ActiveAdmin admin = policy.mAdminList.get(i);
                if (!admin.info.usesPolicy(6)) continue;
                long timeout = admin.passwordExpirationTimeout;
                admin.passwordExpirationDate = expiration = timeout > 0L ? timeout + System.currentTimeMillis() : 0L;
            }
            this.saveSettingsLocked(userHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportFailedPasswordAttempt(int userHandle) {
        this.enforceCrossUserPermission(userHandle);
        this.mContext.enforceCallingOrSelfPermission("android.permission.BIND_DEVICE_ADMIN", null);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            DevicePolicyData policy = this.getUserData(userHandle);
            long ident = Binder.clearCallingIdentity();
            try {
                ++policy.mFailedPasswordAttempts;
                this.saveSettingsLocked(userHandle);
                if (this.mHasFeature) {
                    int max = this.getMaximumFailedPasswordsForWipe(null, userHandle);
                    if (max > 0 && policy.mFailedPasswordAttempts >= max) {
                        this.wipeDeviceOrUserLocked(0, userHandle);
                    }
                    this.sendAdminCommandLocked("android.app.action.ACTION_PASSWORD_FAILED", 1, userHandle);
                }
                Object var8_6 = null;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                Binder.restoreCallingIdentity(ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportSuccessfulPasswordAttempt(int userHandle) {
        this.enforceCrossUserPermission(userHandle);
        this.mContext.enforceCallingOrSelfPermission("android.permission.BIND_DEVICE_ADMIN", null);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            DevicePolicyData policy = this.getUserData(userHandle);
            if (policy.mFailedPasswordAttempts != 0 || policy.mPasswordOwner >= 0) {
                long ident = Binder.clearCallingIdentity();
                try {
                    policy.mFailedPasswordAttempts = 0;
                    policy.mPasswordOwner = -1;
                    this.saveSettingsLocked(userHandle);
                    if (this.mHasFeature) {
                        this.sendAdminCommandLocked("android.app.action.ACTION_PASSWORD_SUCCEEDED", 1, userHandle);
                    }
                    Object var7_5 = null;
                }
                catch (Throwable throwable) {
                    Object var7_6 = null;
                    Binder.restoreCallingIdentity(ident);
                    throw throwable;
                }
                Binder.restoreCallingIdentity(ident);
                {
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentName setGlobalProxy(ComponentName who, String proxySpec, String exclusionList, int userHandle) {
        if (!this.mHasFeature) {
            return null;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            DevicePolicyData policy = this.getUserData(0);
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, 5);
            Set<ComponentName> compSet = policy.mAdminMap.keySet();
            for (ComponentName component : compSet) {
                ActiveAdmin ap = policy.mAdminMap.get(component);
                if (!ap.specifiesGlobalProxy || component.equals(who)) continue;
                return component;
            }
            if (UserHandle.getCallingUserId() != 0) {
                Slog.w(TAG, "Only the owner is allowed to set the global proxy. User " + userHandle + " is not permitted.");
                return null;
            }
            if (proxySpec == null) {
                admin.specifiesGlobalProxy = false;
                admin.globalProxySpec = null;
                admin.globalProxyExclusionList = null;
            } else {
                admin.specifiesGlobalProxy = true;
                admin.globalProxySpec = proxySpec;
                admin.globalProxyExclusionList = exclusionList;
            }
            long origId = Binder.clearCallingIdentity();
            this.resetGlobalProxyLocked(policy);
            Binder.restoreCallingIdentity(origId);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentName getGlobalProxyAdmin(int userHandle) {
        if (!this.mHasFeature) {
            return null;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            DevicePolicyData policy = this.getUserData(0);
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin ap = policy.mAdminList.get(i);
                if (!ap.specifiesGlobalProxy) continue;
                return ap.info.getComponent();
            }
        }
        return null;
    }

    private void resetGlobalProxyLocked(DevicePolicyData policy) {
        int N = policy.mAdminList.size();
        for (int i = 0; i < N; ++i) {
            ActiveAdmin ap = policy.mAdminList.get(i);
            if (!ap.specifiesGlobalProxy) continue;
            this.saveGlobalProxyLocked(ap.globalProxySpec, ap.globalProxyExclusionList);
            return;
        }
        this.saveGlobalProxyLocked(null, null);
    }

    private void saveGlobalProxyLocked(String proxySpec, String exclusionList) {
        if (exclusionList == null) {
            exclusionList = "";
        }
        if (proxySpec == null) {
            proxySpec = "";
        }
        proxySpec = proxySpec.trim();
        String[] data = proxySpec.split(":");
        int proxyPort = 8080;
        if (data.length > 1) {
            try {
                proxyPort = Integer.parseInt(data[1]);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        exclusionList = exclusionList.trim();
        ContentResolver res = this.mContext.getContentResolver();
        Settings.Global.putString(res, "global_http_proxy_host", data[0]);
        Settings.Global.putInt(res, "global_http_proxy_port", proxyPort);
        Settings.Global.putString(res, "global_http_proxy_exclusion_list", exclusionList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setStorageEncryption(ComponentName who, boolean encrypt, int userHandle) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            if (userHandle != 0 || UserHandle.getCallingUserId() != 0) {
                Slog.w(TAG, "Only owner is allowed to set storage encryption. User " + UserHandle.getCallingUserId() + " is not permitted.");
                return 0;
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 7);
            if (!this.isEncryptionSupported()) {
                return 0;
            }
            if (ap.encryptionRequested != encrypt) {
                ap.encryptionRequested = encrypt;
                this.saveSettingsLocked(userHandle);
            }
            DevicePolicyData policy = this.getUserData(0);
            boolean newRequested = false;
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                newRequested |= policy.mAdminList.get((int)i).encryptionRequested;
            }
            this.setEncryptionRequested(newRequested);
            return newRequested ? 3 : 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getStorageEncryption(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return false;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who != null) {
                ActiveAdmin ap = this.getActiveAdminUncheckedLocked(who, userHandle);
                boolean bl = ap != null ? ap.encryptionRequested : false;
                return bl;
            }
            DevicePolicyData policy = this.getUserData(userHandle);
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                if (!policy.mAdminList.get((int)i).encryptionRequested) continue;
                return true;
            }
            return false;
        }
    }

    @Override
    public int getStorageEncryptionStatus(int userHandle) {
        if (!this.mHasFeature) {
            // empty if block
        }
        this.enforceCrossUserPermission(userHandle);
        return this.getEncryptionStatus();
    }

    private boolean isEncryptionSupported() {
        return this.getEncryptionStatus() != 0;
    }

    private int getEncryptionStatus() {
        String status = SystemProperties.get("ro.crypto.state", "unsupported");
        if ("encrypted".equalsIgnoreCase(status)) {
            return 3;
        }
        if ("unencrypted".equalsIgnoreCase(status)) {
            return 1;
        }
        return 0;
    }

    private void setEncryptionRequested(boolean encrypt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCameraDisabled(ComponentName who, boolean disabled, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 8);
            if (ap.disableCamera != disabled) {
                ap.disableCamera = disabled;
                this.saveSettingsLocked(userHandle);
            }
            this.syncDeviceCapabilitiesLocked(this.getUserData(userHandle));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getCameraDisabled(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return false;
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                boolean bl = admin != null ? admin.disableCamera : false;
                return bl;
            }
            DevicePolicyData policy = this.getUserData(userHandle);
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = policy.mAdminList.get(i);
                if (!admin.disableCamera) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setKeyguardDisabledFeatures(ComponentName who, int which, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 9);
            if (ap.disabledKeyguardFeatures != which) {
                ap.disabledKeyguardFeatures = which;
                this.saveSettingsLocked(userHandle);
            }
            this.syncDeviceCapabilitiesLocked(this.getUserData(userHandle));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getKeyguardDisabledFeatures(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                int n = admin != null ? admin.disabledKeyguardFeatures : 0;
                return n;
            }
            DevicePolicyData policy = this.getUserData(userHandle);
            int N = policy.mAdminList.size();
            int which = 0;
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = policy.mAdminList.get(i);
                which |= admin.disabledKeyguardFeatures;
            }
            return which;
        }
    }

    @Override
    public boolean setDeviceOwner(String packageName, String ownerName) {
        if (!this.mHasFeature) {
            return false;
        }
        if (packageName == null || !DeviceOwner.isInstalled(packageName, this.mContext.getPackageManager())) {
            throw new IllegalArgumentException("Invalid package name " + packageName + " for device owner");
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (this.mDeviceOwner == null && !this.isDeviceProvisioned()) {
                this.mDeviceOwner = new DeviceOwner(packageName, ownerName);
                this.mDeviceOwner.writeOwnerFile();
                return true;
            }
            throw new IllegalStateException("Trying to set device owner to " + packageName + ", owner=" + this.mDeviceOwner.getPackageName() + ", device_provisioned=" + this.isDeviceProvisioned());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDeviceOwner(String packageName) {
        if (!this.mHasFeature) {
            return false;
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            return this.mDeviceOwner != null && this.mDeviceOwner.getPackageName().equals(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDeviceOwner() {
        if (!this.mHasFeature) {
            return null;
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (this.mDeviceOwner != null) {
                return this.mDeviceOwner.getPackageName();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDeviceOwnerName() {
        if (!this.mHasFeature) {
            return null;
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USERS", null);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (this.mDeviceOwner != null) {
                return this.mDeviceOwner.getName();
            }
        }
        return null;
    }

    private boolean isDeviceProvisioned() {
        return Settings.Global.getInt(this.mContext.getContentResolver(), "device_provisioned", 0) > 0;
    }

    private void enforceCrossUserPermission(int userHandle) {
        if (userHandle < 0) {
            throw new IllegalArgumentException("Invalid userId " + userHandle);
        }
        int callingUid = Binder.getCallingUid();
        if (userHandle == UserHandle.getUserId(callingUid)) {
            return;
        }
        if (callingUid != 1000 && callingUid != 0) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", "Must be system or have INTERACT_ACROSS_USERS_FULL permission");
        }
    }

    private void enableIfNecessary(String packageName, int userId) {
        try {
            IPackageManager ipm = AppGlobals.getPackageManager();
            ApplicationInfo ai = ipm.getApplicationInfo(packageName, 32768, userId);
            if (ai.enabledSetting == 4) {
                ipm.setApplicationEnabledSetting(packageName, 0, 1, userId, "DevicePolicyManager");
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump DevicePolicyManagerService from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        PrintWriterPrinter p = new PrintWriterPrinter(pw);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            p.println("Current Device Policy Manager state:");
            int userCount = this.mUserData.size();
            for (int u = 0; u < userCount; ++u) {
                DevicePolicyData policy = this.getUserData(this.mUserData.keyAt(u));
                p.println("  Enabled Device Admins (User " + policy.mUserHandle + "):");
                int N = policy.mAdminList.size();
                for (int i = 0; i < N; ++i) {
                    ActiveAdmin ap = policy.mAdminList.get(i);
                    if (ap == null) continue;
                    pw.print("  ");
                    pw.print(ap.info.getComponent().flattenToShortString());
                    pw.println(":");
                    ap.dump("    ", pw);
                }
                pw.println(" ");
                pw.print("  mPasswordOwner=");
                pw.println(policy.mPasswordOwner);
            }
        }
    }

    static class DeviceOwner {
        private static final String DEVICE_OWNER_XML = "device_owner.xml";
        private static final String TAG_DEVICE_OWNER = "device-owner";
        private static final String ATTR_NAME = "name";
        private static final String ATTR_PACKAGE = "package";
        private String mPackageName;
        private String mOwnerName;

        DeviceOwner() {
            this.readOwnerFile();
        }

        DeviceOwner(String packageName, String ownerName) {
            this.mPackageName = packageName;
            this.mOwnerName = ownerName;
        }

        static boolean isRegistered() {
            return new File(Environment.getSystemSecureDirectory(), DEVICE_OWNER_XML).exists();
        }

        String getPackageName() {
            return this.mPackageName;
        }

        String getName() {
            return this.mOwnerName;
        }

        static boolean isInstalled(String packageName, PackageManager pm) {
            try {
                PackageInfo pi = pm.getPackageInfo(packageName, 0);
                if (pi != null && (pi.applicationInfo.flags & 1) != 0) {
                    return true;
                }
            }
            catch (PackageManager.NameNotFoundException nnfe) {
                Slog.w(DevicePolicyManagerService.TAG, "Device Owner package " + packageName + " not installed.");
            }
            return false;
        }

        void readOwnerFile() {
            AtomicFile file = new AtomicFile(new File(Environment.getSystemSecureDirectory(), DEVICE_OWNER_XML));
            try {
                int type;
                FileInputStream input = file.openRead();
                XmlPullParser parser = Xml.newPullParser();
                parser.setInput(input, null);
                while ((type = parser.next()) != 1 && type != 2) {
                }
                String tag = parser.getName();
                if (!TAG_DEVICE_OWNER.equals(tag)) {
                    throw new XmlPullParserException("Device Owner file does not start with device-owner tag: found " + tag);
                }
                this.mPackageName = parser.getAttributeValue(null, ATTR_PACKAGE);
                this.mOwnerName = parser.getAttributeValue(null, ATTR_NAME);
                input.close();
            }
            catch (XmlPullParserException xppe) {
                Slog.e(DevicePolicyManagerService.TAG, "Error parsing device-owner file\n" + xppe);
            }
            catch (IOException ioe) {
                Slog.e(DevicePolicyManagerService.TAG, "IO Exception when reading device-owner file\n" + ioe);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void writeOwnerFile() {
            DeviceOwner deviceOwner = this;
            synchronized (deviceOwner) {
                this.writeOwnerFileLocked();
            }
        }

        private void writeOwnerFileLocked() {
            AtomicFile file = new AtomicFile(new File(Environment.getSystemSecureDirectory(), DEVICE_OWNER_XML));
            try {
                FileOutputStream output = file.startWrite();
                FastXmlSerializer out = new FastXmlSerializer();
                out.setOutput(output, "utf-8");
                out.startDocument(null, true);
                out.startTag(null, TAG_DEVICE_OWNER);
                out.attribute(null, ATTR_PACKAGE, this.mPackageName);
                if (this.mOwnerName != null) {
                    out.attribute(null, ATTR_NAME, this.mOwnerName);
                }
                out.endTag(null, TAG_DEVICE_OWNER);
                out.endDocument();
                out.flush();
                file.finishWrite(output);
            }
            catch (IOException ioe) {
                Slog.e(DevicePolicyManagerService.TAG, "IO Exception when writing device-owner file\n" + ioe);
            }
        }
    }

    static class ActiveAdmin {
        final DeviceAdminInfo info;
        int passwordQuality = 0;
        static final int DEF_MINIMUM_PASSWORD_LENGTH = 0;
        int minimumPasswordLength = 0;
        static final int DEF_PASSWORD_HISTORY_LENGTH = 0;
        int passwordHistoryLength = 0;
        static final int DEF_MINIMUM_PASSWORD_UPPER_CASE = 0;
        int minimumPasswordUpperCase = 0;
        static final int DEF_MINIMUM_PASSWORD_LOWER_CASE = 0;
        int minimumPasswordLowerCase = 0;
        static final int DEF_MINIMUM_PASSWORD_LETTERS = 1;
        int minimumPasswordLetters = 1;
        static final int DEF_MINIMUM_PASSWORD_NUMERIC = 1;
        int minimumPasswordNumeric = 1;
        static final int DEF_MINIMUM_PASSWORD_SYMBOLS = 1;
        int minimumPasswordSymbols = 1;
        static final int DEF_MINIMUM_PASSWORD_NON_LETTER = 0;
        int minimumPasswordNonLetter = 0;
        static final long DEF_MAXIMUM_TIME_TO_UNLOCK = 0L;
        long maximumTimeToUnlock = 0L;
        static final int DEF_MAXIMUM_FAILED_PASSWORDS_FOR_WIPE = 0;
        int maximumFailedPasswordsForWipe = 0;
        static final long DEF_PASSWORD_EXPIRATION_TIMEOUT = 0L;
        long passwordExpirationTimeout = 0L;
        static final long DEF_PASSWORD_EXPIRATION_DATE = 0L;
        long passwordExpirationDate = 0L;
        static final int DEF_KEYGUARD_FEATURES_DISABLED = 0;
        int disabledKeyguardFeatures = 0;
        boolean encryptionRequested = false;
        boolean disableCamera = false;
        boolean specifiesGlobalProxy = false;
        String globalProxySpec = null;
        String globalProxyExclusionList = null;

        ActiveAdmin(DeviceAdminInfo _info) {
            this.info = _info;
        }

        int getUid() {
            return this.info.getActivityInfo().applicationInfo.uid;
        }

        public UserHandle getUserHandle() {
            return new UserHandle(UserHandle.getUserId(this.info.getActivityInfo().applicationInfo.uid));
        }

        void writeToXml(XmlSerializer out) throws IllegalArgumentException, IllegalStateException, IOException {
            out.startTag(null, "policies");
            this.info.writePoliciesToXml(out);
            out.endTag(null, "policies");
            if (this.passwordQuality != 0) {
                out.startTag(null, "password-quality");
                out.attribute(null, "value", Integer.toString(this.passwordQuality));
                out.endTag(null, "password-quality");
                if (this.minimumPasswordLength != 0) {
                    out.startTag(null, "min-password-length");
                    out.attribute(null, "value", Integer.toString(this.minimumPasswordLength));
                    out.endTag(null, "min-password-length");
                }
                if (this.passwordHistoryLength != 0) {
                    out.startTag(null, "password-history-length");
                    out.attribute(null, "value", Integer.toString(this.passwordHistoryLength));
                    out.endTag(null, "password-history-length");
                }
                if (this.minimumPasswordUpperCase != 0) {
                    out.startTag(null, "min-password-uppercase");
                    out.attribute(null, "value", Integer.toString(this.minimumPasswordUpperCase));
                    out.endTag(null, "min-password-uppercase");
                }
                if (this.minimumPasswordLowerCase != 0) {
                    out.startTag(null, "min-password-lowercase");
                    out.attribute(null, "value", Integer.toString(this.minimumPasswordLowerCase));
                    out.endTag(null, "min-password-lowercase");
                }
                if (this.minimumPasswordLetters != 1) {
                    out.startTag(null, "min-password-letters");
                    out.attribute(null, "value", Integer.toString(this.minimumPasswordLetters));
                    out.endTag(null, "min-password-letters");
                }
                if (this.minimumPasswordNumeric != 1) {
                    out.startTag(null, "min-password-numeric");
                    out.attribute(null, "value", Integer.toString(this.minimumPasswordNumeric));
                    out.endTag(null, "min-password-numeric");
                }
                if (this.minimumPasswordSymbols != 1) {
                    out.startTag(null, "min-password-symbols");
                    out.attribute(null, "value", Integer.toString(this.minimumPasswordSymbols));
                    out.endTag(null, "min-password-symbols");
                }
                if (this.minimumPasswordNonLetter > 0) {
                    out.startTag(null, "min-password-nonletter");
                    out.attribute(null, "value", Integer.toString(this.minimumPasswordNonLetter));
                    out.endTag(null, "min-password-nonletter");
                }
            }
            if (this.maximumTimeToUnlock != 0L) {
                out.startTag(null, "max-time-to-unlock");
                out.attribute(null, "value", Long.toString(this.maximumTimeToUnlock));
                out.endTag(null, "max-time-to-unlock");
            }
            if (this.maximumFailedPasswordsForWipe != 0) {
                out.startTag(null, "max-failed-password-wipe");
                out.attribute(null, "value", Integer.toString(this.maximumFailedPasswordsForWipe));
                out.endTag(null, "max-failed-password-wipe");
            }
            if (this.specifiesGlobalProxy) {
                out.startTag(null, "specifies-global-proxy");
                out.attribute(null, "value", Boolean.toString(this.specifiesGlobalProxy));
                out.endTag(null, "specifies_global_proxy");
                if (this.globalProxySpec != null) {
                    out.startTag(null, "global-proxy-spec");
                    out.attribute(null, "value", this.globalProxySpec);
                    out.endTag(null, "global-proxy-spec");
                }
                if (this.globalProxyExclusionList != null) {
                    out.startTag(null, "global-proxy-exclusion-list");
                    out.attribute(null, "value", this.globalProxyExclusionList);
                    out.endTag(null, "global-proxy-exclusion-list");
                }
            }
            if (this.passwordExpirationTimeout != 0L) {
                out.startTag(null, "password-expiration-timeout");
                out.attribute(null, "value", Long.toString(this.passwordExpirationTimeout));
                out.endTag(null, "password-expiration-timeout");
            }
            if (this.passwordExpirationDate != 0L) {
                out.startTag(null, "password-expiration-date");
                out.attribute(null, "value", Long.toString(this.passwordExpirationDate));
                out.endTag(null, "password-expiration-date");
            }
            if (this.encryptionRequested) {
                out.startTag(null, "encryption-requested");
                out.attribute(null, "value", Boolean.toString(this.encryptionRequested));
                out.endTag(null, "encryption-requested");
            }
            if (this.disableCamera) {
                out.startTag(null, "disable-camera");
                out.attribute(null, "value", Boolean.toString(this.disableCamera));
                out.endTag(null, "disable-camera");
            }
            if (this.disabledKeyguardFeatures != 0) {
                out.startTag(null, "disable-keyguard-features");
                out.attribute(null, "value", Integer.toString(this.disabledKeyguardFeatures));
                out.endTag(null, "disable-keyguard-features");
            }
        }

        void readFromXml(XmlPullParser parser) throws XmlPullParserException, IOException {
            int type;
            int outerDepth = parser.getDepth();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                if (type == 3 || type == 4) continue;
                String tag = parser.getName();
                if ("policies".equals(tag)) {
                    this.info.readPoliciesFromXml(parser);
                } else if ("password-quality".equals(tag)) {
                    this.passwordQuality = Integer.parseInt(parser.getAttributeValue(null, "value"));
                } else if ("min-password-length".equals(tag)) {
                    this.minimumPasswordLength = Integer.parseInt(parser.getAttributeValue(null, "value"));
                } else if ("password-history-length".equals(tag)) {
                    this.passwordHistoryLength = Integer.parseInt(parser.getAttributeValue(null, "value"));
                } else if ("min-password-uppercase".equals(tag)) {
                    this.minimumPasswordUpperCase = Integer.parseInt(parser.getAttributeValue(null, "value"));
                } else if ("min-password-lowercase".equals(tag)) {
                    this.minimumPasswordLowerCase = Integer.parseInt(parser.getAttributeValue(null, "value"));
                } else if ("min-password-letters".equals(tag)) {
                    this.minimumPasswordLetters = Integer.parseInt(parser.getAttributeValue(null, "value"));
                } else if ("min-password-numeric".equals(tag)) {
                    this.minimumPasswordNumeric = Integer.parseInt(parser.getAttributeValue(null, "value"));
                } else if ("min-password-symbols".equals(tag)) {
                    this.minimumPasswordSymbols = Integer.parseInt(parser.getAttributeValue(null, "value"));
                } else if ("min-password-nonletter".equals(tag)) {
                    this.minimumPasswordNonLetter = Integer.parseInt(parser.getAttributeValue(null, "value"));
                } else if ("max-time-to-unlock".equals(tag)) {
                    this.maximumTimeToUnlock = Long.parseLong(parser.getAttributeValue(null, "value"));
                } else if ("max-failed-password-wipe".equals(tag)) {
                    this.maximumFailedPasswordsForWipe = Integer.parseInt(parser.getAttributeValue(null, "value"));
                } else if ("specifies-global-proxy".equals(tag)) {
                    this.specifiesGlobalProxy = Boolean.parseBoolean(parser.getAttributeValue(null, "value"));
                } else if ("global-proxy-spec".equals(tag)) {
                    this.globalProxySpec = parser.getAttributeValue(null, "value");
                } else if ("global-proxy-exclusion-list".equals(tag)) {
                    this.globalProxyExclusionList = parser.getAttributeValue(null, "value");
                } else if ("password-expiration-timeout".equals(tag)) {
                    this.passwordExpirationTimeout = Long.parseLong(parser.getAttributeValue(null, "value"));
                } else if ("password-expiration-date".equals(tag)) {
                    this.passwordExpirationDate = Long.parseLong(parser.getAttributeValue(null, "value"));
                } else if ("encryption-requested".equals(tag)) {
                    this.encryptionRequested = Boolean.parseBoolean(parser.getAttributeValue(null, "value"));
                } else if ("disable-camera".equals(tag)) {
                    this.disableCamera = Boolean.parseBoolean(parser.getAttributeValue(null, "value"));
                } else if ("disable-keyguard-features".equals(tag)) {
                    this.disabledKeyguardFeatures = Integer.parseInt(parser.getAttributeValue(null, "value"));
                } else {
                    Slog.w(DevicePolicyManagerService.TAG, "Unknown admin tag: " + tag);
                }
                XmlUtils.skipCurrentTag(parser);
            }
        }

        void dump(String prefix, PrintWriter pw) {
            pw.print(prefix);
            pw.print("uid=");
            pw.println(this.getUid());
            pw.print(prefix);
            pw.println("policies:");
            ArrayList<DeviceAdminInfo.PolicyInfo> pols = this.info.getUsedPolicies();
            if (pols != null) {
                for (int i = 0; i < pols.size(); ++i) {
                    pw.print(prefix);
                    pw.print("  ");
                    pw.println(pols.get((int)i).tag);
                }
            }
            pw.print(prefix);
            pw.print("passwordQuality=0x");
            pw.println(Integer.toHexString(this.passwordQuality));
            pw.print(prefix);
            pw.print("minimumPasswordLength=");
            pw.println(this.minimumPasswordLength);
            pw.print(prefix);
            pw.print("passwordHistoryLength=");
            pw.println(this.passwordHistoryLength);
            pw.print(prefix);
            pw.print("minimumPasswordUpperCase=");
            pw.println(this.minimumPasswordUpperCase);
            pw.print(prefix);
            pw.print("minimumPasswordLowerCase=");
            pw.println(this.minimumPasswordLowerCase);
            pw.print(prefix);
            pw.print("minimumPasswordLetters=");
            pw.println(this.minimumPasswordLetters);
            pw.print(prefix);
            pw.print("minimumPasswordNumeric=");
            pw.println(this.minimumPasswordNumeric);
            pw.print(prefix);
            pw.print("minimumPasswordSymbols=");
            pw.println(this.minimumPasswordSymbols);
            pw.print(prefix);
            pw.print("minimumPasswordNonLetter=");
            pw.println(this.minimumPasswordNonLetter);
            pw.print(prefix);
            pw.print("maximumTimeToUnlock=");
            pw.println(this.maximumTimeToUnlock);
            pw.print(prefix);
            pw.print("maximumFailedPasswordsForWipe=");
            pw.println(this.maximumFailedPasswordsForWipe);
            pw.print(prefix);
            pw.print("specifiesGlobalProxy=");
            pw.println(this.specifiesGlobalProxy);
            pw.print(prefix);
            pw.print("passwordExpirationTimeout=");
            pw.println(this.passwordExpirationTimeout);
            pw.print(prefix);
            pw.print("passwordExpirationDate=");
            pw.println(this.passwordExpirationDate);
            if (this.globalProxySpec != null) {
                pw.print(prefix);
                pw.print("globalProxySpec=");
                pw.println(this.globalProxySpec);
            }
            if (this.globalProxyExclusionList != null) {
                pw.print(prefix);
                pw.print("globalProxyEclusionList=");
                pw.println(this.globalProxyExclusionList);
            }
            pw.print(prefix);
            pw.print("encryptionRequested=");
            pw.println(this.encryptionRequested);
            pw.print(prefix);
            pw.print("disableCamera=");
            pw.println(this.disableCamera);
            pw.print(prefix);
            pw.print("disabledKeyguardFeatures=");
            pw.println(this.disabledKeyguardFeatures);
        }
    }

    public static class DevicePolicyData {
        int mActivePasswordQuality = 0;
        int mActivePasswordLength = 0;
        int mActivePasswordUpperCase = 0;
        int mActivePasswordLowerCase = 0;
        int mActivePasswordLetters = 0;
        int mActivePasswordNumeric = 0;
        int mActivePasswordSymbols = 0;
        int mActivePasswordNonLetter = 0;
        int mFailedPasswordAttempts = 0;
        int mUserHandle;
        int mPasswordOwner = -1;
        long mLastMaximumTimeToLock = -1L;
        final HashMap<ComponentName, ActiveAdmin> mAdminMap = new HashMap();
        final ArrayList<ActiveAdmin> mAdminList = new ArrayList();

        public DevicePolicyData(int userHandle) {
            this.mUserHandle = userHandle;
        }
    }
}

