/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.INetworkScoreCache;
import android.net.INetworkScoreService;
import android.net.NetworkScorerAppManager;
import android.net.ScoredNetwork;
import android.os.Binder;
import android.os.RemoteException;
import android.os.UserHandle;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NetworkScoreService
extends INetworkScoreService.Stub {
    private static final String TAG = "NetworkScoreService";
    private final Context mContext;
    private final Map<Integer, INetworkScoreCache> mScoreCaches;

    public NetworkScoreService(Context context) {
        this.mContext = context;
        this.mScoreCaches = new HashMap<Integer, INetworkScoreCache>();
    }

    void systemReady() {
        ContentResolver cr = this.mContext.getContentResolver();
        if (Settings.Global.getInt(cr, "network_scoring_provisioned", 0) == 0) {
            String defaultPackage = this.mContext.getResources().getString(0x1040044);
            if (!TextUtils.isEmpty(defaultPackage)) {
                NetworkScorerAppManager.setActiveScorer((Context)this.mContext, (String)defaultPackage);
            }
            Settings.Global.putInt(cr, "network_scoring_provisioned", 1);
        }
    }

    public boolean updateScores(ScoredNetwork[] networks) {
        if (!NetworkScorerAppManager.isCallerActiveScorer((Context)this.mContext, (int)NetworkScoreService.getCallingUid())) {
            throw new SecurityException("Caller with UID " + NetworkScoreService.getCallingUid() + " is not the active scorer.");
        }
        HashMap<Integer, ArrayList<ScoredNetwork>> networksByType = new HashMap<Integer, ArrayList<ScoredNetwork>>();
        for (ScoredNetwork network : networks) {
            ArrayList<ScoredNetwork> networkList = (ArrayList<ScoredNetwork>)networksByType.get(network.networkKey.type);
            if (networkList == null) {
                networkList = new ArrayList<ScoredNetwork>();
                networksByType.put(network.networkKey.type, networkList);
            }
            networkList.add(network);
        }
        for (Map.Entry entry : networksByType.entrySet()) {
            INetworkScoreCache scoreCache = this.mScoreCaches.get(entry.getKey());
            if (scoreCache != null) {
                try {
                    scoreCache.updateScores((List)entry.getValue());
                }
                catch (RemoteException e) {
                    if (!Log.isLoggable(TAG, 2)) continue;
                    Log.v(TAG, "Unable to update scores of type " + entry.getKey(), e);
                }
                continue;
            }
            if (!Log.isLoggable(TAG, 2)) continue;
            Log.v(TAG, "No scorer registered for type " + entry.getKey() + ", discarding");
        }
        return true;
    }

    public boolean clearScores() {
        if (NetworkScorerAppManager.isCallerActiveScorer((Context)this.mContext, (int)NetworkScoreService.getCallingUid()) || this.mContext.checkCallingOrSelfPermission("android.permission.BROADCAST_SCORE_NETWORKS") == 0) {
            this.clearInternal();
            return true;
        }
        throw new SecurityException("Caller is neither the active scorer nor the scorer manager.");
    }

    public boolean setActiveScorer(String packageName) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BROADCAST_SCORE_NETWORKS", TAG);
        return this.setScorerInternal(packageName);
    }

    public void disableScoring() {
        if (!NetworkScorerAppManager.isCallerActiveScorer((Context)this.mContext, (int)NetworkScoreService.getCallingUid()) && this.mContext.checkCallingOrSelfPermission("android.permission.BROADCAST_SCORE_NETWORKS") != 0) {
            throw new SecurityException("Caller is neither the active scorer nor the scorer manager.");
        }
        this.setScorerInternal(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setScorerInternal(String packageName) {
        long token = Binder.clearCallingIdentity();
        try {
            this.clearInternal();
            boolean result = NetworkScorerAppManager.setActiveScorer((Context)this.mContext, (String)packageName);
            if (result) {
                Intent intent = new Intent("android.net.scoring.SCORER_CHANGED");
                intent.putExtra("newScorer", packageName);
                this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private void clearInternal() {
        Set<INetworkScoreCache> cachesToClear = this.getScoreCaches();
        for (INetworkScoreCache scoreCache : cachesToClear) {
            try {
                scoreCache.clearScores();
            }
            catch (RemoteException e) {
                if (!Log.isLoggable(TAG, 2)) continue;
                Log.v(TAG, "Unable to clear scores", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerNetworkScoreCache(int networkType, INetworkScoreCache scoreCache) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BROADCAST_SCORE_NETWORKS", TAG);
        Map<Integer, INetworkScoreCache> map = this.mScoreCaches;
        synchronized (map) {
            if (this.mScoreCaches.containsKey(networkType)) {
                throw new IllegalArgumentException("Score cache already registered for type " + networkType);
            }
            this.mScoreCaches.put(networkType, scoreCache);
        }
    }

    protected void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", TAG);
        NetworkScorerAppManager.NetworkScorerAppData currentScorer = NetworkScorerAppManager.getActiveScorer((Context)this.mContext);
        if (currentScorer == null) {
            writer.println("Scoring is disabled.");
            return;
        }
        writer.println("Current scorer: " + currentScorer.mPackageName);
        writer.flush();
        for (INetworkScoreCache scoreCache : this.getScoreCaches()) {
            try {
                scoreCache.asBinder().dump(fd, args);
            }
            catch (RemoteException e) {
                writer.println("Unable to dump score cache");
                if (!Log.isLoggable(TAG, 2)) continue;
                Log.v(TAG, "Unable to dump score cache", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<INetworkScoreCache> getScoreCaches() {
        Map<Integer, INetworkScoreCache> map = this.mScoreCaches;
        synchronized (map) {
            return new HashSet<INetworkScoreCache>(this.mScoreCaches.values());
        }
    }
}

