/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.pm.FeatureInfo;
import android.os.Environment;
import android.os.Process;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Slog;
import android.util.SparseArray;
import android.util.Xml;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.XmlUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class SystemConfig {
    static final String TAG = "SystemConfig";
    static SystemConfig sInstance;
    int[] mGlobalGids;
    final SparseArray<HashSet<String>> mSystemPermissions = new SparseArray();
    final ArrayMap<String, String> mSharedLibraries = new ArrayMap();
    final HashMap<String, FeatureInfo> mAvailableFeatures = new HashMap();
    final ArrayMap<String, PermissionEntry> mPermissions = new ArrayMap();
    final ArraySet<String> mAllowInPowerSave = new ArraySet();
    final ArraySet<String> mFixedImeApps = new ArraySet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SystemConfig getInstance() {
        Class<SystemConfig> clazz = SystemConfig.class;
        synchronized (SystemConfig.class) {
            if (sInstance == null) {
                sInstance = new SystemConfig();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public int[] getGlobalGids() {
        return this.mGlobalGids;
    }

    public SparseArray<HashSet<String>> getSystemPermissions() {
        return this.mSystemPermissions;
    }

    public ArrayMap<String, String> getSharedLibraries() {
        return this.mSharedLibraries;
    }

    public HashMap<String, FeatureInfo> getAvailableFeatures() {
        return this.mAvailableFeatures;
    }

    public ArrayMap<String, PermissionEntry> getPermissions() {
        return this.mPermissions;
    }

    public ArraySet<String> getAllowInPowerSave() {
        return this.mAllowInPowerSave;
    }

    public ArraySet<String> getFixedImeApps() {
        return this.mFixedImeApps;
    }

    SystemConfig() {
        this.readPermissions(Environment.buildPath(Environment.getRootDirectory(), "etc", "sysconfig"), false);
        this.readPermissions(Environment.buildPath(Environment.getRootDirectory(), "etc", "permissions"), false);
        this.readPermissions(Environment.buildPath(Environment.getOemDirectory(), "etc", "sysconfig"), true);
        this.readPermissions(Environment.buildPath(Environment.getOemDirectory(), "etc", "permissions"), true);
    }

    void readPermissions(File libraryDir, boolean onlyFeatures) {
        if (!libraryDir.exists() || !libraryDir.isDirectory()) {
            if (!onlyFeatures) {
                Slog.w(TAG, "No directory " + libraryDir + ", skipping");
            }
            return;
        }
        if (!libraryDir.canRead()) {
            Slog.w(TAG, "Directory " + libraryDir + " cannot be read");
            return;
        }
        for (File f : libraryDir.listFiles()) {
            if (f.getPath().endsWith("etc/permissions/platform.xml")) continue;
            if (!f.getPath().endsWith(".xml")) {
                Slog.i(TAG, "Non-xml file " + f + " in " + libraryDir + " directory, ignoring");
                continue;
            }
            if (!f.canRead()) {
                Slog.w(TAG, "Permissions library file " + f + " cannot be read");
                continue;
            }
            this.readPermissionsFromXml(f, onlyFeatures);
        }
        File permFile = new File(Environment.getRootDirectory(), "etc/permissions/platform.xml");
        this.readPermissionsFromXml(permFile, onlyFeatures);
    }

    private void readPermissionsFromXml(File permFile, boolean onlyFeatures) {
        FileReader permReader = null;
        try {
            permReader = new FileReader(permFile);
        }
        catch (FileNotFoundException e) {
            Slog.w(TAG, "Couldn't find or open permissions file " + permFile);
            return;
        }
        try {
            int type;
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(permReader);
            do {
                type = parser.next();
                if (type == 2) break;
            } while (type != 1);
            if (type != 2) {
                throw new XmlPullParserException("No start tag found");
            }
            if (!parser.getName().equals("permissions") && !parser.getName().equals("config")) {
                throw new XmlPullParserException("Unexpected start tag: found " + parser.getName() + ", expected 'permissions' or 'config'");
            }
            while (true) {
                String pkgname;
                String perm;
                XmlUtils.nextElement(parser);
                if (parser.getEventType() == 1) break;
                String name = parser.getName();
                if ("group".equals(name) && !onlyFeatures) {
                    String gidStr = parser.getAttributeValue(null, "gid");
                    if (gidStr != null) {
                        int gid = Process.getGidForName(gidStr);
                        this.mGlobalGids = ArrayUtils.appendInt(this.mGlobalGids, gid);
                    } else {
                        Slog.w(TAG, "<group> without gid at " + parser.getPositionDescription());
                    }
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                if ("permission".equals(name) && !onlyFeatures) {
                    perm = parser.getAttributeValue(null, "name");
                    if (perm == null) {
                        Slog.w(TAG, "<permission> without name at " + parser.getPositionDescription());
                        XmlUtils.skipCurrentTag(parser);
                        continue;
                    }
                    perm = perm.intern();
                    this.readPermission(parser, perm);
                    continue;
                }
                if ("assign-permission".equals(name) && !onlyFeatures) {
                    perm = parser.getAttributeValue(null, "name");
                    if (perm == null) {
                        Slog.w(TAG, "<assign-permission> without name at " + parser.getPositionDescription());
                        XmlUtils.skipCurrentTag(parser);
                        continue;
                    }
                    String uidStr = parser.getAttributeValue(null, "uid");
                    if (uidStr == null) {
                        Slog.w(TAG, "<assign-permission> without uid at " + parser.getPositionDescription());
                        XmlUtils.skipCurrentTag(parser);
                        continue;
                    }
                    int uid = Process.getUidForName(uidStr);
                    if (uid < 0) {
                        Slog.w(TAG, "<assign-permission> with unknown uid \"" + uidStr + "\" at " + parser.getPositionDescription());
                        XmlUtils.skipCurrentTag(parser);
                        continue;
                    }
                    perm = perm.intern();
                    HashSet<String> perms = this.mSystemPermissions.get(uid);
                    if (perms == null) {
                        perms = new HashSet();
                        this.mSystemPermissions.put(uid, perms);
                    }
                    perms.add(perm);
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                if ("library".equals(name) && !onlyFeatures) {
                    String lname = parser.getAttributeValue(null, "name");
                    String lfile = parser.getAttributeValue(null, "file");
                    if (lname == null) {
                        Slog.w(TAG, "<library> without name at " + parser.getPositionDescription());
                    } else if (lfile == null) {
                        Slog.w(TAG, "<library> without file at " + parser.getPositionDescription());
                    } else {
                        this.mSharedLibraries.put(lname, lfile);
                    }
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                if ("feature".equals(name)) {
                    String fname = parser.getAttributeValue(null, "name");
                    if (fname == null) {
                        Slog.w(TAG, "<feature> without name at " + parser.getPositionDescription());
                    } else {
                        FeatureInfo fi = new FeatureInfo();
                        fi.name = fname;
                        this.mAvailableFeatures.put(fname, fi);
                    }
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                if ("allow-in-power-save".equals(name)) {
                    pkgname = parser.getAttributeValue(null, "package");
                    if (pkgname == null) {
                        Slog.w(TAG, "<allow-in-power-save> without package at " + parser.getPositionDescription());
                    } else {
                        this.mAllowInPowerSave.add(pkgname);
                    }
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                if ("fixed-ime-app".equals(name)) {
                    pkgname = parser.getAttributeValue(null, "package");
                    if (pkgname == null) {
                        Slog.w(TAG, "<fixed-ime-app> without package at " + parser.getPositionDescription());
                    } else {
                        this.mFixedImeApps.add(pkgname);
                    }
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                XmlUtils.skipCurrentTag(parser);
            }
            permReader.close();
        }
        catch (XmlPullParserException e) {
            Slog.w(TAG, "Got execption parsing permissions.", e);
        }
        catch (IOException e) {
            Slog.w(TAG, "Got execption parsing permissions.", e);
        }
    }

    void readPermission(XmlPullParser parser, String name) throws IOException, XmlPullParserException {
        int type;
        PermissionEntry perm = this.mPermissions.get(name = name.intern());
        if (perm == null) {
            perm = new PermissionEntry(name);
            this.mPermissions.put(name, perm);
        }
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if ("group".equals(tagName)) {
                String gidStr = parser.getAttributeValue(null, "gid");
                if (gidStr != null) {
                    int gid = Process.getGidForName(gidStr);
                    perm.gids = ArrayUtils.appendInt(perm.gids, gid);
                } else {
                    Slog.w(TAG, "<group> without gid at " + parser.getPositionDescription());
                }
            }
            XmlUtils.skipCurrentTag(parser);
        }
    }

    public static final class PermissionEntry {
        public final String name;
        public int[] gids;

        PermissionEntry(String _name) {
            this.name = _name;
        }
    }
}

