/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.view.accessibility.AccessibilityManager;
import android.widget.Toast;

public class LockTaskNotify {
    private static final String TAG = "LockTaskNotify";
    private final Context mContext;
    private final H mHandler;
    private AccessibilityManager mAccessibilityManager;
    private Toast mLastToast;

    public LockTaskNotify(Context context) {
        this.mContext = context;
        this.mAccessibilityManager = (AccessibilityManager)this.mContext.getSystemService("accessibility");
        this.mHandler = new H();
    }

    public void showToast(boolean isLocked) {
        this.mHandler.obtainMessage(3, isLocked ? 1 : 0, 0).sendToTarget();
    }

    public void handleShowToast(boolean isLocked) {
        String text = this.mContext.getString(isLocked ? 17041011 : 17041009);
        if (!isLocked && this.mAccessibilityManager.isEnabled()) {
            text = this.mContext.getString(17041010);
        }
        if (this.mLastToast != null) {
            this.mLastToast.cancel();
        }
        this.mLastToast = Toast.makeText(this.mContext, text, 1);
        this.mLastToast.show();
    }

    public void show(boolean starting) {
        int showString = 17041018;
        if (starting) {
            showString = 17041017;
        }
        Toast.makeText(this.mContext, this.mContext.getString(showString), 1).show();
    }

    private final class H
    extends Handler {
        private static final int SHOW_TOAST = 3;

        private H() {
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 3: {
                    LockTaskNotify.this.handleShowToast(msg.arg1 != 0);
                }
            }
        }
    }
}

