/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.content;

import android.accounts.Account;
import android.accounts.AccountAndUser;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.ISyncStatusObserver;
import android.content.PeriodicSync;
import android.content.SyncInfo;
import android.content.SyncStatusInfo;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteQueryBuilder;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.os.Parcel;
import android.os.Process;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.util.AtomicFile;
import android.util.Log;
import android.util.Pair;
import android.util.SparseArray;
import android.util.Xml;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.FastXmlSerializer;
import com.android.server.content.SyncManager;
import com.android.server.content.SyncQueue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.TimeZone;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncStorageEngine
extends Handler {
    private static final String TAG = "SyncManager";
    private static final boolean DEBUG = false;
    private static final String TAG_FILE = "SyncManagerFile";
    private static final String XML_ATTR_NEXT_AUTHORITY_ID = "nextAuthorityId";
    private static final String XML_ATTR_LISTEN_FOR_TICKLES = "listen-for-tickles";
    private static final String XML_ATTR_SYNC_RANDOM_OFFSET = "offsetInSeconds";
    private static final String XML_ATTR_ENABLED = "enabled";
    private static final String XML_ATTR_USER = "user";
    private static final String XML_TAG_LISTEN_FOR_TICKLES = "listenForTickles";
    private static final long DEFAULT_POLL_FREQUENCY_SECONDS = 86400L;
    private static final double DEFAULT_FLEX_PERCENT_SYNC = 0.04;
    private static final long DEFAULT_MIN_FLEX_ALLOWED_SECS = 5L;
    static final long MILLIS_IN_4WEEKS = 2419200000L;
    public static final int EVENT_START = 0;
    public static final int EVENT_STOP = 1;
    public static final String[] EVENTS = new String[]{"START", "STOP"};
    public static final int SOURCE_SERVER = 0;
    public static final int SOURCE_LOCAL = 1;
    public static final int SOURCE_POLL = 2;
    public static final int SOURCE_USER = 3;
    public static final int SOURCE_PERIODIC = 4;
    public static final long NOT_IN_BACKOFF_MODE = -1L;
    public static final String[] SOURCES = new String[]{"SERVER", "LOCAL", "POLL", "USER", "PERIODIC"};
    public static final String MESG_SUCCESS = "success";
    public static final String MESG_CANCELED = "canceled";
    public static final int MAX_HISTORY = 100;
    private static final int MSG_WRITE_STATUS = 1;
    private static final long WRITE_STATUS_DELAY = 600000L;
    private static final int MSG_WRITE_STATISTICS = 2;
    private static final long WRITE_STATISTICS_DELAY = 1800000L;
    private static final boolean SYNC_ENABLED_DEFAULT = false;
    private static final int ACCOUNTS_VERSION = 2;
    private static HashMap<String, String> sAuthorityRenames = new HashMap();
    private final SparseArray<AuthorityInfo> mAuthorities = new SparseArray();
    private final HashMap<AccountAndUser, AccountInfo> mAccounts = new HashMap();
    private final ArrayList<PendingOperation> mPendingOperations = new ArrayList();
    private final SparseArray<ArrayList<SyncInfo>> mCurrentSyncs = new SparseArray();
    private final SparseArray<SyncStatusInfo> mSyncStatus = new SparseArray();
    private final ArrayList<SyncHistoryItem> mSyncHistory = new ArrayList();
    private final RemoteCallbackList<ISyncStatusObserver> mChangeListeners = new RemoteCallbackList();
    private final HashMap<ComponentName, SparseArray<AuthorityInfo>> mServices = new HashMap();
    private int mNextAuthorityId = 0;
    private final DayStats[] mDayStats = new DayStats[28];
    private final Calendar mCal;
    private int mYear;
    private int mYearInDays;
    private final Context mContext;
    private static volatile SyncStorageEngine sSyncStorageEngine;
    private int mSyncRandomOffset;
    private final AtomicFile mAccountInfoFile;
    private final AtomicFile mStatusFile;
    private final AtomicFile mStatisticsFile;
    private final AtomicFile mPendingFile;
    private static final int PENDING_FINISH_TO_WRITE = 4;
    private int mNumPendingFinished = 0;
    private int mNextHistoryId = 0;
    private SparseArray<Boolean> mMasterSyncAutomatically = new SparseArray();
    private boolean mDefaultMasterSyncAutomatically;
    private OnSyncRequestListener mSyncRequestListener;
    public static final int STATUS_FILE_END = 0;
    public static final int STATUS_FILE_ITEM = 100;
    public static final int PENDING_OPERATION_VERSION = 3;
    private static final String XML_ATTR_AUTHORITYID = "authority_id";
    private static final String XML_ATTR_SOURCE = "source";
    private static final String XML_ATTR_EXPEDITED = "expedited";
    private static final String XML_ATTR_REASON = "reason";
    private static final String XML_ATTR_VERSION = "version";
    public static final int STATISTICS_FILE_END = 0;
    public static final int STATISTICS_FILE_ITEM_OLD = 100;
    public static final int STATISTICS_FILE_ITEM = 101;

    private SyncStorageEngine(Context context, File dataDir) {
        this.mContext = context;
        sSyncStorageEngine = this;
        this.mCal = Calendar.getInstance(TimeZone.getTimeZone("GMT+0"));
        this.mDefaultMasterSyncAutomatically = this.mContext.getResources().getBoolean(17891406);
        File systemDir = new File(dataDir, "system");
        File syncDir = new File(systemDir, "sync");
        syncDir.mkdirs();
        this.maybeDeleteLegacyPendingInfoLocked(syncDir);
        this.mAccountInfoFile = new AtomicFile(new File(syncDir, "accounts.xml"));
        this.mStatusFile = new AtomicFile(new File(syncDir, "status.bin"));
        this.mPendingFile = new AtomicFile(new File(syncDir, "pending.xml"));
        this.mStatisticsFile = new AtomicFile(new File(syncDir, "stats.bin"));
        this.readAccountInfoLocked();
        this.readStatusLocked();
        this.readPendingOperationsLocked();
        this.readStatisticsLocked();
        this.readAndDeleteLegacyAccountInfoLocked();
        this.writeAccountInfoLocked();
        this.writeStatusLocked();
        this.writePendingOperationsLocked();
        this.writeStatisticsLocked();
    }

    public static SyncStorageEngine newTestInstance(Context context) {
        return new SyncStorageEngine(context, context.getFilesDir());
    }

    public static void init(Context context) {
        if (sSyncStorageEngine != null) {
            return;
        }
        File dataDir = Environment.getSecureDataDirectory();
        sSyncStorageEngine = new SyncStorageEngine(context, dataDir);
    }

    public static SyncStorageEngine getSingleton() {
        if (sSyncStorageEngine == null) {
            throw new IllegalStateException("not initialized");
        }
        return sSyncStorageEngine;
    }

    protected void setOnSyncRequestListener(OnSyncRequestListener listener) {
        if (this.mSyncRequestListener == null) {
            this.mSyncRequestListener = listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(Message msg) {
        if (msg.what == 1) {
            SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
            synchronized (sparseArray) {
                this.writeStatusLocked();
            }
        }
        if (msg.what == 2) {
            SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
            synchronized (sparseArray) {
                this.writeStatisticsLocked();
            }
        }
    }

    public int getSyncRandomOffset() {
        return this.mSyncRandomOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatusChangeListener(int mask, ISyncStatusObserver callback) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            this.mChangeListeners.register(callback, mask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStatusChangeListener(ISyncStatusObserver callback) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            this.mChangeListeners.unregister(callback);
        }
    }

    public static long calculateDefaultFlexTime(long syncTimeSeconds) {
        if (syncTimeSeconds < 5L) {
            return 0L;
        }
        if (syncTimeSeconds < 86400L) {
            return (long)((double)syncTimeSeconds * 0.04);
        }
        return 3456L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportChange(int which) {
        ArrayList<ISyncStatusObserver> reports = null;
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            int i = this.mChangeListeners.beginBroadcast();
            while (i > 0) {
                Integer mask;
                if ((which & (mask = (Integer)this.mChangeListeners.getBroadcastCookie(--i))) == 0) continue;
                if (reports == null) {
                    reports = new ArrayList<ISyncStatusObserver>(i);
                }
                reports.add(this.mChangeListeners.getBroadcastItem(i));
            }
            this.mChangeListeners.finishBroadcast();
        }
        if (reports != null) {
            int i = reports.size();
            while (i > 0) {
                --i;
                try {
                    ((ISyncStatusObserver)reports.get(i)).onStatusChanged(which);
                }
                catch (RemoteException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getSyncAutomatically(Account account, int userId, String providerName) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            if (account != null) {
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl5 : MonitorExitStatement: MONITOREXIT : var4_4
                AuthorityInfo authority = this.getAuthorityLocked(account, userId, providerName, "getSyncAutomatically");
                return authority != null && authority.enabled;
            }
            int i = this.mAuthorities.size();
            while (i > 0) {
                AuthorityInfo authority = this.mAuthorities.valueAt(--i);
                if (!authority.authority.equals(providerName) || authority.userId != userId || !authority.enabled) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSyncAutomatically(Account account, int userId, String providerName, boolean sync) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            AuthorityInfo authority = this.getOrCreateAuthorityLocked(account, userId, providerName, -1, false);
            if (authority.enabled == sync) {
                return;
            }
            authority.enabled = sync;
            this.writeAccountInfoLocked();
        }
        if (sync) {
            this.requestSync(account, userId, -6, providerName, new Bundle());
        }
        this.reportChange(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIsSyncable(Account account, int userId, String providerName) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            if (account != null) {
                AuthorityInfo authority = this.getAuthorityLocked(account, userId, providerName, "getIsSyncable");
                if (authority == null) {
                    return -1;
                }
                return authority.syncable;
            }
            int i = this.mAuthorities.size();
            while (i > 0) {
                AuthorityInfo authority = this.mAuthorities.valueAt(--i);
                if (!authority.authority.equals(providerName)) continue;
                return authority.syncable;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIsSyncable(Account account, int userId, String providerName, int syncable) {
        if (syncable > 1) {
            syncable = 1;
        } else if (syncable < -1) {
            syncable = -1;
        }
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            AuthorityInfo authority = this.getOrCreateAuthorityLocked(account, userId, providerName, -1, false);
            if (authority.syncable == syncable) {
                return;
            }
            authority.syncable = syncable;
            this.writeAccountInfoLocked();
        }
        if (syncable > 0) {
            this.requestSync(account, userId, -5, providerName, new Bundle());
        }
        this.reportChange(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Long, Long> getBackoff(Account account, int userId, String providerName) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            AuthorityInfo authority = this.getAuthorityLocked(account, userId, providerName, "getBackoff");
            if (authority == null || authority.backoffTime < 0L) {
                return null;
            }
            return Pair.create(authority.backoffTime, authority.backoffDelay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBackoff(Account account, int userId, String providerName, long nextSyncTime, long nextDelay) {
        boolean changed = false;
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            if (account == null || providerName == null) {
                for (AccountInfo accountInfo : this.mAccounts.values()) {
                    if (account != null && !account.equals(accountInfo.accountAndUser.account) && userId != accountInfo.accountAndUser.userId) continue;
                    for (AuthorityInfo authorityInfo : accountInfo.authorities.values()) {
                        if (providerName != null && !providerName.equals(authorityInfo.authority) || authorityInfo.backoffTime == nextSyncTime && authorityInfo.backoffDelay == nextDelay) continue;
                        authorityInfo.backoffTime = nextSyncTime;
                        authorityInfo.backoffDelay = nextDelay;
                        changed = true;
                    }
                }
            } else {
                AuthorityInfo authority = this.getOrCreateAuthorityLocked(account, userId, providerName, -1, true);
                if (authority.backoffTime == nextSyncTime && authority.backoffDelay == nextDelay) {
                    return;
                }
                authority.backoffTime = nextSyncTime;
                authority.backoffDelay = nextDelay;
                changed = true;
            }
        }
        if (changed) {
            this.reportChange(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllBackoffsLocked(SyncQueue syncQueue) {
        boolean changed = false;
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            for (AccountInfo accountInfo : this.mAccounts.values()) {
                for (AuthorityInfo authorityInfo : accountInfo.authorities.values()) {
                    if (authorityInfo.backoffTime == -1L && authorityInfo.backoffDelay == -1L) continue;
                    authorityInfo.backoffTime = -1L;
                    authorityInfo.backoffDelay = -1L;
                    syncQueue.onBackoffChanged(accountInfo.accountAndUser.account, accountInfo.accountAndUser.userId, authorityInfo.authority, 0L);
                    changed = true;
                }
            }
        }
        if (changed) {
            this.reportChange(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDelayUntilTime(Account account, int userId, String providerName, long delayUntil) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            AuthorityInfo authority = this.getOrCreateAuthorityLocked(account, userId, providerName, -1, true);
            if (authority.delayUntil == delayUntil) {
                return;
            }
            authority.delayUntil = delayUntil;
        }
        this.reportChange(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDelayUntilTime(Account account, int userId, String providerName) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            AuthorityInfo authority = this.getAuthorityLocked(account, userId, providerName, "getDelayUntil");
            if (authority == null) {
                return 0L;
            }
            return authority.delayUntil;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateOrRemovePeriodicSync(PeriodicSync toUpdate, int userId, boolean add) {
        block16: {
            SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
            synchronized (sparseArray) {
                block15: {
                    if (toUpdate.period <= 0L && add) {
                        Log.e(TAG, "period < 0, should never happen in updateOrRemovePeriodicSync: add-" + add);
                    }
                    if (toUpdate.extras == null) {
                        Log.e(TAG, "null extras, should never happen in updateOrRemovePeriodicSync: add-" + add);
                    }
                    try {
                        AuthorityInfo authority = this.getOrCreateAuthorityLocked(toUpdate.account, userId, toUpdate.authority, -1, false);
                        if (add) {
                            boolean alreadyPresent = false;
                            int N = authority.periodicSyncs.size();
                            for (int i = 0; i < N; ++i) {
                                PeriodicSync syncInfo = authority.periodicSyncs.get(i);
                                if (!PeriodicSync.syncExtrasEquals(toUpdate.extras, syncInfo.extras)) continue;
                                if (toUpdate.period == syncInfo.period && toUpdate.flexTime == syncInfo.flexTime) {
                                    Object var12_15 = null;
                                    this.writeAccountInfoLocked();
                                    this.writeStatusLocked();
                                    return;
                                }
                                authority.periodicSyncs.set(i, new PeriodicSync(toUpdate));
                                alreadyPresent = true;
                                break;
                            }
                            if (!alreadyPresent) {
                                authority.periodicSyncs.add(new PeriodicSync(toUpdate));
                                SyncStatusInfo status = this.getOrCreateSyncStatusLocked(authority.ident);
                                status.setPeriodicSyncTime(authority.periodicSyncs.size() - 1, 0L);
                            }
                        } else {
                            SyncStatusInfo status = this.mSyncStatus.get(authority.ident);
                            boolean changed = false;
                            Iterator<PeriodicSync> iterator = authority.periodicSyncs.iterator();
                            int i = 0;
                            while (iterator.hasNext()) {
                                PeriodicSync syncInfo = iterator.next();
                                if (PeriodicSync.syncExtrasEquals(syncInfo.extras, toUpdate.extras)) {
                                    iterator.remove();
                                    changed = true;
                                    if (status != null) {
                                        status.removePeriodicSyncTime(i);
                                        continue;
                                    }
                                    Log.e(TAG, "Tried removing sync status on remove periodic sync butdid not find it.");
                                    continue;
                                }
                                ++i;
                            }
                            if (!changed) {
                                break block15;
                            }
                        }
                        Object var12_17 = null;
                        this.writeAccountInfoLocked();
                        this.writeStatusLocked();
                        break block16;
                    }
                    catch (Throwable throwable) {
                        Object var12_18 = null;
                        this.writeAccountInfoLocked();
                        this.writeStatusLocked();
                        throw throwable;
                    }
                }
                Object var12_16 = null;
                this.writeAccountInfoLocked();
                this.writeStatusLocked();
                return;
            }
        }
        this.reportChange(1);
    }

    public void addPeriodicSync(PeriodicSync toAdd, int userId) {
        this.updateOrRemovePeriodicSync(toAdd, userId, true);
    }

    public void removePeriodicSync(PeriodicSync toRemove, int userId) {
        this.updateOrRemovePeriodicSync(toRemove, userId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PeriodicSync> getPeriodicSyncs(Account account, int userId, String providerName) {
        ArrayList<PeriodicSync> syncs = new ArrayList<PeriodicSync>();
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            AuthorityInfo authority = this.getAuthorityLocked(account, userId, providerName, "getPeriodicSyncs");
            if (authority != null) {
                for (PeriodicSync item : authority.periodicSyncs) {
                    syncs.add(new PeriodicSync(item));
                }
            }
        }
        return syncs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMasterSyncAutomatically(boolean flag, int userId) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            Boolean auto = this.mMasterSyncAutomatically.get(userId);
            if (auto != null && auto == flag) {
                return;
            }
            this.mMasterSyncAutomatically.put(userId, flag);
            this.writeAccountInfoLocked();
        }
        if (flag) {
            this.requestSync(null, userId, -7, null, new Bundle());
        }
        this.reportChange(1);
        this.mContext.sendBroadcast(ContentResolver.ACTION_SYNC_CONN_STATUS_CHANGED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getMasterSyncAutomatically(int userId) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            Boolean auto = this.mMasterSyncAutomatically.get(userId);
            return auto == null ? this.mDefaultMasterSyncAutomatically : auto;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAuthority(Account account, int userId, String authority) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            this.removeAuthorityLocked(account, userId, authority, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthorityInfo getAuthority(int authorityId) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            return this.mAuthorities.get(authorityId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSyncActive(Account account, int userId, String authority) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            for (SyncInfo syncInfo : this.getCurrentSyncs(userId)) {
                AuthorityInfo ainfo = this.getAuthority(syncInfo.authorityId);
                if (ainfo == null || !ainfo.account.equals(account) || !ainfo.authority.equals(authority) || ainfo.userId != userId) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PendingOperation insertIntoPending(PendingOperation op) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            AuthorityInfo authority = this.getOrCreateAuthorityLocked(op.account, op.userId, op.authority, -1, true);
            if (authority == null) {
                return null;
            }
            op = new PendingOperation(op);
            op.authorityId = authority.ident;
            this.mPendingOperations.add(op);
            this.appendPendingOperationLocked(op);
            SyncStatusInfo status = this.getOrCreateSyncStatusLocked(authority.ident);
            status.pending = true;
        }
        this.reportChange(2);
        return op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteFromPending(PendingOperation op) {
        boolean res = false;
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            if (this.mPendingOperations.remove(op)) {
                if (this.mPendingOperations.size() == 0 || this.mNumPendingFinished >= 4) {
                    this.writePendingOperationsLocked();
                    this.mNumPendingFinished = 0;
                } else {
                    ++this.mNumPendingFinished;
                }
                AuthorityInfo authority = this.getAuthorityLocked(op.account, op.userId, op.authority, "deleteFromPending");
                if (authority != null) {
                    int N = this.mPendingOperations.size();
                    boolean morePending = false;
                    for (int i = 0; i < N; ++i) {
                        PendingOperation cur = this.mPendingOperations.get(i);
                        if (!cur.account.equals(op.account) || !cur.authority.equals(op.authority) || cur.userId != op.userId) continue;
                        morePending = true;
                        break;
                    }
                    if (!morePending) {
                        SyncStatusInfo status = this.getOrCreateSyncStatusLocked(authority.ident);
                        status.pending = false;
                    }
                }
                res = true;
            }
        }
        this.reportChange(2);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<PendingOperation> getPendingOperations() {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            return new ArrayList<PendingOperation>(this.mPendingOperations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPendingOperationCount() {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            return this.mPendingOperations.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDatabaseCleanup(Account[] accounts, int userId) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            SparseArray<AuthorityInfo> removing = new SparseArray<AuthorityInfo>();
            Iterator<AccountInfo> accIt = this.mAccounts.values().iterator();
            while (accIt.hasNext()) {
                AccountInfo acc = accIt.next();
                if (ArrayUtils.contains(accounts, acc.accountAndUser.account) || acc.accountAndUser.userId != userId) continue;
                for (AuthorityInfo auth : acc.authorities.values()) {
                    removing.put(auth.ident, auth);
                }
                accIt.remove();
            }
            int i = removing.size();
            if (i > 0) {
                while (i > 0) {
                    int ident = removing.keyAt(--i);
                    this.mAuthorities.remove(ident);
                    int j = this.mSyncStatus.size();
                    while (j > 0) {
                        if (this.mSyncStatus.keyAt(--j) != ident) continue;
                        this.mSyncStatus.remove(this.mSyncStatus.keyAt(j));
                    }
                    j = this.mSyncHistory.size();
                    while (j > 0) {
                        if (this.mSyncHistory.get((int)(--j)).authorityId != ident) continue;
                        this.mSyncHistory.remove(j);
                    }
                }
                this.writeAccountInfoLocked();
                this.writeStatusLocked();
                this.writePendingOperationsLocked();
                this.writeStatisticsLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyncInfo addActiveSync(SyncManager.ActiveSyncContext activeSyncContext) {
        SyncInfo syncInfo;
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            AuthorityInfo authority = this.getOrCreateAuthorityLocked(activeSyncContext.mSyncOperation.account, activeSyncContext.mSyncOperation.userId, activeSyncContext.mSyncOperation.authority, -1, true);
            syncInfo = new SyncInfo(authority.ident, authority.account, authority.authority, activeSyncContext.mStartTime);
            this.getCurrentSyncs(authority.userId).add(syncInfo);
        }
        this.reportActiveChange();
        return syncInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActiveSync(SyncInfo syncInfo, int userId) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            this.getCurrentSyncs(userId).remove(syncInfo);
        }
        this.reportActiveChange();
    }

    public void reportActiveChange() {
        this.reportChange(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long insertStartSyncEvent(Account accountName, int userId, int reason, String authorityName, long now, int source, boolean initialization, Bundle extras) {
        long id2;
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            AuthorityInfo authority = this.getAuthorityLocked(accountName, userId, authorityName, "insertStartSyncEvent");
            if (authority == null) {
                return -1L;
            }
            SyncHistoryItem item = new SyncHistoryItem();
            item.initialization = initialization;
            item.authorityId = authority.ident;
            item.historyId = this.mNextHistoryId++;
            if (this.mNextHistoryId < 0) {
                this.mNextHistoryId = 0;
            }
            item.eventTime = now;
            item.source = source;
            item.reason = reason;
            item.extras = extras;
            item.event = 0;
            this.mSyncHistory.add(0, item);
            while (this.mSyncHistory.size() > 100) {
                this.mSyncHistory.remove(this.mSyncHistory.size() - 1);
            }
            id2 = item.historyId;
        }
        this.reportChange(8);
        return id2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopSyncEvent(long historyId, long elapsedTime, String resultMessage, long downstreamActivity, long upstreamActivity) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            SyncHistoryItem item = null;
            int i = this.mSyncHistory.size();
            while (i > 0) {
                item = this.mSyncHistory.get(--i);
                if ((long)item.historyId == historyId) break;
                item = null;
            }
            if (item == null) {
                Log.w(TAG, "stopSyncEvent: no history for id " + historyId);
                return;
            }
            item.elapsedTime = elapsedTime;
            item.event = 1;
            item.mesg = resultMessage;
            item.downstreamActivity = downstreamActivity;
            item.upstreamActivity = upstreamActivity;
            SyncStatusInfo status = this.getOrCreateSyncStatusLocked(item.authorityId);
            ++status.numSyncs;
            status.totalElapsedTime += elapsedTime;
            switch (item.source) {
                case 1: {
                    ++status.numSourceLocal;
                    break;
                }
                case 2: {
                    ++status.numSourcePoll;
                    break;
                }
                case 3: {
                    ++status.numSourceUser;
                    break;
                }
                case 0: {
                    ++status.numSourceServer;
                    break;
                }
                case 4: {
                    ++status.numSourcePeriodic;
                }
            }
            boolean writeStatisticsNow = false;
            int day = this.getCurrentDayLocked();
            if (this.mDayStats[0] == null) {
                this.mDayStats[0] = new DayStats(day);
            } else if (day != this.mDayStats[0].day) {
                System.arraycopy(this.mDayStats, 0, this.mDayStats, 1, this.mDayStats.length - 1);
                this.mDayStats[0] = new DayStats(day);
                writeStatisticsNow = true;
            } else if (this.mDayStats[0] == null) {
                // empty if block
            }
            DayStats ds = this.mDayStats[0];
            long lastSyncTime = item.eventTime + elapsedTime;
            boolean writeStatusNow = false;
            if (MESG_SUCCESS.equals(resultMessage)) {
                if (status.lastSuccessTime == 0L || status.lastFailureTime != 0L) {
                    writeStatusNow = true;
                }
                status.lastSuccessTime = lastSyncTime;
                status.lastSuccessSource = item.source;
                status.lastFailureTime = 0L;
                status.lastFailureSource = -1;
                status.lastFailureMesg = null;
                status.initialFailureTime = 0L;
                ++ds.successCount;
                ds.successTime += elapsedTime;
            } else if (!MESG_CANCELED.equals(resultMessage)) {
                if (status.lastFailureTime == 0L) {
                    writeStatusNow = true;
                }
                status.lastFailureTime = lastSyncTime;
                status.lastFailureSource = item.source;
                status.lastFailureMesg = resultMessage;
                if (status.initialFailureTime == 0L) {
                    status.initialFailureTime = lastSyncTime;
                }
                ++ds.failureCount;
                ds.failureTime += elapsedTime;
            }
            if (writeStatusNow) {
                this.writeStatusLocked();
            } else if (!this.hasMessages(1)) {
                this.sendMessageDelayed(this.obtainMessage(1), 600000L);
            }
            if (writeStatisticsNow) {
                this.writeStatisticsLocked();
            } else if (!this.hasMessages(2)) {
                this.sendMessageDelayed(this.obtainMessage(2), 1800000L);
            }
        }
        this.reportChange(8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SyncInfo> getCurrentSyncs(int userId) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            ArrayList<SyncInfo> syncs = this.mCurrentSyncs.get(userId);
            if (syncs == null) {
                syncs = new ArrayList();
                this.mCurrentSyncs.put(userId, syncs);
            }
            return syncs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<SyncStatusInfo> getSyncStatus() {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            int N = this.mSyncStatus.size();
            ArrayList<SyncStatusInfo> ops = new ArrayList<SyncStatusInfo>(N);
            for (int i = 0; i < N; ++i) {
                ops.add(this.mSyncStatus.valueAt(i));
            }
            return ops;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<AuthorityInfo, SyncStatusInfo> getCopyOfAuthorityWithSyncStatus(Account account, int userId, String authority) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            AuthorityInfo authorityInfo = this.getOrCreateAuthorityLocked(account, userId, authority, -1, true);
            return this.createCopyPairOfAuthorityWithSyncStatusLocked(authorityInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Pair<AuthorityInfo, SyncStatusInfo>> getCopyOfAllAuthoritiesWithSyncStatus() {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            ArrayList<Pair<AuthorityInfo, SyncStatusInfo>> infos = new ArrayList<Pair<AuthorityInfo, SyncStatusInfo>>(this.mAuthorities.size());
            for (int i = 0; i < this.mAuthorities.size(); ++i) {
                infos.add(this.createCopyPairOfAuthorityWithSyncStatusLocked(this.mAuthorities.valueAt(i)));
            }
            return infos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyncStatusInfo getStatusByAccountAndAuthority(Account account, int userId, String authority) {
        if (account == null || authority == null) {
            return null;
        }
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            int N = this.mSyncStatus.size();
            for (int i = 0; i < N; ++i) {
                SyncStatusInfo cur = this.mSyncStatus.valueAt(i);
                AuthorityInfo ainfo = this.mAuthorities.get(cur.authorityId);
                if (ainfo == null || !ainfo.authority.equals(authority) || ainfo.userId != userId || !account.equals(ainfo.account)) continue;
                return cur;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSyncPending(Account account, int userId, String authority) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            int N = this.mSyncStatus.size();
            for (int i = 0; i < N; ++i) {
                SyncStatusInfo cur = this.mSyncStatus.valueAt(i);
                AuthorityInfo ainfo = this.mAuthorities.get(cur.authorityId);
                if (ainfo == null || userId != ainfo.userId || account != null && !ainfo.account.equals(account) || !ainfo.authority.equals(authority) || !cur.pending) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<SyncHistoryItem> getSyncHistory() {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            int N = this.mSyncHistory.size();
            ArrayList<SyncHistoryItem> items = new ArrayList<SyncHistoryItem>(N);
            for (int i = 0; i < N; ++i) {
                items.add(this.mSyncHistory.get(i));
            }
            return items;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DayStats[] getDayStatistics() {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            DayStats[] ds = new DayStats[this.mDayStats.length];
            System.arraycopy(this.mDayStats, 0, ds, 0, ds.length);
            return ds;
        }
    }

    private Pair<AuthorityInfo, SyncStatusInfo> createCopyPairOfAuthorityWithSyncStatusLocked(AuthorityInfo authorityInfo) {
        SyncStatusInfo syncStatusInfo = this.getOrCreateSyncStatusLocked(authorityInfo.ident);
        return Pair.create(new AuthorityInfo(authorityInfo), new SyncStatusInfo(syncStatusInfo));
    }

    private int getCurrentDayLocked() {
        this.mCal.setTimeInMillis(System.currentTimeMillis());
        int dayOfYear = this.mCal.get(6);
        if (this.mYear != this.mCal.get(1)) {
            this.mYear = this.mCal.get(1);
            this.mCal.clear();
            this.mCal.set(1, this.mYear);
            this.mYearInDays = (int)(this.mCal.getTimeInMillis() / 86400000L);
        }
        return dayOfYear + this.mYearInDays;
    }

    private AuthorityInfo getAuthorityLocked(Account accountName, int userId, String authorityName, String tag) {
        AccountAndUser au = new AccountAndUser(accountName, userId);
        AccountInfo accountInfo = this.mAccounts.get(au);
        if (accountInfo == null) {
            if (tag != null) {
                // empty if block
            }
            return null;
        }
        AuthorityInfo authority = accountInfo.authorities.get(authorityName);
        if (authority == null) {
            if (tag != null) {
                // empty if block
            }
            return null;
        }
        return authority;
    }

    private AuthorityInfo getAuthorityLocked(ComponentName service, int userId, String tag) {
        AuthorityInfo authority = this.mServices.get(service).get(userId);
        if (authority == null) {
            if (tag != null) {
                // empty if block
            }
            return null;
        }
        return authority;
    }

    private AuthorityInfo getOrCreateAuthorityLocked(ComponentName cname, int userId, int ident, boolean doWrite) {
        AuthorityInfo authority;
        SparseArray<AuthorityInfo> aInfo = this.mServices.get(cname);
        if (aInfo == null) {
            aInfo = new SparseArray();
            this.mServices.put(cname, aInfo);
        }
        if ((authority = aInfo.get(userId)) == null) {
            if (ident < 0) {
                ident = this.mNextAuthorityId++;
                doWrite = true;
            }
            authority = new AuthorityInfo(cname, userId, ident);
            aInfo.put(userId, authority);
            this.mAuthorities.put(ident, authority);
            if (doWrite) {
                this.writeAccountInfoLocked();
            }
        }
        return authority;
    }

    private AuthorityInfo getOrCreateAuthorityLocked(Account accountName, int userId, String authorityName, int ident, boolean doWrite) {
        AuthorityInfo authority;
        AccountAndUser au = new AccountAndUser(accountName, userId);
        AccountInfo account = this.mAccounts.get(au);
        if (account == null) {
            account = new AccountInfo(au);
            this.mAccounts.put(au, account);
        }
        if ((authority = account.authorities.get(authorityName)) == null) {
            if (ident < 0) {
                ident = this.mNextAuthorityId++;
                doWrite = true;
            }
            authority = new AuthorityInfo(accountName, userId, authorityName, ident);
            account.authorities.put(authorityName, authority);
            this.mAuthorities.put(ident, authority);
            if (doWrite) {
                this.writeAccountInfoLocked();
            }
        }
        return authority;
    }

    private void removeAuthorityLocked(Account account, int userId, String authorityName, boolean doWrite) {
        AuthorityInfo authorityInfo;
        AccountInfo accountInfo = this.mAccounts.get(new AccountAndUser(account, userId));
        if (accountInfo != null && (authorityInfo = accountInfo.authorities.remove(authorityName)) != null) {
            this.mAuthorities.remove(authorityInfo.ident);
            if (doWrite) {
                this.writeAccountInfoLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPeriodicSyncTime(int authorityId, PeriodicSync targetPeriodicSync, long when) {
        AuthorityInfo authorityInfo;
        boolean found = false;
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            authorityInfo = this.mAuthorities.get(authorityId);
            for (int i = 0; i < authorityInfo.periodicSyncs.size(); ++i) {
                PeriodicSync periodicSync = authorityInfo.periodicSyncs.get(i);
                if (!targetPeriodicSync.equals(periodicSync)) continue;
                this.mSyncStatus.get(authorityId).setPeriodicSyncTime(i, when);
                found = true;
                break;
            }
        }
        if (!found) {
            Log.w(TAG, "Ignoring setPeriodicSyncTime request for a sync that does not exist. Authority: " + authorityInfo.authority);
        }
    }

    private SyncStatusInfo getOrCreateSyncStatusLocked(int authorityId) {
        SyncStatusInfo status = this.mSyncStatus.get(authorityId);
        if (status == null) {
            status = new SyncStatusInfo(authorityId);
            this.mSyncStatus.put(authorityId, status);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAllState() {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            if (this.mNumPendingFinished > 0) {
                this.writePendingOperationsLocked();
            }
            this.writeStatusLocked();
            this.writeStatisticsLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAndReadState() {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            this.mAuthorities.clear();
            this.mAccounts.clear();
            this.mServices.clear();
            this.mPendingOperations.clear();
            this.mSyncStatus.clear();
            this.mSyncHistory.clear();
            this.readAccountInfoLocked();
            this.readStatusLocked();
            this.readPendingOperationsLocked();
            this.readStatisticsLocked();
            this.readAndDeleteLegacyAccountInfoLocked();
            this.writeAccountInfoLocked();
            this.writeStatusLocked();
            this.writePendingOperationsLocked();
            this.writeStatisticsLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void readAccountInfoLocked() {
        block32: {
            int highestAuthorityId = -1;
            FileInputStream fis = null;
            try {
                block29: {
                    int version;
                    fis = this.mAccountInfoFile.openRead();
                    if (Log.isLoggable(TAG_FILE, 2)) {
                        Log.v(TAG, "Reading " + this.mAccountInfoFile.getBaseFile());
                    }
                    XmlPullParser parser = Xml.newPullParser();
                    parser.setInput(fis, null);
                    int eventType = parser.getEventType();
                    while (eventType != 2) {
                        eventType = parser.next();
                    }
                    String tagName = parser.getName();
                    if (!"accounts".equals(tagName)) break block29;
                    String listen = parser.getAttributeValue(null, XML_ATTR_LISTEN_FOR_TICKLES);
                    String versionString = parser.getAttributeValue(null, XML_ATTR_VERSION);
                    try {
                        version = versionString == null ? 0 : Integer.parseInt(versionString);
                    }
                    catch (NumberFormatException e) {
                        version = 0;
                    }
                    String nextIdString = parser.getAttributeValue(null, XML_ATTR_NEXT_AUTHORITY_ID);
                    try {
                        int id2 = nextIdString == null ? 0 : Integer.parseInt(nextIdString);
                        this.mNextAuthorityId = Math.max(this.mNextAuthorityId, id2);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    String offsetString = parser.getAttributeValue(null, XML_ATTR_SYNC_RANDOM_OFFSET);
                    try {
                        this.mSyncRandomOffset = offsetString == null ? 0 : Integer.parseInt(offsetString);
                    }
                    catch (NumberFormatException e) {
                        this.mSyncRandomOffset = 0;
                    }
                    if (this.mSyncRandomOffset == 0) {
                        Random random = new Random(System.currentTimeMillis());
                        this.mSyncRandomOffset = random.nextInt(86400);
                    }
                    this.mMasterSyncAutomatically.put(0, listen == null || Boolean.parseBoolean(listen));
                    eventType = parser.next();
                    AuthorityInfo authority = null;
                    PeriodicSync periodicSync = null;
                    do {
                        if (eventType != 2) continue;
                        tagName = parser.getName();
                        if (parser.getDepth() == 2) {
                            if ("authority".equals(tagName)) {
                                authority = this.parseAuthority(parser, version);
                                periodicSync = null;
                                if (authority.ident <= highestAuthorityId) continue;
                                highestAuthorityId = authority.ident;
                                continue;
                            }
                            if (!XML_TAG_LISTEN_FOR_TICKLES.equals(tagName)) continue;
                            this.parseListenForTickles(parser);
                            continue;
                        }
                        if (parser.getDepth() == 3) {
                            if (!"periodicSync".equals(tagName) || authority == null) continue;
                            periodicSync = this.parsePeriodicSync(parser, authority);
                            continue;
                        }
                        if (parser.getDepth() != 4 || periodicSync == null || !"extra".equals(tagName)) continue;
                        this.parseExtra(parser, periodicSync.extras);
                    } while ((eventType = parser.next()) != 1);
                }
                Object var14_19 = null;
            }
            catch (Throwable throwable) {
                Object var14_22 = null;
                this.mNextAuthorityId = Math.max(highestAuthorityId + 1, this.mNextAuthorityId);
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e1) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            this.mNextAuthorityId = Math.max(highestAuthorityId + 1, this.mNextAuthorityId);
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e1) {}
            }
            break block32;
            {
                catch (XmlPullParserException e) {
                    Log.w(TAG, "Error reading accounts", e);
                    Object var14_20 = null;
                    this.mNextAuthorityId = Math.max(highestAuthorityId + 1, this.mNextAuthorityId);
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException e1) {
                            // empty catch block
                        }
                    }
                    return;
                }
                catch (IOException e) {
                    if (fis == null) {
                        Log.i(TAG, "No initial accounts");
                    } else {
                        Log.w(TAG, "Error reading accounts", e);
                    }
                    Object var14_21 = null;
                    this.mNextAuthorityId = Math.max(highestAuthorityId + 1, this.mNextAuthorityId);
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException e1) {
                            // empty catch block
                        }
                    }
                    return;
                }
            }
        }
        this.maybeMigrateSettingsForRenamedAuthorities();
    }

    private void maybeDeleteLegacyPendingInfoLocked(File syncDir) {
        File file = new File(syncDir, "pending.bin");
        if (!file.exists()) {
            return;
        }
        file.delete();
    }

    private boolean maybeMigrateSettingsForRenamedAuthorities() {
        boolean writeNeeded = false;
        ArrayList<AuthorityInfo> authoritiesToRemove = new ArrayList<AuthorityInfo>();
        int N = this.mAuthorities.size();
        for (int i = 0; i < N; ++i) {
            AuthorityInfo authority = this.mAuthorities.valueAt(i);
            String newAuthorityName = sAuthorityRenames.get(authority.authority);
            if (newAuthorityName == null) continue;
            authoritiesToRemove.add(authority);
            if (!authority.enabled || this.getAuthorityLocked(authority.account, authority.userId, newAuthorityName, "cleanup") != null) continue;
            AuthorityInfo newAuthority = this.getOrCreateAuthorityLocked(authority.account, authority.userId, newAuthorityName, -1, false);
            newAuthority.enabled = true;
            writeNeeded = true;
        }
        for (AuthorityInfo authorityInfo : authoritiesToRemove) {
            this.removeAuthorityLocked(authorityInfo.account, authorityInfo.userId, authorityInfo.authority, false);
            writeNeeded = true;
        }
        return writeNeeded;
    }

    private void parseListenForTickles(XmlPullParser parser) {
        String user = parser.getAttributeValue(null, XML_ATTR_USER);
        int userId = 0;
        try {
            userId = Integer.parseInt(user);
        }
        catch (NumberFormatException e) {
            Log.e(TAG, "error parsing the user for listen-for-tickles", e);
        }
        catch (NullPointerException e) {
            Log.e(TAG, "the user in listen-for-tickles is null", e);
        }
        String enabled = parser.getAttributeValue(null, XML_ATTR_ENABLED);
        boolean listen = enabled == null || Boolean.parseBoolean(enabled);
        this.mMasterSyncAutomatically.put(userId, listen);
    }

    private AuthorityInfo parseAuthority(XmlPullParser parser, int version) {
        AuthorityInfo authority = null;
        int id2 = -1;
        try {
            id2 = Integer.parseInt(parser.getAttributeValue(null, "id"));
        }
        catch (NumberFormatException e) {
            Log.e(TAG, "error parsing the id of the authority", e);
        }
        catch (NullPointerException e) {
            Log.e(TAG, "the id of the authority is null", e);
        }
        if (id2 >= 0) {
            int userId;
            String authorityName = parser.getAttributeValue(null, "authority");
            String enabled = parser.getAttributeValue(null, XML_ATTR_ENABLED);
            String syncable = parser.getAttributeValue(null, "syncable");
            String accountName = parser.getAttributeValue(null, "account");
            String accountType = parser.getAttributeValue(null, "type");
            String user = parser.getAttributeValue(null, XML_ATTR_USER);
            String packageName = parser.getAttributeValue(null, "package");
            String className = parser.getAttributeValue(null, "class");
            int n = userId = user == null ? 0 : Integer.parseInt(user);
            if (accountType == null) {
                accountType = "com.google";
                syncable = "unknown";
            }
            authority = this.mAuthorities.get(id2);
            if (Log.isLoggable(TAG_FILE, 2)) {
                Log.v(TAG, "Adding authority: account=" + accountName + " auth=" + authorityName + " user=" + userId + " enabled=" + enabled + " syncable=" + syncable);
            }
            if (authority == null) {
                if (Log.isLoggable(TAG_FILE, 2)) {
                    Log.v(TAG, "Creating entry");
                }
                authority = accountName != null && accountType != null ? this.getOrCreateAuthorityLocked(new Account(accountName, accountType), userId, authorityName, id2, false) : this.getOrCreateAuthorityLocked(new ComponentName(packageName, className), userId, id2, false);
                if (version > 0) {
                    authority.periodicSyncs.clear();
                }
            }
            if (authority != null) {
                boolean bl = authority.enabled = enabled == null || Boolean.parseBoolean(enabled);
                authority.syncable = "unknown".equals(syncable) ? -1 : (syncable == null || Boolean.parseBoolean(syncable) ? 1 : 0);
            } else {
                Log.w(TAG, "Failure adding authority: account=" + accountName + " auth=" + authorityName + " enabled=" + enabled + " syncable=" + syncable);
            }
        }
        return authority;
    }

    private PeriodicSync parsePeriodicSync(XmlPullParser parser, AuthorityInfo authority) {
        long flextime;
        long period;
        Bundle extras = new Bundle();
        String periodValue = parser.getAttributeValue(null, "period");
        String flexValue = parser.getAttributeValue(null, "flex");
        try {
            period = Long.parseLong(periodValue);
        }
        catch (NumberFormatException e) {
            Log.e(TAG, "error parsing the period of a periodic sync", e);
            return null;
        }
        catch (NullPointerException e) {
            Log.e(TAG, "the period of a periodic sync is null", e);
            return null;
        }
        try {
            flextime = Long.parseLong(flexValue);
        }
        catch (NumberFormatException e) {
            Log.e(TAG, "Error formatting value parsed for periodic sync flex: " + flexValue);
            flextime = SyncStorageEngine.calculateDefaultFlexTime(period);
        }
        catch (NullPointerException expected) {
            flextime = SyncStorageEngine.calculateDefaultFlexTime(period);
            Log.d(TAG, "No flex time specified for this sync, using a default. period: " + period + " flex: " + flextime);
        }
        PeriodicSync periodicSync = new PeriodicSync(authority.account, authority.authority, extras, period, flextime);
        authority.periodicSyncs.add(periodicSync);
        return periodicSync;
    }

    private void parseExtra(XmlPullParser parser, Bundle extras) {
        String name = parser.getAttributeValue(null, "name");
        String type = parser.getAttributeValue(null, "type");
        String value1 = parser.getAttributeValue(null, "value1");
        String value2 = parser.getAttributeValue(null, "value2");
        try {
            if ("long".equals(type)) {
                extras.putLong(name, Long.parseLong(value1));
            } else if ("integer".equals(type)) {
                extras.putInt(name, Integer.parseInt(value1));
            } else if ("double".equals(type)) {
                extras.putDouble(name, Double.parseDouble(value1));
            } else if ("float".equals(type)) {
                extras.putFloat(name, Float.parseFloat(value1));
            } else if ("boolean".equals(type)) {
                extras.putBoolean(name, Boolean.parseBoolean(value1));
            } else if ("string".equals(type)) {
                extras.putString(name, value1);
            } else if ("account".equals(type)) {
                extras.putParcelable(name, new Account(value1, value2));
            }
        }
        catch (NumberFormatException e) {
            Log.e(TAG, "error parsing bundle value", e);
        }
        catch (NullPointerException e) {
            Log.e(TAG, "error parsing bundle value", e);
        }
    }

    private void writeAccountInfoLocked() {
        block10: {
            if (Log.isLoggable(TAG_FILE, 2)) {
                Log.v(TAG, "Writing new " + this.mAccountInfoFile.getBaseFile());
            }
            FileOutputStream fos = null;
            try {
                fos = this.mAccountInfoFile.startWrite();
                FastXmlSerializer out = new FastXmlSerializer();
                out.setOutput(fos, "utf-8");
                out.startDocument(null, true);
                out.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
                out.startTag(null, "accounts");
                out.attribute(null, XML_ATTR_VERSION, Integer.toString(2));
                out.attribute(null, XML_ATTR_NEXT_AUTHORITY_ID, Integer.toString(this.mNextAuthorityId));
                out.attribute(null, XML_ATTR_SYNC_RANDOM_OFFSET, Integer.toString(this.mSyncRandomOffset));
                int M = this.mMasterSyncAutomatically.size();
                for (int m = 0; m < M; ++m) {
                    int userId = this.mMasterSyncAutomatically.keyAt(m);
                    Boolean listen = this.mMasterSyncAutomatically.valueAt(m);
                    out.startTag(null, XML_TAG_LISTEN_FOR_TICKLES);
                    out.attribute(null, XML_ATTR_USER, Integer.toString(userId));
                    out.attribute(null, XML_ATTR_ENABLED, Boolean.toString(listen));
                    out.endTag(null, XML_TAG_LISTEN_FOR_TICKLES);
                }
                int N = this.mAuthorities.size();
                for (int i = 0; i < N; ++i) {
                    AuthorityInfo authority = this.mAuthorities.valueAt(i);
                    out.startTag(null, "authority");
                    out.attribute(null, "id", Integer.toString(authority.ident));
                    out.attribute(null, XML_ATTR_USER, Integer.toString(authority.userId));
                    out.attribute(null, XML_ATTR_ENABLED, Boolean.toString(authority.enabled));
                    if (authority.service == null) {
                        out.attribute(null, "account", authority.account.name);
                        out.attribute(null, "type", authority.account.type);
                        out.attribute(null, "authority", authority.authority);
                    } else {
                        out.attribute(null, "package", authority.service.getPackageName());
                        out.attribute(null, "class", authority.service.getClassName());
                    }
                    if (authority.syncable < 0) {
                        out.attribute(null, "syncable", "unknown");
                    } else {
                        out.attribute(null, "syncable", Boolean.toString(authority.syncable != 0));
                    }
                    for (PeriodicSync periodicSync : authority.periodicSyncs) {
                        out.startTag(null, "periodicSync");
                        out.attribute(null, "period", Long.toString(periodicSync.period));
                        out.attribute(null, "flex", Long.toString(periodicSync.flexTime));
                        Bundle extras = periodicSync.extras;
                        this.extrasToXml(out, extras);
                        out.endTag(null, "periodicSync");
                    }
                    out.endTag(null, "authority");
                }
                out.endTag(null, "accounts");
                out.endDocument();
                this.mAccountInfoFile.finishWrite(fos);
            }
            catch (IOException e1) {
                Log.w(TAG, "Error writing accounts", e1);
                if (fos == null) break block10;
                this.mAccountInfoFile.failWrite(fos);
            }
        }
    }

    static int getIntColumn(Cursor c, String name) {
        return c.getInt(c.getColumnIndex(name));
    }

    static long getLongColumn(Cursor c, String name) {
        return c.getLong(c.getColumnIndex(name));
    }

    private void readAndDeleteLegacyAccountInfoLocked() {
        File file = this.mContext.getDatabasePath("syncmanager.db");
        if (!file.exists()) {
            return;
        }
        String path = file.getPath();
        SQLiteDatabase db = null;
        try {
            db = SQLiteDatabase.openDatabase(path, null, 1);
        }
        catch (SQLiteException e) {
            // empty catch block
        }
        if (db != null) {
            boolean hasType;
            boolean bl = hasType = db.getVersion() >= 11;
            if (Log.isLoggable(TAG_FILE, 2)) {
                Log.v(TAG, "Reading legacy sync accounts db");
            }
            SQLiteQueryBuilder qb = new SQLiteQueryBuilder();
            qb.setTables("stats, status");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("_id", "status._id as _id");
            map.put("account", "stats.account as account");
            if (hasType) {
                map.put("account_type", "stats.account_type as account_type");
            }
            map.put("authority", "stats.authority as authority");
            map.put("totalElapsedTime", "totalElapsedTime");
            map.put("numSyncs", "numSyncs");
            map.put("numSourceLocal", "numSourceLocal");
            map.put("numSourcePoll", "numSourcePoll");
            map.put("numSourceServer", "numSourceServer");
            map.put("numSourceUser", "numSourceUser");
            map.put("lastSuccessSource", "lastSuccessSource");
            map.put("lastSuccessTime", "lastSuccessTime");
            map.put("lastFailureSource", "lastFailureSource");
            map.put("lastFailureTime", "lastFailureTime");
            map.put("lastFailureMesg", "lastFailureMesg");
            map.put("pending", "pending");
            qb.setProjectionMap(map);
            qb.appendWhere("stats._id = status.stats_id");
            Cursor c = qb.query(db, null, null, null, null, null, null);
            while (c.moveToNext()) {
                String authorityName;
                AuthorityInfo authority;
                String accountType;
                String accountName = c.getString(c.getColumnIndex("account"));
                String string2 = accountType = hasType ? c.getString(c.getColumnIndex("account_type")) : null;
                if (accountType == null) {
                    accountType = "com.google";
                }
                if ((authority = this.getOrCreateAuthorityLocked(new Account(accountName, accountType), 0, authorityName = c.getString(c.getColumnIndex("authority")), -1, false)) == null) continue;
                int i = this.mSyncStatus.size();
                boolean found = false;
                SyncStatusInfo st = null;
                while (i > 0) {
                    st = this.mSyncStatus.valueAt(--i);
                    if (st.authorityId != authority.ident) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    st = new SyncStatusInfo(authority.ident);
                    this.mSyncStatus.put(authority.ident, st);
                }
                st.totalElapsedTime = SyncStorageEngine.getLongColumn(c, "totalElapsedTime");
                st.numSyncs = SyncStorageEngine.getIntColumn(c, "numSyncs");
                st.numSourceLocal = SyncStorageEngine.getIntColumn(c, "numSourceLocal");
                st.numSourcePoll = SyncStorageEngine.getIntColumn(c, "numSourcePoll");
                st.numSourceServer = SyncStorageEngine.getIntColumn(c, "numSourceServer");
                st.numSourceUser = SyncStorageEngine.getIntColumn(c, "numSourceUser");
                st.numSourcePeriodic = 0;
                st.lastSuccessSource = SyncStorageEngine.getIntColumn(c, "lastSuccessSource");
                st.lastSuccessTime = SyncStorageEngine.getLongColumn(c, "lastSuccessTime");
                st.lastFailureSource = SyncStorageEngine.getIntColumn(c, "lastFailureSource");
                st.lastFailureTime = SyncStorageEngine.getLongColumn(c, "lastFailureTime");
                st.lastFailureMesg = c.getString(c.getColumnIndex("lastFailureMesg"));
                st.pending = SyncStorageEngine.getIntColumn(c, "pending") != 0;
            }
            c.close();
            qb = new SQLiteQueryBuilder();
            qb.setTables("settings");
            c = qb.query(db, null, null, null, null, null, null);
            while (c.moveToNext()) {
                String name = c.getString(c.getColumnIndex("name"));
                String value = c.getString(c.getColumnIndex("value"));
                if (name == null) continue;
                if (name.equals("listen_for_tickles")) {
                    this.setMasterSyncAutomatically(value == null || Boolean.parseBoolean(value), 0);
                    continue;
                }
                if (!name.startsWith("sync_provider_")) continue;
                String provider = name.substring("sync_provider_".length(), name.length());
                int i = this.mAuthorities.size();
                while (i > 0) {
                    AuthorityInfo authority = this.mAuthorities.valueAt(--i);
                    if (!authority.authority.equals(provider)) continue;
                    authority.enabled = value == null || Boolean.parseBoolean(value);
                    authority.syncable = 1;
                }
            }
            c.close();
            db.close();
            new File(path).delete();
        }
    }

    private void readStatusLocked() {
        if (Log.isLoggable(TAG_FILE, 2)) {
            Log.v(TAG, "Reading " + this.mStatusFile.getBaseFile());
        }
        try {
            int token;
            byte[] data = this.mStatusFile.readFully();
            Parcel in = Parcel.obtain();
            in.unmarshall(data, 0, data.length);
            in.setDataPosition(0);
            while ((token = in.readInt()) != 0) {
                if (token == 100) {
                    SyncStatusInfo status = new SyncStatusInfo(in);
                    if (this.mAuthorities.indexOfKey(status.authorityId) < 0) continue;
                    status.pending = false;
                    if (Log.isLoggable(TAG_FILE, 2)) {
                        Log.v(TAG, "Adding status for id " + status.authorityId);
                    }
                    this.mSyncStatus.put(status.authorityId, status);
                    continue;
                }
                Log.w(TAG, "Unknown status token: " + token);
                break;
            }
        }
        catch (IOException e) {
            Log.i(TAG, "No initial status");
        }
    }

    private void writeStatusLocked() {
        block4: {
            if (Log.isLoggable(TAG_FILE, 2)) {
                Log.v(TAG, "Writing new " + this.mStatusFile.getBaseFile());
            }
            this.removeMessages(1);
            FileOutputStream fos = null;
            try {
                fos = this.mStatusFile.startWrite();
                Parcel out = Parcel.obtain();
                int N = this.mSyncStatus.size();
                for (int i = 0; i < N; ++i) {
                    SyncStatusInfo status = this.mSyncStatus.valueAt(i);
                    out.writeInt(100);
                    status.writeToParcel(out, 0);
                }
                out.writeInt(0);
                fos.write(out.marshall());
                out.recycle();
                this.mStatusFile.finishWrite(fos);
            }
            catch (IOException e1) {
                Log.w(TAG, "Error writing status", e1);
                if (fos == null) break block4;
                this.mStatusFile.failWrite(fos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readPendingOperationsLocked() {
        block24: {
            block23: {
                fis = null;
                if (!this.mPendingFile.getBaseFile().exists() && Log.isLoggable("SyncManagerFile", 2)) {
                    Log.v("SyncManagerFile", "No pending operation file.");
                    return;
                }
                try {
                    try {
                        fis = this.mPendingFile.openRead();
                        parser = Xml.newPullParser();
                        parser.setInput(fis, null);
                        eventType = parser.getEventType();
                        while (eventType != 2 && eventType != 1) {
                            eventType = parser.next();
                        }
                        if (eventType == 1) {
                            var13_6 = null;
                            if (fis == null) return;
                            break block23;
                        }
                        tagName = parser.getName();
                        do {
                            pop = null;
                            if (eventType != 2) continue;
                            try {
                                tagName = parser.getName();
                                if (parser.getDepth() == 1 && "op".equals(tagName)) {
                                    versionString = parser.getAttributeValue(null, "version");
                                    if (versionString == null || Integer.parseInt(versionString) != 3) {
                                        Log.w("SyncManager", "Unknown pending operation version " + versionString);
                                        throw new IOException("Unknown version.");
                                    }
                                    authorityId = Integer.valueOf(parser.getAttributeValue(null, "authority_id"));
                                    expedited = Boolean.valueOf(parser.getAttributeValue(null, "expedited"));
                                    syncSource = Integer.valueOf(parser.getAttributeValue(null, "source"));
                                    reason = Integer.valueOf(parser.getAttributeValue(null, "reason"));
                                    authority = this.mAuthorities.get(authorityId);
                                    if (Log.isLoggable("SyncManagerFile", 2)) {
                                        Log.v("SyncManagerFile", authorityId + " " + expedited + " " + syncSource + " " + reason);
                                    }
                                    if (authority != null) {
                                        pop = new PendingOperation(authority.account, authority.userId, reason, syncSource, authority.authority, new Bundle(), expedited);
                                        pop.flatExtras = null;
                                        this.mPendingOperations.add(pop);
                                        if (!Log.isLoggable("SyncManagerFile", 2)) continue;
                                        Log.v("SyncManagerFile", "Adding pending op: " + pop.authority + " src=" + pop.syncSource + " reason=" + pop.reason + " expedited=" + pop.expedited);
                                        continue;
                                    }
                                    pop = null;
                                    if (!Log.isLoggable("SyncManagerFile", 2)) continue;
                                    Log.v("SyncManagerFile", "No authority found for " + authorityId + ", skipping");
                                    continue;
                                }
                                if (parser.getDepth() != 2 || pop == null || !"extra".equals(tagName)) continue;
                                this.parseExtra(parser, pop.extras);
                            }
                            catch (NumberFormatException e) {
                                Log.d("SyncManager", "Invalid data in xml file.", e);
                            }
                        } while ((eventType = parser.next()) != 1);
                        break block24;
                    }
                    catch (IOException e) {
                        Log.w("SyncManagerFile", "Error reading pending data.", e);
                        var13_8 = null;
                        if (fis == null) return;
                        try {
                            fis.close();
                            return;
                        }
                        catch (IOException e1) {
                            return;
                        }
                    }
                    catch (XmlPullParserException e) {
                        if (Log.isLoggable("SyncManagerFile", 2)) {
                            Log.w("SyncManagerFile", "Error parsing pending ops xml.", e);
                        }
                        var13_9 = null;
                        if (fis == null) return;
                        try {}
                        catch (IOException e1) {
                            return;
                        }
                        fis.close();
                        return;
                    }
                }
                catch (Throwable var12_25) {
                    var13_10 = null;
                    if (fis == null) throw var12_25;
                    ** try [egrp 3[TRYBLOCK] [10 : 676->683)] { 
lbl90:
                    // 1 sources

                    fis.close();
                    throw var12_25;
lbl92:
                    // 1 sources

                    catch (IOException e1) {
                        // empty catch block
                    }
                    throw var12_25;
                }
            }
            ** try [egrp 3[TRYBLOCK] [10 : 676->683)] { 
lbl97:
            // 1 sources

            fis.close();
            return;
lbl99:
            // 1 sources

            catch (IOException e1) {
                // empty catch block
            }
            return;
        }
        var13_7 = null;
        if (fis == null) return;
        try {}
        catch (IOException e1) {}
        fis.close();
        return;
    }

    private void writePendingOperationsLocked() {
        block6: {
            int N = this.mPendingOperations.size();
            FileOutputStream fos = null;
            try {
                if (N == 0) {
                    if (Log.isLoggable(TAG_FILE, 2)) {
                        Log.v(TAG_FILE, "Truncating " + this.mPendingFile.getBaseFile());
                    }
                    this.mPendingFile.truncate();
                    return;
                }
                if (Log.isLoggable(TAG_FILE, 2)) {
                    Log.v(TAG_FILE, "Writing new " + this.mPendingFile.getBaseFile());
                }
                fos = this.mPendingFile.startWrite();
                FastXmlSerializer out = new FastXmlSerializer();
                out.setOutput(fos, "utf-8");
                for (int i = 0; i < N; ++i) {
                    PendingOperation pop = this.mPendingOperations.get(i);
                    this.writePendingOperationLocked(pop, out);
                }
                out.endDocument();
                this.mPendingFile.finishWrite(fos);
            }
            catch (IOException e1) {
                Log.w(TAG, "Error writing pending operations", e1);
                if (fos == null) break block6;
                this.mPendingFile.failWrite(fos);
            }
        }
    }

    private void writePendingOperationLocked(PendingOperation pop, XmlSerializer out) throws IOException {
        out.startTag(null, "op");
        out.attribute(null, XML_ATTR_VERSION, Integer.toString(3));
        out.attribute(null, XML_ATTR_AUTHORITYID, Integer.toString(pop.authorityId));
        out.attribute(null, XML_ATTR_SOURCE, Integer.toString(pop.syncSource));
        out.attribute(null, XML_ATTR_EXPEDITED, Boolean.toString(pop.expedited));
        out.attribute(null, XML_ATTR_REASON, Integer.toString(pop.reason));
        this.extrasToXml(out, pop.extras);
        out.endTag(null, "op");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void appendPendingOperationLocked(PendingOperation op) {
        block12: {
            if (Log.isLoggable(TAG_FILE, 2)) {
                Log.v(TAG, "Appending to " + this.mPendingFile.getBaseFile());
            }
            FileOutputStream fos = null;
            try {
                fos = this.mPendingFile.openAppend();
            }
            catch (IOException e) {
                if (Log.isLoggable(TAG_FILE, 2)) {
                    Log.v(TAG, "Failed append; writing full file");
                }
                this.writePendingOperationsLocked();
                return;
            }
            FastXmlSerializer out = new FastXmlSerializer();
            out.setOutput(fos, "utf-8");
            this.writePendingOperationLocked(op, out);
            out.endDocument();
            this.mPendingFile.finishWrite(fos);
            Object var5_6 = null;
            try {
                fos.close();
            }
            catch (IOException e) {}
            break block12;
            {
                catch (IOException e1) {
                    Log.w(TAG, "Error writing appending operation", e1);
                    this.mPendingFile.failWrite(fos);
                    Object var5_7 = null;
                    try {
                        fos.close();
                    }
                    catch (IOException e) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                try {
                    fos.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] flattenBundle(Bundle bundle) {
        byte[] flatData = null;
        Parcel parcel = Parcel.obtain();
        try {
            bundle.writeToParcel(parcel, 0);
            flatData = parcel.marshall();
            Object var4_3 = null;
            parcel.recycle();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            parcel.recycle();
            throw throwable;
        }
        return flatData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Bundle unflattenBundle(byte[] flatData) {
        Bundle bundle;
        Parcel parcel = Parcel.obtain();
        try {
            try {
                parcel.unmarshall(flatData, 0, flatData.length);
                parcel.setDataPosition(0);
                bundle = parcel.readBundle();
            }
            catch (RuntimeException e) {
                bundle = new Bundle();
                Object var5_4 = null;
                parcel.recycle();
            }
            Object var5_3 = null;
            parcel.recycle();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            parcel.recycle();
            throw throwable;
        }
        return bundle;
    }

    private void extrasToXml(XmlSerializer out, Bundle extras) throws IOException {
        for (String key : extras.keySet()) {
            out.startTag(null, "extra");
            out.attribute(null, "name", key);
            Object value = extras.get(key);
            if (value instanceof Long) {
                out.attribute(null, "type", "long");
                out.attribute(null, "value1", value.toString());
            } else if (value instanceof Integer) {
                out.attribute(null, "type", "integer");
                out.attribute(null, "value1", value.toString());
            } else if (value instanceof Boolean) {
                out.attribute(null, "type", "boolean");
                out.attribute(null, "value1", value.toString());
            } else if (value instanceof Float) {
                out.attribute(null, "type", "float");
                out.attribute(null, "value1", value.toString());
            } else if (value instanceof Double) {
                out.attribute(null, "type", "double");
                out.attribute(null, "value1", value.toString());
            } else if (value instanceof String) {
                out.attribute(null, "type", "string");
                out.attribute(null, "value1", value.toString());
            } else if (value instanceof Account) {
                out.attribute(null, "type", "account");
                out.attribute(null, "value1", ((Account)value).name);
                out.attribute(null, "value2", ((Account)value).type);
            }
            out.endTag(null, "extra");
        }
    }

    private void requestSync(Account account, int userId, int reason, String authority, Bundle extras) {
        if (Process.myUid() == 1000 && this.mSyncRequestListener != null) {
            this.mSyncRequestListener.onSyncRequest(account, userId, reason, authority, extras);
        } else {
            ContentResolver.requestSync(account, authority, extras);
        }
    }

    private void readStatisticsLocked() {
        try {
            int token;
            byte[] data = this.mStatisticsFile.readFully();
            Parcel in = Parcel.obtain();
            in.unmarshall(data, 0, data.length);
            in.setDataPosition(0);
            int index = 0;
            while ((token = in.readInt()) != 0) {
                if (token == 101 || token == 100) {
                    int day = in.readInt();
                    if (token == 100) {
                        day = day - 2009 + 14245;
                    }
                    DayStats ds = new DayStats(day);
                    ds.successCount = in.readInt();
                    ds.successTime = in.readLong();
                    ds.failureCount = in.readInt();
                    ds.failureTime = in.readLong();
                    if (index >= this.mDayStats.length) continue;
                    this.mDayStats[index] = ds;
                    ++index;
                    continue;
                }
                Log.w(TAG, "Unknown stats token: " + token);
                break;
            }
        }
        catch (IOException e) {
            Log.i(TAG, "No initial statistics");
        }
    }

    private void writeStatisticsLocked() {
        block4: {
            if (Log.isLoggable(TAG_FILE, 2)) {
                Log.v(TAG, "Writing new " + this.mStatisticsFile.getBaseFile());
            }
            this.removeMessages(2);
            FileOutputStream fos = null;
            try {
                fos = this.mStatisticsFile.startWrite();
                Parcel out = Parcel.obtain();
                for (DayStats ds : this.mDayStats) {
                    if (ds == null) break;
                    out.writeInt(101);
                    out.writeInt(ds.day);
                    out.writeInt(ds.successCount);
                    out.writeLong(ds.successTime);
                    out.writeInt(ds.failureCount);
                    out.writeLong(ds.failureTime);
                }
                out.writeInt(0);
                fos.write(out.marshall());
                out.recycle();
                this.mStatisticsFile.finishWrite(fos);
            }
            catch (IOException e1) {
                Log.w(TAG, "Error writing stats", e1);
                if (fos == null) break block4;
                this.mStatisticsFile.failWrite(fos);
            }
        }
    }

    public void dumpPendingOperations(StringBuilder sb) {
        sb.append("Pending Ops: ").append(this.mPendingOperations.size()).append(" operation(s)\n");
        for (PendingOperation pop : this.mPendingOperations) {
            sb.append("(" + pop.account).append(", u" + pop.userId).append(", " + pop.authority).append(", " + pop.extras).append(")\n");
        }
    }

    static {
        sAuthorityRenames.put("contacts", "com.android.contacts");
        sAuthorityRenames.put("calendar", "com.android.calendar");
        sSyncStorageEngine = null;
    }

    static interface OnSyncRequestListener {
        public void onSyncRequest(Account var1, int var2, int var3, String var4, Bundle var5);
    }

    public static class DayStats {
        public final int day;
        public int successCount;
        public long successTime;
        public int failureCount;
        public long failureTime;

        public DayStats(int day) {
            this.day = day;
        }
    }

    public static class SyncHistoryItem {
        int authorityId;
        int historyId;
        long eventTime;
        long elapsedTime;
        int source;
        int event;
        long upstreamActivity;
        long downstreamActivity;
        String mesg;
        boolean initialization;
        Bundle extras;
        int reason;
    }

    public static class AuthorityInfo {
        final ComponentName service;
        final Account account;
        final int userId;
        final String authority;
        final int ident;
        boolean enabled;
        int syncable;
        long backoffTime;
        long backoffDelay;
        long delayUntil;
        final ArrayList<PeriodicSync> periodicSyncs;

        AuthorityInfo(AuthorityInfo toCopy) {
            this.account = toCopy.account;
            this.userId = toCopy.userId;
            this.authority = toCopy.authority;
            this.service = toCopy.service;
            this.ident = toCopy.ident;
            this.enabled = toCopy.enabled;
            this.syncable = toCopy.syncable;
            this.backoffTime = toCopy.backoffTime;
            this.backoffDelay = toCopy.backoffDelay;
            this.delayUntil = toCopy.delayUntil;
            this.periodicSyncs = new ArrayList();
            for (PeriodicSync sync : toCopy.periodicSyncs) {
                this.periodicSyncs.add(new PeriodicSync(sync));
            }
        }

        AuthorityInfo(Account account, int userId, String authority, int ident) {
            this.account = account;
            this.userId = userId;
            this.authority = authority;
            this.service = null;
            this.ident = ident;
            this.enabled = false;
            this.syncable = -1;
            this.backoffTime = -1L;
            this.backoffDelay = -1L;
            this.periodicSyncs = new ArrayList();
            this.periodicSyncs.add(new PeriodicSync(account, authority, new Bundle(), 86400L, SyncStorageEngine.calculateDefaultFlexTime(86400L)));
        }

        AuthorityInfo(ComponentName cname, int userId, int ident) {
            this.account = null;
            this.userId = userId;
            this.authority = null;
            this.service = cname;
            this.ident = ident;
            this.enabled = true;
            this.syncable = -1;
            this.backoffTime = -1L;
            this.backoffDelay = -1L;
            this.periodicSyncs = new ArrayList();
            this.periodicSyncs.add(new PeriodicSync(this.account, this.authority, new Bundle(), 86400L, SyncStorageEngine.calculateDefaultFlexTime(86400L)));
        }
    }

    static class AccountInfo {
        final AccountAndUser accountAndUser;
        final HashMap<String, AuthorityInfo> authorities = new HashMap();

        AccountInfo(AccountAndUser accountAndUser) {
            this.accountAndUser = accountAndUser;
        }
    }

    public static class PendingOperation {
        final Account account;
        final int userId;
        final int reason;
        final int syncSource;
        final String authority;
        final Bundle extras;
        final ComponentName serviceName;
        final boolean expedited;
        int authorityId;
        byte[] flatExtras;

        PendingOperation(Account account, int userId, int reason, int source, String authority, Bundle extras, boolean expedited) {
            this.account = account;
            this.userId = userId;
            this.syncSource = source;
            this.reason = reason;
            this.authority = authority;
            this.extras = extras != null ? new Bundle(extras) : extras;
            this.expedited = expedited;
            this.authorityId = -1;
            this.serviceName = null;
        }

        PendingOperation(PendingOperation other) {
            this.account = other.account;
            this.userId = other.userId;
            this.reason = other.reason;
            this.syncSource = other.syncSource;
            this.authority = other.authority;
            this.extras = other.extras;
            this.authorityId = other.authorityId;
            this.expedited = other.expedited;
            this.serviceName = other.serviceName;
        }
    }
}

