/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.display;

import android.content.Context;
import android.os.Handler;
import com.android.server.display.DisplayAdapter;
import com.android.server.display.DisplayDevice;
import com.android.server.display.DisplayDeviceInfo;
import com.android.server.display.DisplayManagerService;

final class HeadlessDisplayAdapter
extends DisplayAdapter {
    private static final String TAG = "HeadlessDisplayAdapter";

    public HeadlessDisplayAdapter(DisplayManagerService.SyncRoot syncRoot, Context context, Handler handler, DisplayAdapter.Listener listener) {
        super(syncRoot, context, handler, listener, TAG);
    }

    public void registerLocked() {
        super.registerLocked();
        this.sendDisplayDeviceEventLocked(new HeadlessDisplayDevice(), 1);
    }

    private final class HeadlessDisplayDevice
    extends DisplayDevice {
        private DisplayDeviceInfo mInfo;

        public HeadlessDisplayDevice() {
            super(HeadlessDisplayAdapter.this, null);
        }

        public DisplayDeviceInfo getDisplayDeviceInfoLocked() {
            if (this.mInfo == null) {
                this.mInfo = new DisplayDeviceInfo();
                this.mInfo.name = HeadlessDisplayAdapter.this.getContext().getResources().getString(17040713);
                this.mInfo.width = 640;
                this.mInfo.height = 480;
                this.mInfo.refreshRate = 60.0f;
                this.mInfo.densityDpi = 160;
                this.mInfo.xDpi = 160.0f;
                this.mInfo.yDpi = 160.0f;
                this.mInfo.flags = 13;
                this.mInfo.type = 1;
                this.mInfo.touch = 0;
            }
            return this.mInfo;
        }
    }
}

