/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.dreams;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.UserHandle;
import android.service.dreams.IDreamService;
import android.util.Slog;
import android.view.IWindowManager;
import android.view.WindowManagerGlobal;
import java.io.PrintWriter;
import java.util.NoSuchElementException;

final class DreamController {
    private static final String TAG = "DreamController";
    private static final int DREAM_CONNECTION_TIMEOUT = 5000;
    private final Context mContext;
    private final Handler mHandler;
    private final Listener mListener;
    private final IWindowManager mIWindowManager;
    private final Intent mDreamingStartedIntent = new Intent("android.intent.action.DREAMING_STARTED").addFlags(0x40000000);
    private final Intent mDreamingStoppedIntent = new Intent("android.intent.action.DREAMING_STOPPED").addFlags(0x40000000);
    private final Intent mCloseNotificationShadeIntent = new Intent("android.intent.action.CLOSE_SYSTEM_DIALOGS");
    private DreamRecord mCurrentDream;
    private final Runnable mStopUnconnectedDreamRunnable = new Runnable(){

        public void run() {
            if (DreamController.this.mCurrentDream != null && ((DreamController)DreamController.this).mCurrentDream.mBound && !((DreamController)DreamController.this).mCurrentDream.mConnected) {
                Slog.w(DreamController.TAG, "Bound dream did not connect in the time allotted");
                DreamController.this.stopDream();
            }
        }
    };

    public DreamController(Context context, Handler handler, Listener listener) {
        this.mContext = context;
        this.mHandler = handler;
        this.mListener = listener;
        this.mIWindowManager = WindowManagerGlobal.getWindowManagerService();
    }

    public void dump(PrintWriter pw) {
        pw.println("Dreamland:");
        if (this.mCurrentDream != null) {
            pw.println("  mCurrentDream:");
            pw.println("    mToken=" + this.mCurrentDream.mToken);
            pw.println("    mName=" + this.mCurrentDream.mName);
            pw.println("    mIsTest=" + this.mCurrentDream.mIsTest);
            pw.println("    mUserId=" + this.mCurrentDream.mUserId);
            pw.println("    mBound=" + this.mCurrentDream.mBound);
            pw.println("    mService=" + this.mCurrentDream.mService);
            pw.println("    mSentStartBroadcast=" + this.mCurrentDream.mSentStartBroadcast);
        } else {
            pw.println("  mCurrentDream: null");
        }
    }

    public void startDream(Binder token, ComponentName name, boolean isTest, int userId) {
        this.stopDream();
        this.mContext.sendBroadcastAsUser(this.mCloseNotificationShadeIntent, UserHandle.ALL);
        Slog.i(TAG, "Starting dream: name=" + name + ", isTest=" + isTest + ", userId=" + userId);
        this.mCurrentDream = new DreamRecord(token, name, isTest, userId);
        try {
            this.mIWindowManager.addWindowToken(token, 2023);
        }
        catch (RemoteException ex) {
            Slog.e(TAG, "Unable to add window token for dream.", ex);
            this.stopDream();
            return;
        }
        Intent intent = new Intent("android.service.dreams.DreamService");
        intent.setComponent(name);
        intent.addFlags(0x800000);
        try {
            if (!this.mContext.bindServiceAsUser(intent, this.mCurrentDream, 1, new UserHandle(userId))) {
                Slog.e(TAG, "Unable to bind dream service: " + intent);
                this.stopDream();
                return;
            }
        }
        catch (SecurityException ex) {
            Slog.e(TAG, "Unable to bind dream service: " + intent, ex);
            this.stopDream();
            return;
        }
        this.mCurrentDream.mBound = true;
        this.mHandler.postDelayed(this.mStopUnconnectedDreamRunnable, 5000L);
    }

    public void stopDream() {
        if (this.mCurrentDream == null) {
            return;
        }
        final DreamRecord oldDream = this.mCurrentDream;
        this.mCurrentDream = null;
        Slog.i(TAG, "Stopping dream: name=" + oldDream.mName + ", isTest=" + oldDream.mIsTest + ", userId=" + oldDream.mUserId);
        this.mHandler.removeCallbacks(this.mStopUnconnectedDreamRunnable);
        if (oldDream.mSentStartBroadcast) {
            this.mContext.sendBroadcastAsUser(this.mDreamingStoppedIntent, UserHandle.ALL);
        }
        if (oldDream.mService != null) {
            try {
                oldDream.mService.detach();
            }
            catch (RemoteException ex) {
                // empty catch block
            }
            try {
                oldDream.mService.asBinder().unlinkToDeath(oldDream, 0);
            }
            catch (NoSuchElementException ex) {
                // empty catch block
            }
            oldDream.mService = null;
        }
        if (oldDream.mBound) {
            this.mContext.unbindService(oldDream);
        }
        try {
            this.mIWindowManager.removeWindowToken(oldDream.mToken);
        }
        catch (RemoteException ex) {
            Slog.w(TAG, "Error removing window token for dream.", ex);
        }
        this.mHandler.post(new Runnable(){

            public void run() {
                DreamController.this.mListener.onDreamStopped(oldDream.mToken);
            }
        });
    }

    private void attach(IDreamService service) {
        try {
            service.asBinder().linkToDeath(this.mCurrentDream, 0);
            service.attach(this.mCurrentDream.mToken);
        }
        catch (RemoteException ex) {
            Slog.e(TAG, "The dream service died unexpectedly.", ex);
            this.stopDream();
            return;
        }
        this.mCurrentDream.mService = service;
        if (!this.mCurrentDream.mIsTest) {
            this.mContext.sendBroadcastAsUser(this.mDreamingStartedIntent, UserHandle.ALL);
            this.mCurrentDream.mSentStartBroadcast = true;
        }
    }

    private final class DreamRecord
    implements IBinder.DeathRecipient,
    ServiceConnection {
        public final Binder mToken;
        public final ComponentName mName;
        public final boolean mIsTest;
        public final int mUserId;
        public boolean mBound;
        public boolean mConnected;
        public IDreamService mService;
        public boolean mSentStartBroadcast;

        public DreamRecord(Binder token, ComponentName name, boolean isTest, int userId) {
            this.mToken = token;
            this.mName = name;
            this.mIsTest = isTest;
            this.mUserId = userId;
        }

        public void binderDied() {
            DreamController.this.mHandler.post(new Runnable(){

                public void run() {
                    DreamRecord.this.mService = null;
                    if (DreamController.this.mCurrentDream == DreamRecord.this) {
                        DreamController.this.stopDream();
                    }
                }
            });
        }

        public void onServiceConnected(ComponentName name, final IBinder service) {
            DreamController.this.mHandler.post(new Runnable(){

                public void run() {
                    DreamRecord.this.mConnected = true;
                    if (DreamController.this.mCurrentDream == DreamRecord.this && DreamRecord.this.mService == null) {
                        DreamController.this.attach(IDreamService.Stub.asInterface(service));
                    }
                }
            });
        }

        public void onServiceDisconnected(ComponentName name) {
            DreamController.this.mHandler.post(new Runnable(){

                public void run() {
                    DreamRecord.this.mService = null;
                    if (DreamController.this.mCurrentDream == DreamRecord.this) {
                        DreamController.this.stopDream();
                    }
                }
            });
        }
    }

    public static interface Listener {
        public void onDreamStopped(Binder var1);
    }
}

