/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.hdmi;

import com.android.server.hdmi.HdmiCecFeatureAction;
import com.android.server.hdmi.HdmiCecLocalDevice;
import com.android.server.hdmi.HdmiCecMessage;
import com.android.server.hdmi.HdmiLogger;
import com.android.server.hdmi.HdmiUtils;
import com.android.server.hdmi.SetArcTransmissionStateAction;

abstract class RequestArcAction
extends HdmiCecFeatureAction {
    private static final String TAG = "RequestArcAction";
    protected static final int STATE_WATING_FOR_REQUEST_ARC_REQUEST_RESPONSE = 1;
    protected final int mAvrAddress;

    RequestArcAction(HdmiCecLocalDevice source, int avrAddress) {
        super(source);
        HdmiUtils.verifyAddressType(this.getSourceAddress(), 0);
        HdmiUtils.verifyAddressType(avrAddress, 5);
        this.mAvrAddress = avrAddress;
    }

    @Override
    boolean processCommand(HdmiCecMessage cmd) {
        if (this.mState != 1 || !HdmiUtils.checkCommandSource(cmd, this.mAvrAddress, TAG)) {
            return false;
        }
        int opcode = cmd.getOpcode();
        switch (opcode) {
            case 0: {
                int originalOpcode = cmd.getParams()[0] & 0xFF;
                if (originalOpcode == 195 || originalOpcode == 196) {
                    this.disableArcTransmission();
                    this.finish();
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    protected final void disableArcTransmission() {
        SetArcTransmissionStateAction action = new SetArcTransmissionStateAction(this.localDevice(), this.mAvrAddress, false);
        this.addAndStartAction(action);
    }

    @Override
    final void handleTimerEvent(int state) {
        if (this.mState != state || state != 1) {
            return;
        }
        HdmiLogger.debug("[T]RequestArcAction.", new Object[0]);
        this.disableArcTransmission();
        this.finish();
    }
}

