/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.hdmi;

import android.hardware.hdmi.HdmiDeviceInfo;
import android.hardware.hdmi.IHdmiControlCallback;
import android.os.RemoteException;
import android.util.Slog;
import com.android.server.hdmi.HdmiCecFeatureAction;
import com.android.server.hdmi.HdmiCecLocalDevice;
import com.android.server.hdmi.HdmiCecMessage;
import com.android.server.hdmi.HdmiCecMessageBuilder;
import com.android.server.hdmi.HdmiControlService;
import com.android.server.hdmi.HdmiUtils;

final class RoutingControlAction
extends HdmiCecFeatureAction {
    private static final String TAG = "RoutingControlAction";
    private static final int STATE_WAIT_FOR_ROUTING_INFORMATION = 1;
    private static final int STATE_WAIT_FOR_REPORT_POWER_STATUS = 2;
    private static final int TIMEOUT_ROUTING_INFORMATION_MS = 1000;
    private static final int TIMEOUT_REPORT_POWER_STATUS_MS = 1000;
    private final boolean mQueryDevicePowerStatus;
    private final boolean mNotifyInputChange;
    private final IHdmiControlCallback mCallback;
    private int mCurrentRoutingPath;

    RoutingControlAction(HdmiCecLocalDevice localDevice, int path, boolean queryDevicePowerStatus, IHdmiControlCallback callback) {
        super(localDevice);
        this.mCallback = callback;
        this.mCurrentRoutingPath = path;
        this.mQueryDevicePowerStatus = queryDevicePowerStatus;
        this.mNotifyInputChange = callback == null;
    }

    @Override
    public boolean start() {
        this.mState = 1;
        this.addTimer(this.mState, 1000);
        return true;
    }

    @Override
    public boolean processCommand(HdmiCecMessage cmd) {
        int opcode = cmd.getOpcode();
        byte[] params = cmd.getParams();
        if (this.mState == 1 && opcode == 129) {
            int routingPath = HdmiUtils.twoBytesToInt(params);
            if (!HdmiUtils.isInActiveRoutingPath(this.mCurrentRoutingPath, routingPath)) {
                return true;
            }
            this.mCurrentRoutingPath = routingPath;
            this.removeActionExcept(RoutingControlAction.class, this);
            this.addTimer(this.mState, 1000);
            return true;
        }
        if (this.mState == 2 && opcode == 144) {
            this.handleReportPowerStatus(cmd.getParams()[0]);
            return true;
        }
        return false;
    }

    private void handleReportPowerStatus(int devicePowerStatus) {
        if (RoutingControlAction.isPowerOnOrTransient(this.getTvPowerStatus())) {
            if (RoutingControlAction.isPowerOnOrTransient(devicePowerStatus)) {
                this.sendSetStreamPath();
            } else {
                this.tv().updateActiveInput(this.mCurrentRoutingPath, this.mNotifyInputChange);
            }
        }
        this.finishWithCallback(0);
    }

    private int getTvPowerStatus() {
        return this.tv().getPowerStatus();
    }

    private static boolean isPowerOnOrTransient(int status) {
        return status == 0 || status == 2;
    }

    private void sendSetStreamPath() {
        this.sendCommand(HdmiCecMessageBuilder.buildSetStreamPath(this.getSourceAddress(), this.mCurrentRoutingPath));
    }

    private void finishWithCallback(int result) {
        this.invokeCallback(result);
        this.finish();
    }

    @Override
    public void handleTimerEvent(int timeoutState) {
        if (this.mState != timeoutState || this.mState == 0) {
            Slog.w("CEC", "Timer in a wrong state. Ignored.");
            return;
        }
        switch (timeoutState) {
            case 1: {
                HdmiDeviceInfo device = this.tv().getDeviceInfoByPath(this.mCurrentRoutingPath);
                if (device != null && this.mQueryDevicePowerStatus) {
                    int deviceLogicalAddress = device.getLogicalAddress();
                    this.queryDevicePowerStatus(deviceLogicalAddress, new HdmiControlService.SendMessageCallback(){

                        @Override
                        public void onSendCompleted(int error) {
                            RoutingControlAction.this.handlDevicePowerStatusAckResult(error == 0);
                        }
                    });
                } else {
                    this.tv().updateActiveInput(this.mCurrentRoutingPath, this.mNotifyInputChange);
                    this.finishWithCallback(0);
                }
                return;
            }
            case 2: {
                if (RoutingControlAction.isPowerOnOrTransient(this.getTvPowerStatus())) {
                    this.tv().updateActiveInput(this.mCurrentRoutingPath, this.mNotifyInputChange);
                    this.sendSetStreamPath();
                }
                this.finishWithCallback(0);
                return;
            }
        }
    }

    private void queryDevicePowerStatus(int address, HdmiControlService.SendMessageCallback callback) {
        this.sendCommand(HdmiCecMessageBuilder.buildGiveDevicePowerStatus(this.getSourceAddress(), address), callback);
    }

    private void handlDevicePowerStatusAckResult(boolean acked) {
        if (acked) {
            this.mState = 2;
            this.addTimer(this.mState, 1000);
        } else {
            this.tv().updateActiveInput(this.mCurrentRoutingPath, this.mNotifyInputChange);
            this.sendSetStreamPath();
            this.finishWithCallback(0);
        }
    }

    private void invokeCallback(int result) {
        if (this.mCallback == null) {
            return;
        }
        try {
            this.mCallback.onComplete(result);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }
}

