/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.job;

import android.app.job.JobInfo;
import android.content.ComponentName;
import android.content.Context;
import android.os.Environment;
import android.os.Handler;
import android.os.PersistableBundle;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.ArraySet;
import android.util.AtomicFile;
import android.util.Pair;
import android.util.Slog;
import android.util.Xml;
import com.android.internal.util.FastXmlSerializer;
import com.android.server.IoThread;
import com.android.server.job.JobSchedulerService;
import com.android.server.job.controllers.JobStatus;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class JobStore {
    private static final String TAG = "JobStore";
    private static final boolean DEBUG = false;
    private static final int MAX_OPS_BEFORE_WRITE = 1;
    final ArraySet<JobStatus> mJobSet;
    final Context mContext;
    private int mDirtyOperations;
    private static final Object sSingletonLock = new Object();
    private final AtomicFile mJobsFile;
    private final Handler mIoHandler = IoThread.getHandler();
    private static JobStore sSingleton;
    private static final int JOBS_FILE_VERSION = 0;
    private static final String XML_TAG_PARAMS_CONSTRAINTS = "constraints";
    private static final String XML_TAG_PERIODIC = "periodic";
    private static final String XML_TAG_ONEOFF = "one-off";
    private static final String XML_TAG_EXTRAS = "extras";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JobStore initAndGet(JobSchedulerService jobManagerService) {
        Object object = sSingletonLock;
        synchronized (object) {
            if (sSingleton == null) {
                sSingleton = new JobStore(jobManagerService.getContext(), Environment.getDataDirectory());
            }
            return sSingleton;
        }
    }

    public static JobStore initAndGetForTesting(Context context, File dataDir) {
        JobStore jobStoreUnderTest = new JobStore(context, dataDir);
        jobStoreUnderTest.clear();
        return jobStoreUnderTest;
    }

    private JobStore(Context context, File dataDir) {
        this.mContext = context;
        this.mDirtyOperations = 0;
        File systemDir = new File(dataDir, "system");
        File jobDir = new File(systemDir, "job");
        jobDir.mkdirs();
        this.mJobsFile = new AtomicFile(new File(jobDir, "jobs.xml"));
        this.mJobSet = new ArraySet();
        this.readJobMapFromDisk(this.mJobSet);
    }

    public boolean add(JobStatus jobStatus) {
        boolean replaced = this.mJobSet.remove(jobStatus);
        this.mJobSet.add(jobStatus);
        if (jobStatus.isPersisted()) {
            this.maybeWriteStatusToDiskAsync();
        }
        return replaced;
    }

    public boolean containsJobIdForUid(int jobId, int uId) {
        for (int i = this.mJobSet.size() - 1; i >= 0; --i) {
            JobStatus ts = this.mJobSet.valueAt(i);
            if (ts.getUid() != uId || ts.getJobId() != jobId) continue;
            return true;
        }
        return false;
    }

    boolean containsJob(JobStatus jobStatus) {
        return this.mJobSet.contains(jobStatus);
    }

    public int size() {
        return this.mJobSet.size();
    }

    public boolean remove(JobStatus jobStatus) {
        boolean removed = this.mJobSet.remove(jobStatus);
        if (!removed) {
            return false;
        }
        if (jobStatus.isPersisted()) {
            this.maybeWriteStatusToDiskAsync();
        }
        return removed;
    }

    public void clear() {
        this.mJobSet.clear();
        this.maybeWriteStatusToDiskAsync();
    }

    public List<JobStatus> getJobsByUser(int userHandle) {
        ArrayList<JobStatus> matchingJobs = new ArrayList<JobStatus>();
        for (JobStatus ts : this.mJobSet) {
            if (UserHandle.getUserId(ts.getUid()) != userHandle) continue;
            matchingJobs.add(ts);
        }
        return matchingJobs;
    }

    public List<JobStatus> getJobsByUid(int uid) {
        ArrayList<JobStatus> matchingJobs = new ArrayList<JobStatus>();
        for (JobStatus ts : this.mJobSet) {
            if (ts.getUid() != uid) continue;
            matchingJobs.add(ts);
        }
        return matchingJobs;
    }

    public JobStatus getJobByUidAndJobId(int uid, int jobId) {
        for (JobStatus ts : this.mJobSet) {
            if (ts.getUid() != uid || ts.getJobId() != jobId) continue;
            return ts;
        }
        return null;
    }

    public ArraySet<JobStatus> getJobs() {
        return this.mJobSet;
    }

    private void maybeWriteStatusToDiskAsync() {
        ++this.mDirtyOperations;
        if (this.mDirtyOperations >= 1) {
            this.mIoHandler.post(new WriteJobsMapToDiskRunnable());
        }
    }

    public void readJobMapFromDisk(ArraySet<JobStatus> jobSet) {
        new ReadJobMapFromDiskRunnable(jobSet).run();
    }

    private class ReadJobMapFromDiskRunnable
    implements Runnable {
        private final ArraySet<JobStatus> jobSet;

        ReadJobMapFromDiskRunnable(ArraySet<JobStatus> jobSet) {
            this.jobSet = jobSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                FileInputStream fis = JobStore.this.mJobsFile.openRead();
                JobStore jobStore = JobStore.this;
                synchronized (jobStore) {
                    List<JobStatus> jobs = this.readJobMapImpl(fis);
                    if (jobs != null) {
                        for (int i = 0; i < jobs.size(); ++i) {
                            this.jobSet.add(jobs.get(i));
                        }
                    }
                }
                fis.close();
            }
            catch (FileNotFoundException e) {
            }
            catch (XmlPullParserException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private List<JobStatus> readJobMapImpl(FileInputStream fis) throws XmlPullParserException, IOException {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(fis, null);
            int eventType = parser.getEventType();
            while (eventType != 2 && eventType != 1) {
                eventType = parser.next();
                Slog.d(JobStore.TAG, parser.getName());
            }
            if (eventType == 1) {
                return null;
            }
            String tagName = parser.getName();
            if ("job-info".equals(tagName)) {
                ArrayList<JobStatus> jobs = new ArrayList<JobStatus>();
                try {
                    int version = Integer.valueOf(parser.getAttributeValue(null, "version"));
                    if (version != 0) {
                        Slog.d(JobStore.TAG, "Invalid version number, aborting jobs file read.");
                        return null;
                    }
                }
                catch (NumberFormatException e) {
                    Slog.e(JobStore.TAG, "Invalid version number, aborting jobs file read.");
                    return null;
                }
                eventType = parser.next();
                do {
                    if (eventType != 2 || !"job".equals(tagName = parser.getName())) continue;
                    JobStatus persistedJob = this.restoreJobFromXml(parser);
                    if (persistedJob != null) {
                        jobs.add(persistedJob);
                        continue;
                    }
                    Slog.d(JobStore.TAG, "Error reading job from file.");
                } while ((eventType = parser.next()) != 1);
                return jobs;
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private JobStatus restoreJobFromXml(XmlPullParser parser) throws XmlPullParserException, IOException {
            Pair<Long, Long> runtimes;
            int eventType;
            int uid;
            JobInfo.Builder jobBuilder;
            try {
                jobBuilder = this.buildBuilderFromXml(parser);
                jobBuilder.setPersisted(true);
                uid = Integer.valueOf(parser.getAttributeValue(null, "uid"));
            }
            catch (NumberFormatException e) {
                Slog.e(JobStore.TAG, "Error parsing job's required fields, skipping");
                return null;
            }
            while ((eventType = parser.next()) == 4) {
            }
            if (eventType != 2 || !JobStore.XML_TAG_PARAMS_CONSTRAINTS.equals(parser.getName())) {
                return null;
            }
            try {
                this.buildConstraintsFromXml(jobBuilder, parser);
            }
            catch (NumberFormatException e) {
                Slog.d(JobStore.TAG, "Error reading constraints, skipping.");
                return null;
            }
            parser.next();
            while ((eventType = parser.next()) == 4) {
            }
            if (eventType != 2) {
                return null;
            }
            try {
                runtimes = this.buildExecutionTimesFromXml(parser);
            }
            catch (NumberFormatException e) {
                return null;
            }
            if (JobStore.XML_TAG_PERIODIC.equals(parser.getName())) {
                try {
                    String val = parser.getAttributeValue(null, "period");
                    jobBuilder.setPeriodic(Long.valueOf(val).longValue());
                }
                catch (NumberFormatException e) {
                    Slog.d(JobStore.TAG, "Error reading periodic execution criteria, skipping.");
                    return null;
                }
            }
            if (!JobStore.XML_TAG_ONEOFF.equals(parser.getName())) return null;
            try {
                if ((Long)runtimes.first != 0L) {
                    jobBuilder.setMinimumLatency((Long)runtimes.first - SystemClock.elapsedRealtime());
                }
                if ((Long)runtimes.second != Long.MAX_VALUE) {
                    jobBuilder.setOverrideDeadline((Long)runtimes.second - SystemClock.elapsedRealtime());
                }
            }
            catch (NumberFormatException e) {
                Slog.d(JobStore.TAG, "Error reading job execution criteria, skipping.");
                return null;
            }
            this.maybeBuildBackoffPolicyFromXml(jobBuilder, parser);
            parser.nextTag();
            while ((eventType = parser.next()) == 4) {
            }
            if (eventType != 2 || !JobStore.XML_TAG_EXTRAS.equals(parser.getName())) {
                return null;
            }
            PersistableBundle extras = PersistableBundle.restoreFromXml((XmlPullParser)parser);
            jobBuilder.setExtras(extras);
            parser.nextTag();
            return new JobStatus(jobBuilder.build(), uid, (long)((Long)runtimes.first), (Long)runtimes.second);
        }

        private JobInfo.Builder buildBuilderFromXml(XmlPullParser parser) throws NumberFormatException {
            int jobId = Integer.valueOf(parser.getAttributeValue(null, "jobid"));
            String packageName = parser.getAttributeValue(null, "package");
            String className = parser.getAttributeValue(null, "class");
            ComponentName cname = new ComponentName(packageName, className);
            return new JobInfo.Builder(jobId, cname);
        }

        private void buildConstraintsFromXml(JobInfo.Builder jobBuilder, XmlPullParser parser) {
            String val = parser.getAttributeValue(null, "unmetered");
            if (val != null) {
                jobBuilder.setRequiredNetworkType(2);
            }
            if ((val = parser.getAttributeValue(null, "connectivity")) != null) {
                jobBuilder.setRequiredNetworkType(1);
            }
            if ((val = parser.getAttributeValue(null, "idle")) != null) {
                jobBuilder.setRequiresDeviceIdle(true);
            }
            if ((val = parser.getAttributeValue(null, "charging")) != null) {
                jobBuilder.setRequiresCharging(true);
            }
        }

        private void maybeBuildBackoffPolicyFromXml(JobInfo.Builder jobBuilder, XmlPullParser parser) {
            String val = parser.getAttributeValue(null, "initial-backoff");
            if (val != null) {
                long initialBackoff = Long.valueOf(val);
                val = parser.getAttributeValue(null, "backoff-policy");
                int backoffPolicy = Integer.valueOf(val);
                jobBuilder.setBackoffCriteria(initialBackoff, backoffPolicy);
            }
        }

        private Pair<Long, Long> buildExecutionTimesFromXml(XmlPullParser parser) throws NumberFormatException {
            long nowWallclock = System.currentTimeMillis();
            long nowElapsed = SystemClock.elapsedRealtime();
            long earliestRunTimeElapsed = 0L;
            long latestRunTimeElapsed = Long.MAX_VALUE;
            String val = parser.getAttributeValue(null, "deadline");
            if (val != null) {
                long latestRuntimeWallclock = Long.valueOf(val);
                long maxDelayElapsed = Math.max(latestRuntimeWallclock - nowWallclock, 0L);
                latestRunTimeElapsed = nowElapsed + maxDelayElapsed;
            }
            if ((val = parser.getAttributeValue(null, "delay")) != null) {
                long earliestRuntimeWallclock = Long.valueOf(val);
                long minDelayElapsed = Math.max(earliestRuntimeWallclock - nowWallclock, 0L);
                earliestRunTimeElapsed = nowElapsed + minDelayElapsed;
            }
            return Pair.create(earliestRunTimeElapsed, latestRunTimeElapsed);
        }
    }

    private class WriteJobsMapToDiskRunnable
    implements Runnable {
        private WriteJobsMapToDiskRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long startElapsed = SystemClock.elapsedRealtime();
            ArrayList<JobStatus> mStoreCopy = new ArrayList<JobStatus>();
            JobStore jobStore = JobStore.this;
            synchronized (jobStore) {
                for (int i = 0; i < JobStore.this.mJobSet.size(); ++i) {
                    JobStatus jobStatus = JobStore.this.mJobSet.valueAt(i);
                    JobStatus copy = new JobStatus(jobStatus.getJob(), jobStatus.getUid(), jobStatus.getEarliestRunTime(), jobStatus.getLatestRunTimeElapsed());
                    mStoreCopy.add(copy);
                }
            }
            this.writeJobsMapImpl(mStoreCopy);
        }

        private void writeJobsMapImpl(List<JobStatus> jobList) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                FastXmlSerializer out = new FastXmlSerializer();
                out.setOutput(baos, "utf-8");
                out.startDocument(null, true);
                out.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
                out.startTag(null, "job-info");
                out.attribute(null, "version", Integer.toString(0));
                for (int i = 0; i < jobList.size(); ++i) {
                    JobStatus jobStatus = jobList.get(i);
                    out.startTag(null, "job");
                    this.addIdentifierAttributesToJobTag(out, jobStatus);
                    this.writeConstraintsToXml(out, jobStatus);
                    this.writeExecutionCriteriaToXml(out, jobStatus);
                    this.writeBundleToXml(jobStatus.getExtras(), out);
                    out.endTag(null, "job");
                }
                out.endTag(null, "job-info");
                out.endDocument();
                FileOutputStream fos = JobStore.this.mJobsFile.startWrite();
                fos.write(baos.toByteArray());
                JobStore.this.mJobsFile.finishWrite(fos);
                JobStore.this.mDirtyOperations = 0;
            }
            catch (IOException e) {
            }
            catch (XmlPullParserException xmlPullParserException) {
                // empty catch block
            }
        }

        private void addIdentifierAttributesToJobTag(XmlSerializer out, JobStatus jobStatus) throws IOException {
            out.attribute(null, "jobid", Integer.toString(jobStatus.getJobId()));
            out.attribute(null, "package", jobStatus.getServiceComponent().getPackageName());
            out.attribute(null, "class", jobStatus.getServiceComponent().getClassName());
            out.attribute(null, "uid", Integer.toString(jobStatus.getUid()));
        }

        private void writeBundleToXml(PersistableBundle extras, XmlSerializer out) throws IOException, XmlPullParserException {
            out.startTag(null, JobStore.XML_TAG_EXTRAS);
            extras.saveToXml(out);
            out.endTag(null, JobStore.XML_TAG_EXTRAS);
        }

        private void writeConstraintsToXml(XmlSerializer out, JobStatus jobStatus) throws IOException {
            out.startTag(null, JobStore.XML_TAG_PARAMS_CONSTRAINTS);
            if (jobStatus.hasUnmeteredConstraint()) {
                out.attribute(null, "unmetered", Boolean.toString(true));
            }
            if (jobStatus.hasConnectivityConstraint()) {
                out.attribute(null, "connectivity", Boolean.toString(true));
            }
            if (jobStatus.hasIdleConstraint()) {
                out.attribute(null, "idle", Boolean.toString(true));
            }
            if (jobStatus.hasChargingConstraint()) {
                out.attribute(null, "charging", Boolean.toString(true));
            }
            out.endTag(null, JobStore.XML_TAG_PARAMS_CONSTRAINTS);
        }

        private void writeExecutionCriteriaToXml(XmlSerializer out, JobStatus jobStatus) throws IOException {
            JobInfo job = jobStatus.getJob();
            if (jobStatus.getJob().isPeriodic()) {
                out.startTag(null, JobStore.XML_TAG_PERIODIC);
                out.attribute(null, "period", Long.toString(job.getIntervalMillis()));
            } else {
                out.startTag(null, JobStore.XML_TAG_ONEOFF);
            }
            if (jobStatus.hasDeadlineConstraint()) {
                long deadlineWallclock = System.currentTimeMillis() + (jobStatus.getLatestRunTimeElapsed() - SystemClock.elapsedRealtime());
                out.attribute(null, "deadline", Long.toString(deadlineWallclock));
            }
            if (jobStatus.hasTimingDelayConstraint()) {
                long delayWallclock = System.currentTimeMillis() + (jobStatus.getEarliestRunTime() - SystemClock.elapsedRealtime());
                out.attribute(null, "delay", Long.toString(delayWallclock));
            }
            if (jobStatus.getJob().getInitialBackoffMillis() != 30000L || jobStatus.getJob().getBackoffPolicy() != 1) {
                out.attribute(null, "backoff-policy", Integer.toString(job.getBackoffPolicy()));
                out.attribute(null, "initial-backoff", Long.toString(job.getInitialBackoffMillis()));
            }
            if (job.isPeriodic()) {
                out.endTag(null, JobStore.XML_TAG_PERIODIC);
            } else {
                out.endTag(null, JobStore.XML_TAG_ONEOFF);
            }
        }
    }
}

