/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.content.Context;
import android.location.Country;
import android.location.CountryListener;
import android.os.Handler;

public abstract class CountryDetectorBase {
    protected final Handler mHandler;
    protected final Context mContext;
    protected CountryListener mListener;
    protected Country mDetectedCountry;

    public CountryDetectorBase(Context ctx) {
        this.mContext = ctx;
        this.mHandler = new Handler();
    }

    public abstract Country detectCountry();

    public void setCountryListener(CountryListener listener) {
        this.mListener = listener;
    }

    public abstract void stop();

    protected void notifyListener(Country country) {
        if (this.mListener != null) {
            this.mListener.onCountryDetected(country);
        }
    }
}

