/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.content.Context;
import android.hardware.location.GeofenceHardwareImpl;
import android.hardware.location.GeofenceHardwareRequestParcelable;
import android.hardware.location.IFusedLocationHardware;
import android.hardware.location.IFusedLocationHardwareSink;
import android.location.FusedBatchOptions;
import android.location.IFusedGeofenceHardware;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.location.LocationRequest;
import android.os.Bundle;
import android.os.Looper;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.Log;

public class FlpHardwareProvider {
    private GeofenceHardwareImpl mGeofenceHardwareSink = null;
    private IFusedLocationHardwareSink mLocationSink = null;
    private static FlpHardwareProvider sSingletonInstance = null;
    private static final String TAG = "FlpHardwareProvider";
    private final Context mContext;
    private final Object mLocationSinkLock = new Object();
    private static final int FLP_RESULT_SUCCESS = 0;
    private static final int FLP_RESULT_ERROR = -1;
    private static final int FLP_RESULT_INSUFFICIENT_MEMORY = -2;
    private static final int FLP_RESULT_TOO_MANY_GEOFENCES = -3;
    private static final int FLP_RESULT_ID_EXISTS = -4;
    private static final int FLP_RESULT_ID_UNKNOWN = -5;
    private static final int FLP_RESULT_INVALID_GEOFENCE_TRANSITION = -6;
    public static final String LOCATION = "Location";
    public static final String GEOFENCING = "Geofencing";
    private final IFusedLocationHardware mLocationHardware = new IFusedLocationHardware.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registerSink(IFusedLocationHardwareSink eventSink) {
            Object object = FlpHardwareProvider.this.mLocationSinkLock;
            synchronized (object) {
                if (FlpHardwareProvider.this.mLocationSink != null) {
                    throw new RuntimeException("IFusedLocationHardware does not support multiple sinks");
                }
                FlpHardwareProvider.this.mLocationSink = eventSink;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregisterSink(IFusedLocationHardwareSink eventSink) {
            Object object = FlpHardwareProvider.this.mLocationSinkLock;
            synchronized (object) {
                if (FlpHardwareProvider.this.mLocationSink == eventSink) {
                    FlpHardwareProvider.this.mLocationSink = null;
                }
            }
        }

        public int getSupportedBatchSize() {
            return FlpHardwareProvider.this.nativeGetBatchSize();
        }

        public void startBatching(int requestId, FusedBatchOptions options) {
            FlpHardwareProvider.this.nativeStartBatching(requestId, options);
        }

        public void stopBatching(int requestId) {
            FlpHardwareProvider.this.nativeStopBatching(requestId);
        }

        public void updateBatchingOptions(int requestId, FusedBatchOptions options) {
            FlpHardwareProvider.this.nativeUpdateBatchingOptions(requestId, options);
        }

        public void requestBatchOfLocations(int batchSizeRequested) {
            FlpHardwareProvider.this.nativeRequestBatchedLocation(batchSizeRequested);
        }

        public boolean supportsDiagnosticDataInjection() {
            return FlpHardwareProvider.this.nativeIsDiagnosticSupported();
        }

        public void injectDiagnosticData(String data) {
            FlpHardwareProvider.this.nativeInjectDiagnosticData(data);
        }

        public boolean supportsDeviceContextInjection() {
            return FlpHardwareProvider.this.nativeIsDeviceContextSupported();
        }

        public void injectDeviceContext(int deviceEnabledContext) {
            FlpHardwareProvider.this.nativeInjectDeviceContext(deviceEnabledContext);
        }
    };
    private final IFusedGeofenceHardware mGeofenceHardwareService = new IFusedGeofenceHardware.Stub(){

        public boolean isSupported() {
            return FlpHardwareProvider.this.nativeIsGeofencingSupported();
        }

        public void addGeofences(GeofenceHardwareRequestParcelable[] geofenceRequestsArray) {
            FlpHardwareProvider.this.nativeAddGeofences(geofenceRequestsArray);
        }

        public void removeGeofences(int[] geofenceIds) {
            FlpHardwareProvider.this.nativeRemoveGeofences(geofenceIds);
        }

        public void pauseMonitoringGeofence(int geofenceId) {
            FlpHardwareProvider.this.nativePauseGeofence(geofenceId);
        }

        public void resumeMonitoringGeofence(int geofenceId, int monitorTransitions) {
            FlpHardwareProvider.this.nativeResumeGeofence(geofenceId, monitorTransitions);
        }

        public void modifyGeofenceOptions(int geofenceId, int lastTransition, int monitorTransitions, int notificationResponsiveness, int unknownTimer, int sourcesToUse) {
            FlpHardwareProvider.this.nativeModifyGeofenceOption(geofenceId, lastTransition, monitorTransitions, notificationResponsiveness, unknownTimer, sourcesToUse);
        }
    };

    public static FlpHardwareProvider getInstance(Context context) {
        if (sSingletonInstance == null) {
            sSingletonInstance = new FlpHardwareProvider(context);
        }
        return sSingletonInstance;
    }

    private FlpHardwareProvider(Context context) {
        this.mContext = context;
        LocationManager manager = (LocationManager)this.mContext.getSystemService("location");
        long minTime = 0L;
        float minDistance = 0.0f;
        boolean oneShot = false;
        LocationRequest request = LocationRequest.createFromDeprecatedProvider("passive", 0L, 0.0f, false);
        request.setHideFromAppOps(true);
        manager.requestLocationUpdates(request, new NetworkLocationListener(), Looper.myLooper());
    }

    public static boolean isSupported() {
        return FlpHardwareProvider.nativeIsSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onLocationReport(Location[] locations) {
        IFusedLocationHardwareSink sink;
        for (Location location : locations) {
            location.setProvider("fused");
            location.setElapsedRealtimeNanos(SystemClock.elapsedRealtimeNanos());
        }
        Object len$ = this.mLocationSinkLock;
        synchronized (len$) {
            sink = this.mLocationSink;
        }
        try {
            if (sink != null) {
                sink.onLocationAvailable(locations);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException calling onLocationAvailable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDataReport(String data) {
        IFusedLocationHardwareSink sink;
        Object object = this.mLocationSinkLock;
        synchronized (object) {
            sink = this.mLocationSink;
        }
        try {
            if (this.mLocationSink != null) {
                sink.onDiagnosticDataAvailable(data);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException calling onDiagnosticDataAvailable");
        }
    }

    private void onGeofenceTransition(int geofenceId, Location location, int transition2, long timestamp, int sourcesUsed) {
        this.getGeofenceHardwareSink().reportGeofenceTransition(geofenceId, this.updateLocationInformation(location), transition2, timestamp, 1, sourcesUsed);
    }

    private void onGeofenceMonitorStatus(int status, int source, Location location) {
        Location updatedLocation = null;
        if (location != null) {
            updatedLocation = this.updateLocationInformation(location);
        }
        this.getGeofenceHardwareSink().reportGeofenceMonitorStatus(1, status, updatedLocation, source);
    }

    private void onGeofenceAdd(int geofenceId, int result) {
        this.getGeofenceHardwareSink().reportGeofenceAddStatus(geofenceId, FlpHardwareProvider.translateToGeofenceHardwareStatus(result));
    }

    private void onGeofenceRemove(int geofenceId, int result) {
        this.getGeofenceHardwareSink().reportGeofenceRemoveStatus(geofenceId, FlpHardwareProvider.translateToGeofenceHardwareStatus(result));
    }

    private void onGeofencePause(int geofenceId, int result) {
        this.getGeofenceHardwareSink().reportGeofencePauseStatus(geofenceId, FlpHardwareProvider.translateToGeofenceHardwareStatus(result));
    }

    private void onGeofenceResume(int geofenceId, int result) {
        this.getGeofenceHardwareSink().reportGeofenceResumeStatus(geofenceId, FlpHardwareProvider.translateToGeofenceHardwareStatus(result));
    }

    private static native void nativeClassInit();

    private static native boolean nativeIsSupported();

    private native void nativeInit();

    private native int nativeGetBatchSize();

    private native void nativeStartBatching(int var1, FusedBatchOptions var2);

    private native void nativeUpdateBatchingOptions(int var1, FusedBatchOptions var2);

    private native void nativeStopBatching(int var1);

    private native void nativeRequestBatchedLocation(int var1);

    private native void nativeInjectLocation(Location var1);

    private native void nativeCleanup();

    private native boolean nativeIsDiagnosticSupported();

    private native void nativeInjectDiagnosticData(String var1);

    private native boolean nativeIsDeviceContextSupported();

    private native void nativeInjectDeviceContext(int var1);

    private native boolean nativeIsGeofencingSupported();

    private native void nativeAddGeofences(GeofenceHardwareRequestParcelable[] var1);

    private native void nativePauseGeofence(int var1);

    private native void nativeResumeGeofence(int var1, int var2);

    private native void nativeModifyGeofenceOption(int var1, int var2, int var3, int var4, int var5, int var6);

    private native void nativeRemoveGeofences(int[] var1);

    public IFusedLocationHardware getLocationHardware() {
        this.nativeInit();
        return this.mLocationHardware;
    }

    public IFusedGeofenceHardware getGeofenceHardware() {
        this.nativeInit();
        return this.mGeofenceHardwareService;
    }

    private GeofenceHardwareImpl getGeofenceHardwareSink() {
        if (this.mGeofenceHardwareSink == null) {
            this.mGeofenceHardwareSink = GeofenceHardwareImpl.getInstance(this.mContext);
        }
        return this.mGeofenceHardwareSink;
    }

    private static int translateToGeofenceHardwareStatus(int flpHalResult) {
        switch (flpHalResult) {
            case 0: {
                return 0;
            }
            case -1: {
                return 5;
            }
            case -3: {
                return 1;
            }
            case -4: {
                return 2;
            }
            case -5: {
                return 3;
            }
            case -6: {
                return 4;
            }
        }
        Log.e(TAG, String.format("Invalid FlpHal result code: %d", flpHalResult));
        return 5;
    }

    private Location updateLocationInformation(Location location) {
        location.setProvider("fused");
        location.setElapsedRealtimeNanos(SystemClock.elapsedRealtimeNanos());
        return location;
    }

    static {
        FlpHardwareProvider.nativeClassInit();
    }

    private final class NetworkLocationListener
    implements LocationListener {
        private NetworkLocationListener() {
        }

        public void onLocationChanged(Location location) {
            if (!"network".equals(location.getProvider()) || !location.hasAccuracy()) {
                return;
            }
            FlpHardwareProvider.this.nativeInjectLocation(location);
        }

        public void onStatusChanged(String provider, int status, Bundle extras) {
        }

        public void onProviderEnabled(String provider) {
        }

        public void onProviderDisabled(String provider) {
        }
    }
}

