/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.location.IGpsStatusListener;
import android.os.RemoteException;
import com.android.server.location.RemoteListenerHelper;

abstract class GpsStatusListenerHelper
extends RemoteListenerHelper<IGpsStatusListener> {
    public GpsStatusListenerHelper() {
        super("GpsStatusListenerHelper");
    }

    public void onFirstFix(final int timeToFirstFix) {
        Operation operation = new Operation(){

            @Override
            public void execute(IGpsStatusListener listener) throws RemoteException {
                listener.onFirstFix(timeToFirstFix);
            }
        };
        this.foreach(operation);
    }

    public void onStatusChanged(final boolean isNavigating) {
        Operation operation = new Operation(){

            @Override
            public void execute(IGpsStatusListener listener) throws RemoteException {
                if (isNavigating) {
                    listener.onGpsStarted();
                } else {
                    listener.onGpsStopped();
                }
            }
        };
        this.foreach(operation);
    }

    public void onSvStatusChanged(final int svCount, final int[] prns, final float[] snrs, final float[] elevations, final float[] azimuths, final int ephemerisMask, final int almanacMask, final int usedInFixMask) {
        Operation operation = new Operation(){

            @Override
            public void execute(IGpsStatusListener listener) throws RemoteException {
                listener.onSvStatusChanged(svCount, prns, snrs, elevations, azimuths, ephemerisMask, almanacMask, usedInFixMask);
            }
        };
        this.foreach(operation);
    }

    public void onNmeaReceived(final long timestamp, final String nmea) {
        Operation operation = new Operation(){

            @Override
            public void execute(IGpsStatusListener listener) throws RemoteException {
                listener.onNmeaReceived(timestamp, nmea);
            }
        };
        this.foreach(operation);
    }

    private abstract class Operation
    implements RemoteListenerHelper.ListenerOperation<IGpsStatusListener> {
        private Operation() {
        }
    }
}

