/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

import android.content.ComponentName;
import android.net.Uri;
import android.os.Build;
import android.os.RemoteException;
import android.service.notification.Condition;
import android.service.notification.IConditionProvider;
import android.service.notification.ZenModeConfig;
import android.util.ArraySet;
import android.util.Slog;
import com.android.server.notification.NotificationRecord;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ZenLog {
    private static final String TAG = "ZenLog";
    private static final int SIZE = Build.IS_DEBUGGABLE ? 100 : 20;
    private static final long[] TIMES = new long[SIZE];
    private static final int[] TYPES = new int[SIZE];
    private static final String[] MSGS = new String[SIZE];
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("MM-dd HH:mm:ss.SSS");
    private static final int TYPE_INTERCEPTED = 1;
    private static final int TYPE_ALLOW_DISABLE = 2;
    private static final int TYPE_SET_RINGER_MODE = 3;
    private static final int TYPE_DOWNTIME = 4;
    private static final int TYPE_SET_ZEN_MODE = 5;
    private static final int TYPE_UPDATE_ZEN_MODE = 6;
    private static final int TYPE_EXIT_CONDITION = 7;
    private static final int TYPE_SUBSCRIBE = 8;
    private static final int TYPE_UNSUBSCRIBE = 9;
    private static final int TYPE_CONFIG = 10;
    private static final int TYPE_FOLLOW_RINGER_MODE = 11;
    private static final int TYPE_NOT_INTERCEPTED = 12;
    private static final int TYPE_DISABLE_EFFECTS = 13;
    private static int sNext;
    private static int sSize;

    public static void traceIntercepted(NotificationRecord record, String reason) {
        if (record != null && record.isIntercepted()) {
            return;
        }
        ZenLog.append(1, record.getKey() + "," + reason);
    }

    public static void traceNotIntercepted(NotificationRecord record, String reason) {
        if (record != null && record.isUpdate) {
            return;
        }
        ZenLog.append(12, record.getKey() + "," + reason);
    }

    public static void traceSetRingerMode(int ringerMode) {
        ZenLog.append(3, ZenLog.ringerModeToString(ringerMode));
    }

    public static void traceDowntime(boolean inDowntime, int day, ArraySet<Integer> days) {
        ZenLog.append(4, inDowntime + ",day=" + day + ",days=" + days);
    }

    public static void traceSetZenMode(int mode, String reason) {
        ZenLog.append(5, ZenLog.zenModeToString(mode) + "," + reason);
    }

    public static void traceUpdateZenMode(int fromMode, int toMode) {
        ZenLog.append(6, ZenLog.zenModeToString(fromMode) + " -> " + ZenLog.zenModeToString(toMode));
    }

    public static void traceExitCondition(Condition c, ComponentName component, String reason) {
        ZenLog.append(7, c + "," + ZenLog.componentToString(component) + "," + reason);
    }

    public static void traceSubscribe(Uri uri, IConditionProvider provider, RemoteException e) {
        ZenLog.append(8, uri + "," + ZenLog.subscribeResult(provider, e));
    }

    public static void traceUnsubscribe(Uri uri, IConditionProvider provider, RemoteException e) {
        ZenLog.append(9, uri + "," + ZenLog.subscribeResult(provider, e));
    }

    public static void traceConfig(ZenModeConfig oldConfig, ZenModeConfig newConfig) {
        ZenLog.append(10, newConfig != null ? newConfig.toString() : null);
    }

    public static void traceFollowRingerMode(int ringerMode, int oldZen, int newZen) {
        ZenLog.append(11, ZenLog.ringerModeToString(ringerMode) + ", " + ZenLog.zenModeToString(oldZen) + " -> " + ZenLog.zenModeToString(newZen));
    }

    public static void traceDisableEffects(NotificationRecord record, String reason) {
        ZenLog.append(13, record.getKey() + "," + reason);
    }

    private static String subscribeResult(IConditionProvider provider, RemoteException e) {
        return provider == null ? "no provider" : (e != null ? e.getMessage() : "ok");
    }

    private static String typeToString(int type) {
        switch (type) {
            case 1: {
                return "intercepted";
            }
            case 2: {
                return "allow_disable";
            }
            case 3: {
                return "set_ringer_mode";
            }
            case 4: {
                return "downtime";
            }
            case 5: {
                return "set_zen_mode";
            }
            case 6: {
                return "update_zen_mode";
            }
            case 7: {
                return "exit_condition";
            }
            case 8: {
                return "subscribe";
            }
            case 9: {
                return "unsubscribe";
            }
            case 10: {
                return "config";
            }
            case 11: {
                return "follow_ringer_mode";
            }
            case 12: {
                return "not_intercepted";
            }
            case 13: {
                return "disable_effects";
            }
        }
        return "unknown";
    }

    private static String ringerModeToString(int ringerMode) {
        switch (ringerMode) {
            case 0: {
                return "silent";
            }
            case 1: {
                return "vibrate";
            }
            case 2: {
                return "normal";
            }
        }
        return "unknown";
    }

    private static String zenModeToString(int zenMode) {
        switch (zenMode) {
            case 0: {
                return "off";
            }
            case 1: {
                return "important_interruptions";
            }
            case 2: {
                return "no_interruptions";
            }
        }
        return "unknown";
    }

    private static String componentToString(ComponentName component) {
        return component != null ? component.toShortString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void append(int type, String msg) {
        String[] stringArray = MSGS;
        synchronized (MSGS) {
            ZenLog.TIMES[ZenLog.sNext] = System.currentTimeMillis();
            ZenLog.TYPES[ZenLog.sNext] = type;
            ZenLog.MSGS[ZenLog.sNext] = msg;
            sNext = (sNext + 1) % SIZE;
            if (sSize < SIZE) {
                ++sSize;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            Slog.d(TAG, ZenLog.typeToString(type) + ": " + msg);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump(PrintWriter pw, String prefix) {
        String[] stringArray = MSGS;
        synchronized (MSGS) {
            int start = (sNext - sSize + SIZE) % SIZE;
            for (int i = 0; i < sSize; ++i) {
                int j = (start + i) % SIZE;
                pw.print(prefix);
                pw.print(FORMAT.format(new Date(TIMES[j])));
                pw.print(' ');
                pw.print(ZenLog.typeToString(TYPES[j]));
                pw.print(": ");
                pw.println(MSGS[j]);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

