/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

import android.app.AppOpsManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.database.ContentObserver;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.UserHandle;
import android.provider.Settings;
import android.service.notification.ZenModeConfig;
import android.telecom.TelecomManager;
import android.util.Log;
import android.util.Slog;
import com.android.server.notification.NotificationRecord;
import com.android.server.notification.ValidateNotificationPeople;
import com.android.server.notification.ZenLog;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Objects;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class ZenModeHelper {
    private static final String TAG = "ZenModeHelper";
    private static final boolean DEBUG = Log.isLoggable("ZenModeHelper", 3);
    private final Context mContext;
    private final Handler mHandler;
    private final SettingsObserver mSettingsObserver;
    private final AppOpsManager mAppOps;
    private final ZenModeConfig mDefaultConfig;
    private final ArrayList<Callback> mCallbacks = new ArrayList();
    private ComponentName mDefaultPhoneApp;
    private int mZenMode;
    private ZenModeConfig mConfig;
    private AudioManager mAudioManager;
    private int mPreviousRingerMode = -1;
    private final Runnable mRingerModeChanged = new Runnable(){

        @Override
        public void run() {
            ZenModeHelper.this.handleRingerModeChanged();
        }
    };
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            ZenModeHelper.this.mHandler.post(ZenModeHelper.this.mRingerModeChanged);
        }
    };

    public ZenModeHelper(Context context, Handler handler) {
        this.mContext = context;
        this.mHandler = handler;
        this.mAppOps = (AppOpsManager)context.getSystemService("appops");
        this.mConfig = this.mDefaultConfig = ZenModeHelper.readDefaultConfig(context.getResources());
        this.mSettingsObserver = new SettingsObserver(this.mHandler);
        this.mSettingsObserver.observe();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.media.RINGER_MODE_CHANGED");
        this.mContext.registerReceiver(this.mReceiver, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZenModeConfig readDefaultConfig(Resources resources) {
        XmlResourceParser parser = null;
        try {
            parser = resources.getXml(0x1110003);
            while (parser.next() != 1) {
                ZenModeConfig config = ZenModeConfig.readXml((XmlPullParser)parser);
                if (config == null) continue;
                ZenModeConfig zenModeConfig = config;
                return zenModeConfig;
            }
        }
        catch (Exception e) {
            Slog.w(TAG, "Error reading default zen mode config from resource", e);
        }
        finally {
            IoUtils.closeQuietly(parser);
        }
        return new ZenModeConfig();
    }

    public void addCallback(Callback callback) {
        this.mCallbacks.add(callback);
    }

    public void setAudioManager(AudioManager audioManager) {
        this.mAudioManager = audioManager;
    }

    public int getZenModeListenerInterruptionFilter() {
        switch (this.mZenMode) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
        }
        return 0;
    }

    private static int zenModeFromListenerInterruptionFilter(int listenerInterruptionFilter, int defValue) {
        switch (listenerInterruptionFilter) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        return defValue;
    }

    public void requestFromListener(int interruptionFilter) {
        int newZen = ZenModeHelper.zenModeFromListenerInterruptionFilter(interruptionFilter, -1);
        if (newZen != -1) {
            this.setZenMode(newZen, "listener");
        }
    }

    public boolean shouldIntercept(NotificationRecord record) {
        if (ZenModeHelper.isSystem(record)) {
            return false;
        }
        switch (this.mZenMode) {
            case 2: {
                ZenLog.traceIntercepted(record, "none");
                return true;
            }
            case 1: {
                if (ZenModeHelper.isAlarm(record)) {
                    return false;
                }
                if (record.getPackagePriority() == 2) {
                    ZenLog.traceNotIntercepted(record, "priorityApp");
                    return false;
                }
                if (this.isCall(record)) {
                    if (!this.mConfig.allowCalls) {
                        ZenLog.traceIntercepted(record, "!allowCalls");
                        return true;
                    }
                    return this.shouldInterceptAudience(record);
                }
                if (this.isMessage(record)) {
                    if (!this.mConfig.allowMessages) {
                        ZenLog.traceIntercepted(record, "!allowMessages");
                        return true;
                    }
                    return this.shouldInterceptAudience(record);
                }
                if (ZenModeHelper.isEvent(record)) {
                    if (!this.mConfig.allowEvents) {
                        ZenLog.traceIntercepted(record, "!allowEvents");
                        return true;
                    }
                    return false;
                }
                ZenLog.traceIntercepted(record, "!priority");
                return true;
            }
        }
        return false;
    }

    private boolean shouldInterceptAudience(NotificationRecord record) {
        if (!this.audienceMatches(record.getContactAffinity())) {
            ZenLog.traceIntercepted(record, "!audienceMatches");
            return true;
        }
        return false;
    }

    public int getZenMode() {
        return this.mZenMode;
    }

    public void setZenMode(int zenModeValue, String reason) {
        ZenLog.traceSetZenMode(zenModeValue, reason);
        Settings.Global.putInt(this.mContext.getContentResolver(), "zen_mode", zenModeValue);
    }

    public void updateZenMode() {
        int mode = Settings.Global.getInt(this.mContext.getContentResolver(), "zen_mode", 0);
        if (mode != this.mZenMode) {
            ZenLog.traceUpdateZenMode(this.mZenMode, mode);
        }
        this.mZenMode = mode;
        boolean zen = this.mZenMode != 0;
        String[] exceptionPackages = null;
        boolean muteCalls = zen && !this.mConfig.allowCalls;
        this.mAppOps.setRestriction(3, 6, muteCalls ? 1 : 0, exceptionPackages);
        this.mAppOps.setRestriction(28, 6, muteCalls ? 1 : 0, exceptionPackages);
        boolean muteAlarms = this.mZenMode == 2;
        this.mAppOps.setRestriction(3, 4, muteAlarms ? 1 : 0, exceptionPackages);
        this.mAppOps.setRestriction(28, 4, muteAlarms ? 1 : 0, exceptionPackages);
        if (this.mAudioManager != null) {
            int ringerMode = this.mAudioManager.getRingerMode();
            int forcedRingerMode = -1;
            if (this.mZenMode == 2) {
                if (ringerMode != 0) {
                    this.mPreviousRingerMode = ringerMode;
                    if (DEBUG) {
                        Slog.d(TAG, "Silencing ringer");
                    }
                    forcedRingerMode = 0;
                }
            } else if (ringerMode == 0) {
                if (DEBUG) {
                    Slog.d(TAG, "Unsilencing ringer");
                }
                forcedRingerMode = this.mPreviousRingerMode != -1 ? this.mPreviousRingerMode : 2;
                this.mPreviousRingerMode = -1;
            }
            if (forcedRingerMode != -1) {
                this.mAudioManager.setRingerMode(forcedRingerMode, false);
                ZenLog.traceSetRingerMode(forcedRingerMode);
            }
        }
        this.dispatchOnZenModeChanged();
    }

    public void dump(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.print("mZenMode=");
        pw.println(Settings.Global.zenModeToString((int)this.mZenMode));
        pw.print(prefix);
        pw.print("mConfig=");
        pw.println(this.mConfig);
        pw.print(prefix);
        pw.print("mDefaultConfig=");
        pw.println(this.mDefaultConfig);
        pw.print(prefix);
        pw.print("mPreviousRingerMode=");
        pw.println(this.mPreviousRingerMode);
        pw.print(prefix);
        pw.print("mDefaultPhoneApp=");
        pw.println(this.mDefaultPhoneApp);
    }

    public void readXml(XmlPullParser parser) throws XmlPullParserException, IOException {
        ZenModeConfig config = ZenModeConfig.readXml((XmlPullParser)parser);
        if (config != null) {
            this.setConfig(config);
        }
    }

    public void writeXml(XmlSerializer out) throws IOException {
        this.mConfig.writeXml(out);
    }

    public ZenModeConfig getConfig() {
        return this.mConfig;
    }

    public boolean setConfig(ZenModeConfig config) {
        if (config == null || !config.isValid()) {
            return false;
        }
        if (config.equals((Object)this.mConfig)) {
            return true;
        }
        ZenLog.traceConfig(this.mConfig, config);
        this.mConfig = config;
        this.dispatchOnConfigChanged();
        String val = Integer.toString(this.mConfig.hashCode());
        Settings.Global.putString(this.mContext.getContentResolver(), "zen_mode_config_etag", val);
        this.updateZenMode();
        return true;
    }

    private void handleRingerModeChanged() {
        if (this.mAudioManager != null) {
            int ringerMode = this.mAudioManager.getRingerMode();
            int newZen = -1;
            if (ringerMode == 0) {
                if (this.mZenMode == 0) {
                    newZen = 1;
                }
            } else if ((ringerMode == 2 || ringerMode == 1) && this.mZenMode == 2) {
                newZen = 0;
            }
            if (newZen != -1) {
                ZenLog.traceFollowRingerMode(ringerMode, this.mZenMode, newZen);
                this.setZenMode(newZen, "ringerMode");
            }
        }
    }

    private void dispatchOnConfigChanged() {
        for (Callback callback : this.mCallbacks) {
            callback.onConfigChanged();
        }
    }

    private void dispatchOnZenModeChanged() {
        for (Callback callback : this.mCallbacks) {
            callback.onZenModeChanged();
        }
    }

    private static boolean isSystem(NotificationRecord record) {
        return record.isCategory("sys");
    }

    private static boolean isAlarm(NotificationRecord record) {
        return record.isCategory("alarm") || record.isAudioStream(4) || record.isAudioAttributesUsage(4);
    }

    private static boolean isEvent(NotificationRecord record) {
        return record.isCategory("event");
    }

    public boolean isCall(NotificationRecord record) {
        return record != null && (this.isDefaultPhoneApp(record.sbn.getPackageName()) || record.isCategory("call"));
    }

    private boolean isDefaultPhoneApp(String pkg) {
        if (this.mDefaultPhoneApp == null) {
            TelecomManager telecomm = (TelecomManager)this.mContext.getSystemService("telecom");
            ComponentName componentName = this.mDefaultPhoneApp = telecomm != null ? telecomm.getDefaultPhoneApp() : null;
            if (DEBUG) {
                Slog.d(TAG, "Default phone app: " + this.mDefaultPhoneApp);
            }
        }
        return pkg != null && this.mDefaultPhoneApp != null && pkg.equals(this.mDefaultPhoneApp.getPackageName());
    }

    private boolean isDefaultMessagingApp(NotificationRecord record) {
        int userId = record.getUserId();
        if (userId == -10000 || userId == -1) {
            return false;
        }
        String defaultApp = Settings.Secure.getStringForUser(this.mContext.getContentResolver(), "sms_default_application", userId);
        return Objects.equals(defaultApp, record.sbn.getPackageName());
    }

    private boolean isMessage(NotificationRecord record) {
        return record.isCategory("msg") || this.isDefaultMessagingApp(record);
    }

    public boolean matchesCallFilter(UserHandle userHandle, Bundle extras, ValidateNotificationPeople validator, int contactsTimeoutMs, float timeoutAffinity) {
        int zen = this.mZenMode;
        if (zen == 2) {
            return false;
        }
        if (zen == 1) {
            if (!this.mConfig.allowCalls) {
                return false;
            }
            if (validator != null) {
                float contactAffinity = validator.getContactAffinity(userHandle, extras, contactsTimeoutMs, timeoutAffinity);
                return this.audienceMatches(contactAffinity);
            }
        }
        return true;
    }

    private boolean audienceMatches(float contactAffinity) {
        switch (this.mConfig.allowFrom) {
            case 0: {
                return true;
            }
            case 1: {
                return contactAffinity >= 0.5f;
            }
            case 2: {
                return contactAffinity >= 1.0f;
            }
        }
        Slog.w(TAG, "Encountered unknown source: " + this.mConfig.allowFrom);
        return true;
    }

    public static class Callback {
        void onConfigChanged() {
        }

        void onZenModeChanged() {
        }
    }

    private class SettingsObserver
    extends ContentObserver {
        private final Uri ZEN_MODE;

        public SettingsObserver(Handler handler) {
            super(handler);
            this.ZEN_MODE = Settings.Global.getUriFor("zen_mode");
        }

        public void observe() {
            ContentResolver resolver = ZenModeHelper.this.mContext.getContentResolver();
            resolver.registerContentObserver(this.ZEN_MODE, false, this);
            this.update(null);
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            this.update(uri);
        }

        public void update(Uri uri) {
            if (this.ZEN_MODE.equals(uri)) {
                ZenModeHelper.this.updateZenMode();
            }
        }
    }
}

