/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.pm.PackageParser;
import android.util.ArraySet;
import android.util.Base64;
import android.util.LongSparseArray;
import android.util.Slog;
import com.android.server.pm.KeySetHandle;
import com.android.server.pm.PackageManagerService;
import com.android.server.pm.PackageSetting;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.PublicKey;
import java.util.Map;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class KeySetManagerService {
    static final String TAG = "KeySetManagerService";
    public static final int FIRST_VERSION = 1;
    public static final int CURRENT_VERSION = 1;
    public static final long KEYSET_NOT_FOUND = -1L;
    protected static final long PUBLIC_KEY_NOT_FOUND = -1L;
    private final LongSparseArray<KeySetHandle> mKeySets = new LongSparseArray();
    private final LongSparseArray<PublicKey> mPublicKeys = new LongSparseArray();
    protected final LongSparseArray<ArraySet<Long>> mKeySetMapping = new LongSparseArray();
    private final Map<String, PackageSetting> mPackages;
    private static long lastIssuedKeySetId = 0L;
    private static long lastIssuedKeyId = 0L;

    public KeySetManagerService(Map<String, PackageSetting> packages) {
        this.mPackages = packages;
    }

    public boolean packageIsSignedByLPr(String packageName, KeySetHandle ks) {
        PackageSetting pkg = this.mPackages.get(packageName);
        if (pkg == null) {
            throw new NullPointerException("Invalid package name");
        }
        if (pkg.keySetData == null) {
            throw new NullPointerException("Package has no KeySet data");
        }
        long id2 = this.getIdByKeySetLPr(ks);
        if (id2 == -1L) {
            return false;
        }
        return pkg.keySetData.packageIsSignedBy(id2);
    }

    public boolean packageIsSignedByExactlyLPr(String packageName, KeySetHandle ks) {
        PackageSetting pkg = this.mPackages.get(packageName);
        if (pkg == null) {
            throw new NullPointerException("Invalid package name");
        }
        if (pkg.keySetData == null || pkg.keySetData.getProperSigningKeySet() == -1L) {
            throw new NullPointerException("Package has no KeySet data");
        }
        long id2 = this.getIdByKeySetLPr(ks);
        return pkg.keySetData.getProperSigningKeySet() == id2;
    }

    public void addDefinedKeySetToPackageLPw(String packageName, ArraySet<PublicKey> keys, String alias) {
        if (packageName == null || keys == null || alias == null) {
            Slog.w(TAG, "Got null argument for a defined keyset, ignoring!");
            return;
        }
        PackageSetting pkg = this.mPackages.get(packageName);
        if (pkg == null) {
            throw new NullPointerException("Unknown package");
        }
        KeySetHandle ks = this.addKeySetLPw(keys);
        long id2 = this.getIdByKeySetLPr(ks);
        pkg.keySetData.addDefinedKeySet(id2, alias);
    }

    public void addUpgradeKeySetToPackageLPw(String packageName, String alias) {
        if (packageName == null || alias == null) {
            Slog.w(TAG, "Got null argument for a defined keyset, ignoring!");
            return;
        }
        PackageSetting pkg = this.mPackages.get(packageName);
        if (pkg == null) {
            throw new NullPointerException("Unknown package");
        }
        pkg.keySetData.addUpgradeKeySet(alias);
    }

    public void addSigningKeySetToPackageLPw(String packageName, ArraySet<PublicKey> signingKeys) {
        if (packageName == null || signingKeys == null) {
            Slog.w(TAG, "Got null argument for a signing keyset, ignoring!");
            return;
        }
        KeySetHandle ks = this.addKeySetLPw(signingKeys);
        long id2 = this.getIdByKeySetLPr(ks);
        ArraySet<Long> publicKeyIds = this.mKeySetMapping.get(id2);
        if (publicKeyIds == null) {
            throw new NullPointerException("Got invalid KeySet id");
        }
        PackageSetting pkg = this.mPackages.get(packageName);
        if (pkg == null) {
            throw new NullPointerException("No such package!");
        }
        pkg.keySetData.setProperSigningKeySet(id2);
        for (int keySetIndex = 0; keySetIndex < this.mKeySets.size(); ++keySetIndex) {
            long keySetID = this.mKeySets.keyAt(keySetIndex);
            ArraySet<Long> definedKeys = this.mKeySetMapping.get(keySetID);
            if (!publicKeyIds.containsAll(definedKeys)) continue;
            pkg.keySetData.addSigningKeySet(keySetID);
        }
    }

    private long getIdByKeySetLPr(KeySetHandle ks) {
        for (int keySetIndex = 0; keySetIndex < this.mKeySets.size(); ++keySetIndex) {
            KeySetHandle value = this.mKeySets.valueAt(keySetIndex);
            if (!ks.equals(value)) continue;
            return this.mKeySets.keyAt(keySetIndex);
        }
        return -1L;
    }

    public KeySetHandle getKeySetByIdLPr(long id2) {
        return this.mKeySets.get(id2);
    }

    public KeySetHandle getKeySetByAliasAndPackageNameLPr(String packageName, String alias) {
        PackageSetting p = this.mPackages.get(packageName);
        if (p == null || p.keySetData == null) {
            return null;
        }
        Long keySetId = p.keySetData.getAliases().get(alias);
        if (keySetId == null) {
            throw new IllegalArgumentException("Unknown KeySet alias: " + alias);
        }
        return this.mKeySets.get(keySetId);
    }

    public ArraySet<PublicKey> getPublicKeysFromKeySetLPr(long id2) {
        if (this.mKeySetMapping.get(id2) == null) {
            return null;
        }
        ArraySet<PublicKey> mPubKeys = new ArraySet<PublicKey>();
        for (long pkId : this.mKeySetMapping.get(id2)) {
            mPubKeys.add(this.mPublicKeys.get(pkId));
        }
        return mPubKeys;
    }

    public KeySetHandle getSigningKeySetByPackageNameLPr(String packageName) {
        PackageSetting p = this.mPackages.get(packageName);
        if (p == null || p.keySetData == null || p.keySetData.getProperSigningKeySet() == -1L) {
            return null;
        }
        return this.mKeySets.get(p.keySetData.getProperSigningKeySet());
    }

    public ArraySet<KeySetHandle> getUpgradeKeySetsByPackageNameLPr(String packageName) {
        ArraySet<KeySetHandle> upgradeKeySets = new ArraySet<KeySetHandle>();
        PackageSetting p = this.mPackages.get(packageName);
        if (p == null) {
            throw new NullPointerException("Unknown package");
        }
        if (p.keySetData == null) {
            throw new IllegalArgumentException("Package has no keySet data");
        }
        if (p.keySetData.isUsingUpgradeKeySets()) {
            for (long l : p.keySetData.getUpgradeKeySets()) {
                upgradeKeySets.add(this.mKeySets.get(l));
            }
        }
        return upgradeKeySets;
    }

    private KeySetHandle addKeySetLPw(ArraySet<PublicKey> keys) {
        if (keys == null) {
            throw new NullPointerException("Provided keys cannot be null");
        }
        ArraySet<Long> addedKeyIds = new ArraySet<Long>(keys.size());
        for (PublicKey k : keys) {
            long id2 = this.addPublicKeyLPw(k);
            addedKeyIds.add(id2);
        }
        long existingKeySetId = this.getIdFromKeyIdsLPr(addedKeyIds);
        if (existingKeySetId != -1L) {
            return this.mKeySets.get(existingKeySetId);
        }
        KeySetHandle ks = new KeySetHandle();
        long id3 = this.getFreeKeySetIDLPw();
        this.mKeySets.put(id3, ks);
        this.mKeySetMapping.put(id3, addedKeyIds);
        for (String pkgName : this.mPackages.keySet()) {
            ArraySet<Long> pSigningKeys;
            long pProperSigning;
            PackageSetting p = this.mPackages.get(pkgName);
            if (p.keySetData == null || (pProperSigning = p.keySetData.getProperSigningKeySet()) == -1L || !(pSigningKeys = this.mKeySetMapping.get(pProperSigning)).containsAll(addedKeyIds)) continue;
            p.keySetData.addSigningKeySet(id3);
        }
        return ks;
    }

    private long addPublicKeyLPw(PublicKey key) {
        long existingKeyId = this.getIdForPublicKeyLPr(key);
        if (existingKeyId != -1L) {
            return existingKeyId;
        }
        long id2 = this.getFreePublicKeyIdLPw();
        this.mPublicKeys.put(id2, key);
        return id2;
    }

    private long getIdFromKeyIdsLPr(Set<Long> publicKeyIds) {
        for (int keyMapIndex = 0; keyMapIndex < this.mKeySetMapping.size(); ++keyMapIndex) {
            ArraySet<Long> value = this.mKeySetMapping.valueAt(keyMapIndex);
            if (!value.equals(publicKeyIds)) continue;
            return this.mKeySetMapping.keyAt(keyMapIndex);
        }
        return -1L;
    }

    private long getIdForPublicKeyLPr(PublicKey k) {
        String encodedPublicKey = new String(k.getEncoded());
        for (int publicKeyIndex = 0; publicKeyIndex < this.mPublicKeys.size(); ++publicKeyIndex) {
            PublicKey value = this.mPublicKeys.valueAt(publicKeyIndex);
            String encodedExistingKey = new String(value.getEncoded());
            if (!encodedPublicKey.equals(encodedExistingKey)) continue;
            return this.mPublicKeys.keyAt(publicKeyIndex);
        }
        return -1L;
    }

    private long getFreeKeySetIDLPw() {
        return ++lastIssuedKeySetId;
    }

    private long getFreePublicKeyIdLPw() {
        return ++lastIssuedKeyId;
    }

    public void removeAppKeySetDataLPw(String packageName) {
        ArraySet<Long> deletableKeySets = this.getOriginalKeySetsByPackageNameLPr(packageName);
        ArraySet deletableKeys = new ArraySet();
        ArraySet<Long> knownKeys = null;
        for (Long ks : deletableKeySets) {
            knownKeys = this.mKeySetMapping.get(ks);
            if (knownKeys == null) continue;
            deletableKeys.addAll(knownKeys);
        }
        for (String pkgName : this.mPackages.keySet()) {
            if (pkgName.equals(packageName)) continue;
            ArraySet<Long> knownKeySets = this.getOriginalKeySetsByPackageNameLPr(pkgName);
            deletableKeySets.removeAll(knownKeySets);
            knownKeys = new ArraySet();
            for (Long ks : knownKeySets) {
                knownKeys = this.mKeySetMapping.get(ks);
                if (knownKeys == null) continue;
                deletableKeys.removeAll(knownKeys);
            }
        }
        for (Long ks : deletableKeySets) {
            this.mKeySets.delete(ks);
            this.mKeySetMapping.delete(ks);
        }
        for (Long keyId : deletableKeys) {
            this.mPublicKeys.delete(keyId);
        }
        for (String pkgName : this.mPackages.keySet()) {
            PackageSetting p = this.mPackages.get(pkgName);
            for (Long ks : deletableKeySets) {
                p.keySetData.removeSigningKeySet(ks);
            }
        }
        PackageSetting p = this.mPackages.get(packageName);
        this.clearPackageKeySetDataLPw(p);
    }

    private void clearPackageKeySetDataLPw(PackageSetting p) {
        p.keySetData.removeAllSigningKeySets();
        p.keySetData.removeAllUpgradeKeySets();
        p.keySetData.removeAllDefinedKeySets();
    }

    private ArraySet<Long> getOriginalKeySetsByPackageNameLPr(String packageName) {
        PackageSetting p = this.mPackages.get(packageName);
        if (p == null) {
            throw new NullPointerException("Unknown package");
        }
        if (p.keySetData == null) {
            throw new IllegalArgumentException("Package has no keySet data");
        }
        ArraySet<Long> knownKeySets = new ArraySet<Long>();
        knownKeySets.add(p.keySetData.getProperSigningKeySet());
        if (p.keySetData.isUsingDefinedKeySets()) {
            for (long ks : p.keySetData.getDefinedKeySets()) {
                knownKeySets.add(ks);
            }
        }
        return knownKeySets;
    }

    public String encodePublicKey(PublicKey k) throws IOException {
        return new String(Base64.encode(k.getEncoded(), 0));
    }

    public void dumpLPr(PrintWriter pw, String packageName, PackageManagerService.DumpState dumpState) {
        boolean printedHeader = false;
        for (Map.Entry<String, PackageSetting> e : this.mPackages.entrySet()) {
            String keySetPackage = e.getKey();
            if (packageName != null && !packageName.equals(keySetPackage)) continue;
            if (!printedHeader) {
                if (dumpState.onTitlePrinted()) {
                    pw.println();
                }
                pw.println("Key Set Manager:");
                printedHeader = true;
            }
            PackageSetting pkg = e.getValue();
            pw.print("  [");
            pw.print(keySetPackage);
            pw.println("]");
            if (pkg.keySetData == null) continue;
            boolean printedLabel = false;
            for (Map.Entry<String, Long> entry : pkg.keySetData.getAliases().entrySet()) {
                if (!printedLabel) {
                    pw.print("      KeySets Aliases: ");
                    printedLabel = true;
                } else {
                    pw.print(", ");
                }
                pw.print(entry.getKey());
                pw.print('=');
                pw.print(Long.toString(entry.getValue()));
            }
            if (printedLabel) {
                pw.println("");
            }
            printedLabel = false;
            if (pkg.keySetData.isUsingDefinedKeySets()) {
                for (long keySetId : pkg.keySetData.getDefinedKeySets()) {
                    if (!printedLabel) {
                        pw.print("      Defined KeySets: ");
                        printedLabel = true;
                    } else {
                        pw.print(", ");
                    }
                    pw.print(Long.toString(keySetId));
                }
            }
            if (printedLabel) {
                pw.println("");
            }
            printedLabel = false;
            long[] signingKeySets = pkg.keySetData.getSigningKeySets();
            if (signingKeySets != null) {
                for (long keySetId : signingKeySets) {
                    if (!printedLabel) {
                        pw.print("      Signing KeySets: ");
                        printedLabel = true;
                    } else {
                        pw.print(", ");
                    }
                    pw.print(Long.toString(keySetId));
                }
            }
            if (printedLabel) {
                pw.println("");
            }
            printedLabel = false;
            if (pkg.keySetData.isUsingUpgradeKeySets()) {
                for (long keySetId : pkg.keySetData.getUpgradeKeySets()) {
                    if (!printedLabel) {
                        pw.print("      Upgrade KeySets: ");
                        printedLabel = true;
                    } else {
                        pw.print(", ");
                    }
                    pw.print(Long.toString(keySetId));
                }
            }
            if (!printedLabel) continue;
            pw.println("");
        }
    }

    void writeKeySetManagerServiceLPr(XmlSerializer serializer) throws IOException {
        serializer.startTag(null, "keyset-settings");
        serializer.attribute(null, "version", Integer.toString(1));
        this.writePublicKeysLPr(serializer);
        this.writeKeySetsLPr(serializer);
        serializer.startTag(null, "lastIssuedKeyId");
        serializer.attribute(null, "value", Long.toString(lastIssuedKeyId));
        serializer.endTag(null, "lastIssuedKeyId");
        serializer.startTag(null, "lastIssuedKeySetId");
        serializer.attribute(null, "value", Long.toString(lastIssuedKeySetId));
        serializer.endTag(null, "lastIssuedKeySetId");
        serializer.endTag(null, "keyset-settings");
    }

    void writePublicKeysLPr(XmlSerializer serializer) throws IOException {
        serializer.startTag(null, "keys");
        for (int pKeyIndex = 0; pKeyIndex < this.mPublicKeys.size(); ++pKeyIndex) {
            long id2 = this.mPublicKeys.keyAt(pKeyIndex);
            PublicKey key = this.mPublicKeys.valueAt(pKeyIndex);
            String encodedKey = this.encodePublicKey(key);
            serializer.startTag(null, "public-key");
            serializer.attribute(null, "identifier", Long.toString(id2));
            serializer.attribute(null, "value", encodedKey);
            serializer.endTag(null, "public-key");
        }
        serializer.endTag(null, "keys");
    }

    void writeKeySetsLPr(XmlSerializer serializer) throws IOException {
        serializer.startTag(null, "keysets");
        for (int keySetIndex = 0; keySetIndex < this.mKeySetMapping.size(); ++keySetIndex) {
            long id2 = this.mKeySetMapping.keyAt(keySetIndex);
            ArraySet<Long> keys = this.mKeySetMapping.valueAt(keySetIndex);
            serializer.startTag(null, "keyset");
            serializer.attribute(null, "identifier", Long.toString(id2));
            for (long keyId : keys) {
                serializer.startTag(null, "key-id");
                serializer.attribute(null, "identifier", Long.toString(keyId));
                serializer.endTag(null, "key-id");
            }
            serializer.endTag(null, "keyset");
        }
        serializer.endTag(null, "keysets");
    }

    void readKeySetsLPw(XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        long currentKeySetId = 0L;
        int outerDepth = parser.getDepth();
        String recordedVersion = parser.getAttributeValue(null, "version");
        if (recordedVersion == null || Integer.parseInt(recordedVersion) != 1) {
            int type2;
            while ((type2 = parser.next()) != 1 && (type2 != 3 || parser.getDepth() > outerDepth)) {
            }
            for (PackageSetting p : this.mPackages.values()) {
                this.clearPackageKeySetDataLPw(p);
            }
            return;
        }
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals("keys")) {
                this.readKeysLPw(parser);
                continue;
            }
            if (tagName.equals("keysets")) {
                this.readKeySetListLPw(parser);
                continue;
            }
            if (tagName.equals("lastIssuedKeyId")) {
                lastIssuedKeyId = Long.parseLong(parser.getAttributeValue(null, "value"));
                continue;
            }
            if (!tagName.equals("lastIssuedKeySetId")) continue;
            lastIssuedKeySetId = Long.parseLong(parser.getAttributeValue(null, "value"));
        }
    }

    void readKeysLPw(XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            String tagName;
            if (type == 3 || type == 4 || !(tagName = parser.getName()).equals("public-key")) continue;
            this.readPublicKeyLPw(parser);
        }
    }

    void readKeySetListLPw(XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        long currentKeySetId = 0L;
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals("keyset")) {
                currentKeySetId = this.readIdentifierLPw(parser);
                this.mKeySets.put(currentKeySetId, new KeySetHandle());
                this.mKeySetMapping.put(currentKeySetId, new ArraySet());
                continue;
            }
            if (!tagName.equals("key-id")) continue;
            long id2 = this.readIdentifierLPw(parser);
            this.mKeySetMapping.get(currentKeySetId).add(id2);
        }
    }

    long readIdentifierLPw(XmlPullParser parser) throws XmlPullParserException {
        return Long.parseLong(parser.getAttributeValue(null, "identifier"));
    }

    void readPublicKeyLPw(XmlPullParser parser) throws XmlPullParserException {
        String encodedID = parser.getAttributeValue(null, "identifier");
        long identifier = Long.parseLong(encodedID);
        String encodedPublicKey = parser.getAttributeValue(null, "value");
        PublicKey pub = PackageParser.parsePublicKey(encodedPublicKey);
        if (pub != null) {
            this.mPublicKeys.put(identifier, pub);
        }
    }
}

