/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.app.AppGlobals;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ILauncherApps;
import android.content.pm.IOnAppsChangedListener;
import android.content.pm.IPackageManager;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.UserInfo;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.UserManager;
import android.util.Slog;
import com.android.internal.content.PackageMonitor;
import com.android.server.SystemService;
import java.util.ArrayList;
import java.util.List;

public class LauncherAppsService
extends SystemService {
    private final LauncherAppsImpl mLauncherAppsImpl;

    public LauncherAppsService(Context context) {
        super(context);
        this.mLauncherAppsImpl = new LauncherAppsImpl(context);
    }

    @Override
    public void onStart() {
        this.publishBinderService("launcherapps", (IBinder)((Object)this.mLauncherAppsImpl));
    }

    class LauncherAppsImpl
    extends ILauncherApps.Stub {
        private static final boolean DEBUG = false;
        private static final String TAG = "LauncherAppsService";
        private final Context mContext;
        private final PackageManager mPm;
        private final UserManager mUm;
        private final PackageCallbackList<IOnAppsChangedListener> mListeners = new PackageCallbackList();
        private MyPackageMonitor mPackageMonitor = new MyPackageMonitor();

        public LauncherAppsImpl(Context context) {
            this.mContext = context;
            this.mPm = this.mContext.getPackageManager();
            this.mUm = (UserManager)this.mContext.getSystemService("user");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addOnAppsChangedListener(IOnAppsChangedListener listener) throws RemoteException {
            PackageCallbackList<IOnAppsChangedListener> packageCallbackList = this.mListeners;
            synchronized (packageCallbackList) {
                if (this.mListeners.getRegisteredCallbackCount() == 0) {
                    this.startWatchingPackageBroadcasts();
                }
                this.mListeners.unregister(listener);
                this.mListeners.register(listener, Binder.getCallingUserHandle());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeOnAppsChangedListener(IOnAppsChangedListener listener) throws RemoteException {
            PackageCallbackList<IOnAppsChangedListener> packageCallbackList = this.mListeners;
            synchronized (packageCallbackList) {
                this.mListeners.unregister(listener);
                if (this.mListeners.getRegisteredCallbackCount() == 0) {
                    this.stopWatchingPackageBroadcasts();
                }
            }
        }

        private void startWatchingPackageBroadcasts() {
            this.mPackageMonitor.register(this.mContext, null, UserHandle.ALL, true);
        }

        private void stopWatchingPackageBroadcasts() {
            this.mPackageMonitor.unregister();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void checkCallbackCount() {
            PackageCallbackList<IOnAppsChangedListener> packageCallbackList = this.mListeners;
            synchronized (packageCallbackList) {
                if (this.mListeners.getRegisteredCallbackCount() == 0) {
                    this.stopWatchingPackageBroadcasts();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void ensureInUserProfiles(UserHandle userToCheck, String message) {
            int callingUserId = UserHandle.getCallingUserId();
            int targetUserId = userToCheck.getIdentifier();
            if (targetUserId == callingUserId) {
                return;
            }
            long ident = Binder.clearCallingIdentity();
            try {
                UserInfo callingUserInfo = this.mUm.getUserInfo(callingUserId);
                UserInfo targetUserInfo = this.mUm.getUserInfo(targetUserId);
                if (targetUserInfo == null || targetUserInfo.profileGroupId == -1 || targetUserInfo.profileGroupId != callingUserInfo.profileGroupId) {
                    throw new SecurityException(message);
                }
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isUserEnabled(UserHandle user) {
            long ident = Binder.clearCallingIdentity();
            try {
                UserInfo targetUserInfo = this.mUm.getUserInfo(user.getIdentifier());
                boolean bl = targetUserInfo != null && targetUserInfo.isEnabled();
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<ResolveInfo> getLauncherActivities(String packageName, UserHandle user) throws RemoteException {
            this.ensureInUserProfiles(user, "Cannot retrieve activities for unrelated profile " + user);
            if (!this.isUserEnabled(user)) {
                return new ArrayList<ResolveInfo>();
            }
            Intent mainIntent = new Intent("android.intent.action.MAIN", null);
            mainIntent.addCategory("android.intent.category.LAUNCHER");
            mainIntent.setPackage(packageName);
            long ident = Binder.clearCallingIdentity();
            try {
                List<ResolveInfo> apps;
                List<ResolveInfo> list = apps = this.mPm.queryIntentActivitiesAsUser(mainIntent, 0, user.getIdentifier());
                return list;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ResolveInfo resolveActivity(Intent intent, UserHandle user) throws RemoteException {
            this.ensureInUserProfiles(user, "Cannot resolve activity for unrelated profile " + user);
            if (!this.isUserEnabled(user)) {
                return null;
            }
            long ident = Binder.clearCallingIdentity();
            try {
                ResolveInfo app;
                ResolveInfo resolveInfo = app = this.mPm.resolveActivityAsUser(intent, 0, user.getIdentifier());
                return resolveInfo;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isPackageEnabled(String packageName, UserHandle user) throws RemoteException {
            this.ensureInUserProfiles(user, "Cannot check package for unrelated profile " + user);
            if (!this.isUserEnabled(user)) {
                return false;
            }
            long ident = Binder.clearCallingIdentity();
            try {
                IPackageManager pm = AppGlobals.getPackageManager();
                PackageInfo info = pm.getPackageInfo(packageName, 0, user.getIdentifier());
                boolean bl = info != null && info.applicationInfo.enabled;
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isActivityEnabled(ComponentName component, UserHandle user) throws RemoteException {
            this.ensureInUserProfiles(user, "Cannot check component for unrelated profile " + user);
            if (!this.isUserEnabled(user)) {
                return false;
            }
            long ident = Binder.clearCallingIdentity();
            try {
                IPackageManager pm = AppGlobals.getPackageManager();
                ActivityInfo info = pm.getActivityInfo(component, 0, user.getIdentifier());
                boolean bl = info != null;
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        public void startActivityAsUser(ComponentName component, Rect sourceBounds, Bundle opts, UserHandle user) throws RemoteException {
            this.ensureInUserProfiles(user, "Cannot start activity for unrelated profile " + user);
            if (!this.isUserEnabled(user)) {
                throw new IllegalStateException("Cannot start activity for disabled profile " + user);
            }
            Intent launchIntent = new Intent("android.intent.action.MAIN");
            launchIntent.addCategory("android.intent.category.LAUNCHER");
            launchIntent.setSourceBounds(sourceBounds);
            launchIntent.addFlags(0x10000000);
            launchIntent.setPackage(component.getPackageName());
            long ident = Binder.clearCallingIdentity();
            try {
                IPackageManager pm = AppGlobals.getPackageManager();
                ActivityInfo info = pm.getActivityInfo(component, 0, user.getIdentifier());
                if (!info.exported) {
                    throw new SecurityException("Cannot launch non-exported components " + component);
                }
                List<ResolveInfo> apps = this.mPm.queryIntentActivitiesAsUser(launchIntent, 0, user.getIdentifier());
                int size = apps.size();
                for (int i = 0; i < size; ++i) {
                    ActivityInfo activityInfo = apps.get((int)i).activityInfo;
                    if (!activityInfo.packageName.equals(component.getPackageName()) || !activityInfo.name.equals(component.getClassName())) continue;
                    launchIntent.setComponent(component);
                    this.mContext.startActivityAsUser(launchIntent, opts, user);
                    return;
                }
                throw new SecurityException("Attempt to launch activity without  category Intent.CATEGORY_LAUNCHER " + component);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void showAppDetailsAsUser(ComponentName component, Rect sourceBounds, Bundle opts, UserHandle user) throws RemoteException {
            this.ensureInUserProfiles(user, "Cannot show app details for unrelated profile " + user);
            if (!this.isUserEnabled(user)) {
                throw new IllegalStateException("Cannot show app details for disabled profile " + user);
            }
            long ident = Binder.clearCallingIdentity();
            try {
                String packageName = component.getPackageName();
                Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS", Uri.fromParts("package", packageName, null));
                intent.setFlags(0x10808000);
                intent.setSourceBounds(sourceBounds);
                this.mContext.startActivityAsUser(intent, opts, user);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        class PackageCallbackList<T extends IInterface>
        extends RemoteCallbackList<T> {
            PackageCallbackList() {
            }

            @Override
            public void onCallbackDied(T callback, Object cookie) {
                LauncherAppsImpl.this.checkCallbackCount();
            }
        }

        private class MyPackageMonitor
        extends PackageMonitor {
            private MyPackageMonitor() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isEnabledProfileOf(UserHandle user, UserHandle listeningUser, String debugMsg) {
                if (user.getIdentifier() == listeningUser.getIdentifier()) {
                    return true;
                }
                long ident = Binder.clearCallingIdentity();
                try {
                    UserInfo userInfo = LauncherAppsImpl.this.mUm.getUserInfo(user.getIdentifier());
                    UserInfo listeningUserInfo = LauncherAppsImpl.this.mUm.getUserInfo(listeningUser.getIdentifier());
                    if (userInfo == null || listeningUserInfo == null || userInfo.profileGroupId == -1 || userInfo.profileGroupId != listeningUserInfo.profileGroupId || !userInfo.isEnabled()) {
                        boolean bl = false;
                        return bl;
                    }
                    boolean bl = true;
                    return bl;
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            }

            @Override
            public void onPackageAdded(String packageName, int uid) {
                UserHandle user = new UserHandle(this.getChangingUserId());
                int n = LauncherAppsImpl.this.mListeners.beginBroadcast();
                for (int i = 0; i < n; ++i) {
                    IOnAppsChangedListener listener = (IOnAppsChangedListener)LauncherAppsImpl.this.mListeners.getBroadcastItem(i);
                    UserHandle listeningUser = (UserHandle)LauncherAppsImpl.this.mListeners.getBroadcastCookie(i);
                    if (!this.isEnabledProfileOf(user, listeningUser, "onPackageAdded")) continue;
                    try {
                        listener.onPackageAdded(user, packageName);
                        continue;
                    }
                    catch (RemoteException re) {
                        Slog.d(LauncherAppsImpl.TAG, "Callback failed ", re);
                    }
                }
                LauncherAppsImpl.this.mListeners.finishBroadcast();
                super.onPackageAdded(packageName, uid);
            }

            @Override
            public void onPackageRemoved(String packageName, int uid) {
                UserHandle user = new UserHandle(this.getChangingUserId());
                int n = LauncherAppsImpl.this.mListeners.beginBroadcast();
                for (int i = 0; i < n; ++i) {
                    IOnAppsChangedListener listener = (IOnAppsChangedListener)LauncherAppsImpl.this.mListeners.getBroadcastItem(i);
                    UserHandle listeningUser = (UserHandle)LauncherAppsImpl.this.mListeners.getBroadcastCookie(i);
                    if (!this.isEnabledProfileOf(user, listeningUser, "onPackageRemoved")) continue;
                    try {
                        listener.onPackageRemoved(user, packageName);
                        continue;
                    }
                    catch (RemoteException re) {
                        Slog.d(LauncherAppsImpl.TAG, "Callback failed ", re);
                    }
                }
                LauncherAppsImpl.this.mListeners.finishBroadcast();
                super.onPackageRemoved(packageName, uid);
            }

            @Override
            public void onPackageModified(String packageName) {
                UserHandle user = new UserHandle(this.getChangingUserId());
                int n = LauncherAppsImpl.this.mListeners.beginBroadcast();
                for (int i = 0; i < n; ++i) {
                    IOnAppsChangedListener listener = (IOnAppsChangedListener)LauncherAppsImpl.this.mListeners.getBroadcastItem(i);
                    UserHandle listeningUser = (UserHandle)LauncherAppsImpl.this.mListeners.getBroadcastCookie(i);
                    if (!this.isEnabledProfileOf(user, listeningUser, "onPackageModified")) continue;
                    try {
                        listener.onPackageChanged(user, packageName);
                        continue;
                    }
                    catch (RemoteException re) {
                        Slog.d(LauncherAppsImpl.TAG, "Callback failed ", re);
                    }
                }
                LauncherAppsImpl.this.mListeners.finishBroadcast();
                super.onPackageModified(packageName);
            }

            @Override
            public void onPackagesAvailable(String[] packages) {
                UserHandle user = new UserHandle(this.getChangingUserId());
                int n = LauncherAppsImpl.this.mListeners.beginBroadcast();
                for (int i = 0; i < n; ++i) {
                    IOnAppsChangedListener listener = (IOnAppsChangedListener)LauncherAppsImpl.this.mListeners.getBroadcastItem(i);
                    UserHandle listeningUser = (UserHandle)LauncherAppsImpl.this.mListeners.getBroadcastCookie(i);
                    if (!this.isEnabledProfileOf(user, listeningUser, "onPackagesAvailable")) continue;
                    try {
                        listener.onPackagesAvailable(user, packages, this.isReplacing());
                        continue;
                    }
                    catch (RemoteException re) {
                        Slog.d(LauncherAppsImpl.TAG, "Callback failed ", re);
                    }
                }
                LauncherAppsImpl.this.mListeners.finishBroadcast();
                super.onPackagesAvailable(packages);
            }

            @Override
            public void onPackagesUnavailable(String[] packages) {
                UserHandle user = new UserHandle(this.getChangingUserId());
                int n = LauncherAppsImpl.this.mListeners.beginBroadcast();
                for (int i = 0; i < n; ++i) {
                    IOnAppsChangedListener listener = (IOnAppsChangedListener)LauncherAppsImpl.this.mListeners.getBroadcastItem(i);
                    UserHandle listeningUser = (UserHandle)LauncherAppsImpl.this.mListeners.getBroadcastCookie(i);
                    if (!this.isEnabledProfileOf(user, listeningUser, "onPackagesUnavailable")) continue;
                    try {
                        listener.onPackagesUnavailable(user, packages, this.isReplacing());
                        continue;
                    }
                    catch (RemoteException re) {
                        Slog.d(LauncherAppsImpl.TAG, "Callback failed ", re);
                    }
                }
                LauncherAppsImpl.this.mListeners.finishBroadcast();
                super.onPackagesUnavailable(packages);
            }
        }
    }
}

