/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageInstallObserver2;
import android.content.pm.IPackageInstallerSession;
import android.content.pm.PackageInstaller;
import android.content.pm.PackageParser;
import android.content.pm.Signature;
import android.os.Bundle;
import android.os.FileBridge;
import android.os.FileUtils;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.UserHandle;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructStat;
import android.util.ArraySet;
import android.util.ExceptionUtils;
import android.util.MathUtils;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.content.NativeLibraryHelper;
import com.android.internal.content.PackageHelper;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.Preconditions;
import com.android.server.pm.PackageInstallerService;
import com.android.server.pm.PackageManagerException;
import com.android.server.pm.PackageManagerService;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import libcore.io.IoUtils;
import libcore.io.Libcore;

public class PackageInstallerSession
extends IPackageInstallerSession.Stub {
    private static final String TAG = "PackageInstaller";
    private static final boolean LOGD = true;
    private static final int MSG_COMMIT = 0;
    private final PackageInstallerService.InternalCallback mCallback;
    private final Context mContext;
    private final PackageManagerService mPm;
    private final Handler mHandler;
    final int sessionId;
    final int userId;
    final String installerPackageName;
    final int installerUid;
    final PackageInstaller.SessionParams params;
    final long createdMillis;
    final File stageDir;
    final String stageCid;
    private final AtomicInteger mActiveCount = new AtomicInteger();
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private float mClientProgress = 0.0f;
    @GuardedBy(value="mLock")
    private float mInternalProgress = 0.0f;
    @GuardedBy(value="mLock")
    private float mProgress = 0.0f;
    @GuardedBy(value="mLock")
    private float mReportedProgress = -1.0f;
    @GuardedBy(value="mLock")
    private boolean mPrepared = false;
    @GuardedBy(value="mLock")
    private boolean mSealed = false;
    @GuardedBy(value="mLock")
    private boolean mPermissionsAccepted = false;
    @GuardedBy(value="mLock")
    private boolean mDestroyed = false;
    private int mFinalStatus;
    private String mFinalMessage;
    @GuardedBy(value="mLock")
    private ArrayList<FileBridge> mBridges = new ArrayList();
    @GuardedBy(value="mLock")
    private IPackageInstallObserver2 mRemoteObserver;
    private String mPackageName;
    private int mVersionCode;
    private Signature[] mSignatures;
    @GuardedBy(value="mLock")
    private File mResolvedBaseFile;
    @GuardedBy(value="mLock")
    private File mResolvedStageDir;
    @GuardedBy(value="mLock")
    private final List<File> mResolvedStagedFiles = new ArrayList<File>();
    @GuardedBy(value="mLock")
    private final List<File> mResolvedInheritedFiles = new ArrayList<File>();
    private final Handler.Callback mHandlerCallback = new Handler.Callback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean handleMessage(Message msg) {
            Object object = PackageInstallerSession.this.mLock;
            synchronized (object) {
                if (msg.obj != null) {
                    PackageInstallerSession.this.mRemoteObserver = (IPackageInstallObserver2)msg.obj;
                }
                try {
                    PackageInstallerSession.this.commitLocked();
                }
                catch (PackageManagerException e) {
                    String completeMsg = ExceptionUtils.getCompleteMessage(e);
                    Slog.e(PackageInstallerSession.TAG, "Commit of session " + PackageInstallerSession.this.sessionId + " failed: " + completeMsg);
                    PackageInstallerSession.this.destroyInternal();
                    PackageInstallerSession.this.dispatchSessionFinished(e.error, completeMsg, null);
                }
                return true;
            }
        }
    };

    public PackageInstallerSession(PackageInstallerService.InternalCallback callback, Context context, PackageManagerService pm, Looper looper, int sessionId, int userId, String installerPackageName, int installerUid, PackageInstaller.SessionParams params, long createdMillis, File stageDir, String stageCid, boolean prepared, boolean sealed) {
        this.mCallback = callback;
        this.mContext = context;
        this.mPm = pm;
        this.mHandler = new Handler(looper, this.mHandlerCallback);
        this.sessionId = sessionId;
        this.userId = userId;
        this.installerPackageName = installerPackageName;
        this.installerUid = installerUid;
        this.params = params;
        this.createdMillis = createdMillis;
        this.stageDir = stageDir;
        this.stageCid = stageCid;
        if (stageDir == null == (stageCid == null)) {
            throw new IllegalArgumentException("Exactly one of stageDir or stageCid stage must be set");
        }
        this.mPrepared = prepared;
        this.mSealed = sealed;
        this.mPermissionsAccepted = this.mPm.checkUidPermission("android.permission.INSTALL_PACKAGES", installerUid) == 0 || installerUid == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackageInstaller.SessionInfo generateInfo() {
        PackageInstaller.SessionInfo info = new PackageInstaller.SessionInfo();
        Object object = this.mLock;
        synchronized (object) {
            info.sessionId = this.sessionId;
            info.installerPackageName = this.installerPackageName;
            info.resolvedBaseCodePath = this.mResolvedBaseFile != null ? this.mResolvedBaseFile.getAbsolutePath() : null;
            info.progress = this.mProgress;
            info.sealed = this.mSealed;
            info.active = this.mActiveCount.get() > 0;
            info.mode = this.params.mode;
            info.sizeBytes = this.params.sizeBytes;
            info.appPackageName = this.params.appPackageName;
            info.appIcon = this.params.appIcon;
            info.appLabel = this.params.appLabel;
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPrepared() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mPrepared;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSealed() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mSealed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertPreparedAndNotSealed(String cookie) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mPrepared) {
                throw new IllegalStateException(cookie + " before prepared");
            }
            if (this.mSealed) {
                throw new SecurityException(cookie + " not allowed after commit");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File resolveStageDir() throws IOException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mResolvedStageDir == null) {
                if (this.stageDir != null) {
                    this.mResolvedStageDir = this.stageDir;
                } else {
                    String path = PackageHelper.getSdDir(this.stageCid);
                    if (path != null) {
                        this.mResolvedStageDir = new File(path);
                    } else {
                        throw new IOException("Failed to resolve path to container " + this.stageCid);
                    }
                }
            }
            return this.mResolvedStageDir;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClientProgress(float progress) {
        Object object = this.mLock;
        synchronized (object) {
            boolean forcePublish = this.mClientProgress == 0.0f;
            this.mClientProgress = progress;
            this.computeProgressLocked(forcePublish);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClientProgress(float progress) {
        Object object = this.mLock;
        synchronized (object) {
            this.setClientProgress(this.mClientProgress + progress);
        }
    }

    private void computeProgressLocked(boolean forcePublish) {
        this.mProgress = MathUtils.constrain(this.mClientProgress * 0.8f, 0.0f, 0.8f) + MathUtils.constrain(this.mInternalProgress * 0.2f, 0.0f, 0.2f);
        if (forcePublish || (double)Math.abs(this.mProgress - this.mReportedProgress) >= 0.01) {
            this.mReportedProgress = this.mProgress;
            this.mCallback.onSessionProgressChanged(this, this.mProgress);
        }
    }

    public String[] getNames() {
        this.assertPreparedAndNotSealed("getNames");
        try {
            return this.resolveStageDir().list();
        }
        catch (IOException e) {
            throw ExceptionUtils.wrap(e);
        }
    }

    public ParcelFileDescriptor openWrite(String name, long offsetBytes, long lengthBytes) {
        try {
            return this.openWriteInternal(name, offsetBytes, lengthBytes);
        }
        catch (IOException e) {
            throw ExceptionUtils.wrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParcelFileDescriptor openWriteInternal(String name, long offsetBytes, long lengthBytes) throws IOException {
        FileBridge bridge;
        Object object = this.mLock;
        synchronized (object) {
            this.assertPreparedAndNotSealed("openWrite");
            bridge = new FileBridge();
            this.mBridges.add(bridge);
        }
        try {
            if (!FileUtils.isValidExtFilename((String)name)) {
                throw new IllegalArgumentException("Invalid name: " + name);
            }
            File target = new File(this.resolveStageDir(), name);
            FileDescriptor targetFd = Libcore.os.open(target.getAbsolutePath(), OsConstants.O_CREAT | OsConstants.O_WRONLY, 420);
            Os.chmod(target.getAbsolutePath(), 420);
            if (lengthBytes > 0L) {
                StructStat stat = Libcore.os.fstat(targetFd);
                long deltaBytes = lengthBytes - stat.st_size;
                if (this.stageDir != null && deltaBytes > 0L) {
                    this.mPm.freeStorage(deltaBytes);
                }
                Libcore.os.posix_fallocate(targetFd, 0L, lengthBytes);
            }
            if (offsetBytes > 0L) {
                Libcore.os.lseek(targetFd, offsetBytes, OsConstants.SEEK_SET);
            }
            bridge.setTargetFile(targetFd);
            bridge.start();
            return new ParcelFileDescriptor(bridge.getClientSocket());
        }
        catch (ErrnoException e) {
            throw e.rethrowAsIOException();
        }
    }

    public ParcelFileDescriptor openRead(String name) {
        try {
            return this.openReadInternal(name);
        }
        catch (IOException e) {
            throw ExceptionUtils.wrap(e);
        }
    }

    private ParcelFileDescriptor openReadInternal(String name) throws IOException {
        this.assertPreparedAndNotSealed("openRead");
        try {
            if (!FileUtils.isValidExtFilename((String)name)) {
                throw new IllegalArgumentException("Invalid name: " + name);
            }
            File target = new File(this.resolveStageDir(), name);
            FileDescriptor targetFd = Libcore.os.open(target.getAbsolutePath(), OsConstants.O_RDONLY, 0);
            return new ParcelFileDescriptor(targetFd);
        }
        catch (ErrnoException e) {
            throw e.rethrowAsIOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(IntentSender statusReceiver) {
        boolean wasSealed;
        Preconditions.checkNotNull(statusReceiver);
        Object object = this.mLock;
        synchronized (object) {
            wasSealed = this.mSealed;
            if (!this.mSealed) {
                for (FileBridge bridge : this.mBridges) {
                    if (bridge.isClosed()) continue;
                    throw new SecurityException("Files still open");
                }
                this.mSealed = true;
            }
            this.mClientProgress = 1.0f;
            this.computeProgressLocked(true);
        }
        if (!wasSealed) {
            this.mCallback.onSessionSealedBlocking(this);
        }
        this.mActiveCount.incrementAndGet();
        PackageInstallerService.PackageInstallObserverAdapter adapter = new PackageInstallerService.PackageInstallObserverAdapter(this.mContext, statusReceiver, this.sessionId);
        this.mHandler.obtainMessage(0, adapter.getBinder()).sendToTarget();
    }

    private void commitLocked() throws PackageManagerException {
        if (this.mDestroyed) {
            throw new PackageManagerException(-110, "Session destroyed");
        }
        if (!this.mSealed) {
            throw new PackageManagerException(-110, "Session not sealed");
        }
        try {
            this.resolveStageDir();
        }
        catch (IOException e) {
            throw new PackageManagerException(-18, "Failed to resolve stage location", e);
        }
        this.validateInstallLocked();
        Preconditions.checkNotNull(this.mPackageName);
        Preconditions.checkNotNull(this.mSignatures);
        Preconditions.checkNotNull(this.mResolvedBaseFile);
        if (!this.mPermissionsAccepted) {
            Intent intent = new Intent("android.content.pm.action.CONFIRM_PERMISSIONS");
            intent.setPackage("com.android.packageinstaller");
            intent.putExtra("android.content.pm.extra.SESSION_ID", this.sessionId);
            try {
                this.mRemoteObserver.onUserActionRequired(intent);
            }
            catch (RemoteException ignored) {
                // empty catch block
            }
            this.close();
            return;
        }
        if (this.stageCid != null) {
            long finalSize = this.calculateInstalledSize();
            PackageInstallerSession.resizeContainer(this.stageCid, finalSize);
        }
        if (this.params.mode == 2) {
            try {
                if (this.stageCid != null) {
                    PackageInstallerSession.copyFiles(this.mResolvedInheritedFiles, this.resolveStageDir());
                } else {
                    PackageInstallerSession.linkFiles(this.mResolvedInheritedFiles, this.resolveStageDir());
                }
            }
            catch (IOException e) {
                throw new PackageManagerException(-4, "Failed to inherit existing install", e);
            }
        }
        this.mInternalProgress = 0.5f;
        this.computeProgressLocked(true);
        PackageInstallerSession.extractNativeLibraries(this.mResolvedStageDir, this.params.abiOverride);
        if (this.stageCid != null) {
            this.finalizeAndFixContainer(this.stageCid);
        }
        IPackageInstallObserver2.Stub localObserver = new IPackageInstallObserver2.Stub(){

            public void onUserActionRequired(Intent intent) {
                throw new IllegalStateException();
            }

            public void onPackageInstalled(String basePackageName, int returnCode, String msg, Bundle extras) {
                PackageInstallerSession.this.destroyInternal();
                PackageInstallerSession.this.dispatchSessionFinished(returnCode, msg, extras);
            }
        };
        UserHandle user = (this.params.installFlags & 0x40) != 0 ? UserHandle.ALL : new UserHandle(this.userId);
        this.mPm.installStage(this.mPackageName, this.stageDir, this.stageCid, (IPackageInstallObserver2)localObserver, this.params, this.installerPackageName, this.installerUid, user);
    }

    private void validateInstallLocked() throws PackageManagerException {
        this.mPackageName = null;
        this.mVersionCode = -1;
        this.mSignatures = null;
        this.mResolvedBaseFile = null;
        this.mResolvedStagedFiles.clear();
        this.mResolvedInheritedFiles.clear();
        Object[] files = this.mResolvedStageDir.listFiles();
        if (ArrayUtils.isEmpty((Object[])files)) {
            throw new PackageManagerException(-2, "No packages staged");
        }
        ArraySet<String> stagedSplits = new ArraySet<String>();
        for (Object file : files) {
            PackageParser.ApkLite apk;
            if (((File)file).isDirectory()) continue;
            try {
                apk = PackageParser.parseApkLite((File)file, (int)256);
            }
            catch (PackageParser.PackageParserException e) {
                throw PackageManagerException.from(e);
            }
            if (!stagedSplits.add(apk.splitName)) {
                throw new PackageManagerException(-2, "Split " + apk.splitName + " was defined multiple times");
            }
            if (this.mPackageName == null) {
                this.mPackageName = apk.packageName;
                this.mVersionCode = apk.versionCode;
            }
            if (this.mSignatures == null) {
                this.mSignatures = apk.signatures;
            }
            this.assertApkConsistent(String.valueOf(file), apk);
            String targetName = apk.splitName == null ? "base.apk" : "split_" + apk.splitName + ".apk";
            if (!FileUtils.isValidExtFilename((String)targetName)) {
                throw new PackageManagerException(-2, "Invalid filename: " + targetName);
            }
            File targetFile = new File(this.mResolvedStageDir, targetName);
            if (!((File)file).equals(targetFile)) {
                ((File)file).renameTo(targetFile);
            }
            if (apk.splitName == null) {
                this.mResolvedBaseFile = targetFile;
            }
            this.mResolvedStagedFiles.add(targetFile);
        }
        if (this.params.mode == 1) {
            if (!stagedSplits.contains(null)) {
                throw new PackageManagerException(-2, "Full install must include a base package");
            }
        } else {
            PackageParser.ApkLite existingBase;
            PackageParser.PackageLite existing;
            ApplicationInfo app = this.mPm.getApplicationInfo(this.mPackageName, 0, this.userId);
            if (app == null) {
                throw new PackageManagerException(-2, "Missing existing base package for " + this.mPackageName);
            }
            try {
                existing = PackageParser.parsePackageLite((File)new File(app.getCodePath()), (int)0);
                existingBase = PackageParser.parseApkLite((File)new File(app.getBaseCodePath()), (int)256);
            }
            catch (PackageParser.PackageParserException e) {
                throw PackageManagerException.from(e);
            }
            this.assertApkConsistent("Existing base", existingBase);
            if (this.mResolvedBaseFile == null) {
                this.mResolvedBaseFile = new File(app.getBaseCodePath());
                this.mResolvedInheritedFiles.add(this.mResolvedBaseFile);
            }
            if (!ArrayUtils.isEmpty((Object[])existing.splitNames)) {
                for (int i = 0; i < existing.splitNames.length; ++i) {
                    String splitName = existing.splitNames[i];
                    File splitFile = new File(existing.splitCodePaths[i]);
                    if (stagedSplits.contains(splitName)) continue;
                    this.mResolvedInheritedFiles.add(splitFile);
                }
            }
        }
    }

    private void assertApkConsistent(String tag, PackageParser.ApkLite apk) throws PackageManagerException {
        if (!this.mPackageName.equals(apk.packageName)) {
            throw new PackageManagerException(-2, tag + " package " + apk.packageName + " inconsistent with " + this.mPackageName);
        }
        if (this.mVersionCode != apk.versionCode) {
            throw new PackageManagerException(-2, tag + " version code " + apk.versionCode + " inconsistent with " + this.mVersionCode);
        }
        if (!Signature.areExactMatch(this.mSignatures, apk.signatures)) {
            throw new PackageManagerException(-2, tag + " signatures are inconsistent");
        }
    }

    private long calculateInstalledSize() throws PackageManagerException {
        PackageParser.ApkLite baseApk;
        Preconditions.checkNotNull(this.mResolvedBaseFile);
        try {
            baseApk = PackageParser.parseApkLite((File)this.mResolvedBaseFile, (int)0);
        }
        catch (PackageParser.PackageParserException e) {
            throw PackageManagerException.from(e);
        }
        ArrayList<String> splitPaths = new ArrayList<String>();
        for (File file : this.mResolvedStagedFiles) {
            if (this.mResolvedBaseFile.equals(file)) continue;
            splitPaths.add(file.getAbsolutePath());
        }
        for (File file : this.mResolvedInheritedFiles) {
            if (this.mResolvedBaseFile.equals(file)) continue;
            splitPaths.add(file.getAbsolutePath());
        }
        PackageParser.PackageLite pkg = new PackageParser.PackageLite(null, baseApk, null, splitPaths.toArray(new String[splitPaths.size()]));
        boolean isForwardLocked = (this.params.installFlags & 1) != 0;
        try {
            return PackageHelper.calculateInstalledSize((PackageParser.PackageLite)pkg, (boolean)isForwardLocked, (String)this.params.abiOverride);
        }
        catch (IOException e) {
            throw new PackageManagerException(-2, "Failed to calculate install size", e);
        }
    }

    private static void linkFiles(List<File> fromFiles, File toDir) throws IOException {
        for (File fromFile : fromFiles) {
            File toFile = new File(toDir, fromFile.getName());
            try {
                Slog.d(TAG, "Linking " + fromFile + " to " + toFile);
                Os.link(fromFile.getAbsolutePath(), toFile.getAbsolutePath());
            }
            catch (ErrnoException e) {
                throw new IOException("Failed to link " + fromFile + " to " + toFile, e);
            }
        }
        Slog.d(TAG, "Linked " + fromFiles.size() + " files into " + toDir);
    }

    private static void copyFiles(List<File> fromFiles, File toDir) throws IOException {
        for (File file : toDir.listFiles()) {
            if (!file.getName().endsWith(".tmp")) continue;
            file.delete();
        }
        for (File fromFile : fromFiles) {
            File tmpFile = File.createTempFile("inherit", ".tmp", toDir);
            Slog.d(TAG, "Copying " + fromFile + " to " + tmpFile);
            if (!FileUtils.copyFile(fromFile, tmpFile)) {
                throw new IOException("Failed to copy " + fromFile + " to " + tmpFile);
            }
            File toFile = new File(toDir, fromFile.getName());
            Slog.d(TAG, "Renaming " + tmpFile + " to " + toFile);
            if (tmpFile.renameTo(toFile)) continue;
            throw new IOException("Failed to rename " + tmpFile + " to " + toFile);
        }
        Slog.d(TAG, "Copied " + fromFiles.size() + " files into " + toDir);
    }

    private static void extractNativeLibraries(File packageDir, String abiOverride) throws PackageManagerException {
        File libDir = new File(packageDir, "lib");
        NativeLibraryHelper.removeNativeBinariesFromDirLI((File)libDir, (boolean)true);
        NativeLibraryHelper.Handle handle = null;
        try {
            handle = NativeLibraryHelper.Handle.create(packageDir);
            int res = NativeLibraryHelper.copyNativeBinariesWithOverride((NativeLibraryHelper.Handle)handle, (File)libDir, (String)abiOverride);
            if (res != 1) {
                throw new PackageManagerException(res, "Failed to extract native libraries, res=" + res);
            }
        }
        catch (IOException e) {
            throw new PackageManagerException(-110, "Failed to extract native libraries", e);
        }
        finally {
            IoUtils.closeQuietly(handle);
        }
    }

    private static void resizeContainer(String cid, long targetSize) throws PackageManagerException {
        String path = PackageHelper.getSdDir(cid);
        if (path == null) {
            throw new PackageManagerException(-18, "Failed to find mounted " + cid);
        }
        long currentSize = new File(path).getTotalSpace();
        if (currentSize > targetSize) {
            Slog.w(TAG, "Current size " + currentSize + " is larger than target size " + targetSize + "; skipping resize");
            return;
        }
        if (!PackageHelper.unMountSdDir(cid)) {
            throw new PackageManagerException(-18, "Failed to unmount " + cid + " before resize");
        }
        if (!PackageHelper.resizeSdDir((long)targetSize, (String)cid, (String)PackageManagerService.getEncryptKey())) {
            throw new PackageManagerException(-18, "Failed to resize " + cid + " to " + targetSize + " bytes");
        }
        path = PackageHelper.mountSdDir((String)cid, (String)PackageManagerService.getEncryptKey(), (int)1000, (boolean)false);
        if (path == null) {
            throw new PackageManagerException(-18, "Failed to mount " + cid + " after resize");
        }
    }

    private void finalizeAndFixContainer(String cid) throws PackageManagerException {
        if (!PackageHelper.finalizeSdDir(cid)) {
            throw new PackageManagerException(-18, "Failed to finalize container " + cid);
        }
        int uid = this.mPm.getPackageUid("com.android.defcontainer", 0);
        int gid = UserHandle.getSharedAppGid(uid);
        if (!PackageHelper.fixSdPermissions(cid, gid, null)) {
            throw new PackageManagerException(-18, "Failed to fix permissions on container " + cid);
        }
    }

    void setPermissionsResult(boolean accepted) {
        if (!this.mSealed) {
            throw new SecurityException("Must be sealed to accept permissions");
        }
        if (accepted) {
            this.mPermissionsAccepted = true;
            this.mHandler.obtainMessage(0).sendToTarget();
        } else {
            this.destroyInternal();
            this.dispatchSessionFinished(-115, "User rejected permissions", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws IOException {
        if (this.mActiveCount.getAndIncrement() == 0) {
            this.mCallback.onSessionActiveChanged(this, true);
        }
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mPrepared) {
                if (this.stageDir != null) {
                    PackageInstallerService.prepareInternalStageDir(this.stageDir);
                } else if (this.stageCid != null) {
                    PackageInstallerService.prepareExternalStageCid(this.stageCid, this.params.sizeBytes);
                    this.mInternalProgress = 0.25f;
                    this.computeProgressLocked(true);
                } else {
                    throw new IllegalArgumentException("Exactly one of stageDir or stageCid stage must be set");
                }
                this.mPrepared = true;
                this.mCallback.onSessionPrepared(this);
            }
        }
    }

    public void close() {
        if (this.mActiveCount.decrementAndGet() == 0) {
            this.mCallback.onSessionActiveChanged(this, false);
        }
    }

    public void abandon() {
        this.destroyInternal();
        this.dispatchSessionFinished(-115, "Session was abandoned", null);
    }

    private void dispatchSessionFinished(int returnCode, String msg, Bundle extras) {
        this.mFinalStatus = returnCode;
        this.mFinalMessage = msg;
        if (this.mRemoteObserver != null) {
            try {
                this.mRemoteObserver.onPackageInstalled(this.mPackageName, returnCode, msg, extras);
            }
            catch (RemoteException ignored) {
                // empty catch block
            }
        }
        boolean success = returnCode == 1;
        this.mCallback.onSessionFinished(this, success);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyInternal() {
        Object object = this.mLock;
        synchronized (object) {
            this.mSealed = true;
            this.mDestroyed = true;
            for (FileBridge bridge : this.mBridges) {
                bridge.forceClose();
            }
        }
        if (this.stageDir != null) {
            FileUtils.deleteContents((File)this.stageDir);
            this.stageDir.delete();
        }
        if (this.stageCid != null) {
            PackageHelper.destroySdDir(this.stageCid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(IndentingPrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            this.dumpLocked(pw);
        }
    }

    private void dumpLocked(IndentingPrintWriter pw) {
        pw.println("Session " + this.sessionId + ":");
        pw.increaseIndent();
        pw.printPair("userId", this.userId);
        pw.printPair("installerPackageName", this.installerPackageName);
        pw.printPair("installerUid", this.installerUid);
        pw.printPair("createdMillis", this.createdMillis);
        pw.printPair("stageDir", this.stageDir);
        pw.printPair("stageCid", this.stageCid);
        pw.println();
        this.params.dump(pw);
        pw.printPair("mClientProgress", Float.valueOf(this.mClientProgress));
        pw.printPair("mProgress", Float.valueOf(this.mProgress));
        pw.printPair("mSealed", this.mSealed);
        pw.printPair("mPermissionsAccepted", this.mPermissionsAccepted);
        pw.printPair("mDestroyed", this.mDestroyed);
        pw.printPair("mBridges", this.mBridges.size());
        pw.printPair("mFinalStatus", this.mFinalStatus);
        pw.printPair("mFinalMessage", this.mFinalMessage);
        pw.println();
        pw.decreaseIndent();
    }
}

