/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wifi;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.NetworkInfo;
import android.net.TrafficStats;
import android.os.Handler;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

final class WifiTrafficPoller {
    private static final int POLL_TRAFFIC_STATS_INTERVAL_MSECS = 1000;
    private static final int ENABLE_TRAFFIC_STATS_POLL = 1;
    private static final int TRAFFIC_STATS_POLL = 2;
    private static final int ADD_CLIENT = 3;
    private static final int REMOVE_CLIENT = 4;
    private boolean mEnableTrafficStatsPoll = false;
    private int mTrafficStatsPollToken = 0;
    private long mTxPkts;
    private long mRxPkts;
    private int mDataActivity;
    private final List<Messenger> mClients = new ArrayList<Messenger>();
    private AtomicBoolean mScreenOn = new AtomicBoolean(true);
    private final TrafficHandler mTrafficHandler;
    private NetworkInfo mNetworkInfo;
    private final String mInterface;

    WifiTrafficPoller(Context context, String iface) {
        this.mInterface = iface;
        this.mTrafficHandler = new TrafficHandler();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.net.wifi.STATE_CHANGE");
        filter.addAction("android.intent.action.SCREEN_OFF");
        filter.addAction("android.intent.action.SCREEN_ON");
        context.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (intent.getAction().equals("android.net.wifi.STATE_CHANGE")) {
                    WifiTrafficPoller.this.mNetworkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
                } else if (intent.getAction().equals("android.intent.action.SCREEN_OFF")) {
                    WifiTrafficPoller.this.mScreenOn.set(false);
                } else if (intent.getAction().equals("android.intent.action.SCREEN_ON")) {
                    WifiTrafficPoller.this.mScreenOn.set(true);
                }
                WifiTrafficPoller.this.evaluateTrafficStatsPolling();
            }
        }, filter);
    }

    void addClient(Messenger client) {
        Message.obtain(this.mTrafficHandler, 3, client).sendToTarget();
    }

    void removeClient(Messenger client) {
        Message.obtain(this.mTrafficHandler, 4, client).sendToTarget();
    }

    private void evaluateTrafficStatsPolling() {
        if (this.mNetworkInfo == null) {
            return;
        }
        Message msg = this.mNetworkInfo.getDetailedState() == NetworkInfo.DetailedState.CONNECTED && this.mScreenOn.get() ? Message.obtain(this.mTrafficHandler, 1, 1, 0) : Message.obtain(this.mTrafficHandler, 1, 0, 0);
        msg.sendToTarget();
    }

    private void notifyOnDataActivity() {
        long preTxPkts = this.mTxPkts;
        long preRxPkts = this.mRxPkts;
        int dataActivity = 0;
        this.mTxPkts = TrafficStats.getTxPackets(this.mInterface);
        this.mRxPkts = TrafficStats.getRxPackets(this.mInterface);
        if (preTxPkts > 0L || preRxPkts > 0L) {
            long sent = this.mTxPkts - preTxPkts;
            long received = this.mRxPkts - preRxPkts;
            if (sent > 0L) {
                dataActivity |= 2;
            }
            if (received > 0L) {
                dataActivity |= 1;
            }
            if (dataActivity != this.mDataActivity && this.mScreenOn.get()) {
                this.mDataActivity = dataActivity;
                for (Messenger client : this.mClients) {
                    Message msg = Message.obtain();
                    msg.what = 1;
                    msg.arg1 = this.mDataActivity;
                    try {
                        client.send(msg);
                    }
                    catch (RemoteException e) {}
                }
            }
        }
    }

    void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("mEnableTrafficStatsPoll " + this.mEnableTrafficStatsPoll);
        pw.println("mTrafficStatsPollToken " + this.mTrafficStatsPollToken);
        pw.println("mTxPkts " + this.mTxPkts);
        pw.println("mRxPkts " + this.mRxPkts);
        pw.println("mDataActivity " + this.mDataActivity);
    }

    private class TrafficHandler
    extends Handler {
        private TrafficHandler() {
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    WifiTrafficPoller.this.mEnableTrafficStatsPoll = msg.arg1 == 1;
                    WifiTrafficPoller.this.mTrafficStatsPollToken++;
                    if (!WifiTrafficPoller.this.mEnableTrafficStatsPoll) break;
                    WifiTrafficPoller.this.notifyOnDataActivity();
                    this.sendMessageDelayed(Message.obtain(this, 2, WifiTrafficPoller.this.mTrafficStatsPollToken, 0), 1000L);
                    break;
                }
                case 2: {
                    if (msg.arg1 != WifiTrafficPoller.this.mTrafficStatsPollToken) break;
                    WifiTrafficPoller.this.notifyOnDataActivity();
                    this.sendMessageDelayed(Message.obtain(this, 2, WifiTrafficPoller.this.mTrafficStatsPollToken, 0), 1000L);
                    break;
                }
                case 3: {
                    WifiTrafficPoller.this.mClients.add((Messenger)msg.obj);
                    break;
                }
                case 4: {
                    WifiTrafficPoller.this.mClients.remove(msg.obj);
                }
            }
        }
    }
}

