/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManager;
import android.graphics.Rect;
import android.graphics.Region;
import android.view.Display;
import android.view.DisplayInfo;
import com.android.server.wm.AppTokenList;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.StackBox;
import com.android.server.wm.StackTapPointerEventListener;
import com.android.server.wm.Task;
import com.android.server.wm.TaskStack;
import com.android.server.wm.WindowList;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import com.android.server.wm.WindowToken;
import java.io.PrintWriter;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DisplayContent {
    private final int mDisplayId;
    private WindowList mWindows = new WindowList();
    final Object mDisplaySizeLock = new Object();
    int mInitialDisplayWidth = 0;
    int mInitialDisplayHeight = 0;
    int mInitialDisplayDensity = 0;
    int mBaseDisplayWidth = 0;
    int mBaseDisplayHeight = 0;
    int mBaseDisplayDensity = 0;
    private final DisplayInfo mDisplayInfo = new DisplayInfo();
    private final Display mDisplay;
    Rect mBaseDisplayRect = new Rect();
    boolean layoutNeeded;
    int pendingLayoutChanges;
    final boolean isDefaultDisplay;
    final ArrayList<WindowToken> mExitingTokens = new ArrayList();
    final AppTokenList mExitingAppTokens = new AppTokenList();
    private ArrayList<StackBox> mStackBoxes = new ArrayList();
    private TaskStack mHomeStack = null;
    ArrayList<TaskStack> mStackHistory = new ArrayList();
    StackTapPointerEventListener mTapDetector;
    Region mTouchExcludeRegion = new Region();
    ArrayList<Task> mTmpTasks = new ArrayList();
    Rect mTmpRect = new Rect();
    final WindowManagerService mService;

    DisplayContent(Display display, WindowManagerService service) {
        this.mDisplay = display;
        this.mDisplayId = display.getDisplayId();
        display.getDisplayInfo(this.mDisplayInfo);
        this.isDefaultDisplay = this.mDisplayId == 0;
        this.mService = service;
        StackBox newBox = new StackBox(service, this, null);
        this.mStackBoxes.add(newBox);
        TaskStack newStack = new TaskStack(service, 0, this);
        newStack.mStackBox = newBox;
        newBox.mStack = newStack;
        this.mHomeStack = newStack;
    }

    int getDisplayId() {
        return this.mDisplayId;
    }

    WindowList getWindowList() {
        return this.mWindows;
    }

    Display getDisplay() {
        return this.mDisplay;
    }

    DisplayInfo getDisplayInfo() {
        return this.mDisplayInfo;
    }

    public boolean hasAccess(int uid) {
        return this.mDisplay.hasAccess(uid);
    }

    boolean homeOnTop() {
        return this.mStackBoxes.get((int)0).mStack != this.mHomeStack;
    }

    void moveStack(TaskStack stack, boolean toTop) {
        this.mStackHistory.remove(stack);
        this.mStackHistory.add(toTop ? this.mStackHistory.size() : 0, stack);
        this.mService.moveStackWindowsLocked(stack);
    }

    public boolean isPrivate() {
        return (this.mDisplay.getFlags() & 4) != 0;
    }

    ArrayList<Task> getTasks() {
        this.mTmpTasks.clear();
        int numStacks = this.mStackHistory.size();
        for (int stackNdx = 0; stackNdx < numStacks; ++stackNdx) {
            this.mTmpTasks.addAll(this.mStackHistory.get(stackNdx).getTasks());
        }
        return this.mTmpTasks;
    }

    TaskStack getHomeStack() {
        return this.mHomeStack;
    }

    void updateDisplayInfo() {
        this.mDisplay.getDisplayInfo(this.mDisplayInfo);
    }

    void getLogicalDisplayRect(Rect out) {
        this.updateDisplayInfo();
        int width = this.mDisplayInfo.logicalWidth;
        int left = (this.mBaseDisplayWidth - width) / 2;
        int height = this.mDisplayInfo.logicalHeight;
        int top = (this.mBaseDisplayHeight - height) / 2;
        out.set(left, top, left + width, top + height);
    }

    int numTokens() {
        this.getTasks();
        int count = 0;
        for (int taskNdx = this.mTmpTasks.size() - 1; taskNdx >= 0; --taskNdx) {
            count += this.mTmpTasks.get((int)taskNdx).mAppTokens.size();
        }
        return count;
    }

    TaskStack createStack(int stackId, int relativeStackBoxId, int position, float weight) {
        TaskStack newStack = null;
        if (stackId == 0) {
            if (this.mStackBoxes.size() != 1) {
                throw new IllegalArgumentException("createStack: HOME_STACK_ID (0) not first.");
            }
            newStack = this.mHomeStack;
        } else {
            int stackBoxNdx;
            for (stackBoxNdx = this.mStackBoxes.size() - 1; stackBoxNdx >= 0; --stackBoxNdx) {
                StackBox box = this.mStackBoxes.get(stackBoxNdx);
                if (position == 6 || position == 7) {
                    if (!box.contains(relativeStackBoxId)) continue;
                    StackBox newBox = new StackBox(this.mService, this, null);
                    newStack = new TaskStack(this.mService, stackId, this);
                    newStack.mStackBox = newBox;
                    newBox.mStack = newStack;
                    int offset = position == 6 ? 1 : 0;
                    this.mStackBoxes.add(stackBoxNdx + offset, newBox);
                    break;
                }
                newStack = box.split(stackId, relativeStackBoxId, position, weight);
                if (newStack != null) break;
            }
            if (stackBoxNdx < 0) {
                throw new IllegalArgumentException("createStack: stackBoxId " + relativeStackBoxId + " not found.");
            }
        }
        if (newStack != null) {
            this.layoutNeeded = true;
        }
        return newStack;
    }

    boolean resizeStack(int stackBoxId, float weight) {
        for (int stackBoxNdx = this.mStackBoxes.size() - 1; stackBoxNdx >= 0; --stackBoxNdx) {
            StackBox box = this.mStackBoxes.get(stackBoxNdx);
            if (!box.resize(stackBoxId, weight)) continue;
            this.layoutNeeded = true;
            return true;
        }
        return false;
    }

    void addStackBox(StackBox box, boolean toTop) {
        if (this.mStackBoxes.size() >= 2) {
            throw new RuntimeException("addStackBox: Too many toplevel StackBoxes!");
        }
        this.mStackBoxes.add(toTop ? this.mStackBoxes.size() : 0, box);
    }

    void removeStackBox(StackBox box) {
        TaskStack stack = box.mStack;
        if (stack != null && stack.mStackId == 0) {
            return;
        }
        this.mStackBoxes.remove(box);
    }

    ActivityManager.StackBoxInfo getStackBoxInfo(StackBox box) {
        ActivityManager.StackBoxInfo info = new ActivityManager.StackBoxInfo();
        info.stackBoxId = box.mStackBoxId;
        info.weight = box.mWeight;
        info.vertical = box.mVertical;
        info.bounds = new Rect(box.mBounds);
        if (box.mStack != null) {
            info.stackId = box.mStack.mStackId;
        } else {
            info.stackId = -1;
            info.children = new ActivityManager.StackBoxInfo[2];
            info.children[0] = this.getStackBoxInfo(box.mFirst);
            info.children[1] = this.getStackBoxInfo(box.mSecond);
        }
        return info;
    }

    ArrayList<ActivityManager.StackBoxInfo> getStackBoxInfos() {
        ArrayList<ActivityManager.StackBoxInfo> list = new ArrayList<ActivityManager.StackBoxInfo>();
        for (int stackBoxNdx = this.mStackBoxes.size() - 1; stackBoxNdx >= 0; --stackBoxNdx) {
            list.add(this.getStackBoxInfo(this.mStackBoxes.get(stackBoxNdx)));
        }
        return list;
    }

    boolean moveHomeStackBox(boolean toTop) {
        switch (this.mStackBoxes.size()) {
            case 0: {
                throw new RuntimeException("moveHomeStackBox: No home StackBox!");
            }
            case 1: {
                return false;
            }
            case 2: {
                if (this.homeOnTop() ^ toTop) {
                    this.mStackBoxes.add(this.mStackBoxes.remove(0));
                    return true;
                }
                return false;
            }
        }
        throw new RuntimeException("moveHomeStackBox: Too many toplevel StackBoxes!");
    }

    boolean setStackBoxSize(Rect contentRect) {
        boolean change = false;
        for (int stackBoxNdx = this.mStackBoxes.size() - 1; stackBoxNdx >= 0; --stackBoxNdx) {
            change |= this.mStackBoxes.get(stackBoxNdx).setStackBoxSizes(contentRect, true);
        }
        return change;
    }

    Rect getStackBounds(int stackId) {
        for (int stackBoxNdx = this.mStackBoxes.size() - 1; stackBoxNdx >= 0; --stackBoxNdx) {
            Rect bounds = this.mStackBoxes.get(stackBoxNdx).getStackBounds(stackId);
            if (bounds == null) continue;
            return bounds;
        }
        return null;
    }

    int stackIdFromPoint(int x, int y) {
        StackBox topBox = this.mStackBoxes.get(this.mStackBoxes.size() - 1);
        return topBox.stackIdFromPoint(x, y);
    }

    void setTouchExcludeRegion(TaskStack focusedStack) {
        this.mTouchExcludeRegion.set(this.mBaseDisplayRect);
        WindowList windows = this.getWindowList();
        for (int i = windows.size() - 1; i >= 0; --i) {
            WindowState win = (WindowState)windows.get(i);
            TaskStack stack = win.getStack();
            if (!win.isVisibleLw() || stack == null || stack == focusedStack) continue;
            this.mTmpRect.set(win.mVisibleFrame);
            this.mTmpRect.intersect(win.mVisibleInsets);
            this.mTouchExcludeRegion.op(this.mTmpRect, Region.Op.DIFFERENCE);
        }
    }

    void switchUserStacks(int oldUserId, int newUserId) {
        WindowList windows = this.getWindowList();
        for (int i = 0; i < windows.size(); ++i) {
            WindowState win = (WindowState)windows.get(i);
            if (!win.isHiddenFromUserLocked()) continue;
            win.hideLw(false);
        }
        for (int stackBoxNdx = this.mStackBoxes.size() - 1; stackBoxNdx >= 0; --stackBoxNdx) {
            this.mStackBoxes.get(stackBoxNdx).switchUserStacks(newUserId);
        }
    }

    void resetAnimationBackgroundAnimator() {
        for (int stackBoxNdx = this.mStackBoxes.size() - 1; stackBoxNdx >= 0; --stackBoxNdx) {
            this.mStackBoxes.get(stackBoxNdx).resetAnimationBackgroundAnimator();
        }
    }

    boolean animateDimLayers() {
        boolean result = false;
        for (int stackBoxNdx = this.mStackBoxes.size() - 1; stackBoxNdx >= 0; --stackBoxNdx) {
            result |= this.mStackBoxes.get(stackBoxNdx).animateDimLayers();
        }
        return result;
    }

    void resetDimming() {
        for (int stackBoxNdx = this.mStackBoxes.size() - 1; stackBoxNdx >= 0; --stackBoxNdx) {
            this.mStackBoxes.get(stackBoxNdx).resetDimming();
        }
    }

    boolean isDimming() {
        boolean result = false;
        for (int stackBoxNdx = this.mStackBoxes.size() - 1; stackBoxNdx >= 0; --stackBoxNdx) {
            result |= this.mStackBoxes.get(stackBoxNdx).isDimming();
        }
        return result;
    }

    void stopDimmingIfNeeded() {
        for (int stackBoxNdx = this.mStackBoxes.size() - 1; stackBoxNdx >= 0; --stackBoxNdx) {
            this.mStackBoxes.get(stackBoxNdx).stopDimmingIfNeeded();
        }
    }

    void close() {
        for (int stackBoxNdx = this.mStackBoxes.size() - 1; stackBoxNdx >= 0; --stackBoxNdx) {
            this.mStackBoxes.get(stackBoxNdx).close();
        }
    }

    public void dump(String prefix, PrintWriter pw) {
        WindowToken token;
        int i;
        pw.print(prefix);
        pw.print("Display: mDisplayId=");
        pw.println(this.mDisplayId);
        String subPrefix = "  " + prefix;
        pw.print(subPrefix);
        pw.print("init=");
        pw.print(this.mInitialDisplayWidth);
        pw.print("x");
        pw.print(this.mInitialDisplayHeight);
        pw.print(" ");
        pw.print(this.mInitialDisplayDensity);
        pw.print("dpi");
        if (this.mInitialDisplayWidth != this.mBaseDisplayWidth || this.mInitialDisplayHeight != this.mBaseDisplayHeight || this.mInitialDisplayDensity != this.mBaseDisplayDensity) {
            pw.print(" base=");
            pw.print(this.mBaseDisplayWidth);
            pw.print("x");
            pw.print(this.mBaseDisplayHeight);
            pw.print(" ");
            pw.print(this.mBaseDisplayDensity);
            pw.print("dpi");
        }
        pw.print(" cur=");
        pw.print(this.mDisplayInfo.logicalWidth);
        pw.print("x");
        pw.print(this.mDisplayInfo.logicalHeight);
        pw.print(" app=");
        pw.print(this.mDisplayInfo.appWidth);
        pw.print("x");
        pw.print(this.mDisplayInfo.appHeight);
        pw.print(" rng=");
        pw.print(this.mDisplayInfo.smallestNominalAppWidth);
        pw.print("x");
        pw.print(this.mDisplayInfo.smallestNominalAppHeight);
        pw.print("-");
        pw.print(this.mDisplayInfo.largestNominalAppWidth);
        pw.print("x");
        pw.println(this.mDisplayInfo.largestNominalAppHeight);
        pw.print(subPrefix);
        pw.print("layoutNeeded=");
        pw.println(this.layoutNeeded);
        for (int boxNdx = 0; boxNdx < this.mStackBoxes.size(); ++boxNdx) {
            pw.print(prefix);
            pw.print("StackBox #");
            pw.println(boxNdx);
            this.mStackBoxes.get(boxNdx).dump(prefix + "  ", pw);
        }
        int ndx = this.numTokens();
        if (ndx > 0) {
            pw.println();
            pw.println("  Application tokens in Z order:");
            this.getTasks();
            for (int taskNdx = this.mTmpTasks.size() - 1; taskNdx >= 0; --taskNdx) {
                AppTokenList tokens = this.mTmpTasks.get((int)taskNdx).mAppTokens;
                for (int tokenNdx = tokens.size() - 1; tokenNdx >= 0; --tokenNdx) {
                    AppWindowToken wtoken = (AppWindowToken)tokens.get(tokenNdx);
                    pw.print("  App #");
                    pw.print(ndx--);
                    pw.print(' ');
                    pw.print(wtoken);
                    pw.println(":");
                    wtoken.dump(pw, "    ");
                }
            }
        }
        if (this.mExitingTokens.size() > 0) {
            pw.println();
            pw.println("  Exiting tokens:");
            for (i = this.mExitingTokens.size() - 1; i >= 0; --i) {
                token = this.mExitingTokens.get(i);
                pw.print("  Exiting #");
                pw.print(i);
                pw.print(' ');
                pw.print(token);
                pw.println(':');
                token.dump(pw, "    ");
            }
        }
        if (this.mExitingAppTokens.size() > 0) {
            pw.println();
            pw.println("  Exiting application tokens:");
            for (i = this.mExitingAppTokens.size() - 1; i >= 0; --i) {
                token = (WindowToken)this.mExitingAppTokens.get(i);
                pw.print("  Exiting App #");
                pw.print(i);
                pw.print(' ');
                pw.print(token);
                pw.println(':');
                token.dump(pw, "    ");
            }
        }
        pw.println();
    }
}

