/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Pools;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.IMagnificationCallbacks;
import android.view.MagnificationSpec;
import android.view.Surface;
import android.view.SurfaceControl;
import android.view.WindowManager;
import android.view.WindowManagerPolicy;
import android.view.animation.DecelerateInterpolator;
import com.android.internal.os.SomeArgs;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.WindowList;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import java.util.HashMap;

final class DisplayMagnifier {
    private static final String LOG_TAG = DisplayMagnifier.class.getSimpleName();
    private static final boolean DEBUG_WINDOW_TRANSITIONS = false;
    private static final boolean DEBUG_ROTATION = false;
    private static final boolean DEBUG_LAYERS = false;
    private static final boolean DEBUG_RECTANGLE_REQUESTED = false;
    private static final boolean DEBUG_VIEWPORT_WINDOW = false;
    private final Rect mTempRect1 = new Rect();
    private final Rect mTempRect2 = new Rect();
    private final Region mTempRegion1 = new Region();
    private final Region mTempRegion2 = new Region();
    private final Region mTempRegion3 = new Region();
    private final Region mTempRegion4 = new Region();
    private final Context mContext;
    private final WindowManagerService mWindowManagerService;
    private final MagnifiedViewport mMagnifedViewport;
    private final Handler mHandler;
    private final IMagnificationCallbacks mCallbacks;
    private final long mLongAnimationDuration;

    public DisplayMagnifier(WindowManagerService windowManagerService, IMagnificationCallbacks callbacks) {
        this.mContext = windowManagerService.mContext;
        this.mWindowManagerService = windowManagerService;
        this.mCallbacks = callbacks;
        this.mHandler = new MyHandler(this.mWindowManagerService.mH.getLooper());
        this.mMagnifedViewport = new MagnifiedViewport();
        this.mLongAnimationDuration = this.mContext.getResources().getInteger(17694722);
    }

    public void setMagnificationSpecLocked(MagnificationSpec spec) {
        this.mMagnifedViewport.updateMagnificationSpecLocked(spec);
        this.mMagnifedViewport.recomputeBoundsLocked();
        this.mWindowManagerService.scheduleAnimationLocked();
    }

    public void onRectangleOnScreenRequestedLocked(Rect rectangle, boolean immediate) {
        if (!this.mMagnifedViewport.isMagnifyingLocked()) {
            return;
        }
        Rect magnifiedRegionBounds = this.mTempRect2;
        this.mMagnifedViewport.getMagnifiedFrameInContentCoordsLocked(magnifiedRegionBounds);
        if (magnifiedRegionBounds.contains(rectangle)) {
            return;
        }
        SomeArgs args = SomeArgs.obtain();
        args.argi1 = rectangle.left;
        args.argi2 = rectangle.top;
        args.argi3 = rectangle.right;
        args.argi4 = rectangle.bottom;
        this.mHandler.obtainMessage(2, args).sendToTarget();
    }

    public void onWindowLayersChangedLocked() {
        this.mMagnifedViewport.recomputeBoundsLocked();
        this.mWindowManagerService.scheduleAnimationLocked();
    }

    public void onRotationChangedLocked(DisplayContent displayContent, int rotation) {
        this.mMagnifedViewport.onRotationChangedLocked();
        this.mHandler.sendEmptyMessage(4);
    }

    public void onAppWindowTransitionLocked(WindowState windowState, int transition2) {
        boolean magnifying = this.mMagnifedViewport.isMagnifyingLocked();
        if (magnifying) {
            switch (transition2) {
                case 4102: 
                case 4104: 
                case 4106: 
                case 4109: 
                case 4110: 
                case 8204: {
                    this.mHandler.sendEmptyMessage(3);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onWindowTransitionLocked(WindowState windowState, int transition2) {
        boolean magnifying = this.mMagnifedViewport.isMagnifyingLocked();
        int type = windowState.mAttrs.type;
        switch (transition2) {
            case 1: 
            case 3: {
                if (!magnifying) {
                    return;
                }
                switch (type) {
                    case 2: 
                    case 1000: 
                    case 1001: 
                    case 1002: 
                    case 1003: 
                    case 2001: 
                    case 2002: 
                    case 2003: 
                    case 2005: 
                    case 2006: 
                    case 2007: 
                    case 2008: 
                    case 2009: 
                    case 2010: 
                    case 2020: 
                    case 2024: 
                    case 2028: {
                        Rect magnifiedRegionBounds = this.mTempRect2;
                        this.mMagnifedViewport.getMagnifiedFrameInContentCoordsLocked(magnifiedRegionBounds);
                        Rect touchableRegionBounds = this.mTempRect1;
                        windowState.getTouchableRegion(this.mTempRegion1);
                        this.mTempRegion1.getBounds(touchableRegionBounds);
                        if (magnifiedRegionBounds.intersect(touchableRegionBounds)) return;
                        try {
                            this.mCallbacks.onRectangleOnScreenRequested(touchableRegionBounds.left, touchableRegionBounds.top, touchableRegionBounds.right, touchableRegionBounds.bottom);
                            return;
                        }
                        catch (RemoteException re) {
                            // empty catch block
                        }
                    }
                }
                return;
            }
        }
    }

    public MagnificationSpec getMagnificationSpecForWindowLocked(WindowState windowState) {
        MagnificationSpec spec = this.mMagnifedViewport.getMagnificationSpecLocked();
        if (spec != null && !spec.isNop()) {
            WindowManagerPolicy policy = this.mWindowManagerService.mPolicy;
            int windowType = windowState.mAttrs.type;
            if (!policy.isTopLevelWindow(windowType) && windowState.mAttachedWindow != null && !policy.canMagnifyWindow(windowType)) {
                return null;
            }
            if (!policy.canMagnifyWindow(windowState.mAttrs.type)) {
                return null;
            }
        }
        return spec;
    }

    public void destroyLocked() {
        this.mMagnifedViewport.destroyWindow();
    }

    public void drawMagnifiedRegionBorderIfNeededLocked() {
        this.mMagnifedViewport.drawWindowIfNeededLocked();
    }

    private class MyHandler
    extends Handler {
        public static final int MESSAGE_NOTIFY_MAGNIFIED_BOUNDS_CHANGED = 1;
        public static final int MESSAGE_NOTIFY_RECTANGLE_ON_SCREEN_REQUESTED = 2;
        public static final int MESSAGE_NOTIFY_USER_CONTEXT_CHANGED = 3;
        public static final int MESSAGE_NOTIFY_ROTATION_CHANGED = 4;
        public static final int MESSAGE_SHOW_MAGNIFIED_REGION_BOUNDS_IF_NEEDED = 5;

        public MyHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    Region bounds = (Region)message.obj;
                    try {
                        DisplayMagnifier.this.mCallbacks.onMagnifedBoundsChanged(bounds);
                        break;
                    }
                    catch (RemoteException re) {
                        break;
                    }
                    finally {
                        bounds.recycle();
                    }
                }
                case 2: {
                    SomeArgs args = (SomeArgs)message.obj;
                    int left = args.argi1;
                    int top = args.argi2;
                    int right = args.argi3;
                    int bottom = args.argi4;
                    try {
                        DisplayMagnifier.this.mCallbacks.onRectangleOnScreenRequested(left, top, right, bottom);
                        break;
                    }
                    catch (RemoteException re) {
                        break;
                    }
                    finally {
                        args.recycle();
                    }
                }
                case 3: {
                    try {
                        DisplayMagnifier.this.mCallbacks.onUserContextChanged();
                    }
                    catch (RemoteException re) {}
                    break;
                }
                case 4: {
                    int rotation = message.arg1;
                    try {
                        DisplayMagnifier.this.mCallbacks.onRotationChanged(rotation);
                    }
                    catch (RemoteException remoteException) {}
                    break;
                }
                case 5: {
                    HashMap<IBinder, WindowState> hashMap = ((DisplayMagnifier)DisplayMagnifier.this).mWindowManagerService.mWindowMap;
                    synchronized (hashMap) {
                        if (DisplayMagnifier.this.mMagnifedViewport.isMagnifyingLocked()) {
                            DisplayMagnifier.this.mMagnifedViewport.setMagnifiedRegionBorderShownLocked(true, true);
                            DisplayMagnifier.this.mWindowManagerService.scheduleAnimationLocked();
                        }
                        break;
                    }
                }
            }
        }
    }

    private static final class WindowStateInfo {
        private static final int MAX_POOL_SIZE = 30;
        private static final Pools.SimplePool<WindowStateInfo> sPool = new Pools.SimplePool(30);
        private static final Region mTempRegion = new Region();
        public WindowState mWindowState;
        public final Rect mTouchableRegion = new Rect();

        private WindowStateInfo() {
        }

        public static WindowStateInfo obtain(WindowState windowState) {
            WindowStateInfo info = sPool.acquire();
            if (info == null) {
                info = new WindowStateInfo();
            }
            info.mWindowState = windowState;
            windowState.getTouchableRegion(mTempRegion);
            mTempRegion.getBounds(info.mTouchableRegion);
            return info;
        }

        public void recycle() {
            this.mWindowState = null;
            this.mTouchableRegion.setEmpty();
            sPool.release(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MagnifiedViewport {
        private static final int DEFAUTLT_BORDER_WIDTH_DIP = 5;
        private final SparseArray<WindowStateInfo> mTempWindowStateInfos = new SparseArray();
        private final float[] mTempFloats = new float[9];
        private final RectF mTempRectF = new RectF();
        private final Point mTempPoint = new Point();
        private final Matrix mTempMatrix = new Matrix();
        private final Region mMagnifiedBounds = new Region();
        private final Region mOldMagnifiedBounds = new Region();
        private final MagnificationSpec mMagnificationSpec = MagnificationSpec.obtain();
        private final WindowManager mWindowManager;
        private final int mBorderWidth;
        private final int mHalfBorderWidth;
        private final ViewportWindow mWindow;
        private boolean mFullRedrawNeeded;

        public MagnifiedViewport() {
            this.mWindowManager = (WindowManager)DisplayMagnifier.this.mContext.getSystemService("window");
            this.mBorderWidth = (int)TypedValue.applyDimension(1, 5.0f, DisplayMagnifier.this.mContext.getResources().getDisplayMetrics());
            this.mHalfBorderWidth = (int)((double)this.mBorderWidth + 0.5) / 2;
            this.mWindow = new ViewportWindow(DisplayMagnifier.this.mContext);
            this.recomputeBoundsLocked();
        }

        public void updateMagnificationSpecLocked(MagnificationSpec spec) {
            if (spec != null) {
                this.mMagnificationSpec.initialize(spec.scale, spec.offsetX, spec.offsetY);
            } else {
                this.mMagnificationSpec.clear();
            }
            if (!DisplayMagnifier.this.mHandler.hasMessages(5)) {
                this.setMagnifiedRegionBorderShownLocked(this.isMagnifyingLocked(), true);
            }
        }

        public void recomputeBoundsLocked() {
            WindowStateInfo info;
            int i;
            this.mWindowManager.getDefaultDisplay().getRealSize(this.mTempPoint);
            int screenWidth = this.mTempPoint.x;
            int screenHeight = this.mTempPoint.y;
            Region magnifiedBounds = this.mMagnifiedBounds;
            magnifiedBounds.set(0, 0, 0, 0);
            Region availableBounds = DisplayMagnifier.this.mTempRegion1;
            availableBounds.set(0, 0, screenWidth, screenHeight);
            Region nonMagnifiedBounds = DisplayMagnifier.this.mTempRegion4;
            nonMagnifiedBounds.set(0, 0, 0, 0);
            SparseArray<WindowStateInfo> visibleWindows = this.mTempWindowStateInfos;
            visibleWindows.clear();
            this.getWindowsOnScreenLocked(visibleWindows);
            int visibleWindowCount = visibleWindows.size();
            for (i = visibleWindowCount - 1; i >= 0; --i) {
                info = visibleWindows.valueAt(i);
                if (info.mWindowState.mAttrs.type == 2027) continue;
                Region windowBounds = DisplayMagnifier.this.mTempRegion2;
                Matrix matrix = this.mTempMatrix;
                this.populateTransformationMatrix(info.mWindowState, matrix);
                RectF windowFrame = this.mTempRectF;
                if (((DisplayMagnifier)DisplayMagnifier.this).mWindowManagerService.mPolicy.canMagnifyWindow(info.mWindowState.mAttrs.type)) {
                    windowFrame.set(info.mWindowState.mFrame);
                    windowFrame.offset(-windowFrame.left, -windowFrame.top);
                    matrix.mapRect(windowFrame);
                    windowBounds.set((int)windowFrame.left, (int)windowFrame.top, (int)windowFrame.right, (int)windowFrame.bottom);
                    magnifiedBounds.op(windowBounds, Region.Op.UNION);
                    magnifiedBounds.op(availableBounds, Region.Op.INTERSECT);
                } else {
                    windowFrame.set(info.mTouchableRegion);
                    windowFrame.offset(-info.mWindowState.mFrame.left, -info.mWindowState.mFrame.top);
                    matrix.mapRect(windowFrame);
                    windowBounds.set((int)windowFrame.left, (int)windowFrame.top, (int)windowFrame.right, (int)windowFrame.bottom);
                    nonMagnifiedBounds.op(windowBounds, Region.Op.UNION);
                    windowBounds.op(magnifiedBounds, Region.Op.DIFFERENCE);
                    availableBounds.op(windowBounds, Region.Op.DIFFERENCE);
                }
                Region accountedBounds = DisplayMagnifier.this.mTempRegion2;
                accountedBounds.set(magnifiedBounds);
                accountedBounds.op(nonMagnifiedBounds, Region.Op.UNION);
                accountedBounds.op(0, 0, screenWidth, screenHeight, Region.Op.INTERSECT);
                if (!accountedBounds.isRect()) continue;
                Rect accountedFrame = DisplayMagnifier.this.mTempRect1;
                accountedBounds.getBounds(accountedFrame);
                if (accountedFrame.width() == screenWidth && accountedFrame.height() == screenHeight) break;
            }
            for (i = visibleWindowCount - 1; i >= 0; --i) {
                info = visibleWindows.valueAt(i);
                info.recycle();
                visibleWindows.removeAt(i);
            }
            magnifiedBounds.op(this.mHalfBorderWidth, this.mHalfBorderWidth, screenWidth - this.mHalfBorderWidth, screenHeight - this.mHalfBorderWidth, Region.Op.INTERSECT);
            if (!this.mOldMagnifiedBounds.equals(magnifiedBounds)) {
                Region bounds = Region.obtain();
                bounds.set(magnifiedBounds);
                DisplayMagnifier.this.mHandler.obtainMessage(1, bounds).sendToTarget();
                this.mWindow.setBounds(magnifiedBounds);
                Rect dirtyRect = DisplayMagnifier.this.mTempRect1;
                if (this.mFullRedrawNeeded) {
                    this.mFullRedrawNeeded = false;
                    dirtyRect.set(this.mHalfBorderWidth, this.mHalfBorderWidth, screenWidth - this.mHalfBorderWidth, screenHeight - this.mHalfBorderWidth);
                    this.mWindow.invalidate(dirtyRect);
                } else {
                    Region dirtyRegion = DisplayMagnifier.this.mTempRegion3;
                    dirtyRegion.set(magnifiedBounds);
                    dirtyRegion.op(this.mOldMagnifiedBounds, Region.Op.UNION);
                    dirtyRegion.op(nonMagnifiedBounds, Region.Op.INTERSECT);
                    dirtyRegion.getBounds(dirtyRect);
                    this.mWindow.invalidate(dirtyRect);
                }
                this.mOldMagnifiedBounds.set(magnifiedBounds);
            }
        }

        private void populateTransformationMatrix(WindowState windowState, Matrix outMatrix) {
            this.mTempFloats[0] = windowState.mWinAnimator.mDsDx;
            this.mTempFloats[3] = windowState.mWinAnimator.mDtDx;
            this.mTempFloats[1] = windowState.mWinAnimator.mDsDy;
            this.mTempFloats[4] = windowState.mWinAnimator.mDtDy;
            this.mTempFloats[2] = windowState.mShownFrame.left;
            this.mTempFloats[5] = windowState.mShownFrame.top;
            this.mTempFloats[6] = 0.0f;
            this.mTempFloats[7] = 0.0f;
            this.mTempFloats[8] = 1.0f;
            outMatrix.setValues(this.mTempFloats);
        }

        private void getWindowsOnScreenLocked(SparseArray<WindowStateInfo> outWindowStates) {
            DisplayContent displayContent = DisplayMagnifier.this.mWindowManagerService.getDefaultDisplayContentLocked();
            WindowList windowList = displayContent.getWindowList();
            int windowCount = windowList.size();
            for (int i = 0; i < windowCount; ++i) {
                WindowState windowState = (WindowState)windowList.get(i);
                if (!windowState.isOnScreen() && windowState.mAttrs.type != 2025 || windowState.mWinAnimator.mEnterAnimationPending) continue;
                outWindowStates.put(windowState.mLayer, WindowStateInfo.obtain(windowState));
            }
        }

        public void onRotationChangedLocked() {
            if (this.isMagnifyingLocked()) {
                this.setMagnifiedRegionBorderShownLocked(false, false);
                long delay = (long)((float)DisplayMagnifier.this.mLongAnimationDuration * ((DisplayMagnifier)DisplayMagnifier.this).mWindowManagerService.mWindowAnimationScale);
                Message message = DisplayMagnifier.this.mHandler.obtainMessage(5);
                DisplayMagnifier.this.mHandler.sendMessageDelayed(message, delay);
            }
            this.recomputeBoundsLocked();
            this.mWindow.updateSize();
        }

        public void setMagnifiedRegionBorderShownLocked(boolean shown, boolean animate) {
            if (shown) {
                this.mFullRedrawNeeded = true;
                this.mOldMagnifiedBounds.set(0, 0, 0, 0);
            }
            this.mWindow.setShown(shown, animate);
        }

        public void getMagnifiedFrameInContentCoordsLocked(Rect rect) {
            MagnificationSpec spec = this.mMagnificationSpec;
            this.mMagnifiedBounds.getBounds(rect);
            rect.offset((int)(-spec.offsetX), (int)(-spec.offsetY));
            rect.scale(1.0f / spec.scale);
        }

        public boolean isMagnifyingLocked() {
            return this.mMagnificationSpec.scale > 1.0f;
        }

        public MagnificationSpec getMagnificationSpecLocked() {
            return this.mMagnificationSpec;
        }

        public void drawWindowIfNeededLocked() {
            this.recomputeBoundsLocked();
            this.mWindow.drawIfNeeded();
        }

        public void destroyWindow() {
            this.mWindow.releaseSurface();
        }

        private final class ViewportWindow {
            private static final String SURFACE_TITLE = "Magnification Overlay";
            private static final String PROPERTY_NAME_ALPHA = "alpha";
            private static final int MIN_ALPHA = 0;
            private static final int MAX_ALPHA = 255;
            private final Region mBounds = new Region();
            private final Rect mDirtyRect = new Rect();
            private final Paint mPaint = new Paint();
            private final ValueAnimator mShowHideFrameAnimator;
            private final SurfaceControl mSurfaceControl;
            private final Surface mSurface = new Surface();
            private boolean mShown;
            private int mAlpha;
            private boolean mInvalidated;

            public ViewportWindow(Context context) {
                SurfaceControl surfaceControl = null;
                try {
                    MagnifiedViewport.this.mWindowManager.getDefaultDisplay().getRealSize(MagnifiedViewport.this.mTempPoint);
                    surfaceControl = new SurfaceControl(((DisplayMagnifier)DisplayMagnifier.this).mWindowManagerService.mFxSession, SURFACE_TITLE, ((MagnifiedViewport)MagnifiedViewport.this).mTempPoint.x, ((MagnifiedViewport)MagnifiedViewport.this).mTempPoint.y, -3, 4);
                }
                catch (Surface.OutOfResourcesException oore) {
                    // empty catch block
                }
                this.mSurfaceControl = surfaceControl;
                this.mSurfaceControl.setLayerStack(MagnifiedViewport.this.mWindowManager.getDefaultDisplay().getLayerStack());
                this.mSurfaceControl.setLayer(((DisplayMagnifier)DisplayMagnifier.this).mWindowManagerService.mPolicy.windowTypeToLayerLw(2027) * 10000);
                this.mSurfaceControl.setPosition(0.0f, 0.0f);
                this.mSurface.copyFrom(this.mSurfaceControl);
                TypedValue typedValue = new TypedValue();
                context.getTheme().resolveAttribute(16843664, typedValue, true);
                int borderColor = context.getResources().getColor(typedValue.resourceId);
                this.mPaint.setStyle(Paint.Style.STROKE);
                this.mPaint.setStrokeWidth(MagnifiedViewport.this.mBorderWidth);
                this.mPaint.setColor(borderColor);
                DecelerateInterpolator interpolator2 = new DecelerateInterpolator(2.5f);
                long longAnimationDuration = context.getResources().getInteger(17694722);
                this.mShowHideFrameAnimator = ObjectAnimator.ofInt(this, PROPERTY_NAME_ALPHA, 0, 255);
                this.mShowHideFrameAnimator.setInterpolator(interpolator2);
                this.mShowHideFrameAnimator.setDuration(longAnimationDuration);
                this.mInvalidated = true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setShown(boolean shown, boolean animate) {
                HashMap<IBinder, WindowState> hashMap = ((DisplayMagnifier)DisplayMagnifier.this).mWindowManagerService.mWindowMap;
                synchronized (hashMap) {
                    if (this.mShown == shown) {
                        return;
                    }
                    this.mShown = shown;
                    if (animate) {
                        if (this.mShowHideFrameAnimator.isRunning()) {
                            this.mShowHideFrameAnimator.reverse();
                        } else if (shown) {
                            this.mShowHideFrameAnimator.start();
                        } else {
                            this.mShowHideFrameAnimator.reverse();
                        }
                    } else {
                        this.mShowHideFrameAnimator.cancel();
                        if (shown) {
                            this.setAlpha(255);
                        } else {
                            this.setAlpha(0);
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int getAlpha() {
                HashMap<IBinder, WindowState> hashMap = ((DisplayMagnifier)DisplayMagnifier.this).mWindowManagerService.mWindowMap;
                synchronized (hashMap) {
                    return this.mAlpha;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setAlpha(int alpha) {
                HashMap<IBinder, WindowState> hashMap = ((DisplayMagnifier)DisplayMagnifier.this).mWindowManagerService.mWindowMap;
                synchronized (hashMap) {
                    if (this.mAlpha == alpha) {
                        return;
                    }
                    this.mAlpha = alpha;
                    this.invalidate(null);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setBounds(Region bounds) {
                HashMap<IBinder, WindowState> hashMap = ((DisplayMagnifier)DisplayMagnifier.this).mWindowManagerService.mWindowMap;
                synchronized (hashMap) {
                    if (this.mBounds.equals(bounds)) {
                        return;
                    }
                    this.mBounds.set(bounds);
                    this.invalidate(this.mDirtyRect);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void updateSize() {
                HashMap<IBinder, WindowState> hashMap = ((DisplayMagnifier)DisplayMagnifier.this).mWindowManagerService.mWindowMap;
                synchronized (hashMap) {
                    MagnifiedViewport.this.mWindowManager.getDefaultDisplay().getRealSize(MagnifiedViewport.this.mTempPoint);
                    this.mSurfaceControl.setSize(((MagnifiedViewport)MagnifiedViewport.this).mTempPoint.x, ((MagnifiedViewport)MagnifiedViewport.this).mTempPoint.y);
                    this.invalidate(this.mDirtyRect);
                }
            }

            public void invalidate(Rect dirtyRect) {
                if (dirtyRect != null) {
                    this.mDirtyRect.set(dirtyRect);
                } else {
                    this.mDirtyRect.setEmpty();
                }
                this.mInvalidated = true;
                DisplayMagnifier.this.mWindowManagerService.scheduleAnimationLocked();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void drawIfNeeded() {
                HashMap<IBinder, WindowState> hashMap = ((DisplayMagnifier)DisplayMagnifier.this).mWindowManagerService.mWindowMap;
                synchronized (hashMap) {
                    if (!this.mInvalidated) {
                        return;
                    }
                    this.mInvalidated = false;
                    Canvas canvas = null;
                    try {
                        if (this.mDirtyRect.isEmpty()) {
                            this.mBounds.getBounds(this.mDirtyRect);
                        }
                        this.mDirtyRect.inset(-MagnifiedViewport.this.mHalfBorderWidth, -MagnifiedViewport.this.mHalfBorderWidth);
                        canvas = this.mSurface.lockCanvas(this.mDirtyRect);
                    }
                    catch (IllegalArgumentException iae) {
                    }
                    catch (Surface.OutOfResourcesException oore) {
                        // empty catch block
                    }
                    if (canvas == null) {
                        return;
                    }
                    canvas.drawColor(0, PorterDuff.Mode.CLEAR);
                    this.mPaint.setAlpha(this.mAlpha);
                    Path path = this.mBounds.getBoundaryPath();
                    canvas.drawPath(path, this.mPaint);
                    this.mSurface.unlockCanvasAndPost(canvas);
                    if (this.mAlpha > 0) {
                        this.mSurfaceControl.show();
                    } else {
                        this.mSurfaceControl.hide();
                    }
                }
            }

            public void releaseSurface() {
                this.mSurfaceControl.release();
                this.mSurface.release();
            }
        }
    }
}

