/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system;

import dalvik.system.CloseGuard;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import libcore.io.ErrnoException;
import libcore.io.Libcore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DexFile {
    private int mCookie;
    private final String mFileName;
    private final CloseGuard guard = CloseGuard.get();

    public DexFile(File file) throws IOException {
        this(file.getPath());
    }

    public DexFile(String fileName) throws IOException {
        this.mCookie = DexFile.openDexFile(fileName, null, 0);
        this.mFileName = fileName;
        this.guard.open("close");
    }

    private DexFile(String sourceName, String outputName, int flags) throws IOException {
        if (outputName != null) {
            try {
                String parent = new File(outputName).getParent();
                if (Libcore.os.getuid() != Libcore.os.stat((String)parent).st_uid) {
                    throw new IllegalArgumentException("Optimized data directory " + parent + " is not owned by the current user. Shared storage cannot protect" + " your application from code injection attacks.");
                }
            }
            catch (ErrnoException ignored) {
                // empty catch block
            }
        }
        this.mCookie = DexFile.openDexFile(sourceName, outputName, flags);
        this.mFileName = sourceName;
        this.guard.open("close");
    }

    public static DexFile loadDex(String sourcePathName, String outputPathName, int flags) throws IOException {
        return new DexFile(sourcePathName, outputPathName, flags);
    }

    public String getName() {
        return this.mFileName;
    }

    public void close() throws IOException {
        if (this.mCookie != 0) {
            this.guard.close();
            DexFile.closeDexFile(this.mCookie);
            this.mCookie = 0;
        }
    }

    public Class loadClass(String name, ClassLoader loader) {
        String slashName = name.replace('.', '/');
        return this.loadClassBinaryName(slashName, loader, null);
    }

    public Class loadClassBinaryName(String name, ClassLoader loader, List<Throwable> suppressed) {
        return DexFile.defineClass(name, loader, this.mCookie, suppressed);
    }

    private static Class defineClass(String name, ClassLoader loader, int cookie, List<Throwable> suppressed) {
        Class result;
        block4: {
            result = null;
            try {
                result = DexFile.defineClassNative(name, loader, cookie);
            }
            catch (NoClassDefFoundError e) {
                if (suppressed != null) {
                    suppressed.add(e);
                }
            }
            catch (ClassNotFoundException e) {
                if (suppressed == null) break block4;
                suppressed.add(e);
            }
        }
        return result;
    }

    private static native Class defineClassNative(String var0, ClassLoader var1, int var2) throws ClassNotFoundException, NoClassDefFoundError;

    public Enumeration<String> entries() {
        return new DFEnum(this);
    }

    private static native String[] getClassNameList(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.guard != null) {
                this.guard.warnIfOpen();
            }
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private static int openDexFile(String sourceName, String outputName, int flags) throws IOException {
        return DexFile.openDexFileNative(new File(sourceName).getCanonicalPath(), outputName == null ? null : new File(outputName).getCanonicalPath(), flags);
    }

    private static native int openDexFileNative(String var0, String var1, int var2) throws IOException;

    private static native void closeDexFile(int var0);

    public static native boolean isDexOptNeeded(String var0) throws FileNotFoundException, IOException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DFEnum
    implements Enumeration<String> {
        private int mIndex = 0;
        private String[] mNameList;

        DFEnum(DexFile df) {
            this.mNameList = DexFile.getClassNameList(DexFile.this.mCookie);
        }

        @Override
        public boolean hasMoreElements() {
            return this.mIndex < this.mNameList.length;
        }

        @Override
        public String nextElement() {
            return this.mNameList[this.mIndex++];
        }
    }
}

