/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip;

import gov.nist.core.ServerLogger;
import gov.nist.core.StackLogger;
import gov.nist.core.net.AddressResolver;
import gov.nist.core.net.NetworkLayer;
import gov.nist.core.net.SslNetworkLayer;
import gov.nist.javax.sip.EventScanner;
import gov.nist.javax.sip.ListeningPointImpl;
import gov.nist.javax.sip.LogRecordFactory;
import gov.nist.javax.sip.NistSipMessageFactoryImpl;
import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.SipStackExt;
import gov.nist.javax.sip.clientauthutils.AccountManager;
import gov.nist.javax.sip.clientauthutils.AuthenticationHelper;
import gov.nist.javax.sip.clientauthutils.AuthenticationHelperImpl;
import gov.nist.javax.sip.clientauthutils.SecureAccountManager;
import gov.nist.javax.sip.parser.StringMsgParser;
import gov.nist.javax.sip.stack.DefaultMessageLogFactory;
import gov.nist.javax.sip.stack.DefaultRouter;
import gov.nist.javax.sip.stack.MessageProcessor;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.sip.InvalidArgumentException;
import javax.sip.ListeningPoint;
import javax.sip.ObjectInUseException;
import javax.sip.PeerUnavailableException;
import javax.sip.ProviderDoesNotExistException;
import javax.sip.SipException;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.TransportNotSupportedException;
import javax.sip.address.Router;
import javax.sip.header.HeaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SipStackImpl
extends SIPTransactionStack
implements SipStack,
SipStackExt {
    private EventScanner eventScanner;
    private Hashtable<String, ListeningPointImpl> listeningPoints;
    private LinkedList<SipProviderImpl> sipProviders;
    public static final Integer MAX_DATAGRAM_SIZE = 8192;
    boolean reEntrantListener;
    SipListener sipListener;
    boolean deliverTerminatedEventForAck;
    boolean deliverUnsolicitedNotify;
    private Semaphore stackSemaphore;
    private String[] cipherSuites;
    private String[] enabledProtocols;

    protected SipStackImpl() {
        this.deliverTerminatedEventForAck = false;
        this.deliverUnsolicitedNotify = false;
        this.stackSemaphore = new Semaphore(1);
        this.cipherSuites = new String[]{"TLS_RSA_WITH_AES_128_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_DH_anon_WITH_AES_128_CBC_SHA", "SSL_DH_anon_WITH_3DES_EDE_CBC_SHA"};
        this.enabledProtocols = new String[]{"SSLv3", "SSLv2Hello", "TLSv1"};
        NistSipMessageFactoryImpl msgFactory = new NistSipMessageFactoryImpl(this);
        super.setMessageFactory(msgFactory);
        this.eventScanner = new EventScanner(this);
        this.listeningPoints = new Hashtable();
        this.sipProviders = new LinkedList();
    }

    private void reInitialize() {
        super.reInit();
        this.eventScanner = new EventScanner(this);
        this.listeningPoints = new Hashtable();
        this.sipProviders = new LinkedList();
        this.sipListener = null;
    }

    boolean isAutomaticDialogSupportEnabled() {
        return this.isAutomaticDialogSupportEnabled;
    }

    public SipStackImpl(Properties configurationProperties) throws PeerUnavailableException {
        boolean congetstionControlEnabled;
        InputStream in;
        block84: {
            block83: {
                String stunAddr;
                block82: {
                    String readTimeout;
                    String clientTransactionTableSize;
                    String serverTransactionTableSize;
                    block81: {
                        String threadPoolSize;
                        block80: {
                            String maxConnections;
                            String extensionMethods;
                            this();
                            String address = configurationProperties.getProperty("javax.sip.IP_ADDRESS");
                            try {
                                if (address != null) {
                                    super.setHostAddress(address);
                                }
                            }
                            catch (UnknownHostException ex) {
                                throw new PeerUnavailableException("bad address " + address);
                            }
                            String name = configurationProperties.getProperty("javax.sip.STACK_NAME");
                            if (name == null) {
                                throw new PeerUnavailableException("stack name is missing");
                            }
                            super.setStackName(name);
                            String stackLoggerClassName = configurationProperties.getProperty("gov.nist.javax.sip.STACK_LOGGER");
                            if (stackLoggerClassName == null) {
                                stackLoggerClassName = "gov.nist.core.LogWriter";
                            }
                            try {
                                Class<?> stackLoggerClass = Class.forName(stackLoggerClassName);
                                Class[] constructorArgs = new Class[]{};
                                Constructor<?> cons = stackLoggerClass.getConstructor(constructorArgs);
                                Object[] args = new Object[]{};
                                StackLogger stackLogger = (StackLogger)cons.newInstance(args);
                                stackLogger.setStackProperties(configurationProperties);
                                super.setStackLogger(stackLogger);
                            }
                            catch (InvocationTargetException ex1) {
                                throw new IllegalArgumentException("Cound not instantiate stack logger " + stackLoggerClassName + "- check that it is present on the classpath and that there is a no-args constructor defined", ex1);
                            }
                            catch (Exception ex) {
                                throw new IllegalArgumentException("Cound not instantiate stack logger " + stackLoggerClassName + "- check that it is present on the classpath and that there is a no-args constructor defined", ex);
                            }
                            String serverLoggerClassName = configurationProperties.getProperty("gov.nist.javax.sip.SERVER_LOGGER");
                            if (serverLoggerClassName == null) {
                                serverLoggerClassName = "gov.nist.javax.sip.stack.ServerLog";
                            }
                            try {
                                Class<?> serverLoggerClass = Class.forName(serverLoggerClassName);
                                Class[] constructorArgs = new Class[]{};
                                Constructor<?> cons = serverLoggerClass.getConstructor(constructorArgs);
                                Object[] args = new Object[]{};
                                this.serverLogger = (ServerLogger)cons.newInstance(args);
                                this.serverLogger.setSipStack(this);
                                this.serverLogger.setStackProperties(configurationProperties);
                            }
                            catch (InvocationTargetException ex1) {
                                throw new IllegalArgumentException("Cound not instantiate server logger " + stackLoggerClassName + "- check that it is present on the classpath and that there is a no-args constructor defined", ex1);
                            }
                            catch (Exception ex) {
                                throw new IllegalArgumentException("Cound not instantiate server logger " + stackLoggerClassName + "- check that it is present on the classpath and that there is a no-args constructor defined", ex);
                            }
                            this.outboundProxy = configurationProperties.getProperty("javax.sip.OUTBOUND_PROXY");
                            this.defaultRouter = new DefaultRouter(this, this.outboundProxy);
                            String routerPath = configurationProperties.getProperty("javax.sip.ROUTER_PATH");
                            if (routerPath == null) {
                                routerPath = "gov.nist.javax.sip.stack.DefaultRouter";
                            }
                            try {
                                Class<?> routerClass = Class.forName(routerPath);
                                Class[] constructorArgs = new Class[]{SipStack.class, String.class};
                                Constructor<?> cons = routerClass.getConstructor(constructorArgs);
                                Object[] args = new Object[]{this, this.outboundProxy};
                                Router router = (Router)cons.newInstance(args);
                                super.setRouter(router);
                            }
                            catch (InvocationTargetException ex1) {
                                this.getStackLogger().logError("could not instantiate router -- invocation target problem", (Exception)ex1.getCause());
                                throw new PeerUnavailableException("Cound not instantiate router - check constructor", ex1);
                            }
                            catch (Exception ex) {
                                this.getStackLogger().logError("could not instantiate router", (Exception)ex.getCause());
                                throw new PeerUnavailableException("Could not instantiate router", ex);
                            }
                            String useRouterForAll = configurationProperties.getProperty("javax.sip.USE_ROUTER_FOR_ALL_URIS");
                            this.useRouterForAll = true;
                            if (useRouterForAll != null) {
                                this.useRouterForAll = "true".equalsIgnoreCase(useRouterForAll);
                            }
                            if ((extensionMethods = configurationProperties.getProperty("javax.sip.EXTENSION_METHODS")) != null) {
                                StringTokenizer st = new StringTokenizer(extensionMethods);
                                while (st.hasMoreTokens()) {
                                    String em = st.nextToken(":");
                                    if (em.equalsIgnoreCase("BYE") || em.equalsIgnoreCase("INVITE") || em.equalsIgnoreCase("SUBSCRIBE") || em.equalsIgnoreCase("NOTIFY") || em.equalsIgnoreCase("ACK") || em.equalsIgnoreCase("OPTIONS")) {
                                        throw new PeerUnavailableException("Bad extension method " + em);
                                    }
                                    this.addExtensionMethod(em);
                                }
                            }
                            String keyStoreFile = configurationProperties.getProperty("javax.net.ssl.keyStore");
                            String trustStoreFile = configurationProperties.getProperty("javax.net.ssl.trustStore");
                            if (keyStoreFile != null) {
                                if (trustStoreFile == null) {
                                    trustStoreFile = keyStoreFile;
                                }
                                String keyStorePassword = configurationProperties.getProperty("javax.net.ssl.keyStorePassword");
                                try {
                                    this.networkLayer = new SslNetworkLayer(trustStoreFile, keyStoreFile, keyStorePassword.toCharArray(), configurationProperties.getProperty("javax.net.ssl.keyStoreType"));
                                }
                                catch (Exception e1) {
                                    this.getStackLogger().logError("could not instantiate SSL networking", e1);
                                }
                            }
                            this.isAutomaticDialogSupportEnabled = configurationProperties.getProperty("javax.sip.AUTOMATIC_DIALOG_SUPPORT", "on").equalsIgnoreCase("on");
                            this.isAutomaticDialogErrorHandlingEnabled = configurationProperties.getProperty("gov.nist.javax.sip.AUTOMATIC_DIALOG_ERROR_HANDLING", "true").equals(Boolean.TRUE.toString());
                            if (this.isAutomaticDialogSupportEnabled) {
                                this.isAutomaticDialogErrorHandlingEnabled = true;
                            }
                            if (configurationProperties.getProperty("gov.nist.javax.sip.MAX_LISTENER_RESPONSE_TIME") != null) {
                                this.maxListenerResponseTime = Integer.parseInt(configurationProperties.getProperty("gov.nist.javax.sip.MAX_LISTENER_RESPONSE_TIME"));
                                if (this.maxListenerResponseTime <= 0) {
                                    throw new PeerUnavailableException("Bad configuration parameter gov.nist.javax.sip.MAX_LISTENER_RESPONSE_TIME : should be positive");
                                }
                            } else {
                                this.maxListenerResponseTime = -1;
                            }
                            this.deliverTerminatedEventForAck = configurationProperties.getProperty("gov.nist.javax.sip.DELIVER_TERMINATED_EVENT_FOR_ACK", "false").equalsIgnoreCase("true");
                            this.deliverUnsolicitedNotify = configurationProperties.getProperty("gov.nist.javax.sip.DELIVER_UNSOLICITED_NOTIFY", "false").equalsIgnoreCase("true");
                            String forkedSubscriptions = configurationProperties.getProperty("javax.sip.FORKABLE_EVENTS");
                            if (forkedSubscriptions != null) {
                                StringTokenizer st = new StringTokenizer(forkedSubscriptions);
                                while (st.hasMoreTokens()) {
                                    String nextEvent = st.nextToken();
                                    this.forkedEvents.add(nextEvent);
                                }
                            }
                            String NETWORK_LAYER_KEY = "gov.nist.javax.sip.NETWORK_LAYER";
                            if (configurationProperties.containsKey("gov.nist.javax.sip.NETWORK_LAYER")) {
                                String path = configurationProperties.getProperty("gov.nist.javax.sip.NETWORK_LAYER");
                                try {
                                    Class<?> clazz = Class.forName(path);
                                    Constructor<?> c = clazz.getConstructor(new Class[0]);
                                    this.networkLayer = (NetworkLayer)c.newInstance(new Object[0]);
                                }
                                catch (Exception e) {
                                    throw new PeerUnavailableException("can't find or instantiate NetworkLayer implementation: " + path);
                                }
                            }
                            String ADDRESS_RESOLVER_KEY = "gov.nist.javax.sip.ADDRESS_RESOLVER";
                            if (configurationProperties.containsKey("gov.nist.javax.sip.ADDRESS_RESOLVER")) {
                                String path = configurationProperties.getProperty("gov.nist.javax.sip.ADDRESS_RESOLVER");
                                try {
                                    Class<?> clazz = Class.forName(path);
                                    Constructor<?> c = clazz.getConstructor(new Class[0]);
                                    this.addressResolver = (AddressResolver)c.newInstance(new Object[0]);
                                }
                                catch (Exception e) {
                                    throw new PeerUnavailableException("can't find or instantiate AddressResolver implementation: " + path);
                                }
                            }
                            if ((maxConnections = configurationProperties.getProperty("gov.nist.javax.sip.MAX_CONNECTIONS")) != null) {
                                try {
                                    this.maxConnections = new Integer(maxConnections);
                                }
                                catch (NumberFormatException ex) {
                                    if (!this.isLoggingEnabled()) break block80;
                                    this.getStackLogger().logError("max connections - bad value " + ex.getMessage());
                                }
                            }
                        }
                        if ((threadPoolSize = configurationProperties.getProperty("gov.nist.javax.sip.THREAD_POOL_SIZE")) != null) {
                            try {
                                this.threadPoolSize = new Integer(threadPoolSize);
                            }
                            catch (NumberFormatException ex) {
                                if (!this.isLoggingEnabled()) break block81;
                                this.getStackLogger().logError("thread pool size - bad value " + ex.getMessage());
                            }
                        }
                    }
                    if ((serverTransactionTableSize = configurationProperties.getProperty("gov.nist.javax.sip.MAX_SERVER_TRANSACTIONS")) != null) {
                        try {
                            this.serverTransactionTableHighwaterMark = new Integer(serverTransactionTableSize);
                            this.serverTransactionTableLowaterMark = this.serverTransactionTableHighwaterMark * 80 / 100;
                        }
                        catch (NumberFormatException ex) {
                            if (this.isLoggingEnabled()) {
                                this.getStackLogger().logError("transaction table size - bad value " + ex.getMessage());
                            }
                        }
                    } else {
                        this.unlimitedServerTransactionTableSize = true;
                    }
                    if ((clientTransactionTableSize = configurationProperties.getProperty("gov.nist.javax.sip.MAX_CLIENT_TRANSACTIONS")) != null) {
                        try {
                            this.clientTransactionTableHiwaterMark = new Integer(clientTransactionTableSize);
                            this.clientTransactionTableLowaterMark = this.clientTransactionTableLowaterMark * 80 / 100;
                        }
                        catch (NumberFormatException ex) {
                            if (this.isLoggingEnabled()) {
                                this.getStackLogger().logError("transaction table size - bad value " + ex.getMessage());
                            }
                        }
                    } else {
                        this.unlimitedClientTransactionTableSize = true;
                    }
                    this.cacheServerConnections = true;
                    String flag = configurationProperties.getProperty("gov.nist.javax.sip.CACHE_SERVER_CONNECTIONS");
                    if (flag != null && "false".equalsIgnoreCase(flag.trim())) {
                        this.cacheServerConnections = false;
                    }
                    this.cacheClientConnections = true;
                    String cacheflag = configurationProperties.getProperty("gov.nist.javax.sip.CACHE_CLIENT_CONNECTIONS");
                    if (cacheflag != null && "false".equalsIgnoreCase(cacheflag.trim())) {
                        this.cacheClientConnections = false;
                    }
                    if ((readTimeout = configurationProperties.getProperty("gov.nist.javax.sip.READ_TIMEOUT")) != null) {
                        try {
                            int rt = Integer.parseInt(readTimeout);
                            if (rt >= 100) {
                                this.readTimeout = rt;
                            } else {
                                System.err.println("Value too low " + readTimeout);
                            }
                        }
                        catch (NumberFormatException nfe) {
                            if (!this.isLoggingEnabled()) break block82;
                            this.getStackLogger().logError("Bad read timeout " + readTimeout);
                        }
                    }
                }
                if ((stunAddr = configurationProperties.getProperty("gov.nist.javax.sip.STUN_SERVER")) != null) {
                    this.getStackLogger().logWarning("Ignoring obsolete property gov.nist.javax.sip.STUN_SERVER");
                }
                String maxMsgSize = configurationProperties.getProperty("gov.nist.javax.sip.MAX_MESSAGE_SIZE");
                try {
                    if (maxMsgSize != null) {
                        this.maxMessageSize = new Integer(maxMsgSize);
                        if (this.maxMessageSize < 4096) {
                            this.maxMessageSize = 4096;
                        }
                    } else {
                        this.maxMessageSize = 0;
                    }
                }
                catch (NumberFormatException ex) {
                    if (!this.isLoggingEnabled()) break block83;
                    this.getStackLogger().logError("maxMessageSize - bad value " + ex.getMessage());
                }
            }
            String rel = configurationProperties.getProperty("gov.nist.javax.sip.REENTRANT_LISTENER");
            this.reEntrantListener = rel != null && "true".equalsIgnoreCase(rel);
            String interval = configurationProperties.getProperty("gov.nist.javax.sip.THREAD_AUDIT_INTERVAL_IN_MILLISECS");
            if (interval != null) {
                try {
                    this.getThreadAuditor().setPingIntervalInMillisecs(Long.valueOf(interval) / 2L);
                }
                catch (NumberFormatException ex) {
                    if (!this.isLoggingEnabled()) break block84;
                    this.getStackLogger().logError("THREAD_AUDIT_INTERVAL_IN_MILLISECS - bad value [" + interval + "] " + ex.getMessage());
                }
            }
        }
        this.setNon2XXAckPassedToListener(Boolean.valueOf(configurationProperties.getProperty("gov.nist.javax.sip.PASS_INVITE_NON_2XX_ACK_TO_LISTENER", "false")));
        this.generateTimeStampHeader = Boolean.valueOf(configurationProperties.getProperty("gov.nist.javax.sip.AUTO_GENERATE_TIMESTAMP", "false"));
        String messageLogFactoryClasspath = configurationProperties.getProperty("gov.nist.javax.sip.LOG_FACTORY");
        if (messageLogFactoryClasspath != null) {
            try {
                Class<?> clazz = Class.forName(messageLogFactoryClasspath);
                Constructor<?> c = clazz.getConstructor(new Class[0]);
                this.logRecordFactory = (LogRecordFactory)c.newInstance(new Object[0]);
            }
            catch (Exception ex) {
                if (this.isLoggingEnabled()) {
                    this.getStackLogger().logError("Bad configuration value for LOG_FACTORY -- using default logger");
                }
                this.logRecordFactory = new DefaultMessageLogFactory();
            }
        } else {
            this.logRecordFactory = new DefaultMessageLogFactory();
        }
        boolean computeContentLength = configurationProperties.getProperty("gov.nist.javax.sip.COMPUTE_CONTENT_LENGTH_FROM_MESSAGE_BODY", "false").equalsIgnoreCase("true");
        StringMsgParser.setComputeContentLengthFromMessage(computeContentLength);
        String tlsClientProtocols = configurationProperties.getProperty("gov.nist.javax.sip.TLS_CLIENT_PROTOCOLS");
        if (tlsClientProtocols != null) {
            StringTokenizer st = new StringTokenizer(tlsClientProtocols, " ,");
            String[] protocols = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                protocols[i++] = st.nextToken();
            }
            this.enabledProtocols = protocols;
        }
        this.rfc2543Supported = configurationProperties.getProperty("gov.nist.javax.sip.RFC_2543_SUPPORT_ENABLED", "true").equalsIgnoreCase("true");
        this.cancelClientTransactionChecked = configurationProperties.getProperty("gov.nist.javax.sip.CANCEL_CLIENT_TRANSACTION_CHECKED", "true").equalsIgnoreCase("true");
        this.logStackTraceOnMessageSend = configurationProperties.getProperty("gov.nist.javax.sip.LOG_STACK_TRACE_ON_MESSAGE_SEND", "false").equalsIgnoreCase("true");
        if (this.isLoggingEnabled()) {
            this.getStackLogger().logDebug("created Sip stack. Properties = " + configurationProperties);
        }
        if ((in = this.getClass().getResourceAsStream("/TIMESTAMP")) != null) {
            BufferedReader streamReader = new BufferedReader(new InputStreamReader(in));
            try {
                String buildTimeStamp = streamReader.readLine();
                if (in != null) {
                    in.close();
                }
                this.getStackLogger().setBuildTimeStamp(buildTimeStamp);
            }
            catch (IOException ex) {
                this.getStackLogger().logError("Could not open build timestamp.");
            }
        }
        String bufferSize = configurationProperties.getProperty("gov.nist.javax.sip.RECEIVE_UDP_BUFFER_SIZE", MAX_DATAGRAM_SIZE.toString());
        int bufferSizeInteger = new Integer(bufferSize);
        super.setReceiveUdpBufferSize(bufferSizeInteger);
        bufferSize = configurationProperties.getProperty("gov.nist.javax.sip.SEND_UDP_BUFFER_SIZE", MAX_DATAGRAM_SIZE.toString());
        bufferSizeInteger = new Integer(bufferSize);
        super.setSendUdpBufferSize(bufferSizeInteger);
        this.stackDoesCongestionControl = congetstionControlEnabled = Boolean.parseBoolean(configurationProperties.getProperty("gov.nist.javax.sip.CONGESTION_CONTROL_ENABLED", Boolean.TRUE.toString()));
        this.isBackToBackUserAgent = Boolean.parseBoolean(configurationProperties.getProperty("gov.nist.javax.sip.IS_BACK_TO_BACK_USER_AGENT", Boolean.FALSE.toString()));
        this.checkBranchId = Boolean.parseBoolean(configurationProperties.getProperty("gov.nist.javax.sip.REJECT_STRAY_RESPONSES", Boolean.FALSE.toString()));
        this.isDialogTerminatedEventDeliveredForNullDialog = Boolean.parseBoolean(configurationProperties.getProperty("gov.nist.javax.sip.DELIVER_TERMINATED_EVENT_FOR_NULL_DIALOG", Boolean.FALSE.toString()));
        this.maxForkTime = Integer.parseInt(configurationProperties.getProperty("gov.nist.javax.sip.MAX_FORK_TIME_SECONDS", "0"));
    }

    @Override
    public synchronized ListeningPoint createListeningPoint(String address, int port, String transport) throws TransportNotSupportedException, InvalidArgumentException {
        String key;
        ListeningPointImpl lip;
        if (this.isLoggingEnabled()) {
            this.getStackLogger().logDebug("createListeningPoint : address = " + address + " port = " + port + " transport = " + transport);
        }
        if (address == null) {
            throw new NullPointerException("Address for listening point is null!");
        }
        if (transport == null) {
            throw new NullPointerException("null transport");
        }
        if (port <= 0) {
            throw new InvalidArgumentException("bad port");
        }
        if (!(transport.equalsIgnoreCase("UDP") || transport.equalsIgnoreCase("TLS") || transport.equalsIgnoreCase("TCP") || transport.equalsIgnoreCase("SCTP"))) {
            throw new TransportNotSupportedException("bad transport " + transport);
        }
        if (!this.isAlive()) {
            this.toExit = false;
            this.reInitialize();
        }
        if ((lip = this.listeningPoints.get(key = ListeningPointImpl.makeKey(address, port, transport))) != null) {
            return lip;
        }
        try {
            InetAddress inetAddr = InetAddress.getByName(address);
            MessageProcessor messageProcessor = this.createMessageProcessor(inetAddr, port, transport);
            if (this.isLoggingEnabled()) {
                this.getStackLogger().logDebug("Created Message Processor: " + address + " port = " + port + " transport = " + transport);
            }
            lip = new ListeningPointImpl(this, port, transport);
            lip.messageProcessor = messageProcessor;
            messageProcessor.setListeningPoint(lip);
            this.listeningPoints.put(key, lip);
            messageProcessor.start();
            return lip;
        }
        catch (IOException ex) {
            if (this.isLoggingEnabled()) {
                this.getStackLogger().logError("Invalid argument address = " + address + " port = " + port + " transport = " + transport);
            }
            throw new InvalidArgumentException(ex.getMessage(), ex);
        }
    }

    @Override
    public SipProvider createSipProvider(ListeningPoint listeningPoint) throws ObjectInUseException {
        if (listeningPoint == null) {
            throw new NullPointerException("null listeningPoint");
        }
        if (this.isLoggingEnabled()) {
            this.getStackLogger().logDebug("createSipProvider: " + listeningPoint);
        }
        ListeningPointImpl listeningPointImpl = (ListeningPointImpl)listeningPoint;
        if (listeningPointImpl.sipProvider != null) {
            throw new ObjectInUseException("Provider already attached!");
        }
        SipProviderImpl provider = new SipProviderImpl(this);
        provider.setListeningPoint(listeningPointImpl);
        listeningPointImpl.sipProvider = provider;
        this.sipProviders.add(provider);
        return provider;
    }

    @Override
    public void deleteListeningPoint(ListeningPoint listeningPoint) throws ObjectInUseException {
        if (listeningPoint == null) {
            throw new NullPointerException("null listeningPoint arg");
        }
        ListeningPointImpl lip = (ListeningPointImpl)listeningPoint;
        super.removeMessageProcessor(lip.messageProcessor);
        String key = lip.getKey();
        this.listeningPoints.remove(key);
    }

    @Override
    public void deleteSipProvider(SipProvider sipProvider) throws ObjectInUseException {
        if (sipProvider == null) {
            throw new NullPointerException("null provider arg");
        }
        SipProviderImpl sipProviderImpl = (SipProviderImpl)sipProvider;
        if (sipProviderImpl.getSipListener() != null) {
            throw new ObjectInUseException("SipProvider still has an associated SipListener!");
        }
        sipProviderImpl.removeListeningPoints();
        sipProviderImpl.stop();
        this.sipProviders.remove(sipProvider);
        if (this.sipProviders.isEmpty()) {
            this.stopStack();
        }
    }

    @Override
    public String getIPAddress() {
        return super.getHostAddress();
    }

    @Override
    public Iterator getListeningPoints() {
        return this.listeningPoints.values().iterator();
    }

    @Override
    public boolean isRetransmissionFilterActive() {
        return true;
    }

    @Override
    public Iterator<SipProviderImpl> getSipProviders() {
        return this.sipProviders.iterator();
    }

    @Override
    public String getStackName() {
        return this.stackName;
    }

    protected void finalize() {
        this.stopStack();
    }

    @Override
    public ListeningPoint createListeningPoint(int port, String transport) throws TransportNotSupportedException, InvalidArgumentException {
        if (this.stackAddress == null) {
            throw new NullPointerException("Stack does not have a default IP Address!");
        }
        return this.createListeningPoint(this.stackAddress, port, transport);
    }

    @Override
    public void stop() {
        if (this.isLoggingEnabled()) {
            this.getStackLogger().logDebug("stopStack -- stoppping the stack");
        }
        this.stopStack();
        this.sipProviders = new LinkedList();
        this.listeningPoints = new Hashtable();
        if (this.eventScanner != null) {
            this.eventScanner.forceStop();
        }
        this.eventScanner = null;
    }

    @Override
    public void start() throws ProviderDoesNotExistException, SipException {
        if (this.eventScanner == null) {
            this.eventScanner = new EventScanner(this);
        }
    }

    public SipListener getSipListener() {
        return this.sipListener;
    }

    public LogRecordFactory getLogRecordFactory() {
        return this.logRecordFactory;
    }

    @Deprecated
    public EventScanner getEventScanner() {
        return this.eventScanner;
    }

    @Override
    public AuthenticationHelper getAuthenticationHelper(AccountManager accountManager, HeaderFactory headerFactory) {
        return new AuthenticationHelperImpl(this, accountManager, headerFactory);
    }

    @Override
    public AuthenticationHelper getSecureAuthenticationHelper(SecureAccountManager accountManager, HeaderFactory headerFactory) {
        return new AuthenticationHelperImpl(this, accountManager, headerFactory);
    }

    @Override
    public void setEnabledCipherSuites(String[] newCipherSuites) {
        this.cipherSuites = newCipherSuites;
    }

    public String[] getEnabledCipherSuites() {
        return this.cipherSuites;
    }

    public void setEnabledProtocols(String[] newProtocols) {
        this.enabledProtocols = newProtocols;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setIsBackToBackUserAgent(boolean flag) {
        this.isBackToBackUserAgent = flag;
    }

    public boolean isBackToBackUserAgent() {
        return this.isBackToBackUserAgent;
    }

    public boolean isAutomaticDialogErrorHandlingEnabled() {
        return this.isAutomaticDialogErrorHandlingEnabled;
    }

    public boolean acquireSem() {
        try {
            return this.stackSemaphore.tryAcquire(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            return false;
        }
    }

    public void releaseSem() {
        this.stackSemaphore.release();
    }
}

