/*
 * Decompiled with CFR 0.152.
 */
package java.nio.charset;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.util.WeakHashMap;

public class CoderResult {
    private static final int TYPE_UNDERFLOW = 1;
    private static final int TYPE_OVERFLOW = 2;
    private static final int TYPE_MALFORMED_INPUT = 3;
    private static final int TYPE_UNMAPPABLE_CHAR = 4;
    public static final CoderResult UNDERFLOW = new CoderResult(1, 0);
    public static final CoderResult OVERFLOW = new CoderResult(2, 0);
    private static WeakHashMap<Integer, CoderResult> _malformedErrors = new WeakHashMap();
    private static WeakHashMap<Integer, CoderResult> _unmappableErrors = new WeakHashMap();
    private final int type;
    private final int length;

    private CoderResult(int type, int length) {
        this.type = type;
        this.length = length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized CoderResult malformedForLength(int length) throws IllegalArgumentException {
        if (length > 0) {
            Integer key = length;
            WeakHashMap<Integer, CoderResult> weakHashMap = _malformedErrors;
            synchronized (weakHashMap) {
                CoderResult r = _malformedErrors.get(key);
                if (r == null) {
                    r = new CoderResult(3, length);
                    _malformedErrors.put(key, r);
                }
                return r;
            }
        }
        throw new IllegalArgumentException("length <= 0: " + length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized CoderResult unmappableForLength(int length) throws IllegalArgumentException {
        if (length > 0) {
            Integer key = length;
            WeakHashMap<Integer, CoderResult> weakHashMap = _unmappableErrors;
            synchronized (weakHashMap) {
                CoderResult r = _unmappableErrors.get(key);
                if (r == null) {
                    r = new CoderResult(4, length);
                    _unmappableErrors.put(key, r);
                }
                return r;
            }
        }
        throw new IllegalArgumentException("length <= 0: " + length);
    }

    public boolean isUnderflow() {
        return this.type == 1;
    }

    public boolean isError() {
        return this.type == 3 || this.type == 4;
    }

    public boolean isMalformed() {
        return this.type == 3;
    }

    public boolean isOverflow() {
        return this.type == 2;
    }

    public boolean isUnmappable() {
        return this.type == 4;
    }

    public int length() throws UnsupportedOperationException {
        if (this.type == 3 || this.type == 4) {
            return this.length;
        }
        throw new UnsupportedOperationException("length meaningless for " + this.toString());
    }

    public void throwException() throws BufferUnderflowException, BufferOverflowException, UnmappableCharacterException, MalformedInputException, CharacterCodingException {
        switch (this.type) {
            case 1: {
                throw new BufferUnderflowException();
            }
            case 2: {
                throw new BufferOverflowException();
            }
            case 4: {
                throw new UnmappableCharacterException(this.length);
            }
            case 3: {
                throw new MalformedInputException(this.length);
            }
        }
        throw new CharacterCodingException();
    }

    public String toString() {
        String dsc = null;
        switch (this.type) {
            case 1: {
                dsc = "UNDERFLOW error";
                break;
            }
            case 2: {
                dsc = "OVERFLOW error";
                break;
            }
            case 4: {
                dsc = "Unmappable-character error with erroneous input length " + this.length;
                break;
            }
            case 3: {
                dsc = "Malformed-input error with erroneous input length " + this.length;
                break;
            }
            default: {
                dsc = "";
            }
        }
        return this.getClass().getName() + "[" + dsc + "]";
    }
}

