/*
 * Decompiled with CFR 0.152.
 */
package java.sql;

import dalvik.system.VMStack;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.SQLPermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverManager {
    private static PrintStream thePrintStream;
    private static PrintWriter thePrintWriter;
    private static int loginTimeout;
    private static final List<Driver> theDrivers;
    private static final SQLPermission logPermission;

    private static void loadInitialDrivers() {
        String[] theDriverNames;
        String theDriverList = System.getProperty("jdbc.drivers", null);
        if (theDriverList == null) {
            return;
        }
        for (String element : theDriverNames = theDriverList.split(":")) {
            try {
                Class.forName(element, true, ClassLoader.getSystemClassLoader());
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    private DriverManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregisterDriver(Driver driver) throws SQLException {
        if (driver == null) {
            return;
        }
        ClassLoader callerClassLoader = VMStack.getCallingClassLoader();
        if (!DriverManager.isClassFromClassLoader(driver, callerClassLoader)) {
            throw new SecurityException("calling class not authorized to deregister JDBC driver");
        }
        List<Driver> list = theDrivers;
        synchronized (list) {
            theDrivers.remove(driver);
        }
    }

    public static Connection getConnection(String url) throws SQLException {
        return DriverManager.getConnection(url, new Properties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getConnection(String url, Properties info) throws SQLException {
        String sqlState = "08001";
        if (url == null) {
            throw new SQLException("The url cannot be null", sqlState);
        }
        List<Driver> list = theDrivers;
        synchronized (list) {
            for (Driver theDriver : theDrivers) {
                Connection theConnection = theDriver.connect(url, info);
                if (theConnection == null) continue;
                return theConnection;
            }
        }
        throw new SQLException("No suitable driver", sqlState);
    }

    public static Connection getConnection(String url, String user, String password) throws SQLException {
        Properties theProperties = new Properties();
        if (user != null) {
            theProperties.setProperty("user", user);
        }
        if (password != null) {
            theProperties.setProperty("password", password);
        }
        return DriverManager.getConnection(url, theProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Driver getDriver(String url) throws SQLException {
        ClassLoader callerClassLoader = VMStack.getCallingClassLoader();
        List<Driver> list = theDrivers;
        synchronized (list) {
            for (Driver driver : theDrivers) {
                if (!driver.acceptsURL(url) || !DriverManager.isClassFromClassLoader(driver, callerClassLoader)) continue;
                return driver;
            }
        }
        throw new SQLException("No suitable driver", "08001");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Enumeration<Driver> getDrivers() {
        ClassLoader callerClassLoader = VMStack.getCallingClassLoader();
        List<Driver> list = theDrivers;
        synchronized (list) {
            ArrayList<Driver> result = new ArrayList<Driver>();
            for (Driver driver : theDrivers) {
                if (!DriverManager.isClassFromClassLoader(driver, callerClassLoader)) continue;
                result.add(driver);
            }
            return Collections.enumeration(result);
        }
    }

    public static int getLoginTimeout() {
        return loginTimeout;
    }

    @Deprecated
    public static PrintStream getLogStream() {
        return thePrintStream;
    }

    public static PrintWriter getLogWriter() {
        return thePrintWriter;
    }

    public static void println(String message) {
        if (thePrintWriter != null) {
            thePrintWriter.println(message);
            thePrintWriter.flush();
        } else if (thePrintStream != null) {
            thePrintStream.println(message);
            thePrintStream.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerDriver(Driver driver) throws SQLException {
        if (driver == null) {
            throw new NullPointerException("driver == null");
        }
        List<Driver> list = theDrivers;
        synchronized (list) {
            theDrivers.add(driver);
        }
    }

    public static void setLoginTimeout(int seconds) {
        loginTimeout = seconds;
    }

    @Deprecated
    public static void setLogStream(PrintStream out) {
        thePrintStream = out;
    }

    public static void setLogWriter(PrintWriter out) {
        thePrintWriter = out;
    }

    private static boolean isClassFromClassLoader(Object theObject, ClassLoader theClassLoader) {
        if (theObject == null || theClassLoader == null) {
            return false;
        }
        Class<?> objectClass = theObject.getClass();
        try {
            Class<?> checkClass = Class.forName(objectClass.getName(), true, theClassLoader);
            if (checkClass == objectClass) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    static {
        loginTimeout = 0;
        theDrivers = new ArrayList<Driver>(10);
        logPermission = new SQLPermission("setLog");
        DriverManager.loadInitialDrivers();
    }
}

