/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import dalvik.system.CloseGuard;
import java.util.Arrays;
import libcore.util.EmptyArray;

public class Deflater {
    public static final int BEST_COMPRESSION = 9;
    public static final int BEST_SPEED = 1;
    public static final int NO_COMPRESSION = 0;
    public static final int DEFAULT_COMPRESSION = -1;
    public static final int DEFAULT_STRATEGY = 0;
    public static final int DEFLATED = 8;
    public static final int FILTERED = 1;
    public static final int HUFFMAN_ONLY = 2;
    public static final int NO_FLUSH = 0;
    public static final int SYNC_FLUSH = 2;
    public static final int FULL_FLUSH = 3;
    private static final int FINISH = 4;
    private int flushParm = 0;
    private boolean finished;
    private int compressLevel = -1;
    private int strategy = 0;
    private long streamHandle = -1L;
    private byte[] inputBuffer;
    private int inRead;
    private int inLength;
    private final CloseGuard guard = CloseGuard.get();

    public Deflater() {
        this(-1, false);
    }

    public Deflater(int level) {
        this(level, false);
    }

    public Deflater(int level, boolean noHeader) {
        if (level < -1 || level > 9) {
            throw new IllegalArgumentException("Bad level: " + level);
        }
        this.compressLevel = level;
        this.streamHandle = this.createStream(this.compressLevel, this.strategy, noHeader);
        this.guard.open("end");
    }

    public int deflate(byte[] buf) {
        return this.deflate(buf, 0, buf.length);
    }

    public synchronized int deflate(byte[] buf, int offset, int byteCount) {
        return this.deflateImpl(buf, offset, byteCount, this.flushParm);
    }

    public synchronized int deflate(byte[] buf, int offset, int byteCount, int flush) {
        if (flush != 0 && flush != 2 && flush != 3) {
            throw new IllegalArgumentException("Bad flush value: " + flush);
        }
        return this.deflateImpl(buf, offset, byteCount, flush);
    }

    private synchronized int deflateImpl(byte[] buf, int offset, int byteCount, int flush) {
        this.checkOpen();
        Arrays.checkOffsetAndCount(buf.length, offset, byteCount);
        if (this.inputBuffer == null) {
            this.setInput(EmptyArray.BYTE);
        }
        return this.deflateImpl(buf, offset, byteCount, this.streamHandle, flush);
    }

    private native int deflateImpl(byte[] var1, int var2, int var3, long var4, int var6);

    public synchronized void end() {
        this.guard.close();
        this.endImpl();
    }

    private void endImpl() {
        if (this.streamHandle != -1L) {
            this.endImpl(this.streamHandle);
            this.inputBuffer = null;
            this.streamHandle = -1L;
        }
    }

    private native void endImpl(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        try {
            if (this.guard != null) {
                this.guard.warnIfOpen();
            }
            Deflater deflater = this;
            synchronized (deflater) {
                this.end();
                this.endImpl();
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                super.finalize();
            }
            catch (Throwable t) {
                throw new AssertionError((Object)t);
            }
            throw throwable;
        }
        try {
            super.finalize();
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    public synchronized void finish() {
        this.flushParm = 4;
    }

    public synchronized boolean finished() {
        return this.finished;
    }

    public synchronized int getAdler() {
        this.checkOpen();
        return this.getAdlerImpl(this.streamHandle);
    }

    private native int getAdlerImpl(long var1);

    public synchronized int getTotalIn() {
        this.checkOpen();
        return (int)this.getTotalInImpl(this.streamHandle);
    }

    private native long getTotalInImpl(long var1);

    public synchronized int getTotalOut() {
        this.checkOpen();
        return (int)this.getTotalOutImpl(this.streamHandle);
    }

    private native long getTotalOutImpl(long var1);

    public synchronized boolean needsInput() {
        if (this.inputBuffer == null) {
            return true;
        }
        return this.inRead == this.inLength;
    }

    public synchronized void reset() {
        this.checkOpen();
        this.flushParm = 0;
        this.finished = false;
        this.resetImpl(this.streamHandle);
        this.inputBuffer = null;
    }

    private native void resetImpl(long var1);

    public void setDictionary(byte[] dictionary) {
        this.setDictionary(dictionary, 0, dictionary.length);
    }

    public synchronized void setDictionary(byte[] buf, int offset, int byteCount) {
        this.checkOpen();
        Arrays.checkOffsetAndCount(buf.length, offset, byteCount);
        this.setDictionaryImpl(buf, offset, byteCount, this.streamHandle);
    }

    private native void setDictionaryImpl(byte[] var1, int var2, int var3, long var4);

    public void setInput(byte[] buf) {
        this.setInput(buf, 0, buf.length);
    }

    public synchronized void setInput(byte[] buf, int offset, int byteCount) {
        this.checkOpen();
        Arrays.checkOffsetAndCount(buf.length, offset, byteCount);
        this.inLength = byteCount;
        this.inRead = 0;
        if (this.inputBuffer == null) {
            this.setLevelsImpl(this.compressLevel, this.strategy, this.streamHandle);
        }
        this.inputBuffer = buf;
        this.setInputImpl(buf, offset, byteCount, this.streamHandle);
    }

    private native void setLevelsImpl(int var1, int var2, long var3);

    private native void setInputImpl(byte[] var1, int var2, int var3, long var4);

    public synchronized void setLevel(int level) {
        if (level < -1 || level > 9) {
            throw new IllegalArgumentException("Bad level: " + level);
        }
        if (this.inputBuffer != null) {
            throw new IllegalStateException("setLevel cannot be called after setInput");
        }
        this.compressLevel = level;
    }

    public synchronized void setStrategy(int strategy) {
        if (strategy < 0 || strategy > 2) {
            throw new IllegalArgumentException("Bad strategy: " + strategy);
        }
        if (this.inputBuffer != null) {
            throw new IllegalStateException("setStrategy cannot be called after setInput");
        }
        this.strategy = strategy;
    }

    public synchronized long getBytesRead() {
        this.checkOpen();
        return this.getTotalInImpl(this.streamHandle);
    }

    public synchronized long getBytesWritten() {
        this.checkOpen();
        return this.getTotalOutImpl(this.streamHandle);
    }

    private native long createStream(int var1, int var2, boolean var3);

    private void checkOpen() {
        if (this.streamHandle == -1L) {
            throw new IllegalStateException("attempt to use Deflater after calling end");
        }
    }
}

