/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.videosink;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.GLEnvironment;
import android.filterfw.core.GLFrame;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.core.ShaderProgram;
import android.filterfw.format.ImageFormat;
import android.filterfw.geometry.Point;
import android.filterfw.geometry.Quad;
import android.filterpacks.videosink.MediaRecorderStopException;
import android.media.CamcorderProfile;
import android.media.MediaRecorder;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.IOException;

public class MediaEncoderFilter
extends Filter {
    @GenerateFieldPort(name="recording", hasDefault=true)
    private boolean mRecording = true;
    @GenerateFieldPort(name="outputFile", hasDefault=true)
    private String mOutputFile = new String("/sdcard/MediaEncoderOut.mp4");
    @GenerateFieldPort(name="outputFileDescriptor", hasDefault=true)
    private FileDescriptor mFd = null;
    @GenerateFieldPort(name="audioSource", hasDefault=true)
    private int mAudioSource = -1;
    @GenerateFieldPort(name="infoListener", hasDefault=true)
    private MediaRecorder.OnInfoListener mInfoListener = null;
    @GenerateFieldPort(name="errorListener", hasDefault=true)
    private MediaRecorder.OnErrorListener mErrorListener = null;
    @GenerateFieldPort(name="recordingDoneListener", hasDefault=true)
    private OnRecordingDoneListener mRecordingDoneListener = null;
    @GenerateFieldPort(name="orientationHint", hasDefault=true)
    private int mOrientationHint = 0;
    @GenerateFieldPort(name="recordingProfile", hasDefault=true)
    private CamcorderProfile mProfile = null;
    @GenerateFieldPort(name="width", hasDefault=true)
    private int mWidth = 0;
    @GenerateFieldPort(name="height", hasDefault=true)
    private int mHeight = 0;
    @GenerateFieldPort(name="framerate", hasDefault=true)
    private int mFps = 30;
    @GenerateFieldPort(name="outputFormat", hasDefault=true)
    private int mOutputFormat = 2;
    @GenerateFieldPort(name="videoEncoder", hasDefault=true)
    private int mVideoEncoder = 2;
    @GenerateFieldPort(name="inputRegion", hasDefault=true)
    private Quad mSourceRegion;
    @GenerateFieldPort(name="maxFileSize", hasDefault=true)
    private long mMaxFileSize = 0L;
    @GenerateFieldPort(name="maxDurationMs", hasDefault=true)
    private int mMaxDurationMs = 0;
    @GenerateFieldPort(name="timelapseRecordingIntervalUs", hasDefault=true)
    private long mTimeBetweenTimeLapseFrameCaptureUs = 0L;
    private static final int NO_AUDIO_SOURCE = -1;
    private int mSurfaceId;
    private ShaderProgram mProgram;
    private GLFrame mScreen;
    private boolean mRecordingActive = false;
    private long mTimestampNs = 0L;
    private long mLastTimeLapseFrameRealTimestampNs = 0L;
    private int mNumFramesEncoded = 0;
    private boolean mCaptureTimeLapse = false;
    private boolean mLogVerbose;
    private static final String TAG = "MediaEncoderFilter";
    private MediaRecorder mMediaRecorder;

    public MediaEncoderFilter(String name) {
        super(name);
        Point bl = new Point(0.0f, 0.0f);
        Point br = new Point(1.0f, 0.0f);
        Point tl = new Point(0.0f, 1.0f);
        Point tr = new Point(1.0f, 1.0f);
        this.mSourceRegion = new Quad(bl, br, tl, tr);
        this.mLogVerbose = Log.isLoggable(TAG, 2);
    }

    public void setupPorts() {
        this.addMaskedInputPort("videoframe", ImageFormat.create(3, 3));
    }

    public void fieldPortValueUpdated(String name, FilterContext context) {
        if (this.mLogVerbose) {
            Log.v(TAG, "Port " + name + " has been updated");
        }
        if (name.equals("recording")) {
            return;
        }
        if (name.equals("inputRegion")) {
            if (this.isOpen()) {
                this.updateSourceRegion();
            }
            return;
        }
        if (this.isOpen() && this.mRecordingActive) {
            throw new RuntimeException("Cannot change recording parameters when the filter is recording!");
        }
    }

    private void updateSourceRegion() {
        Quad flippedRegion = new Quad();
        flippedRegion.p0 = this.mSourceRegion.p2;
        flippedRegion.p1 = this.mSourceRegion.p3;
        flippedRegion.p2 = this.mSourceRegion.p0;
        flippedRegion.p3 = this.mSourceRegion.p1;
        this.mProgram.setSourceRegion(flippedRegion);
    }

    private void updateMediaRecorderParams() {
        this.mCaptureTimeLapse = this.mTimeBetweenTimeLapseFrameCaptureUs > 0L;
        int GRALLOC_BUFFER = 2;
        this.mMediaRecorder.setVideoSource(2);
        if (!this.mCaptureTimeLapse && this.mAudioSource != -1) {
            this.mMediaRecorder.setAudioSource(this.mAudioSource);
        }
        if (this.mProfile != null) {
            this.mMediaRecorder.setProfile(this.mProfile);
            this.mFps = this.mProfile.videoFrameRate;
            if (this.mWidth > 0 && this.mHeight > 0) {
                this.mMediaRecorder.setVideoSize(this.mWidth, this.mHeight);
            }
        } else {
            this.mMediaRecorder.setOutputFormat(this.mOutputFormat);
            this.mMediaRecorder.setVideoEncoder(this.mVideoEncoder);
            this.mMediaRecorder.setVideoSize(this.mWidth, this.mHeight);
            this.mMediaRecorder.setVideoFrameRate(this.mFps);
        }
        this.mMediaRecorder.setOrientationHint(this.mOrientationHint);
        this.mMediaRecorder.setOnInfoListener(this.mInfoListener);
        this.mMediaRecorder.setOnErrorListener(this.mErrorListener);
        if (this.mFd != null) {
            this.mMediaRecorder.setOutputFile(this.mFd);
        } else {
            this.mMediaRecorder.setOutputFile(this.mOutputFile);
        }
        try {
            this.mMediaRecorder.setMaxFileSize(this.mMaxFileSize);
        }
        catch (Exception e) {
            Log.w(TAG, "Setting maxFileSize on MediaRecorder unsuccessful! " + e.getMessage());
        }
        this.mMediaRecorder.setMaxDuration(this.mMaxDurationMs);
    }

    public void prepare(FilterContext context) {
        if (this.mLogVerbose) {
            Log.v(TAG, "Preparing");
        }
        this.mProgram = ShaderProgram.createIdentity(context);
        this.mRecordingActive = false;
    }

    public void open(FilterContext context) {
        if (this.mLogVerbose) {
            Log.v(TAG, "Opening");
        }
        this.updateSourceRegion();
        if (this.mRecording) {
            this.startRecording(context);
        }
    }

    private void startRecording(FilterContext context) {
        int height;
        int width;
        boolean widthHeightSpecified;
        if (this.mLogVerbose) {
            Log.v(TAG, "Starting recording");
        }
        MutableFrameFormat screenFormat = new MutableFrameFormat(2, 3);
        screenFormat.setBytesPerSample(4);
        boolean bl = widthHeightSpecified = this.mWidth > 0 && this.mHeight > 0;
        if (this.mProfile != null && !widthHeightSpecified) {
            width = this.mProfile.videoFrameWidth;
            height = this.mProfile.videoFrameHeight;
        } else {
            width = this.mWidth;
            height = this.mHeight;
        }
        screenFormat.setDimensions(width, height);
        this.mScreen = (GLFrame)context.getFrameManager().newBoundFrame(screenFormat, 101, 0L);
        this.mMediaRecorder = new MediaRecorder();
        this.updateMediaRecorderParams();
        try {
            this.mMediaRecorder.prepare();
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException("IOException inMediaRecorder.prepare()!", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Unknown Exception inMediaRecorder.prepare()!", e);
        }
        this.mMediaRecorder.start();
        if (this.mLogVerbose) {
            Log.v(TAG, "Open: registering surface from Mediarecorder");
        }
        this.mSurfaceId = context.getGLEnvironment().registerSurfaceFromMediaRecorder(this.mMediaRecorder);
        this.mNumFramesEncoded = 0;
        this.mRecordingActive = true;
    }

    public boolean skipFrameAndModifyTimestamp(long timestampNs) {
        if (this.mNumFramesEncoded == 0) {
            this.mLastTimeLapseFrameRealTimestampNs = timestampNs;
            this.mTimestampNs = timestampNs;
            if (this.mLogVerbose) {
                Log.v(TAG, "timelapse: FIRST frame, last real t= " + this.mLastTimeLapseFrameRealTimestampNs + ", setting t = " + this.mTimestampNs);
            }
            return false;
        }
        if (this.mNumFramesEncoded >= 2 && timestampNs < this.mLastTimeLapseFrameRealTimestampNs + 1000L * this.mTimeBetweenTimeLapseFrameCaptureUs) {
            if (this.mLogVerbose) {
                Log.v(TAG, "timelapse: skipping intermediate frame");
            }
            return true;
        }
        if (this.mLogVerbose) {
            Log.v(TAG, "timelapse: encoding frame, Timestamp t = " + timestampNs + ", last real t= " + this.mLastTimeLapseFrameRealTimestampNs + ", interval = " + this.mTimeBetweenTimeLapseFrameCaptureUs);
        }
        this.mLastTimeLapseFrameRealTimestampNs = timestampNs;
        this.mTimestampNs += 1000000000L / (long)this.mFps;
        if (this.mLogVerbose) {
            Log.v(TAG, "timelapse: encoding frame, setting t = " + this.mTimestampNs + ", delta t = " + 1000000000L / (long)this.mFps + ", fps = " + this.mFps);
        }
        return false;
    }

    public void process(FilterContext context) {
        GLEnvironment glEnv = context.getGLEnvironment();
        Frame input = this.pullInput("videoframe");
        if (!this.mRecordingActive && this.mRecording) {
            this.startRecording(context);
        }
        if (this.mRecordingActive && !this.mRecording) {
            this.stopRecording(context);
        }
        if (!this.mRecordingActive) {
            return;
        }
        if (this.mCaptureTimeLapse) {
            if (this.skipFrameAndModifyTimestamp(input.getTimestamp())) {
                return;
            }
        } else {
            this.mTimestampNs = input.getTimestamp();
        }
        glEnv.activateSurfaceWithId(this.mSurfaceId);
        this.mProgram.process(input, (Frame)this.mScreen);
        glEnv.setSurfaceTimestamp(this.mTimestampNs);
        glEnv.swapBuffers();
        ++this.mNumFramesEncoded;
    }

    private void stopRecording(FilterContext context) {
        if (this.mLogVerbose) {
            Log.v(TAG, "Stopping recording");
        }
        this.mRecordingActive = false;
        this.mNumFramesEncoded = 0;
        GLEnvironment glEnv = context.getGLEnvironment();
        if (this.mLogVerbose) {
            Log.v(TAG, String.format("Unregistering surface %d", this.mSurfaceId));
        }
        glEnv.unregisterSurfaceId(this.mSurfaceId);
        try {
            this.mMediaRecorder.stop();
        }
        catch (RuntimeException e) {
            throw new MediaRecorderStopException("MediaRecorder.stop() failed!", e);
        }
        this.mMediaRecorder.release();
        this.mMediaRecorder = null;
        this.mScreen.release();
        this.mScreen = null;
        if (this.mRecordingDoneListener != null) {
            this.mRecordingDoneListener.onRecordingDone();
        }
    }

    public void close(FilterContext context) {
        if (this.mLogVerbose) {
            Log.v(TAG, "Closing");
        }
        if (this.mRecordingActive) {
            this.stopRecording(context);
        }
    }

    public void tearDown(FilterContext context) {
        if (this.mMediaRecorder != null) {
            this.mMediaRecorder.release();
        }
        if (this.mScreen != null) {
            this.mScreen.release();
        }
    }

    public static interface OnRecordingDoneListener {
        public void onRecordingDone();
    }
}

