/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.location;

import android.hardware.location.GeofenceHardwareRequest;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;

public final class GeofenceHardwareRequestParcelable
implements Parcelable {
    private GeofenceHardwareRequest mRequest;
    private int mId;
    public static final Parcelable.Creator<GeofenceHardwareRequestParcelable> CREATOR = new Parcelable.Creator<GeofenceHardwareRequestParcelable>(){

        @Override
        public GeofenceHardwareRequestParcelable createFromParcel(Parcel parcel) {
            int geofenceType = parcel.readInt();
            if (geofenceType != 0) {
                Log.e("GeofenceHardwareRequest", String.format("Invalid Geofence type: %d", geofenceType));
                return null;
            }
            GeofenceHardwareRequest request = GeofenceHardwareRequest.createCircularGeofence(parcel.readDouble(), parcel.readDouble(), parcel.readDouble());
            request.setLastTransition(parcel.readInt());
            request.setMonitorTransitions(parcel.readInt());
            request.setUnknownTimer(parcel.readInt());
            request.setNotificationResponsiveness(parcel.readInt());
            int id2 = parcel.readInt();
            return new GeofenceHardwareRequestParcelable(id2, request);
        }

        public GeofenceHardwareRequestParcelable[] newArray(int size) {
            return new GeofenceHardwareRequestParcelable[size];
        }
    };

    public GeofenceHardwareRequestParcelable(int id2, GeofenceHardwareRequest request) {
        this.mId = id2;
        this.mRequest = request;
    }

    public int getId() {
        return this.mId;
    }

    public double getLatitude() {
        return this.mRequest.getLatitude();
    }

    public double getLongitude() {
        return this.mRequest.getLongitude();
    }

    public double getRadius() {
        return this.mRequest.getRadius();
    }

    public int getMonitorTransitions() {
        return this.mRequest.getMonitorTransitions();
    }

    public int getUnknownTimer() {
        return this.mRequest.getUnknownTimer();
    }

    public int getNotificationResponsiveness() {
        return this.mRequest.getNotificationResponsiveness();
    }

    public int getLastTransition() {
        return this.mRequest.getLastTransition();
    }

    int getType() {
        return this.mRequest.getType();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.getType());
        parcel.writeDouble(this.getLatitude());
        parcel.writeDouble(this.getLongitude());
        parcel.writeDouble(this.getRadius());
        parcel.writeInt(this.getLastTransition());
        parcel.writeInt(this.getMonitorTransitions());
        parcel.writeInt(this.getUnknownTimer());
        parcel.writeInt(this.getNotificationResponsiveness());
        parcel.writeInt(this.getId());
    }
}

