/*
 * Decompiled with CFR 0.152.
 */
package android.media.videoeditor;

import android.graphics.Bitmap;
import android.media.videoeditor.Effect;
import android.media.videoeditor.EffectKenBurns;
import android.media.videoeditor.ExtractAudioWaveformProgressListener;
import android.media.videoeditor.MediaArtistNativeHelper;
import android.media.videoeditor.MediaItem;
import android.media.videoeditor.VideoEditor;
import android.media.videoeditor.VideoEditorImpl;
import android.media.videoeditor.VideoEditorProfile;
import android.media.videoeditor.WaveformData;
import android.view.Surface;
import android.view.SurfaceHolder;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;

public class MediaVideoItem
extends MediaItem {
    private final int mWidth;
    private final int mHeight;
    private final int mAspectRatio;
    private final int mFileType;
    private final int mVideoType;
    private final int mVideoProfile;
    private final int mVideoLevel;
    private final int mVideoBitrate;
    private final long mDurationMs;
    private final int mAudioBitrate;
    private final int mFps;
    private final int mAudioType;
    private final int mAudioChannels;
    private final int mAudioSamplingFrequency;
    private long mBeginBoundaryTimeMs;
    private long mEndBoundaryTimeMs;
    private int mVolumePercentage;
    private boolean mMuted;
    private String mAudioWaveformFilename;
    private MediaArtistNativeHelper mMANativeHelper;
    private VideoEditorImpl mVideoEditor;
    private final int mVideoRotationDegree;
    private SoftReference<WaveformData> mWaveformData;

    private MediaVideoItem() throws IOException {
        this(null, null, null, 0);
    }

    public MediaVideoItem(VideoEditor editor, String mediaItemId, String filename, int renderingMode) throws IOException {
        this(editor, mediaItemId, filename, renderingMode, 0L, -1L, 100, false, null);
    }

    MediaVideoItem(VideoEditor editor, String mediaItemId, String filename, int renderingMode, long beginMs, long endMs, int volumePercent, boolean muted, String audioWaveformFilename) throws IOException {
        super(editor, mediaItemId, filename, renderingMode);
        MediaArtistNativeHelper.Properties properties;
        if (editor instanceof VideoEditorImpl) {
            this.mMANativeHelper = ((VideoEditorImpl)editor).getNativeContext();
            this.mVideoEditor = (VideoEditorImpl)editor;
        }
        try {
            properties = this.mMANativeHelper.getMediaProperties(filename);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage() + " : " + filename);
        }
        VideoEditorProfile veProfile = VideoEditorProfile.get();
        if (veProfile == null) {
            throw new RuntimeException("Can't get the video editor profile");
        }
        int maxInputWidth = veProfile.maxInputVideoFrameWidth;
        int maxInputHeight = veProfile.maxInputVideoFrameHeight;
        if (properties.width > maxInputWidth || properties.height > maxInputHeight) {
            throw new IllegalArgumentException("Unsupported import resolution. Supported maximum width:" + maxInputWidth + " height:" + maxInputHeight + ", current width:" + properties.width + " height:" + properties.height);
        }
        if (!properties.profileSupported) {
            throw new IllegalArgumentException("Unsupported video profile " + properties.profile);
        }
        if (!properties.levelSupported) {
            throw new IllegalArgumentException("Unsupported video level " + properties.level);
        }
        switch (this.mMANativeHelper.getFileType(properties.fileType)) {
            case 0: 
            case 1: 
            case 10: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported Input File Type");
            }
        }
        switch (this.mMANativeHelper.getVideoCodecType(properties.videoFormat)) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported Video Codec Format in Input File");
            }
        }
        this.mWidth = properties.width;
        this.mHeight = properties.height;
        this.mAspectRatio = this.mMANativeHelper.getAspectRatio(properties.width, properties.height);
        this.mFileType = this.mMANativeHelper.getFileType(properties.fileType);
        this.mVideoType = this.mMANativeHelper.getVideoCodecType(properties.videoFormat);
        this.mVideoProfile = properties.profile;
        this.mVideoLevel = properties.level;
        this.mDurationMs = properties.videoDuration;
        this.mVideoBitrate = properties.videoBitrate;
        this.mAudioBitrate = properties.audioBitrate;
        this.mFps = (int)properties.averageFrameRate;
        this.mAudioType = this.mMANativeHelper.getAudioCodecType(properties.audioFormat);
        this.mAudioChannels = properties.audioChannels;
        this.mAudioSamplingFrequency = properties.audioSamplingFrequency;
        this.mBeginBoundaryTimeMs = beginMs;
        this.mEndBoundaryTimeMs = endMs == -1L ? this.mDurationMs : endMs;
        this.mVolumePercentage = volumePercent;
        this.mMuted = muted;
        this.mAudioWaveformFilename = audioWaveformFilename;
        this.mWaveformData = audioWaveformFilename != null ? new SoftReference<WaveformData>(new WaveformData(audioWaveformFilename)) : null;
        this.mVideoRotationDegree = properties.videoRotation;
    }

    public void setExtractBoundaries(long beginMs, long endMs) {
        if (beginMs > this.mDurationMs) {
            throw new IllegalArgumentException("setExtractBoundaries: Invalid start time");
        }
        if (endMs > this.mDurationMs) {
            throw new IllegalArgumentException("setExtractBoundaries: Invalid end time");
        }
        if (endMs != -1L && beginMs >= endMs) {
            throw new IllegalArgumentException("setExtractBoundaries: Start time is greater than end time");
        }
        if (beginMs < 0L || endMs != -1L && endMs < 0L) {
            throw new IllegalArgumentException("setExtractBoundaries: Start time or end time is negative");
        }
        this.mMANativeHelper.setGeneratePreview(true);
        if (beginMs != this.mBeginBoundaryTimeMs && this.mBeginTransition != null) {
            this.mBeginTransition.invalidate();
        }
        if (endMs != this.mEndBoundaryTimeMs && this.mEndTransition != null) {
            this.mEndTransition.invalidate();
        }
        this.mBeginBoundaryTimeMs = beginMs;
        this.mEndBoundaryTimeMs = endMs;
        this.adjustTransitions();
        this.mVideoEditor.updateTimelineDuration();
    }

    public long getBoundaryBeginTime() {
        return this.mBeginBoundaryTimeMs;
    }

    public long getBoundaryEndTime() {
        return this.mEndBoundaryTimeMs;
    }

    public void addEffect(Effect effect) {
        if (effect instanceof EffectKenBurns) {
            throw new IllegalArgumentException("Ken Burns effects cannot be applied to MediaVideoItem");
        }
        super.addEffect(effect);
    }

    public Bitmap getThumbnail(int width, int height, long timeMs) {
        if (timeMs > this.mDurationMs) {
            throw new IllegalArgumentException("Time Exceeds duration");
        }
        if (timeMs < 0L) {
            throw new IllegalArgumentException("Invalid Time duration");
        }
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Invalid Dimensions");
        }
        if (this.mVideoRotationDegree == 90 || this.mVideoRotationDegree == 270) {
            int temp = width;
            width = height;
            height = temp;
        }
        return this.mMANativeHelper.getPixels(this.getFilename(), width, height, timeMs, this.mVideoRotationDegree);
    }

    public void getThumbnailList(int width, int height, long startMs, long endMs, int thumbnailCount, int[] indices, MediaItem.GetThumbnailListCallback callback) throws IOException {
        if (startMs > endMs) {
            throw new IllegalArgumentException("Start time is greater than end time");
        }
        if (endMs > this.mDurationMs) {
            throw new IllegalArgumentException("End time is greater than file duration");
        }
        if (height <= 0 || width <= 0) {
            throw new IllegalArgumentException("Invalid dimension");
        }
        if (this.mVideoRotationDegree == 90 || this.mVideoRotationDegree == 270) {
            int temp = width;
            width = height;
            height = temp;
        }
        this.mMANativeHelper.getPixelsList(this.getFilename(), width, height, startMs, endMs, thumbnailCount, indices, callback, this.mVideoRotationDegree);
    }

    void invalidateTransitions(long startTimeMs, long durationMs) {
        long transitionDurationMs;
        if (this.mBeginTransition != null && this.isOverlapping(startTimeMs, durationMs, this.mBeginBoundaryTimeMs, this.mBeginTransition.getDuration())) {
            this.mBeginTransition.invalidate();
        }
        if (this.mEndTransition != null && this.isOverlapping(startTimeMs, durationMs, this.mEndBoundaryTimeMs - (transitionDurationMs = this.mEndTransition.getDuration()), transitionDurationMs)) {
            this.mEndTransition.invalidate();
        }
    }

    void invalidateTransitions(long oldStartTimeMs, long oldDurationMs, long newStartTimeMs, long newDurationMs) {
        boolean newOverlap;
        boolean oldOverlap;
        long transitionDurationMs;
        if (this.mBeginTransition != null) {
            transitionDurationMs = this.mBeginTransition.getDuration();
            oldOverlap = this.isOverlapping(oldStartTimeMs, oldDurationMs, this.mBeginBoundaryTimeMs, transitionDurationMs);
            newOverlap = this.isOverlapping(newStartTimeMs, newDurationMs, this.mBeginBoundaryTimeMs, transitionDurationMs);
            if (newOverlap != oldOverlap) {
                this.mBeginTransition.invalidate();
            } else if (newOverlap && (oldStartTimeMs != newStartTimeMs || oldStartTimeMs + oldDurationMs <= transitionDurationMs || newStartTimeMs + newDurationMs <= transitionDurationMs)) {
                this.mBeginTransition.invalidate();
            }
        }
        if (this.mEndTransition != null) {
            transitionDurationMs = this.mEndTransition.getDuration();
            oldOverlap = this.isOverlapping(oldStartTimeMs, oldDurationMs, this.mEndBoundaryTimeMs - transitionDurationMs, transitionDurationMs);
            newOverlap = this.isOverlapping(newStartTimeMs, newDurationMs, this.mEndBoundaryTimeMs - transitionDurationMs, transitionDurationMs);
            if (newOverlap != oldOverlap) {
                this.mEndTransition.invalidate();
            } else if (newOverlap && (oldStartTimeMs + oldDurationMs != newStartTimeMs + newDurationMs || oldStartTimeMs > this.mEndBoundaryTimeMs - transitionDurationMs || newStartTimeMs > this.mEndBoundaryTimeMs - transitionDurationMs)) {
                this.mEndTransition.invalidate();
            }
        }
    }

    public int getAspectRatio() {
        return this.mAspectRatio;
    }

    public int getFileType() {
        return this.mFileType;
    }

    public int getWidth() {
        if (this.mVideoRotationDegree == 90 || this.mVideoRotationDegree == 270) {
            return this.mHeight;
        }
        return this.mWidth;
    }

    public int getHeight() {
        if (this.mVideoRotationDegree == 90 || this.mVideoRotationDegree == 270) {
            return this.mWidth;
        }
        return this.mHeight;
    }

    public long getDuration() {
        return this.mDurationMs;
    }

    public long getTimelineDuration() {
        return this.mEndBoundaryTimeMs - this.mBeginBoundaryTimeMs;
    }

    public long renderFrame(SurfaceHolder surfaceHolder, long timeMs) {
        if (surfaceHolder == null) {
            throw new IllegalArgumentException("Surface Holder is null");
        }
        if (timeMs > this.mDurationMs || timeMs < 0L) {
            throw new IllegalArgumentException("requested time not correct");
        }
        Surface surface = surfaceHolder.getSurface();
        if (surface == null) {
            throw new RuntimeException("Surface could not be retrieved from Surface holder");
        }
        if (this.mFilename != null) {
            return this.mMANativeHelper.renderMediaItemPreviewFrame(surface, this.mFilename, timeMs, this.mWidth, this.mHeight);
        }
        return 0L;
    }

    public void extractAudioWaveform(ExtractAudioWaveformProgressListener listener) throws IOException {
        int frameDuration = 0;
        int sampleCount = 0;
        String projectPath = this.mMANativeHelper.getProjectPath();
        if (this.mAudioWaveformFilename == null) {
            String mAudioWaveFileName = null;
            mAudioWaveFileName = String.format(projectPath + "/" + "audioWaveformFile-" + this.getId() + ".dat", new Object[0]);
            if (this.mMANativeHelper.getAudioCodecType(this.mAudioType) == 1) {
                frameDuration = 5;
                sampleCount = 160;
            } else if (this.mMANativeHelper.getAudioCodecType(this.mAudioType) == 8) {
                frameDuration = 10;
                sampleCount = 320;
            } else if (this.mMANativeHelper.getAudioCodecType(this.mAudioType) == 2) {
                frameDuration = 32;
                sampleCount = 1024;
            }
            this.mMANativeHelper.generateAudioGraph(this.getId(), this.mFilename, mAudioWaveFileName, frameDuration, 2, sampleCount, listener, true);
            this.mAudioWaveformFilename = mAudioWaveFileName;
        }
        this.mWaveformData = new SoftReference<WaveformData>(new WaveformData(this.mAudioWaveformFilename));
    }

    String getAudioWaveformFilename() {
        return this.mAudioWaveformFilename;
    }

    void invalidate() {
        if (this.mAudioWaveformFilename != null) {
            new File(this.mAudioWaveformFilename).delete();
            this.mAudioWaveformFilename = null;
        }
    }

    public WaveformData getWaveformData() throws IOException {
        if (this.mWaveformData == null) {
            return null;
        }
        WaveformData waveformData = this.mWaveformData.get();
        if (waveformData != null) {
            return waveformData;
        }
        if (this.mAudioWaveformFilename != null) {
            waveformData = new WaveformData(this.mAudioWaveformFilename);
            this.mWaveformData = new SoftReference<WaveformData>(waveformData);
            return waveformData;
        }
        return null;
    }

    public void setVolume(int volumePercent) {
        if (volumePercent < 0 || volumePercent > 100) {
            throw new IllegalArgumentException("Invalid volume");
        }
        this.mVolumePercentage = volumePercent;
    }

    public int getVolume() {
        return this.mVolumePercentage;
    }

    public void setMute(boolean muted) {
        this.mMANativeHelper.setGeneratePreview(true);
        this.mMuted = muted;
        if (this.mBeginTransition != null) {
            this.mBeginTransition.invalidate();
        }
        if (this.mEndTransition != null) {
            this.mEndTransition.invalidate();
        }
    }

    public boolean isMuted() {
        return this.mMuted;
    }

    public int getVideoType() {
        return this.mVideoType;
    }

    public int getVideoProfile() {
        return this.mVideoProfile;
    }

    public int getVideoLevel() {
        return this.mVideoLevel;
    }

    public int getVideoBitrate() {
        return this.mVideoBitrate;
    }

    public int getAudioBitrate() {
        return this.mAudioBitrate;
    }

    public int getFps() {
        return this.mFps;
    }

    public int getAudioType() {
        return this.mAudioType;
    }

    public int getAudioChannels() {
        return this.mAudioChannels;
    }

    public int getAudioSamplingFrequency() {
        return this.mAudioSamplingFrequency;
    }

    MediaArtistNativeHelper.ClipSettings getVideoClipProperties() {
        MediaArtistNativeHelper.ClipSettings clipSettings = new MediaArtistNativeHelper.ClipSettings();
        clipSettings.clipPath = this.getFilename();
        clipSettings.fileType = this.mMANativeHelper.getMediaItemFileType(this.getFileType());
        clipSettings.beginCutTime = (int)this.getBoundaryBeginTime();
        clipSettings.endCutTime = (int)this.getBoundaryEndTime();
        clipSettings.mediaRendering = this.mMANativeHelper.getMediaItemRenderingMode(this.getRenderingMode());
        clipSettings.rotationDegree = this.mVideoRotationDegree;
        return clipSettings;
    }
}

